/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutorGroup;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import io.netty.util.internal.ObjectUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultithreadEventExecutorGroup
extends AbstractEventExecutorGroup {
    private final EventExecutor[] children;
    private final Set<EventExecutor> readonlyChildren;
    private final AtomicInteger terminatedChildren = new AtomicInteger();
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private final EventExecutorChooserFactory.EventExecutorChooser chooser;

    protected MultithreadEventExecutorGroup(int n, ThreadFactory threadFactory, Object ... objectArray) {
        this(n, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor(threadFactory)), objectArray);
    }

    protected MultithreadEventExecutorGroup(int n, Executor executor, Object ... objectArray) {
        this(n, executor, DefaultEventExecutorChooserFactory.INSTANCE, objectArray);
    }

    protected MultithreadEventExecutorGroup(int n, Executor executor, EventExecutorChooserFactory object, Object ... object2) {
        ObjectUtil.checkPositive(n, "nThreads");
        if (executor == null) {
            executor = new ThreadPerTaskExecutor(this.newDefaultThreadFactory());
        }
        this.children = new EventExecutor[n];
        for (int i = 0; i < n; ++i) {
            try {
                try {
                    this.children[i] = this.newChild(executor, object2);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to create a child event loop", exception);
                }
            }
            catch (Throwable throwable) {
                int n2;
                for (n2 = 0; n2 < i; ++n2) {
                    this.children[n2].shutdownGracefully();
                }
                for (n2 = 0; n2 < i; ++n2) {
                    object = this.children[n2];
                    try {
                        while (!object.isTerminated()) {
                            object.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                        }
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                throw throwable;
            }
        }
        this.chooser = object.newChooser(this.children);
        FutureListener<Object> futureListener = new FutureListener<Object>(){

            @Override
            public void operationComplete(Future<Object> future) {
                if (MultithreadEventExecutorGroup.this.terminatedChildren.incrementAndGet() == MultithreadEventExecutorGroup.this.children.length) {
                    MultithreadEventExecutorGroup.this.terminationFuture.setSuccess(null);
                }
            }
        };
        Object object3 = this.children;
        int n3 = this.children.length;
        for (int i = 0; i < n3; ++i) {
            object2 = object3[i];
            object2.terminationFuture().addListener(futureListener);
        }
        object3 = new LinkedHashSet(this.children.length);
        Collections.addAll(object3, this.children);
        this.readonlyChildren = Collections.unmodifiableSet(object3);
    }

    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass());
    }

    @Override
    public EventExecutor next() {
        return this.chooser.next();
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.readonlyChildren.iterator();
    }

    public final int executorCount() {
        return this.children.length;
    }

    protected abstract EventExecutor newChild(Executor var1, Object ... var2);

    @Override
    public Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            eventExecutor.shutdownGracefully(l, l2, timeUnit);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            eventExecutor.shutdown();
        }
    }

    @Override
    public boolean isShuttingDown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            if (eventExecutor.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            if (eventExecutor.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            if (eventExecutor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) {
        long l2 = System.nanoTime() + timeUnit.toNanos(l);
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        block0: for (int i = 0; i < n; ++i) {
            long l3;
            EventExecutor eventExecutor = eventExecutorArray[i];
            while ((l3 = l2 - System.nanoTime()) > 0L) {
                if (!eventExecutor.awaitTermination(l3, TimeUnit.NANOSECONDS)) continue;
                continue block0;
            }
            break block0;
        }
        return this.isTerminated();
    }
}

