/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.SizeClassesMetric;

final class SizeClasses
implements SizeClassesMetric {
    static final int LOG2_QUANTUM = 4;
    private static final int LOG2_SIZE_CLASS_GROUP = 2;
    private static final int LOG2_MAX_LOOKUP_SIZE = 12;
    private static final int LOG2GROUP_IDX = 1;
    private static final int LOG2DELTA_IDX = 2;
    private static final int NDELTA_IDX = 3;
    private static final int PAGESIZE_IDX = 4;
    private static final int SUBPAGE_IDX = 5;
    private static final int LOG2_DELTA_LOOKUP_IDX = 6;
    private static final byte no = 0;
    private static final byte yes = 1;
    final int pageSize;
    final int pageShifts;
    final int chunkSize;
    final int directMemoryCacheAlignment;
    final int nSizes;
    final int nSubpages;
    final int nPSizes;
    final int lookupMaxSize;
    final int smallMaxSizeIdx;
    private final int[] pageIdx2sizeTab;
    private final int[] sizeIdx2sizeTab;
    private final int[] size2idxTab;

    SizeClasses(int n, int n2, int n3, int n4) {
        int n5 = PoolThreadCache.log2(n3) - 4 - 2 + 1;
        short[][] sArray = new short[n5 << 2][7];
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 4;
        int n10 = 4;
        int n11 = 0;
        while (n11 < 4) {
            short[] sArray2 = SizeClasses.newSizeClass(n7, 4, 4, n11, n2);
            sArray[n7] = sArray2;
            n8 = SizeClasses.sizeOf(sArray2, n4);
            ++n11;
            ++n7;
        }
        n9 += 2;
        while (n8 < n3) {
            n11 = 1;
            while (n11 <= 4 && n8 < n3) {
                short[] sArray3 = SizeClasses.newSizeClass(n7, n9, n10, n11, n2);
                sArray[n7] = sArray3;
                n8 = n6 = SizeClasses.sizeOf(sArray3, n4);
                ++n11;
                ++n7;
            }
            ++n9;
            ++n10;
        }
        assert (n3 == n6);
        n11 = 0;
        n8 = 0;
        n6 = 0;
        n9 = 0;
        for (n10 = 0; n10 < n7; ++n10) {
            short[] sArray4 = sArray[n10];
            if (sArray4[4] == 1) {
                ++n6;
            }
            if (sArray4[5] == 1) {
                ++n9;
                n11 = n10;
            }
            if (sArray4[6] == 0) continue;
            n8 = SizeClasses.sizeOf(sArray4, n4);
        }
        this.smallMaxSizeIdx = n11;
        this.lookupMaxSize = n8;
        this.nPSizes = n6;
        this.nSubpages = n9;
        this.nSizes = n7;
        this.pageSize = n;
        this.pageShifts = n2;
        this.chunkSize = n3;
        this.directMemoryCacheAlignment = n4;
        this.sizeIdx2sizeTab = SizeClasses.newIdx2SizeTab(sArray, n7, n4);
        this.pageIdx2sizeTab = SizeClasses.newPageIdx2sizeTab(sArray, n7, n6, n4);
        this.size2idxTab = SizeClasses.newSize2idxTab(n8, sArray);
    }

    private static short[] newSizeClass(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        short s;
        if (n3 >= n5) {
            s = 1;
        } else {
            n7 = 1 << n5;
            n6 = SizeClasses.calculateSize(n2, n4, n3);
            s = n6 == n6 / n7 * n7 ? (short)1 : 0;
        }
        short s2 = s;
        n7 = n4 == 0 ? 0 : PoolThreadCache.log2(n4);
        n6 = 1 << n7 < n4 ? 1 : 0;
        if ((n7 = n3 + n7 == n2 ? n2 + 1 : n2) == n2) {
            n6 = 1;
        }
        n5 = n7 < n5 + 2 ? 1 : 0;
        n7 = n7 < 12 || n7 == 12 && n6 == 0 ? n3 : 0;
        return new short[]{(short)n, (short)n2, (short)n3, (short)n4, s2, n5, (short)n7};
    }

    private static int[] newIdx2SizeTab(short[][] sArray, int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            short[] sArray2 = sArray[i];
            nArray[i] = SizeClasses.sizeOf(sArray2, n2);
        }
        return nArray;
    }

    private static int calculateSize(int n, int n2, int n3) {
        return (1 << n) + (n2 << n3);
    }

    private static int sizeOf(short[] sArray, int n) {
        short s = sArray[1];
        short s2 = sArray[2];
        int n2 = sArray[3];
        n2 = SizeClasses.calculateSize(s, n2, s2);
        return SizeClasses.alignSizeIfNeeded(n2, n);
    }

    private static int[] newPageIdx2sizeTab(short[][] sArray, int n, int n2, int n3) {
        int[] nArray = new int[n2];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            short[] sArray2 = sArray[i];
            if (sArray2[4] != 1) continue;
            nArray[n4++] = SizeClasses.sizeOf(sArray2, n3);
        }
        return nArray;
    }

    private static int[] newSize2idxTab(int n, short[][] sArray) {
        int[] nArray = new int[n >> 4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n) {
            int n5 = sArray[n4][2];
            n5 = 1 << n5 - 4;
            while (n3 <= n && n5-- > 0) {
                nArray[n2++] = n4;
                n3 = n2 + 1 << 4;
            }
            ++n4;
        }
        return nArray;
    }

    @Override
    public final int sizeIdx2size(int n) {
        return this.sizeIdx2sizeTab[n];
    }

    @Override
    public final int sizeIdx2sizeCompute(int n) {
        int n2 = n >> 2;
        n &= 3;
        int n3 = n2 == 0 ? 0 : 32 << n2;
        n2 = n2 == 0 ? 1 : n2;
        n2 = n2 + 4 - 1;
        n = n + 1 << n2;
        return n3 + n;
    }

    @Override
    public final long pageIdx2size(int n) {
        return this.pageIdx2sizeTab[n];
    }

    @Override
    public final long pageIdx2sizeCompute(int n) {
        int n2 = n >> 2;
        n &= 3;
        long l = n2 == 0 ? 0L : 1L << this.pageShifts + 2 - 1 << n2;
        n2 = n2 == 0 ? 1 : n2;
        n2 = n2 + this.pageShifts - 1;
        n = n + 1 << n2;
        return l + (long)n;
    }

    @Override
    public final int size2SizeIdx(int n) {
        if (n == 0) {
            return 0;
        }
        if (n > this.chunkSize) {
            return this.nSizes;
        }
        if ((n = SizeClasses.alignSizeIfNeeded(n, this.directMemoryCacheAlignment)) <= this.lookupMaxSize) {
            return this.size2idxTab[n - 1 >> 4];
        }
        int n2 = PoolThreadCache.log2((n << 1) - 1);
        int n3 = n2 < 7 ? 0 : n2 - 6;
        n3 = n3 << 2;
        n2 = n2 < 7 ? 4 : n2 - 2 - 1;
        n = n - 1 >> n2 & 3;
        return n3 + n;
    }

    @Override
    public final int pages2pageIdx(int n) {
        return this.pages2pageIdxCompute(n, false);
    }

    @Override
    public final int pages2pageIdxFloor(int n) {
        return this.pages2pageIdxCompute(n, true);
    }

    private int pages2pageIdxCompute(int n, boolean bl) {
        int n2 = n << this.pageShifts;
        if (n2 > this.chunkSize) {
            return this.nPSizes;
        }
        int n3 = PoolThreadCache.log2((n2 << 1) - 1);
        int n4 = n3 < 2 + this.pageShifts ? 0 : n3 - (2 + this.pageShifts);
        n4 = n4 << 2;
        n3 = n3 < 2 + this.pageShifts + 1 ? this.pageShifts : n3 - 2 - 1;
        n2 = n2 - 1 >> n3 & 3;
        n2 = n4 + n2;
        if (bl && this.pageIdx2sizeTab[n2] > n << this.pageShifts) {
            --n2;
        }
        return n2;
    }

    private static int alignSizeIfNeeded(int n, int n2) {
        if (n2 <= 0) {
            return n;
        }
        int n3 = n & n2 - 1;
        if (n3 == 0) {
            return n;
        }
        return n + n2 - n3;
    }

    @Override
    public final int normalizeSize(int n) {
        if (n == 0) {
            return this.sizeIdx2sizeTab[0];
        }
        if ((n = SizeClasses.alignSizeIfNeeded(n, this.directMemoryCacheAlignment)) <= this.lookupMaxSize) {
            int n2 = this.sizeIdx2sizeTab[this.size2idxTab[n - 1 >> 4]];
            assert (n2 == SizeClasses.normalizeSizeCompute(n));
            return n2;
        }
        return SizeClasses.normalizeSizeCompute(n);
    }

    private static int normalizeSizeCompute(int n) {
        int n2 = PoolThreadCache.log2((n << 1) - 1);
        n2 = n2 < 7 ? 4 : n2 - 2 - 1;
        n2 = 1 << n2;
        return n + --n2 & ~n2;
    }
}

