/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.FixedCompositeByteBuf;
import io.netty.buffer.ReadOnlyByteBuf;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.ReadOnlyUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnreleasableByteBuf;
import io.netty.buffer.WrappedUnpooledUnsafeDirectByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class Unpooled {
    private static final ByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ByteBuf EMPTY_BUFFER = ALLOC.buffer(0, 0);

    public static ByteBuf buffer() {
        return ALLOC.heapBuffer();
    }

    public static ByteBuf directBuffer() {
        return ALLOC.directBuffer();
    }

    public static ByteBuf buffer(int n) {
        return ALLOC.heapBuffer(n);
    }

    public static ByteBuf directBuffer(int n) {
        return ALLOC.directBuffer(n);
    }

    public static ByteBuf buffer(int n, int n2) {
        return ALLOC.heapBuffer(n, n2);
    }

    public static ByteBuf directBuffer(int n, int n2) {
        return ALLOC.directBuffer(n, n2);
    }

    public static ByteBuf wrappedBuffer(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY_BUFFER;
        }
        return new UnpooledHeapByteBuf(ALLOC, byArray, byArray.length);
    }

    public static ByteBuf wrappedBuffer(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return EMPTY_BUFFER;
        }
        if (n == 0 && n2 == byArray.length) {
            return Unpooled.wrappedBuffer(byArray);
        }
        return Unpooled.wrappedBuffer(byArray).slice(n, n2);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return EMPTY_BUFFER;
        }
        if (!byteBuffer.isDirect() && byteBuffer.hasArray()) {
            return Unpooled.wrappedBuffer(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining()).order(byteBuffer.order());
        }
        if (PlatformDependent.hasUnsafe()) {
            if (byteBuffer.isReadOnly()) {
                if (byteBuffer.isDirect()) {
                    return new ReadOnlyUnsafeDirectByteBuf(ALLOC, byteBuffer);
                }
                return new ReadOnlyByteBufferBuf(ALLOC, byteBuffer);
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            return new UnpooledUnsafeDirectByteBuf(ALLOC, byteBuffer2, byteBuffer2.remaining());
        }
        if (byteBuffer.isReadOnly()) {
            return new ReadOnlyByteBufferBuf(ALLOC, byteBuffer);
        }
        ByteBuffer byteBuffer3 = byteBuffer;
        return new UnpooledDirectByteBuf(ALLOC, byteBuffer3, byteBuffer3.remaining());
    }

    public static ByteBuf wrappedBuffer(long l, int n, boolean bl) {
        return new WrappedUnpooledUnsafeDirectByteBuf(ALLOC, l, n, bl);
    }

    public static ByteBuf wrappedBuffer(ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            return byteBuf.slice();
        }
        byteBuf.release();
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(byte[] ... byArray) {
        return Unpooled.wrappedBuffer(byArray.length, byArray);
    }

    public static ByteBuf wrappedBuffer(ByteBuf ... byteBufArray) {
        return Unpooled.wrappedBuffer(byteBufArray.length, byteBufArray);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer ... byteBufferArray) {
        return Unpooled.wrappedBuffer(byteBufferArray.length, byteBufferArray);
    }

    static <T> ByteBuf wrappedBuffer(int n, CompositeByteBuf.ByteWrapper<T> byteWrapper, T[] TArray) {
        switch (TArray.length) {
            case 0: {
                break;
            }
            case 1: {
                if (byteWrapper.isEmpty(TArray[0])) break;
                return byteWrapper.wrap(TArray[0]);
            }
            default: {
                int n2 = TArray.length;
                for (int i = 0; i < n2; ++i) {
                    T t = TArray[i];
                    if (t == null) {
                        return EMPTY_BUFFER;
                    }
                    if (byteWrapper.isEmpty(t)) continue;
                    return new CompositeByteBuf(ALLOC, false, n, byteWrapper, TArray, i);
                }
            }
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(int n, byte[] ... byArray) {
        return Unpooled.wrappedBuffer(n, CompositeByteBuf.BYTE_ARRAY_WRAPPER, byArray);
    }

    public static ByteBuf wrappedBuffer(int n, ByteBuf ... byteBufArray) {
        switch (byteBufArray.length) {
            case 0: {
                break;
            }
            case 1: {
                ByteBuf byteBuf = byteBufArray[0];
                if (byteBuf.isReadable()) {
                    return Unpooled.wrappedBuffer(byteBuf.order(BIG_ENDIAN));
                }
                byteBuf.release();
                break;
            }
            default: {
                for (int i = 0; i < byteBufArray.length; ++i) {
                    ByteBuf byteBuf = byteBufArray[i];
                    if (byteBuf.isReadable()) {
                        return new CompositeByteBuf(ALLOC, false, n, byteBufArray, i);
                    }
                    byteBuf.release();
                }
            }
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf wrappedBuffer(int n, ByteBuffer ... byteBufferArray) {
        return Unpooled.wrappedBuffer(n, CompositeByteBuf.BYTE_BUFFER_WRAPPER, byteBufferArray);
    }

    public static CompositeByteBuf compositeBuffer() {
        return Unpooled.compositeBuffer(16);
    }

    public static CompositeByteBuf compositeBuffer(int n) {
        return new CompositeByteBuf(ALLOC, false, n);
    }

    public static ByteBuf copiedBuffer(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((byte[])byArray.clone());
    }

    public static ByteBuf copiedBuffer(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray2 = PlatformDependent.allocateUninitializedArray((int)n2);
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return Unpooled.wrappedBuffer(byArray2);
    }

    public static ByteBuf copiedBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n == 0) {
            return EMPTY_BUFFER;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray((int)n);
        byteBuffer = byteBuffer.duplicate();
        byteBuffer.get(byArray);
        return Unpooled.wrappedBuffer(byArray).order(byteBuffer.order());
    }

    public static ByteBuf copiedBuffer(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n > 0) {
            ByteBuf byteBuf2 = Unpooled.buffer(n);
            ByteBuf byteBuf3 = byteBuf;
            byteBuf2.writeBytes(byteBuf3, byteBuf3.readerIndex(), n);
            return byteBuf2;
        }
        return EMPTY_BUFFER;
    }

    public static ByteBuf copiedBuffer(byte[] ... byArray) {
        byte[] byArray2;
        int n;
        switch (byArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                if (byArray[0].length == 0) {
                    return EMPTY_BUFFER;
                }
                return Unpooled.copiedBuffer(byArray[0]);
            }
        }
        int n2 = 0;
        Object object = byArray;
        int n3 = byArray.length;
        for (n = 0; n < n3; ++n) {
            byArray2 = object[n];
            if (Integer.MAX_VALUE - n2 < byArray2.length) {
                throw new IllegalArgumentException("The total length of the specified arrays is too big.");
            }
            n2 += byArray2.length;
        }
        if (n2 == 0) {
            return EMPTY_BUFFER;
        }
        object = PlatformDependent.allocateUninitializedArray((int)n2);
        n = 0;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            byArray2 = byArray[n3];
            System.arraycopy(byArray2, 0, object, n, byArray2.length);
            n += byArray2.length;
        }
        return Unpooled.wrappedBuffer((byte[])object);
    }

    public static ByteBuf copiedBuffer(ByteBuf ... byteBufArray) {
        int n;
        ByteBuf byteBuf;
        int n2;
        switch (byteBufArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.copiedBuffer(byteBufArray[0]);
            }
        }
        ByteOrder byteOrder = null;
        int n3 = 0;
        Object[] objectArray = byteBufArray;
        int n4 = byteBufArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            byteBuf = objectArray[n2];
            n = byteBuf.readableBytes();
            if (n <= 0) continue;
            if (Integer.MAX_VALUE - n3 < n) {
                throw new IllegalArgumentException("The total length of the specified buffers is too big.");
            }
            n3 += n;
            if (byteOrder != null) {
                if (byteOrder.equals(byteBuf.order())) continue;
                throw new IllegalArgumentException("inconsistent byte order");
            }
            byteOrder = byteBuf.order();
        }
        if (n3 == 0) {
            return EMPTY_BUFFER;
        }
        objectArray = PlatformDependent.allocateUninitializedArray((int)n3);
        n2 = 0;
        for (n4 = 0; n4 < byteBufArray.length; ++n4) {
            byteBuf = byteBufArray[n4];
            n = byteBuf.readableBytes();
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.getBytes(byteBuf2.readerIndex(), (byte[])objectArray, n2, n);
            n2 += n;
        }
        return Unpooled.wrappedBuffer((byte[])objectArray).order(byteOrder);
    }

    public static ByteBuf copiedBuffer(ByteBuffer ... byteBufferArray) {
        int n;
        ByteBuffer byteBuffer;
        int n2;
        switch (byteBufferArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.copiedBuffer(byteBufferArray[0]);
            }
        }
        ByteOrder byteOrder = null;
        int n3 = 0;
        Object[] objectArray = byteBufferArray;
        int n4 = byteBufferArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            byteBuffer = objectArray[n2];
            n = byteBuffer.remaining();
            if (n <= 0) continue;
            if (Integer.MAX_VALUE - n3 < n) {
                throw new IllegalArgumentException("The total length of the specified buffers is too big.");
            }
            n3 += n;
            if (byteOrder != null) {
                if (byteOrder.equals(byteBuffer.order())) continue;
                throw new IllegalArgumentException("inconsistent byte order");
            }
            byteOrder = byteBuffer.order();
        }
        if (n3 == 0) {
            return EMPTY_BUFFER;
        }
        objectArray = PlatformDependent.allocateUninitializedArray((int)n3);
        n2 = 0;
        for (n4 = 0; n4 < byteBufferArray.length; ++n4) {
            byteBuffer = byteBufferArray[n4].duplicate();
            n = byteBuffer.remaining();
            byteBuffer.get((byte[])objectArray, n2, n);
            n2 += n;
        }
        return Unpooled.wrappedBuffer((byte[])objectArray).order(byteOrder);
    }

    public static ByteBuf copiedBuffer(CharSequence charSequence, Charset charset) {
        ObjectUtil.checkNotNull((Object)charSequence, (String)"string");
        if (CharsetUtil.UTF_8.equals(charset)) {
            return Unpooled.copiedBufferUtf8(charSequence);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return Unpooled.copiedBufferAscii(charSequence);
        }
        if (charSequence instanceof CharBuffer) {
            return Unpooled.copiedBuffer((CharBuffer)charSequence, charset);
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence), charset);
    }

    private static ByteBuf copiedBufferUtf8(CharSequence object) {
        boolean bl = true;
        ByteBuf byteBuf = ALLOC.heapBuffer(ByteBufUtil.utf8Bytes((CharSequence)object));
        try {
            ByteBufUtil.writeUtf8(byteBuf, (CharSequence)object);
            bl = false;
            object = byteBuf;
            return object;
        }
        catch (Throwable throwable) {
            if (bl) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    private static ByteBuf copiedBufferAscii(CharSequence object) {
        boolean bl = true;
        ByteBuf byteBuf = ALLOC.heapBuffer(object.length());
        try {
            ByteBufUtil.writeAscii(byteBuf, (CharSequence)object);
            bl = false;
            object = byteBuf;
            return object;
        }
        catch (Throwable throwable) {
            if (bl) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    public static ByteBuf copiedBuffer(CharSequence charSequence, int n, int n2, Charset charset) {
        ObjectUtil.checkNotNull((Object)charSequence, (String)"string");
        if (n2 == 0) {
            return EMPTY_BUFFER;
        }
        if (charSequence instanceof CharBuffer) {
            if (((CharBuffer)(charSequence = (CharBuffer)charSequence)).hasArray()) {
                return Unpooled.copiedBuffer(((CharBuffer)charSequence).array(), ((CharBuffer)charSequence).arrayOffset() + ((Buffer)((Object)charSequence)).position() + n, n2, charset);
            }
            charSequence = ((CharBuffer)charSequence).slice();
            ((CharBuffer)charSequence).limit(n2);
            ((CharBuffer)charSequence).position(n);
            return Unpooled.copiedBuffer((CharBuffer)charSequence, charset);
        }
        int n3 = n;
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence, n3, n3 + n2), charset);
    }

    public static ByteBuf copiedBuffer(char[] cArray, Charset charset) {
        ObjectUtil.checkNotNull((Object)cArray, (String)"array");
        return Unpooled.copiedBuffer(cArray, 0, cArray.length, charset);
    }

    public static ByteBuf copiedBuffer(char[] cArray, int n, int n2, Charset charset) {
        ObjectUtil.checkNotNull((Object)cArray, (String)"array");
        if (n2 == 0) {
            return EMPTY_BUFFER;
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(cArray, n, n2), charset);
    }

    private static ByteBuf copiedBuffer(CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(ALLOC, true, charBuffer, charset, 0);
    }

    @Deprecated
    public static ByteBuf unmodifiableBuffer(ByteBuf byteBuf) {
        ByteOrder byteOrder = byteBuf.order();
        if (byteOrder == BIG_ENDIAN) {
            return new ReadOnlyByteBuf(byteBuf);
        }
        return ((ByteBuf)new ReadOnlyByteBuf(byteBuf.order(BIG_ENDIAN))).order(LITTLE_ENDIAN);
    }

    public static ByteBuf copyInt(int n) {
        ByteBuf byteBuf = Unpooled.buffer(4);
        byteBuf.writeInt(n);
        return byteBuf;
    }

    public static ByteBuf copyInt(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length << 2);
        for (int n : nArray) {
            byteBuf.writeInt(n);
        }
        return byteBuf;
    }

    public static ByteBuf copyShort(int n) {
        ByteBuf byteBuf = Unpooled.buffer(2);
        byteBuf.writeShort(n);
        return byteBuf;
    }

    public static ByteBuf copyShort(short ... sArray) {
        if (sArray == null || sArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(sArray.length << 1);
        for (short s : sArray) {
            byteBuf.writeShort(s);
        }
        return byteBuf;
    }

    public static ByteBuf copyShort(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length << 1);
        for (int n : nArray) {
            byteBuf.writeShort(n);
        }
        return byteBuf;
    }

    public static ByteBuf copyMedium(int n) {
        ByteBuf byteBuf = Unpooled.buffer(3);
        byteBuf.writeMedium(n);
        return byteBuf;
    }

    public static ByteBuf copyMedium(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(nArray.length * 3);
        for (int n : nArray) {
            byteBuf.writeMedium(n);
        }
        return byteBuf;
    }

    public static ByteBuf copyLong(long l) {
        ByteBuf byteBuf = Unpooled.buffer(8);
        byteBuf.writeLong(l);
        return byteBuf;
    }

    public static ByteBuf copyLong(long ... lArray) {
        if (lArray == null || lArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(lArray.length << 3);
        for (long l : lArray) {
            byteBuf.writeLong(l);
        }
        return byteBuf;
    }

    public static ByteBuf copyBoolean(boolean bl) {
        ByteBuf byteBuf = Unpooled.buffer(1);
        byteBuf.writeBoolean(bl);
        return byteBuf;
    }

    public static ByteBuf copyBoolean(boolean ... blArray) {
        if (blArray == null || blArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(blArray.length);
        for (boolean bl : blArray) {
            byteBuf.writeBoolean(bl);
        }
        return byteBuf;
    }

    public static ByteBuf copyFloat(float f) {
        ByteBuf byteBuf = Unpooled.buffer(4);
        byteBuf.writeFloat(f);
        return byteBuf;
    }

    public static ByteBuf copyFloat(float ... fArray) {
        if (fArray == null || fArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(fArray.length << 2);
        for (float f : fArray) {
            byteBuf.writeFloat(f);
        }
        return byteBuf;
    }

    public static ByteBuf copyDouble(double d) {
        ByteBuf byteBuf = Unpooled.buffer(8);
        byteBuf.writeDouble(d);
        return byteBuf;
    }

    public static ByteBuf copyDouble(double ... dArray) {
        if (dArray == null || dArray.length == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuf byteBuf = Unpooled.buffer(dArray.length << 3);
        for (double d : dArray) {
            byteBuf.writeDouble(d);
        }
        return byteBuf;
    }

    public static ByteBuf unreleasableBuffer(ByteBuf byteBuf) {
        return new UnreleasableByteBuf(byteBuf);
    }

    @Deprecated
    public static ByteBuf unmodifiableBuffer(ByteBuf ... byteBufArray) {
        return Unpooled.wrappedUnmodifiableBuffer(true, byteBufArray);
    }

    public static ByteBuf wrappedUnmodifiableBuffer(ByteBuf ... byteBufArray) {
        return Unpooled.wrappedUnmodifiableBuffer(false, byteBufArray);
    }

    private static ByteBuf wrappedUnmodifiableBuffer(boolean bl, ByteBuf ... byteBufArray) {
        switch (byteBufArray.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return byteBufArray[0].asReadOnly();
            }
        }
        if (bl) {
            byteBufArray = (ByteBuf[])Arrays.copyOf(byteBufArray, byteBufArray.length, ByteBuf[].class);
        }
        return new FixedCompositeByteBuf(ALLOC, byteBufArray);
    }

    private Unpooled() {
    }

    static {
        assert (EMPTY_BUFFER instanceof EmptyByteBuf) : "EMPTY_BUFFER must be an EmptyByteBuf.";
    }
}

