/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer.search;

import io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import io.netty.buffer.search.MultiSearchProcessor;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;

public class AhoCorasicSearchProcessorFactory
extends AbstractMultiSearchProcessorFactory {
    private final int[] jumpTable;
    private final int[] matchForNeedleId;
    static final int BITS_PER_SYMBOL = 8;
    static final int ALPHABET_SIZE = 256;

    AhoCorasicSearchProcessorFactory(byte[] ... byArray) {
        Object object = byArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = object[i];
            if (byArray2.length != 0) continue;
            throw new IllegalArgumentException("Needle must be non empty");
        }
        object = AhoCorasicSearchProcessorFactory.buildTrie(byArray);
        this.jumpTable = object.jumpTable;
        this.matchForNeedleId = object.matchForNeedleId;
        this.linkSuffixes();
        for (n = 0; n < this.jumpTable.length; ++n) {
            if (this.matchForNeedleId[this.jumpTable[n] >> 8] < 0) continue;
            this.jumpTable[n] = -this.jumpTable[n];
        }
    }

    private static Context buildTrie(byte[][] byArray) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(256);
        for (int i = 0; i < 256; ++i) {
            arrayList.add(-1);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(-1);
        for (int i = 0; i < byArray.length; ++i) {
            byte[] byArray2 = byArray[i];
            int n2 = 0;
            for (int n3 : byArray2) {
                if ((Integer)arrayList.get(n2 += (n3 &= 0xFF)) == -1) {
                    arrayList.set(n2, arrayList.size());
                    for (n3 = 0; n3 < 256; ++n3) {
                        arrayList.add(-1);
                    }
                    arrayList2.add(-1);
                }
                n2 = (Integer)arrayList.get(n2);
            }
            arrayList2.set(n2 >> 8, i);
        }
        Context context = new Context();
        new Context().jumpTable = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            context.jumpTable[n] = (Integer)arrayList.get(n);
        }
        context.matchForNeedleId = new int[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            context.matchForNeedleId[n] = (Integer)arrayList2.get(n);
        }
        return context;
    }

    private void linkSuffixes() {
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        arrayDeque.add(0);
        int[] nArray = new int[this.matchForNeedleId.length];
        Arrays.fill(nArray, -1);
        while (!arrayDeque.isEmpty()) {
            int n;
            int n2 = (Integer)arrayDeque.remove();
            int n3 = n2 >> 8;
            int n4 = n = nArray[n3] == -1 ? 0 : nArray[n3];
            if (this.matchForNeedleId[n3] == -1) {
                this.matchForNeedleId[n3] = this.matchForNeedleId[n >> 8];
            }
            for (n3 = 0; n3 < 256; ++n3) {
                int n5 = n2 | n3;
                int n6 = n | n3;
                int n7 = this.jumpTable[n5];
                n6 = this.jumpTable[n6];
                if (n7 != -1) {
                    nArray[n7 >> 8] = n2 > 0 && n6 != -1 ? n6 : 0;
                    arrayDeque.add(n7);
                    continue;
                }
                this.jumpTable[n5] = n6 != -1 ? n6 : 0;
            }
        }
    }

    @Override
    public Processor newSearchProcessor() {
        return new Processor(this.jumpTable, this.matchForNeedleId);
    }

    public static class Processor
    implements MultiSearchProcessor {
        private final int[] jumpTable;
        private final int[] matchForNeedleId;
        private long currentPosition;

        Processor(int[] nArray, int[] nArray2) {
            this.jumpTable = nArray;
            this.matchForNeedleId = nArray2;
        }

        public boolean process(byte by) {
            this.currentPosition = PlatformDependent.getInt((int[])this.jumpTable, (long)(this.currentPosition | (long)by & 0xFFL));
            if (this.currentPosition < 0L) {
                this.currentPosition = -this.currentPosition;
                return false;
            }
            return true;
        }

        @Override
        public int getFoundNeedleId() {
            return this.matchForNeedleId[(int)this.currentPosition >> 8];
        }

        @Override
        public void reset() {
            this.currentPosition = 0L;
        }
    }

    private static class Context {
        int[] jumpTable;
        int[] matchForNeedleId;

        private Context() {
        }
    }
}

