/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class IntIntHashMap
implements Cloneable,
Iterable<Entry> {
    private final float loadFactor;
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;
    private int keyNotFoundValue = -1;
    private static final boolean isPrimitive;
    private static final Constructor<Entry> entryConstructor;
    private static final Method equalsMethod;

    public IntIntHashMap() {
        this(16, 0.75f);
    }

    public IntIntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntIntHashMap(int n, float f) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private IntIntHashMap(float f, int n, int n2, int n3, int n4, int n5, int n6) {
        this.loadFactor = f;
        this.table = new Entry[n];
        this.size = n2;
        this.mask = n3;
        this.capacity = n4;
        this.threshold = n5;
        this.keyNotFoundValue = n6;
    }

    public Object clone() {
        IntIntHashMap intIntHashMap = new IntIntHashMap(this.loadFactor, this.table.length, this.size, this.mask, this.capacity, this.threshold, this.keyNotFoundValue);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (int i = this.table.length - 1; i >= 0; --i) {
            Entry entry = this.table[i];
            while (entry != null) {
                arrayList.add(entry);
                entry = entry.next;
            }
            int n = arrayList.size();
            Entry entry2 = null;
            for (int j = n - 1; j >= 0; --j) {
                Entry entry3 = (Entry)arrayList.remove(j);
                if (isPrimitive) {
                    entry2 = new Entry(entry3.key, entry3.value, entry2);
                    continue;
                }
                Object object = ReflectionUtil.callMethod(entry3.value, IntIntHashMap.getCloneMethod(entry3.value), new Object[0]);
                entry2 = (Entry)ReflectionUtil.createInstance(entryConstructor, entry3.key, object, entry2);
            }
            intIntHashMap.table[i] = entry2;
        }
        return intIntHashMap;
    }

    public boolean containsValue(int n) {
        Entry[] entryArray = this.table;
        int n2 = this.table.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                Boolean bl;
                if (isPrimitive ? entry.value == n : (bl = (Boolean)ReflectionUtil.callMethod(n, equalsMethod, entry.value)) != false) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        Object object = this.table;
        int n2 = n & this.mask;
        object = object[n2];
        while (object != null) {
            if (object.key == n) {
                return true;
            }
            object = object.next;
        }
        return false;
    }

    public int get(int n) {
        Object object = this.table;
        int n2 = n & this.mask;
        object = object[n2];
        while (object != null) {
            if (object.key == n) {
                return object.value;
            }
            object = object.next;
        }
        return this.keyNotFoundValue;
    }

    public int put(int n, int n2) {
        Entry[] entryArray = this.table;
        int n3 = n & this.mask;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n) {
                n = entry.value;
                entry.value = n2;
                return n;
            }
            entry = entry.next;
        }
        entryArray[n3] = new Entry(n, n2, entryArray[n3]);
        if (this.size++ >= this.threshold) {
            int n4 = 2 * this.capacity;
            Entry[] entryArray2 = new Entry[n4];
            n2 = n4 - 1;
            for (n3 = 0; n3 < entryArray.length; ++n3) {
                Entry entry2;
                Entry entry3 = entryArray[n3];
                if (entry3 == null) continue;
                entryArray[n3] = null;
                do {
                    entry2 = entry3.next;
                    int n5 = entry3.key & n2;
                    entry3.next = entryArray2[n5];
                    entryArray2[n5] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray2;
            this.capacity = n4;
            this.threshold = (int)((float)n4 * this.loadFactor);
            this.mask = n2;
        }
        return this.keyNotFoundValue;
    }

    public void putAll(IntIntHashMap object) {
        object = ((IntIntHashMap)object).iterator();
        while (object.hasNext()) {
            Entry entry = (Entry)object.next();
            this.put(entry.key, entry.value);
        }
    }

    public int remove(int n) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == n) {
                --this.size;
                if (entry == entry2) {
                    entryArray[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return this.keyNotFoundValue;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new EntryIterator(this.table);
    }

    public int setKeyNotFoundValue(int n) {
        int n2 = this.keyNotFoundValue;
        this.keyNotFoundValue = n;
        return n2;
    }

    public int getKeyNotFoundValue() {
        return this.keyNotFoundValue;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("{");
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    private static Method getCloneMethod(final Object clazz) {
        clazz = clazz.getClass();
        return SecurityUtil.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod("clone", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new JogampRuntimeException("Class " + clazz + " doesn't support clone()", noSuchMethodException);
                }
            }
        });
    }

    static {
        final Object object = Integer.TYPE;
        final Class<Integer> clazz = Integer.TYPE;
        isPrimitive = ((Class)object).isPrimitive();
        if (!isPrimitive) {
            object = SecurityUtil.doPrivileged(new PrivilegedAction<EntryCM>(){

                @Override
                public EntryCM run() {
                    EntryCM entryCM = new EntryCM();
                    new EntryCM().c = ReflectionUtil.getConstructor(Entry.class, clazz, object, Entry.class);
                    try {
                        entryCM.m1 = object.getDeclaredMethod("equals", Object.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new JogampRuntimeException("Class " + object + " doesn't support equals(Object)");
                    }
                    return entryCM;
                }
            });
            entryConstructor = ((EntryCM)object).c;
            equalsMethod = ((EntryCM)object).m1;
        } else {
            entryConstructor = null;
            equalsMethod = null;
        }
    }

    public static final class Entry {
        public final int key;
        public int value;
        Entry next;

        Entry(int n, int n2, Entry entry) {
            this.key = n;
            this.value = n2;
            this.next = entry;
        }

        public final int getKey() {
            return this.key;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }

        public final StringBuilder toString(StringBuilder stringBuilder) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("[").append(this.key).append(":").append(this.value).append("]");
            return stringBuilder;
        }

        public final String toString() {
            return this.toString(null).toString();
        }
    }

    private static final class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] entries;
        private int index;
        private Entry next;

        private EntryIterator(Entry[] entryArray) {
            this.entries = entryArray;
            this.next();
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final Entry next() {
            Entry entry = this.next;
            if (entry != null && entry.next != null) {
                this.next = entry.next;
            } else {
                while (this.index < this.entries.length) {
                    Entry entry2;
                    if ((entry2 = this.entries[this.index++]) == null) continue;
                    this.next = entry2;
                    return entry;
                }
                this.next = null;
            }
            return entry;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class EntryCM {
        Constructor<Entry> c = null;
        Method m1 = null;

        EntryCM() {
        }
    }
}

