/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.util.ReflectionUtil;
import java.io.File;
import java.lang.reflect.Method;

public class AndroidUtils {
    private static final Method androidGetPackageInfoVersionNameMethod;
    private static final Method androidGetPackageInfoVersionCodeMethod;
    private static final Method androidGetTempRootMethod;

    public static final int getPackageInfoVersionCode(String string) {
        if (androidGetPackageInfoVersionCodeMethod != null) {
            return (Integer)ReflectionUtil.callMethod(null, androidGetPackageInfoVersionCodeMethod, string);
        }
        return -1;
    }

    public static final String getPackageInfoVersionName(String string) {
        if (androidGetPackageInfoVersionNameMethod != null) {
            return (String)ReflectionUtil.callMethod(null, androidGetPackageInfoVersionNameMethod, string);
        }
        return null;
    }

    public static File getTempRoot() {
        if (androidGetTempRootMethod != null) {
            return (File)ReflectionUtil.callMethod(null, androidGetTempRootMethod, new Object[0]);
        }
        return null;
    }

    static {
        if (AndroidVersion.isAvailable) {
            Object object = AndroidUtils.class.getClassLoader();
            object = ReflectionUtil.getClass("jogamp.common.os.android.AndroidUtilsImpl", true, (ClassLoader)object);
            androidGetPackageInfoVersionCodeMethod = ReflectionUtil.getMethod(object, "getPackageInfoVersionCode", new Class[]{String.class});
            androidGetPackageInfoVersionNameMethod = ReflectionUtil.getMethod(object, "getPackageInfoVersionName", new Class[]{String.class});
            androidGetTempRootMethod = ReflectionUtil.getMethod(object, "getTempRoot", new Class[0]);
        } else {
            androidGetPackageInfoVersionCodeMethod = null;
            androidGetPackageInfoVersionNameMethod = null;
            androidGetTempRootMethod = null;
        }
    }
}

