/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.AbstractAnnotationTypeQualifierResolver;
import kotlin.reflect.jvm.internal.impl.load.java.JavaTypeEnhancementState;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;

public final class AnnotationTypeQualifierResolver
extends AbstractAnnotationTypeQualifierResolver<AnnotationDescriptor> {
    public AnnotationTypeQualifierResolver(JavaTypeEnhancementState javaTypeEnhancementState) {
        Intrinsics.checkNotNullParameter((Object)javaTypeEnhancementState, (String)"");
        super(javaTypeEnhancementState);
    }

    @Override
    public final boolean isK2() {
        return false;
    }

    @Override
    protected final Iterable<AnnotationDescriptor> getMetaAnnotations(AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"");
        Object object = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        if (object != null && (object = object.getAnnotations()) != null) {
            return (Iterable)object;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    protected final Object getKey(AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        Intrinsics.checkNotNull((Object)classDescriptor);
        return classDescriptor;
    }

    @Override
    protected final FqName getFqName(AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"");
        return annotationDescriptor.getFqName();
    }

    @Override
    protected final Iterable<String> enumArguments(AnnotationDescriptor object, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = object.getAllValueArguments();
        Collection collection = new ArrayList();
        for (Map.Entry entry : object.entrySet()) {
            Object object2 = entry;
            object2 = entry;
            Name name = (Name)entry.getKey();
            object2 = (ConstantValue)object2.getValue();
            object2 = !bl || Intrinsics.areEqual((Object)name, (Object)JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME) ? this.toEnumNames((ConstantValue<?>)object2) : CollectionsKt.emptyList();
            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
        }
        return (List)collection;
    }

    private final List<String> toEnumNames(ConstantValue<?> iterator2) {
        Iterator iterator3 = iterator2;
        if (iterator3 instanceof ArrayValue) {
            iterator2 = (Iterable)((ArrayValue)((Object)iterator2)).getValue();
            iterator3 = new ArrayList();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                object = (ConstantValue)object;
                object = this.toEnumNames((ConstantValue<?>)object);
                CollectionsKt.addAll((Collection)((Object)iterator3), object);
            }
            return (List)((Object)iterator3);
        }
        if (iterator3 instanceof EnumValue) {
            return CollectionsKt.listOf((Object)((EnumValue)((Object)iterator2)).getEnumEntryName().getIdentifier());
        }
        return CollectionsKt.emptyList();
    }
}

