/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAbi;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.StringsKt;

public final class PropertiesConventionUtilKt {
    public static final Name propertyNameByGetMethodName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Name name2 = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(name, "get", false, null, 12, null);
        if (name2 == null) {
            name2 = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(name, "is", false, null, 8, null);
        }
        return name2;
    }

    public static final Name propertyNameBySetMethodName(Name name, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(name, "set", false, bl ? "is" : null, 4, null);
    }

    public static final List<Name> propertyNamesBySetMethodName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Object[] objectArray = new Name[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = PropertiesConventionUtilKt.propertyNameBySetMethodName(name, false);
        objectArray2[1] = PropertiesConventionUtilKt.propertyNameBySetMethodName(name, true);
        return CollectionsKt.listOfNotNull((Object[])objectArray2);
    }

    private static final Name propertyNameFromAccessorMethodName(Name name, String string, boolean bl, String string2) {
        if (name.isSpecial()) {
            return null;
        }
        String string3 = name.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        String string4 = string3;
        if (!StringsKt.startsWith$default((String)string3, (String)string, (boolean)false, (int)2, null)) {
            return null;
        }
        if (string4.length() == string.length()) {
            return null;
        }
        char c = string4.charAt(string.length());
        boolean bl2 = 'a' <= c ? c < '{' : false;
        if (bl2) {
            return null;
        }
        if (string2 != null) {
            if (_Assertions.ENABLED && !bl) {
                String string5 = "Assertion failed";
                throw new AssertionError((Object)string5);
            }
            return Name.identifier(string2 + StringsKt.removePrefix((String)string4, (CharSequence)string));
        }
        if (!bl) {
            return name;
        }
        String string6 = CapitalizeDecapitalizeKt.decapitalizeSmartForCompiler(StringsKt.removePrefix((String)string4, (CharSequence)string), true);
        if (!Name.isValidIdentifier(string6)) {
            return null;
        }
        return Name.identifier(string6);
    }

    static /* synthetic */ Name propertyNameFromAccessorMethodName$default(Name name, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName(name, string, bl, string2);
    }

    public static final List<Name> getPropertyNamesCandidatesByAccessorName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        String string = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        String string2 = string;
        if (JvmAbi.isGetterName(string)) {
            return CollectionsKt.listOfNotNull((Object)PropertiesConventionUtilKt.propertyNameByGetMethodName(name));
        }
        if (JvmAbi.isSetterName(string2)) {
            return PropertiesConventionUtilKt.propertyNamesBySetMethodName(name);
        }
        return BuiltinSpecialProperties.INSTANCE.getPropertyNameCandidatesBySpecialGetterName(name);
    }
}

