/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.util.Arrays;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;

public final class JvmMetadataVersion
extends BinaryVersion {
    public static final Companion Companion = new Companion(null);
    private final boolean isStrictSemantics;
    public static final JvmMetadataVersion INSTANCE;
    public static final JvmMetadataVersion INSTANCE_NEXT;
    public static final JvmMetadataVersion INVALID_VERSION;

    public JvmMetadataVersion(int[] nArray, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        super(Arrays.copyOf(nArray, nArray.length));
        this.isStrictSemantics = bl;
    }

    public final boolean isStrictSemantics() {
        return this.isStrictSemantics;
    }

    public JvmMetadataVersion(int ... nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this(nArray, false);
    }

    public final JvmMetadataVersion lastSupportedVersionWithThisLanguageVersion(boolean bl) {
        JvmMetadataVersion jvmMetadataVersion = bl ? INSTANCE : INSTANCE_NEXT;
        if (jvmMetadataVersion.newerThan(this)) {
            return jvmMetadataVersion;
        }
        return this;
    }

    public final boolean isCompatible(JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        if (this.getMajor() == 2 && this.getMinor() == 0 && INSTANCE.getMajor() == 1 && INSTANCE.getMinor() == 8) {
            return true;
        }
        jvmMetadataVersion = jvmMetadataVersion.lastSupportedVersionWithThisLanguageVersion(this.isStrictSemantics);
        return this.isCompatibleInternal(jvmMetadataVersion);
    }

    private final boolean isCompatibleInternal(JvmMetadataVersion jvmMetadataVersion) {
        if (this.getMajor() == 1 && this.getMinor() == 0) {
            return false;
        }
        if (this.getMajor() == 0) {
            return false;
        }
        return !this.newerThan(jvmMetadataVersion);
    }

    public final JvmMetadataVersion next() {
        if (this.getMajor() == 1 && this.getMinor() == 9) {
            int[] nArray = new int[3];
            int[] nArray2 = nArray;
            nArray[0] = 2;
            nArray2[1] = 0;
            nArray2[2] = 0;
            return new JvmMetadataVersion(nArray2);
        }
        int[] nArray = new int[3];
        int[] nArray3 = nArray;
        nArray[0] = this.getMajor();
        nArray3[1] = this.getMinor() + 1;
        nArray3[2] = 0;
        return new JvmMetadataVersion(nArray3);
    }

    private final boolean newerThan(JvmMetadataVersion jvmMetadataVersion) {
        if (this.getMajor() > jvmMetadataVersion.getMajor()) {
            return true;
        }
        return this.getMajor() >= jvmMetadataVersion.getMajor() && this.getMinor() > jvmMetadataVersion.getMinor();
    }

    static {
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = 2;
        nArray2[1] = 1;
        nArray2[2] = 0;
        INSTANCE = new JvmMetadataVersion(nArray2);
        INSTANCE_NEXT = INSTANCE.next();
        INVALID_VERSION = new JvmMetadataVersion(new int[0]);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

