/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import java.io.OutputStream;

public enum ConsoleTarget {
    SystemOut("System.out", new OutputStream(){

        @Override
        public void write(int n) {
            System.out.write(n);
        }

        @Override
        public void write(byte[] byArray) {
            System.out.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            System.out.write(byArray, n, n2);
        }

        @Override
        public void flush() {
            System.out.flush();
        }
    }),
    SystemErr("System.err", new OutputStream(){

        @Override
        public void write(int n) {
            System.err.write(n);
        }

        @Override
        public void write(byte[] byArray) {
            System.err.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            System.err.write(byArray, n, n2);
        }

        @Override
        public void flush() {
            System.err.flush();
        }
    });

    private final String name;
    private final OutputStream stream;

    public static ConsoleTarget findByName(String string) {
        for (ConsoleTarget consoleTarget : ConsoleTarget.values()) {
            if (!consoleTarget.name.equalsIgnoreCase(string)) continue;
            return consoleTarget;
        }
        return null;
    }

    private ConsoleTarget(String string2, OutputStream outputStream) {
        this.name = string2;
        this.stream = outputStream;
    }

    public final String getName() {
        return this.name;
    }

    public final OutputStream getStream() {
        return this.stream;
    }

    public final String toString() {
        return this.name;
    }
}

