/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007\u001a0\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007\u001a8\u0010\u0002\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007\u001a0\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a(\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a0\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a@\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a9\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001aH\u0082\b\u001a\r\u0010\u001c\u001a\u00020\u001d*\u00020\tH\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"MAX_LONG_MILLIS", "", "estimateAnimationDurationMillis", "stiffness", "", "dampingRatio", "initialVelocity", "initialDisplacement", "delta", "", "springConstant", "dampingCoefficient", "mass", "estimateUnderDamped", "firstRootReal", "firstRootImaginary", "p0", "v0", "estimateCriticallyDamped", "estimateOverDamped", "secondRootReal", "estimateDurationInternal", "initialPosition", "iterateNewtonsMethod", "x", "fn", "Lkotlin/Function1;", "fnPrime", "isNotFinite", "", "animation-core"})
public final class SpringEstimationKt {
    private static final long MAX_LONG_MILLIS = 9223372036854L;

    public static final long estimateAnimationDurationMillis(float f2, float f3, float f4, float f5, float f6) {
        if (f3 == 0.0f) {
            return 9223372036854L;
        }
        return SpringEstimationKt.estimateAnimationDurationMillis((double)f2, (double)f3, (double)f4, (double)f5, (double)f6);
    }

    public static final long estimateAnimationDurationMillis(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = d3 * 2.0 * Math.sqrt(d2);
        double d9 = d8 * d8 - d2 * 4.0;
        double d10 = d7 < 0.0 ? 0.0 : Math.sqrt(d9);
        double d11 = d9 < 0.0 ? Math.sqrt(Math.abs(d9)) : 0.0;
        double d12 = (-d8 + d10) * 0.5;
        double d13 = d11 * 0.5;
        double d14 = (-d8 - d10) * 0.5;
        return SpringEstimationKt.estimateDurationInternal(d12, d13, d14, d3, d4, d5, d6);
    }

    public static final long estimateAnimationDurationMillis(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = 2.0 * Math.sqrt(d2 * d4);
        double d9 = d3 / d8;
        double d10 = d3;
        double d11 = d10 * d10 - d4 * 4.0 * d2;
        double d12 = 1.0 / (d4 * 2.0);
        double d13 = d11 < 0.0 ? 0.0 : Math.sqrt(d11);
        double d14 = d11 < 0.0 ? Math.sqrt(Math.abs(d11)) : 0.0;
        double d15 = (-d3 + d13) * d12;
        double d16 = d14 * d12;
        double d17 = (-d3 - d13) * d12;
        return SpringEstimationKt.estimateDurationInternal(d15, d16, d17, d9, d5, d6, d7);
    }

    private static final double estimateUnderDamped(double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d5 - d2 * d4) / d3;
        double d8 = d4;
        double d9 = d7;
        double d10 = Math.sqrt(d8 * d8 + d9 * d9);
        return Math.log(d6 / d10) / d2;
    }

    private static final double estimateCriticallyDamped(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        double d9 = d4 - d2 * d3;
        double d10 = Math.log(Math.abs(d5 / d3)) / d2;
        double d11 = d8 = Math.log(Math.abs(d5 / d9));
        for (int i2 = 0; i2 < 6; ++i2) {
            d11 = d8 - Math.log(Math.abs(d11 / d2));
        }
        double d12 = d11 / d2;
        double d13 = d10;
        if (!((Double.doubleToRawLongBits(d13) & Long.MAX_VALUE) < 0x7FF0000000000000L)) {
            d7 = d12;
        } else {
            double d14 = d13 = d12;
            d7 = !((Double.doubleToRawLongBits(d13) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? d10 : Math.max(d10, d12);
        }
        double d15 = d7;
        d13 = -(d2 * d3 + d9) / (d2 * d9);
        double d16 = d3 * Math.exp(d2 * d13) + d9 * d13 * Math.exp(d2 * d13);
        if (Double.isNaN(d13) || d13 <= 0.0) {
            d6 = -d5;
        } else if (d13 > 0.0 && -d16 < d5) {
            if (d9 < 0.0 && d3 > 0.0) {
                d15 = 0.0;
            }
            d6 = -d5;
        } else {
            d15 = -(2.0 / d2) - d3 / d9;
            d6 = d5;
        }
        double d17 = d6;
        double d18 = Double.MAX_VALUE;
        for (int i3 = 0; d18 > 0.001 && i3 < 100; ++i3) {
            double d19;
            double d20 = d15;
            double d21 = d19 = d15;
            double d22 = (d3 + d9 * d19) * Math.exp(d2 * d19) + d17;
            d19 = d15;
            double d23 = (d9 * (d2 * d19 + 1.0) + d3 * d2) * Math.exp(d2 * d19);
            d15 = d21 - d22 / d23;
            d18 = Math.abs(d20 - d15);
        }
        return d15;
    }

    private static final double estimateOverDamped(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = (d2 * d4 - d5) / (d2 - d3);
        double d10 = d4 - d9;
        double d11 = Math.log(Math.abs(d6 / d10)) / d2;
        double d12 = Math.log(Math.abs(d6 / d9)) / d3;
        double d13 = d11;
        double d14 = !((Double.doubleToRawLongBits(d13) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? d12 : (!((Double.doubleToRawLongBits(d13 = d12) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? d11 : Math.max(d11, d12));
        d13 = Math.log(d10 * d2 / (-d9 * d3)) / (d3 - d2);
        if (Double.isNaN(d13) || d13 <= 0.0) {
            d8 = -d6;
        } else if (d13 > 0.0 && -SpringEstimationKt.estimateOverDamped$xInflection(d10, d2, d13, d9, d3) < d6) {
            if (d9 > 0.0 && d10 < 0.0) {
                d14 = 0.0;
            }
            d8 = -d6;
        } else {
            d14 = Math.log(-(d9 * d3 * d3) / (d10 * d2 * d2)) / (d2 - d3);
            d8 = d7 = d6;
        }
        if (Math.abs(d10 * d2 * Math.exp(d2 * d14) + d9 * d3 * Math.exp(d3 * d14)) < 1.0E-4) {
            return d14;
        }
        double d15 = Double.MAX_VALUE;
        for (int i2 = 0; d15 > 0.001 && i2 < 100; ++i2) {
            double d16;
            double d17 = d14;
            double d18 = d16 = d14;
            double d19 = d10 * Math.exp(d2 * d16) + d9 * Math.exp(d3 * d16) + d7;
            d16 = d14;
            double d20 = d10 * d2 * Math.exp(d2 * d16) + d9 * d3 * Math.exp(d3 * d16);
            d14 = d18 - d19 / d20;
            d15 = Math.abs(d17 - d14);
        }
        return d14;
    }

    private static final long estimateDurationInternal(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (d7 == 0.0 && d6 == 0.0) {
            return 0L;
        }
        double d9 = d7 < 0.0 ? -d6 : d6;
        double d10 = Math.abs(d7);
        return (long)((d5 > 1.0 ? SpringEstimationKt.estimateOverDamped(d2, d4, d10, d9, d8) : (d5 < 1.0 ? SpringEstimationKt.estimateUnderDamped(d2, d3, d10, d9, d8) : SpringEstimationKt.estimateCriticallyDamped(d2, d10, d9, d8))) * 1000.0);
    }

    private static final double iterateNewtonsMethod(double d2, Function1<? super Double, Double> function1, Function1<? super Double, Double> function12) {
        return d2 - ((Number)function1.invoke((Object)d2)).doubleValue() / ((Number)function12.invoke((Object)d2)).doubleValue();
    }

    private static final boolean isNotFinite(double d2) {
        return !((Double.doubleToRawLongBits(d2) & Long.MAX_VALUE) < 0x7FF0000000000000L);
    }

    private static final double estimateOverDamped$xInflection(double d2, double d3, double d4, double d5, double d6) {
        return d2 * Math.exp(d3 * d4) + d5 * Math.exp(d6 * d4);
    }
}

