/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.XmppElementUtil;

public class NonzaCallback {
    protected final AbstractXMPPConnection connection;
    protected final Map<QName, ClassAndConsumer<? extends Nonza>> filterAndListeners;

    private NonzaCallback(Builder builder) {
        this.connection = builder.connection;
        this.filterAndListeners = builder.filterAndListeners;
        this.install();
    }

    void onNonzaReceived(Nonza nonza) {
        Object object = nonza.getQName();
        object = this.filterAndListeners.get(object);
        ((ClassAndConsumer)object).accept(nonza);
    }

    public void cancel() {
        for (Map.Entry<QName, ClassAndConsumer<? extends Nonza>> entry : this.filterAndListeners.entrySet()) {
            QName object = entry.getKey();
            MultiMap<QName, NonzaCallback> multiMap = this.connection.nonzaCallbacksMap;
            synchronized (multiMap) {
                this.connection.nonzaCallbacksMap.removeOne(object, this);
            }
        }
    }

    protected void install() {
        if (this.filterAndListeners.isEmpty()) {
            return;
        }
        for (QName qName : this.filterAndListeners.keySet()) {
            MultiMap<QName, NonzaCallback> multiMap = this.connection.nonzaCallbacksMap;
            synchronized (multiMap) {
                this.connection.nonzaCallbacksMap.put(qName, this);
            }
        }
    }

    static <SN extends Nonza, FN extends Nonza> SN sendAndWaitForResponse(Builder object, Nonza nonza, Class<SN> clazz, Class<FN> clazz2) {
        object = new NonzaResponseCallback(clazz, clazz2, (Builder)object);
        try {
            ((NonzaCallback)object).connection.sendNonza(nonza);
            nonza = ((NonzaResponseCallback)object).waitForResponse();
        }
        finally {
            ((NonzaCallback)object).cancel();
        }
        return (SN)nonza;
    }

    private static final class ClassAndConsumer<N extends Nonza> {
        private final Class<N> clazz;
        private final NonzaListener<N> consumer;

        private ClassAndConsumer(Class<N> clazz, NonzaListener<N> nonzaListener) {
            this.clazz = clazz;
            this.consumer = nonzaListener;
        }

        private void accept(Object object) {
            object = (Nonza)this.clazz.cast(object);
            this.consumer.accept(object);
        }
    }

    public static interface NonzaListener<N extends Nonza> {
        public void accept(N var1);
    }

    public static final class Builder {
        private final AbstractXMPPConnection connection;
        private Map<QName, ClassAndConsumer<? extends Nonza>> filterAndListeners = new HashMap<QName, ClassAndConsumer<? extends Nonza>>();

        Builder(AbstractXMPPConnection abstractXMPPConnection) {
            this.connection = abstractXMPPConnection;
        }

        public final <N extends Nonza> Builder listenFor(Class<N> object, NonzaListener<N> nonzaListener) {
            QName qName = XmppElementUtil.getQNameFor(object);
            object = new ClassAndConsumer((Class)object, nonzaListener);
            this.filterAndListeners.put(qName, (ClassAndConsumer<? extends Nonza>)object);
            return this;
        }

        public final NonzaCallback install() {
            return new NonzaCallback(this);
        }
    }

    private static final class NonzaResponseCallback<SN extends Nonza, FN extends Nonza>
    extends NonzaCallback {
        private SN successNonza;
        private FN failedNonza;

        private NonzaResponseCallback(Class<SN> object, Class<FN> object2, Builder object3) {
            super((Builder)object3);
            object3 = XmppElementUtil.getQNameFor(object);
            QName qName = XmppElementUtil.getQNameFor(object2);
            NonzaListener<Object> nonzaListener = new NonzaListener<SN>(){

                @Override
                public void accept(SN SN) {
                    successNonza = SN;
                    this.notifyResponse();
                }
            };
            object = new ClassAndConsumer((Class)object, nonzaListener);
            nonzaListener = new NonzaListener<FN>(){

                @Override
                public void accept(FN FN) {
                    failedNonza = FN;
                    this.notifyResponse();
                }
            };
            object2 = new ClassAndConsumer((Class)object2, nonzaListener);
            this.filterAndListeners.put((QName)object3, (ClassAndConsumer<? extends Nonza>)object);
            this.filterAndListeners.put(qName, (ClassAndConsumer<? extends Nonza>)object2);
            this.install();
        }

        private void notifyResponse() {
            NonzaResponseCallback nonzaResponseCallback = this;
            synchronized (nonzaResponseCallback) {
                this.notifyAll();
                return;
            }
        }

        private boolean hasReceivedSuccessOrFailedNonza() {
            return this.successNonza != null || this.failedNonza != null;
        }

        private SN waitForResponse() {
            long l = System.currentTimeMillis() + this.connection.getReplyTimeout();
            NonzaResponseCallback nonzaResponseCallback = this;
            synchronized (nonzaResponseCallback) {
                long l2;
                while (!this.hasReceivedSuccessOrFailedNonza() && (l2 = System.currentTimeMillis()) < l) {
                    this.wait(l - l2);
                }
            }
            if (!this.hasReceivedSuccessOrFailedNonza()) {
                throw SmackException.NoResponseException.newWith((XMPPConnection)this.connection, "Nonza Listener");
            }
            if (this.failedNonza != null) {
                throw new XMPPException.FailedNonzaException((Nonza)this.failedNonza);
            }
            assert (this.successNonza != null);
            return this.successNonza;
        }
    }
}

