/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.Java7SslParametersUtils;
import io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;

public class JdkSslContext
extends SslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdkSslContext.class);
    static final String PROTOCOL = "TLS";
    private static final String[] DEFAULT_PROTOCOLS;
    private static final List<String> DEFAULT_CIPHERS;
    private static final List<String> DEFAULT_CIPHERS_NON_TLSV13;
    private static final Set<String> SUPPORTED_CIPHERS;
    private static final Set<String> SUPPORTED_CIPHERS_NON_TLSV13;
    private static final Provider DEFAULT_PROVIDER;
    private final String[] protocols;
    private final String[] cipherSuites;
    private final List<String> unmodifiableCipherSuites;
    private final JdkApplicationProtocolNegotiator apn;
    private final ClientAuth clientAuth;
    private final SSLContext sslContext;
    private final boolean isClient;
    private final String endpointIdentificationAlgorithm;

    private static String[] defaultProtocols(SSLContext object, SSLEngine sSLEngine) {
        object = ((SSLContext)object).getDefaultSSLParameters().getProtocols();
        HashSet<String> hashSet = new HashSet<String>(((String[])object).length);
        Collections.addAll(hashSet, object);
        object = new ArrayList();
        SslUtils.addIfSupported(hashSet, (List<String>)object, "TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1");
        if (!object.isEmpty()) {
            return object.toArray(EmptyArrays.EMPTY_STRINGS);
        }
        return sSLEngine.getEnabledProtocols();
    }

    private static Set<String> supportedCiphers(SSLEngine sSLEngine) {
        String[] stringArray = sSLEngine.getSupportedCipherSuites();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            linkedHashSet.add(string);
            if (!string.startsWith("SSL_")) continue;
            string = "TLS_" + string.substring(4);
            try {
                sSLEngine.setEnabledCipherSuites(new String[]{string});
                linkedHashSet.add(string);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return linkedHashSet;
    }

    private static List<String> defaultCiphers(SSLEngine sSLEngine, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(set, arrayList, SslUtils.DEFAULT_CIPHER_SUITES);
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(arrayList, sSLEngine.getEnabledCipherSuites());
        return arrayList;
    }

    private static boolean isTlsV13Supported(String[] stringArray) {
        for (String string : stringArray) {
            if (!"TLSv1.3".equals(string)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public JdkSslContext(SSLContext sSLContext, boolean bl, ClientAuth clientAuth) {
        this(sSLContext, bl, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, JdkDefaultApplicationProtocolNegotiator.INSTANCE, clientAuth, null, false);
    }

    @Deprecated
    public JdkSslContext(SSLContext sSLContext, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, ClientAuth clientAuth) {
        this(sSLContext, bl, iterable, cipherSuiteFilter, applicationProtocolConfig, clientAuth, null, false);
    }

    public JdkSslContext(SSLContext sSLContext, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, ClientAuth clientAuth, String[] stringArray, boolean bl2) {
        this(sSLContext, bl, iterable, cipherSuiteFilter, JdkSslContext.toNegotiator(applicationProtocolConfig, !bl), clientAuth, stringArray == null ? null : (String[])stringArray.clone(), bl2);
    }

    JdkSslContext(SSLContext sSLContext, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, ClientAuth clientAuth, String[] stringArray, boolean bl2) {
        this(sSLContext, bl, iterable, cipherSuiteFilter, jdkApplicationProtocolNegotiator, clientAuth, stringArray, bl2, null, null);
    }

    JdkSslContext(SSLContext list, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator set, ClientAuth object, String[] stringArray, boolean n, String string, ResumptionController object2) {
        super(n != 0, (ResumptionController)object2);
        this.apn = (JdkApplicationProtocolNegotiator)ObjectUtil.checkNotNull((Object)set, (String)"apn");
        this.clientAuth = (ClientAuth)((Object)ObjectUtil.checkNotNull((Object)object, (String)"clientAuth"));
        this.sslContext = (SSLContext)ObjectUtil.checkNotNull((Object)list, (String)"sslContext");
        this.endpointIdentificationAlgorithm = string;
        if (DEFAULT_PROVIDER.equals(((SSLContext)((Object)list)).getProvider())) {
            String[] stringArray2 = this.protocols = stringArray == null ? DEFAULT_PROTOCOLS : stringArray;
            if (JdkSslContext.isTlsV13Supported(this.protocols)) {
                set = SUPPORTED_CIPHERS;
                list = DEFAULT_CIPHERS;
            } else {
                set = SUPPORTED_CIPHERS_NON_TLSV13;
                list = DEFAULT_CIPHERS_NON_TLSV13;
            }
        } else {
            object = ((SSLContext)((Object)list)).createSSLEngine();
            try {
                this.protocols = stringArray == null ? JdkSslContext.defaultProtocols((SSLContext)((Object)list), (SSLEngine)object) : stringArray;
                set = JdkSslContext.supportedCiphers((SSLEngine)object);
                list = JdkSslContext.defaultCiphers((SSLEngine)object, set);
                if (!JdkSslContext.isTlsV13Supported(this.protocols)) {
                    stringArray = SslUtils.DEFAULT_TLSV13_CIPHER_SUITES;
                    n = SslUtils.DEFAULT_TLSV13_CIPHER_SUITES.length;
                    for (int i = 0; i < n; ++i) {
                        object2 = stringArray[i];
                        set.remove(object2);
                        list.remove(object2);
                    }
                }
            }
            finally {
                ReferenceCountUtil.release((Object)object);
            }
        }
        this.cipherSuites = ((CipherSuiteFilter)ObjectUtil.checkNotNull((Object)cipherSuiteFilter, (String)"cipherFilter")).filterCipherSuites(iterable, list, set);
        this.unmodifiableCipherSuites = Collections.unmodifiableList(Arrays.asList(this.cipherSuites));
        this.isClient = bl;
    }

    public final SSLContext context() {
        return this.sslContext;
    }

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final SSLSessionContext sessionContext() {
        if (this.isServer()) {
            return this.context().getServerSessionContext();
        }
        return this.context().getClientSessionContext();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCipherSuites;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        JdkSslContext jdkSslContext = this;
        return jdkSslContext.configureAndWrapEngine(jdkSslContext.context().createSSLEngine(), byteBufAllocator);
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n) {
        JdkSslContext jdkSslContext = this;
        return jdkSslContext.configureAndWrapEngine(jdkSslContext.context().createSSLEngine(string, n), byteBufAllocator);
    }

    private SSLEngine configureAndWrapEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator) {
        sSLEngine.setEnabledCipherSuites(this.cipherSuites);
        sSLEngine.setEnabledProtocols(this.protocols);
        sSLEngine.setUseClientMode(((SslContext)this).isClient());
        if (this.isServer()) {
            switch (this.clientAuth) {
                case OPTIONAL: {
                    sSLEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sSLEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + (Object)((Object)this.clientAuth));
                }
            }
        }
        this.configureEndpointVerification(sSLEngine);
        JdkApplicationProtocolNegotiator.SslEngineWrapperFactory sslEngineWrapperFactory = this.apn.wrapperFactory();
        if (sslEngineWrapperFactory instanceof JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory) {
            return ((JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory)sslEngineWrapperFactory).wrapSslEngine(sSLEngine, byteBufAllocator, this.apn, this.isServer());
        }
        return sslEngineWrapperFactory.wrapSslEngine(sSLEngine, this.apn, this.isServer());
    }

    private void configureEndpointVerification(SSLEngine sSLEngine) {
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            Java7SslParametersUtils.setEndpointIdentificationAlgorithm(sSLParameters, this.endpointIdentificationAlgorithm);
            sSLEngine.setSSLParameters(sSLParameters);
        }
    }

    @Override
    public final JdkApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig, boolean bl) {
        if (applicationProtocolConfig == null) {
            return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case ALPN: {
                if (bl) {
                    switch (applicationProtocolConfig.selectorFailureBehavior()) {
                        case FATAL_ALERT: {
                            return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                        case NO_ADVERTISE: {
                            return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
            }
            case NPN: {
                if (bl) {
                    switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                        case ACCEPT: {
                            return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                        case FATAL_ALERT: {
                            return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectorFailureBehavior()) {
                    case FATAL_ALERT: {
                        return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                    case NO_ADVERTISE: {
                        return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.protocol()) + " protocol");
    }

    static KeyManagerFactory buildKeyManagerFactory(File file, File file2, String string, KeyManagerFactory keyManagerFactory, String string2) {
        String string3 = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (string3 == null) {
            string3 = "SunX509";
        }
        return JdkSslContext.buildKeyManagerFactory(file, string3, file2, string, keyManagerFactory, string2);
    }

    @Deprecated
    protected static KeyManagerFactory buildKeyManagerFactory(File file, File file2, String string, KeyManagerFactory keyManagerFactory) {
        return JdkSslContext.buildKeyManagerFactory(file, file2, string, keyManagerFactory, KeyStore.getDefaultType());
    }

    static KeyManagerFactory buildKeyManagerFactory(File file, String string, File file2, String string2, KeyManagerFactory keyManagerFactory, String string3) {
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(file), string, JdkSslContext.toPrivateKey(file2, string2), string2, keyManagerFactory, string3);
    }

    @Deprecated
    protected static KeyManagerFactory buildKeyManagerFactory(File file, String string, File file2, String string2, KeyManagerFactory keyManagerFactory) {
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(file), string, JdkSslContext.toPrivateKey(file2, string2), string2, keyManagerFactory, KeyStore.getDefaultType());
    }

    static {
        Defaults defaults = new Defaults();
        defaults.init();
        DEFAULT_PROVIDER = defaults.defaultProvider;
        DEFAULT_PROTOCOLS = defaults.defaultProtocols;
        SUPPORTED_CIPHERS = defaults.supportedCiphers;
        DEFAULT_CIPHERS = defaults.defaultCiphers;
        DEFAULT_CIPHERS_NON_TLSV13 = defaults.defaultCiphersNonTLSv13;
        SUPPORTED_CIPHERS_NON_TLSV13 = defaults.supportedCiphersNonTLSv13;
        if (logger.isDebugEnabled()) {
            logger.debug("Default protocols (JDK): {} ", Arrays.asList(DEFAULT_PROTOCOLS));
            logger.debug("Default cipher suites (JDK): {}", DEFAULT_CIPHERS);
        }
    }

    private static final class Defaults {
        String[] defaultProtocols;
        List<String> defaultCiphers;
        List<String> defaultCiphersNonTLSv13;
        Set<String> supportedCiphers;
        Set<String> supportedCiphersNonTLSv13;
        Provider defaultProvider;

        private Defaults() {
        }

        final void init() {
            LinkedHashSet<String> linkedHashSet;
            try {
                linkedHashSet = SSLContext.getInstance(JdkSslContext.PROTOCOL);
                ((SSLContext)((Object)linkedHashSet)).init(null, null, null);
            }
            catch (Exception exception) {
                throw new Error("failed to initialize the default SSL context", exception);
            }
            this.defaultProvider = ((SSLContext)((Object)linkedHashSet)).getProvider();
            SSLEngine sSLEngine = ((SSLContext)((Object)linkedHashSet)).createSSLEngine();
            this.defaultProtocols = JdkSslContext.defaultProtocols((SSLContext)((Object)linkedHashSet), sSLEngine);
            this.supportedCiphers = Collections.unmodifiableSet(JdkSslContext.supportedCiphers(sSLEngine));
            this.defaultCiphers = Collections.unmodifiableList(JdkSslContext.defaultCiphers(sSLEngine, this.supportedCiphers));
            linkedHashSet = new ArrayList<String>(this.defaultCiphers);
            linkedHashSet.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
            this.defaultCiphersNonTLSv13 = Collections.unmodifiableList(linkedHashSet);
            linkedHashSet = new LinkedHashSet<String>(this.supportedCiphers);
            linkedHashSet.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
            this.supportedCiphersNonTLSv13 = Collections.unmodifiableSet(linkedHashSet);
        }
    }
}

