/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class InsecureTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(InsecureTrustManagerFactory.class);
    public static final TrustManagerFactory INSTANCE = new InsecureTrustManagerFactory();
    private static final TrustManager tm = new X509TrustManager(){

        @Override
        public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            if (logger.isDebugEnabled()) {
                logger.debug("Accepting a client certificate: " + x509CertificateArray[0].getSubjectDN());
            }
        }

        @Override
        public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            if (logger.isDebugEnabled()) {
                logger.debug("Accepting a server certificate: " + x509CertificateArray[0].getSubjectDN());
            }
        }

        @Override
        public final X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    };

    private InsecureTrustManagerFactory() {
    }

    @Override
    protected final void engineInit(KeyStore keyStore) {
    }

    @Override
    protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) {
    }

    @Override
    protected final TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{tm};
    }
}

