/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImplKt;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcIdentifierManager;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.PrimaryKeyMetadata;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SchemaMetadata;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 e2\u00020\u0001:\u0002deB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010C\u001a\u00020DH\u0016J3\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020F0\u001f082\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0H\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010IJ3\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f082\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0H\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010IJ/\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010L082\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0H\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010IJ-\u0010M\u001a\b\u0012\u0004\u0012\u0002HO0N\"\u0004\b\u0000\u0010O2\u0017\u0010P\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HO0Q\u00a2\u0006\u0002\bRH\u0002J\b\u0010S\u001a\u00020DH\u0016J\u0010\u0010T\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u0003H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0002J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u001c\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030X2\u0006\u0010Y\u001a\u00020\u001eH\u0002J(\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0\u001f082\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001fH\u0016J$\u0010\\\u001a\u00020]2\u001a\u0010^\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001f\u0018\u000108H\u0016J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010`\u001a\u00020\u0003H\u0002J\f\u0010a\u001a\u00020F*\u00020bH\u0002J\u0012\u0010c\u001a\b\u0012\u0004\u0012\u00020F0\u001f*\u00020bH\u0002R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00038BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00038VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000e\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u001b\u0010\u0014\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0015\u0010\tR\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR6\u0010\u001c\u001a*\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001dj\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020#8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0011\u001a\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001b\u0010,\u001a\u00020-8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0011\u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u00020-8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u0011\u001a\u0004\b2\u0010/R\u001b\u00104\u001a\u00020-8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0011\u001a\u0004\b5\u0010/R&\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001f088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u001b\u0010;\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\u0011\u001a\u0004\b<\u0010\tR\u001b\u0010>\u001a\u00020?8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\u0011\u001a\u0004\b@\u0010A\u00a8\u0006f"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "database", "", "metadata", "Ljava/sql/DatabaseMetaData;", "(Ljava/lang/String;Ljava/sql/DatabaseMetaData;)V", "currentSchema", "getCurrentSchema", "()Ljava/lang/String;", "currentScheme", "getCurrentScheme$annotations", "()V", "getCurrentScheme", "databaseDialectName", "getDatabaseDialectName", "databaseDialectName$delegate", "Lkotlin/Lazy;", "databaseName", "getDatabaseName", "databaseProductVersion", "getDatabaseProductVersion", "databaseProductVersion$delegate", "defaultIsolationLevel", "", "getDefaultIsolationLevel", "()I", "defaultIsolationLevel$delegate", "existingIndicesCache", "Ljava/util/HashMap;", "Lorg/jetbrains/exposed/sql/Table;", "", "Lorg/jetbrains/exposed/sql/Index;", "Lkotlin/collections/HashMap;", "identifierManager", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getMetadata", "()Ljava/sql/DatabaseMetaData;", "schemaNames", "getSchemaNames", "()Ljava/util/List;", "supportsAlterTableWithAddColumn", "", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn$delegate", "supportsMultipleResultSets", "getSupportsMultipleResultSets", "supportsMultipleResultSets$delegate", "supportsSelectForUpdate", "getSupportsSelectForUpdate", "supportsSelectForUpdate$delegate", "tableNames", "", "getTableNames", "()Ljava/util/Map;", "url", "getUrl", "url$delegate", "version", "Ljava/math/BigDecimal;", "getVersion", "()Ljava/math/BigDecimal;", "version$delegate", "cleanCache", "", "columns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "existingIndices", "existingPrimaryKeys", "Lorg/jetbrains/exposed/sql/vendors/PrimaryKeyMetadata;", "lazyMetadata", "Lkotlin/Lazy;", "T", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "resetCurrentScheme", "sanitizedDefault", "defaultValue", "sequences", "tableCatalogAndSchema", "Lkotlin/Pair;", "table", "tableConstraints", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tableNamesByCurrentSchema", "Lorg/jetbrains/exposed/sql/vendors/SchemaMetadata;", "tableNamesCache", "tableNamesFor", "scheme", "asColumnMetadata", "Ljava/sql/ResultSet;", "extractColumns", "CachableMapWithDefault", "Companion", "exposed-jdbc"})
public final class JdbcDatabaseMetadataImpl
extends ExposedDatabaseMetadata {
    public static final Companion Companion = new Companion(null);
    private final DatabaseMetaData metadata;
    private final Lazy url$delegate;
    private final Lazy version$delegate;
    private final Lazy databaseDialectName$delegate;
    private final Lazy databaseProductVersion$delegate;
    private final Lazy defaultIsolationLevel$delegate;
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    private final Lazy supportsMultipleResultSets$delegate;
    private final Lazy supportsSelectForUpdate$delegate;
    private final Lazy identifierManager$delegate;
    private String currentSchema;
    private final HashMap<Table, List<Index>> existingIndicesCache;
    private static final ConcurrentHashMap<String, JdbcIdentifierManager> identityManagerCache = new ConcurrentHashMap();

    public JdbcDatabaseMetadataImpl(String string, DatabaseMetaData databaseMetaData) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)databaseMetaData, (String)"");
        super(string);
        this.metadata = databaseMetaData;
        this.url$delegate = this.lazyMetadata(url.2.INSTANCE);
        this.version$delegate = this.lazyMetadata(version.2.INSTANCE);
        this.databaseDialectName$delegate = this.lazyMetadata(databaseDialectName.2.INSTANCE);
        this.databaseProductVersion$delegate = this.lazyMetadata(databaseProductVersion.2.INSTANCE);
        this.defaultIsolationLevel$delegate = this.lazyMetadata(defaultIsolationLevel.2.INSTANCE);
        this.supportsAlterTableWithAddColumn$delegate = this.lazyMetadata(supportsAlterTableWithAddColumn.2.INSTANCE);
        this.supportsMultipleResultSets$delegate = this.lazyMetadata(supportsMultipleResultSets.2.INSTANCE);
        this.supportsSelectForUpdate$delegate = this.lazyMetadata(supportsSelectForUpdate.2.INSTANCE);
        this.identifierManager$delegate = this.lazyMetadata(identifierManager.2.INSTANCE);
        this.existingIndicesCache = new HashMap();
    }

    public final DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    public final String getUrl() {
        Lazy lazy = this.url$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
        return (String)object;
    }

    public final BigDecimal getVersion() {
        Lazy lazy = this.version$delegate;
        return (BigDecimal)lazy.getValue();
    }

    public final String getDatabaseDialectName() {
        Lazy lazy = this.databaseDialectName$delegate;
        return (String)lazy.getValue();
    }

    private final String getDatabaseName() {
        String string = this.getDatabaseDialectName();
        if (Intrinsics.areEqual((Object)string, (Object)MysqlDialect.Companion.getDialectName()) ? true : Intrinsics.areEqual((Object)string, (Object)MariaDBDialect.Companion.getDialectName())) {
            String string2 = this.getCurrentSchema();
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }
        return this.getDatabase();
    }

    public final String getDatabaseProductVersion() {
        Lazy lazy = this.databaseProductVersion$delegate;
        return (String)lazy.getValue();
    }

    public final int getDefaultIsolationLevel() {
        Lazy lazy = this.defaultIsolationLevel$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getSupportsMultipleResultSets() {
        Lazy lazy = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getSupportsSelectForUpdate() {
        Lazy lazy = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy.getValue();
    }

    public final IdentifierManagerApi getIdentifierManager() {
        Lazy lazy = this.identifierManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
        return (IdentifierManagerApi)object;
    }

    private final String getCurrentSchema() {
        if (this.currentSchema == null) {
            String string;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl2 = this;
            try {
                String string2;
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = this.getDatabaseDialectName();
                if (Intrinsics.areEqual((Object)string, (Object)MysqlDialect.Companion.getDialectName()) ? true : Intrinsics.areEqual((Object)string, (Object)MariaDBDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getCatalog();
                    if (string2 == null) {
                        string2 = "";
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)OracleDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = this.getDatabaseName();
                    }
                } else {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = "";
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = "";
            }
            jdbcDatabaseMetadataImpl.currentSchema = string;
        }
        String string = this.currentSchema;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final /* synthetic */ String getCurrentScheme() {
        String string = this.getCurrentSchema();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Deprecated(message="This will be removed when the interface property is fully deprecated", level=DeprecationLevel.HIDDEN)
    public static /* synthetic */ void getCurrentScheme$annotations() {
    }

    public final void resetCurrentScheme() {
        this.currentSchema = null;
    }

    public final Map<String, List<String>> getTableNames() {
        return new CachableMapWithDefault(this, null, (Function1)new Function1<String, List<? extends String>>(this){
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.this$0 = jdbcDatabaseMetadataImpl;
                super(1);
            }

            public final List<String> invoke(String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                return JdbcDatabaseMetadataImpl.access$tableNamesFor(this.this$0, string);
            }
        }, 1, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<String> tableNamesFor(String var1_1) {
        block6: {
            var2_2 = this.metadata;
            var3_3 = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
            if (!var3_3) break block6;
            v0 = var1_1 /* !! */ ;
            v1 = "%";
            ** GOTO lbl25
        }
        if (DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect) {
            v2 = this.getDatabaseName();
            if ((var1_1 /* !! */  = (CharSequence)var1_1 /* !! */ ).length() == 0) {
                var1_1 /* !! */  = v2;
                v3 /* !! */  = this.getDatabaseName();
                v2 = var1_1 /* !! */ ;
            } else {
                v3 /* !! */  = var1_1 /* !! */ ;
            }
            v4 = TuplesKt.to((Object)v2, (Object)v3 /* !! */ );
        } else {
            v0 = this.getDatabaseName();
            if ((var1_1 /* !! */  = (CharSequence)var1_1 /* !! */ ).length() == 0) {
                var1_1 /* !! */  = v0;
                v1 = "%";
                v0 = var1_1 /* !! */ ;
            } else {
                v1 = var1_1 /* !! */ ;
            }
lbl25:
            // 3 sources

            v4 = TuplesKt.to((Object)v0, (Object)v1);
        }
        var4_4 /* !! */  = v4;
        var1_1 /* !! */  = (String)v4.component1();
        var4_4 /* !! */  = (String)var4_4 /* !! */ .component2();
        v5 /* !! */  = var1_1 /* !! */ ;
        v6 = new String[1];
        var1_1 /* !! */  = v6;
        v6[0] = "TABLE";
        var1_1 /* !! */  = var2_2.getTables(v5 /* !! */ , (String)var4_4 /* !! */ , "%", var1_1 /* !! */ );
        Intrinsics.checkNotNull((Object)var1_1 /* !! */ );
        return JdbcDatabaseMetadataImplKt.access$iterate((ResultSet)var1_1 /* !! */ , (Function1)new Function1<ResultSet, String>(var3_3, this){
            final /* synthetic */ boolean $useCatalogInsteadOfScheme;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$useCatalogInsteadOfScheme = bl;
                this.this$0 = jdbcDatabaseMetadataImpl;
                super(1);
            }

            public final String invoke(ResultSet object) {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                String string3 = object.getString("TABLE_NAME");
                Intrinsics.checkNotNull((Object)string3);
                String string4 = string3;
                if (this.$useCatalogInsteadOfScheme) {
                    String string5 = object.getString("TABLE_CAT");
                    if (string5 != null) {
                        object = string5;
                        string2 = (String)object + '.' + string4;
                    } else {
                        string2 = null;
                    }
                } else {
                    String string6 = object.getString("TABLE_SCHEM");
                    if (string6 != null) {
                        object = string6;
                        string2 = (String)object + '.' + string4;
                    } else {
                        string2 = string = null;
                    }
                }
                if (string2 == null) {
                    string = string4;
                }
                object = string;
                return this.this$0.getIdentifierManager().inProperCase((String)object);
            }
        });
    }

    public final List<String> getSchemaNames() {
        return this.schemaNames();
    }

    private final List<String> schemaNames() {
        List list;
        Object object = this.metadata;
        boolean bl = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        if (bl) {
            ResultSet resultSet = object.getCatalogs();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.1.INSTANCE);
        } else {
            ResultSet resultSet = object.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.2.INSTANCE);
        }
        object = list;
        Object object2 = object = (Iterable)list;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (String)object3;
            Object object4 = object;
            IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
            Intrinsics.checkNotNull(object3);
            object4.add(identifierManagerApi.inProperCase(object3));
        }
        return (List)object;
    }

    public final SchemaMetadata tableNamesByCurrentSchema(Map<String, ? extends List<String>> object) {
        Object object2 = object;
        if (object2 == null) {
            object2 = this.getTableNames();
        }
        String string = this.getCurrentSchema();
        Intrinsics.checkNotNull((Object)string);
        object = (List)MapsKt.getValue((Map)object2, (Object)string);
        String string2 = this.getCurrentSchema();
        Intrinsics.checkNotNull((Object)string2);
        return new SchemaMetadata(string2, (List)object);
    }

    private final List<ColumnMetadata> extractColumns(ResultSet resultSet) {
        List list = new ArrayList();
        while (resultSet.next()) {
            list.add(this.asColumnMetadata(resultSet));
        }
        return list;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final Map<Table, List<ColumnMetadata>> columns(Table ... var1_1) {
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"");
        var2_2 = new LinkedHashMap<K, V>();
        var3_3 = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        var5_4 /* !! */  = var1_1;
        var4_5 = new LinkedHashMap<K, V>();
        var7_8 = var5_4 /* !! */ .length;
        for (var6_6 = 0; var6_6 < var7_8; ++var6_6) {
            var9_11 = var8_10 = var5_4 /* !! */ [var6_6];
            v0 = this.getIdentifierManager();
            v1 = var9_11.getSchemaName();
            if (v1 == null) {
                v2 = this.getCurrentSchema();
                v1 = v2;
                Intrinsics.checkNotNull((Object)v2);
            }
            if ((var10_12 /* !! */  = (var9_11 = var4_5).get(var1_1 = v0.inProperCase(v1))) == null) {
                var10_12 /* !! */  = new ArrayList<E>();
                var9_11.put(var1_1, var10_12 /* !! */ );
                v3 = var10_12 /* !! */ ;
            } else {
                v3 = var10_12 /* !! */ ;
            }
            var1_1 = (List)v3;
            var1_1.add(var8_10);
        }
        var1_1 = var4_5;
        var1_1 = var1_1.entrySet().iterator();
        while (var1_1.hasNext()) {
            var4_5 = (Map.Entry)var1_1.next();
            var5_4 /* !! */  = (String)var4_5.getKey();
            var4_5 = (List)var4_5.getValue();
            var4_5 = var4_5.iterator();
            while (var4_5.hasNext()) {
                var6_7 = (Table)var4_5.next();
                if (!var3_3) ** GOTO lbl-1000
                v4 = this.getCurrentSchema();
                Intrinsics.checkNotNull((Object)v4);
                if (Intrinsics.areEqual((Object)var5_4 /* !! */ , (Object)v4)) lbl-1000:
                // 2 sources

                {
                    v5 /* !! */  = this.getDatabaseName();
                } else {
                    v5 /* !! */  = var5_4 /* !! */ ;
                }
                var7_9 = v5 /* !! */ ;
                var8_10 = this.metadata.getColumns((String)var7_9, (String)var5_4 /* !! */ , var6_7.nameInDatabaseCaseUnquoted(), "%");
                Intrinsics.checkNotNull((Object)var8_10);
                var9_11 = this.extractColumns((ResultSet)var8_10);
                if (!(((Collection)var9_11).isEmpty() == false)) {
                    var1_1 = "Check failed.";
                    throw new IllegalStateException(var1_1.toString());
                }
                var2_2.put(var6_7, var9_11);
                var8_10.close();
            }
        }
        return var2_2;
    }

    private final ColumnMetadata asColumnMetadata(ResultSet resultSet) {
        Object object;
        String string;
        String string2 = resultSet.getString("COLUMN_DEF");
        if (string2 != null) {
            String string3 = string2;
            string = this.sanitizedDefault(string3);
        } else {
            string = null;
        }
        String string4 = string;
        boolean bl = Intrinsics.areEqual((Object)resultSet.getString("IS_AUTOINCREMENT"), (Object)"YES");
        int n = resultSet.getInt("DATA_TYPE");
        String string5 = resultSet.getString("COLUMN_NAME");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
        Object object2 = resultSet.getInt("COLUMN_SIZE");
        int n2 = ((Number)object2).intValue();
        boolean bl2 = resultSet.getBoolean("NULLABLE");
        int n3 = n;
        String string6 = string5;
        Comparable<Boolean> comparable = n2 != 0;
        String string7 = string6;
        int n4 = n3;
        boolean bl3 = bl2;
        Object object3 = comparable != false ? object2 : null;
        boolean bl4 = bl;
        String string8 = string4;
        if (string8 != null) {
            object2 = string8;
            boolean bl5 = bl4;
            comparable = object3;
            bl2 = bl3;
            n3 = n4;
            string6 = string7;
            bl = !bl;
            string7 = string6;
            n4 = n3;
            bl3 = bl2;
            object3 = comparable;
            bl4 = bl5;
            object = bl ? object2 : null;
        } else {
            object = null;
        }
        comparable = object;
        boolean bl6 = bl4;
        Integer n5 = object3;
        boolean bl7 = bl3;
        int n6 = n4;
        String string9 = string7;
        return new ColumnMetadata(string9, n6, bl7, n5, bl6, (String)((Object)comparable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String sanitizedDefault(String object) {
        String string;
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect.H2CompatibilityMode h2CompatibilityMode = H2Kt.getH2Mode((DatabaseDialect)databaseDialect);
        if (databaseDialect instanceof SQLServerDialect) {
            Object object2 = object;
            char[] cArray = new char[3];
            object = cArray;
            cArray[0] = 40;
            object[1] = 41;
            object[2] = 39;
            return StringsKt.trim((String)object2, (char[])object);
        }
        if (databaseDialect instanceof OracleDialect || h2CompatibilityMode == H2Dialect.H2CompatibilityMode.Oracle) {
            if (!StringsKt.startsWith$default((CharSequence)((CharSequence)(object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString())), (char)'\'', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)((CharSequence)object), (char)'\'', (boolean)false, (int)2, null)) return object;
            Object object3 = object;
            char[] cArray = new char[1];
            object = cArray;
            cArray[0] = 39;
            string = StringsKt.trim((String)object3, (char[])object);
            return string;
        } else {
            if (databaseDialect instanceof MysqlDialect || h2CompatibilityMode == H2Dialect.H2CompatibilityMode.MySQL || h2CompatibilityMode == H2Dialect.H2CompatibilityMode.MariaDB) {
                String string2 = StringsKt.substringAfter$default((String)object, (String)"b'", null, (int)2, null);
                char[] cArray = new char[1];
                object = cArray;
                cArray[0] = 39;
                return StringsKt.trim((String)string2, (char[])object);
            }
            if (!(!(databaseDialect instanceof PostgreSQLDialect) && h2CompatibilityMode != H2Dialect.H2CompatibilityMode.PostgreSQL || StringsKt.startsWith$default((CharSequence)((CharSequence)object), (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)((CharSequence)object), (char)'\'', (boolean)false, (int)2, null))) {
                return object;
            }
            Object object4 = object;
            char[] cArray = new char[1];
            object = cArray;
            cArray[0] = 39;
            string = StringsKt.trim((String)object4, (char[])object);
        }
        return string;
    }

    public final Map<Table, List<Index>> existingIndices(Table ... tableArray) {
        Intrinsics.checkNotNullParameter((Object)tableArray, (String)"");
        for (Table table : tableArray) {
            Object object3;
            Object object4;
            Object object5 = TransactionManager.Companion.current();
            Object object6 = this.tableCatalogAndSchema(table);
            Object object7 = (String)object6.component1();
            object6 = (String)object6.component2();
            Map map = this.existingIndicesCache;
            Object object82 = map.get(table);
            if (object82 != null) continue;
            object82 = this.metadata.getPrimaryKeys((String)object7, (String)object6, table.nameInDatabaseCaseUnquoted());
            Object object9 = new ArrayList();
            while (object82.next()) {
                object4 = object82.getString("PK_NAME");
                if (object4 == null) continue;
                Intrinsics.checkNotNull((Object)object4);
                ((Collection)object9).add(object4);
            }
            object82.close();
            Object object10 = object9;
            String string = this.getCurrentSchema();
            Intrinsics.checkNotNull((Object)string);
            object82 = Intrinsics.areEqual(object6, (Object)string) && DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? table.nameInDatabaseCase() : table.nameInDatabaseCaseUnquoted();
            object82 = this.metadata.getIndexInfo((String)object7, (String)object6, (String)object82, false, false);
            object6 = new HashMap();
            while (object82.next()) {
                Object object;
                object9 = object82.getString("INDEX_NAME");
                if (object9 == null) continue;
                Intrinsics.checkNotNull((Object)object9);
                object4 = object9;
                Object object2 = object82.getString("COLUMN_NAME");
                if (object2 == null) {
                    object3 = DatabaseDialectKt.getCurrentDialect();
                    object2 = object7 = (object3 instanceof MysqlDialect ? true : object3 instanceof SQLiteDialect) ? "\"\"" : null;
                }
                if (object2 == null) continue;
                object3 = object2;
                String string2 = object5.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary((String)object3);
                boolean bl = !object82.getBoolean("NON_UNIQUE");
                CharSequence charSequence = object82.getString("FILTER_CONDITION");
                object7 = charSequence == null || charSequence.length() == 0 ? null : Op.TRUE.INSTANCE;
                Map map2 = (Map)object6;
                object7 = new Triple(object4, (Object)bl, object7);
                object9 = map2.get(object7);
                if (object9 == null) {
                    object4 = new ArrayList();
                    map2.put(object7, object4);
                    object = object4;
                } else {
                    object = object9;
                }
                ((List)object).add(string2);
            }
            object82.close();
            object4 = table.getColumns();
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10)), (int)16);
            object3 = object4;
            object7 = new LinkedHashMap(n);
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                Column column = (Column)t;
                object82 = object7;
                object82.put(object5.identity(column), t);
            }
            object9 = object7;
            object7 = object4 = (Map)object6;
            object3 = new LinkedHashMap();
            for (Map.Entry entry : object7.entrySet()) {
                Map.Entry entry2 = entry;
                if (((ArrayList)object10).contains(((Triple)entry2.getKey()).getFirst())) continue;
                object3.put(entry.getKey(), entry.getValue());
            }
            object7 = object4 = object3;
            object3 = new ArrayList();
            object5 = object7;
            for (Map.Entry entry : object5.entrySet()) {
                Index index;
                object7 = entry;
                object5 = entry;
                Object object15 = (Triple)entry.getKey();
                object5 = (List)object5.getValue();
                object6 = CollectionsKt.distinct((Iterable)((Iterable)object5));
                object7 = new ArrayList();
                object82 = new ArrayList();
                object10 = object6.iterator();
                while (object10.hasNext()) {
                    Object e = object10.next();
                    String string3 = (String)e;
                    if (object9.get(string3) == null) {
                        ((ArrayList)object7).add(e);
                        continue;
                    }
                    ((ArrayList)object82).add(e);
                }
                object7 = new Pair(object7, object82);
                object6 = (List)object7.component1();
                object7 = (List)object7.component2();
                object82 = (Iterable)object7;
                Iterable iterable = object82;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object82, (int)10));
                for (Object object82 : iterable) {
                    object10 = (String)object82;
                    object82 = collection;
                    Object v = object9.get(object10);
                    Intrinsics.checkNotNull(v);
                    object82.add((Column)((Column)v));
                }
                object10 = object82 = (List)collection;
                Object object = object82.size() + object6.size() == object5.size() ? object82 : null;
                if (object != null) {
                    Collection collection2;
                    Collection<LiteralOp> collection3;
                    object10 = object;
                    Iterable iterable2 = (Iterable)object6;
                    object5 = (Op)object15.getThird();
                    object82 = (String)object15.getFirst();
                    boolean bl = (Boolean)object15.getSecond();
                    object7 = object;
                    object15 = iterable2;
                    Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                    object15 = object15.iterator();
                    while (object15.hasNext()) {
                        Object e = object15.next();
                        String string4 = (String)e;
                        collection3 = collection4;
                        collection3.add(OpKt.stringLiteral((String)string4));
                    }
                    collection3 = (List)collection4;
                    Object object11 = object7;
                    boolean bl2 = bl;
                    Object object12 = object82;
                    Object object13 = object5;
                    Collection collection5 = collection3;
                    if (collection5.isEmpty()) {
                        object5 = object13;
                        object82 = object12;
                        bl = bl2;
                        object11 = object7 = object11;
                        bl2 = bl;
                        object12 = object82;
                        object13 = object5;
                        collection2 = null;
                    } else {
                        collection2 = collection5;
                    }
                    object5 = !((Collection)object6).isEmpty() ? table : null;
                    object6 = (List)collection2;
                    object7 = object13;
                    object82 = object12;
                    boolean bl3 = bl2;
                    object10 = object11;
                    index = new Index((List)object10, bl3, (String)object82, null, (Op)object7, (List)object6, (Table)object5, 8, null);
                } else {
                    index = null;
                }
                if (index == null) continue;
                object5 = index;
                object3.add(object5);
            }
            object5 = (List)object3;
            map.put(table, object5);
        }
        return new HashMap(this.existingIndicesCache);
    }

    public final Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tableArray) {
        Intrinsics.checkNotNullParameter((Object)tableArray, (String)"");
        LinkedHashMap linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)tableArray.length), (int)16));
        int n = tableArray.length;
        for (int i = 0; i < n; ++i) {
            Table table;
            Table table2;
            Table table3 = table2 = (table = tableArray[i]);
            Map map = linkedHashMap;
            Object object = this.tableCatalogAndSchema(table2);
            String string = (String)object.component1();
            object = (String)object.component2();
            ResultSet resultSet = this.metadata.getPrimaryKeys(string, (String)object, table2.nameInDatabaseCaseUnquoted());
            object = new ArrayList();
            string = "";
            while (resultSet.next()) {
                String string2 = resultSet.getString("PK_NAME");
                if (string2 != null) {
                    Intrinsics.checkNotNull((Object)string2);
                    string = string2;
                }
                ((Collection)object).add(resultSet.getString("COLUMN_NAME"));
            }
            resultSet.close();
            PrimaryKeyMetadata object2 = ((CharSequence)string).length() == 0 ? null : new PrimaryKeyMetadata(string, object);
            map.put(table3, object2);
        }
        return linkedHashMap;
    }

    public final List<String> sequences() {
        List list = new ArrayList();
        String[] stringArray = new String[1];
        Object object = stringArray;
        stringArray[0] = "SEQUENCE";
        object = this.metadata.getTables(null, null, null, (String[])object);
        while (object.next()) {
            String string = object.getString(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            list.add(string);
        }
        return list;
    }

    public final synchronized Map<String, List<ForeignKeyConstraint>> tableConstraints(List<? extends Table> object) {
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(object, (String)"");
        Object object4 = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable)object);
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10)), (int)16);
        object = new LinkedHashMap(n);
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            object3 = object5.next();
            object4 = (Table)object3;
            object2 = object;
            object2.put(object4.nameInDatabaseCaseUnquoted(), object3);
        }
        object4 = object.keySet();
        LinkedHashMap linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10)), (int)16));
        object4 = object4.iterator();
        while (object4.hasNext()) {
            Iterator<Object> iterator;
            Object object6;
            Object object7;
            Object object8;
            object5 = object4.next();
            object3 = (String)object5;
            object2 = linkedHashMap;
            Object v = object.get(object3);
            Intrinsics.checkNotNull(v);
            object5 = this.tableCatalogAndSchema((Table)v);
            Iterator iterator2 = (String)object5.component1();
            object5 = (String)object5.component2();
            ResultSet resultSet = this.metadata.getImportedKeys((String)((Object)iterator2), this.getIdentifierManager().inProperCase((String)object5), (String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
            object3 = object5 = (Iterable)CollectionsKt.filterNotNull((Iterable)JdbcDatabaseMetadataImplKt.access$iterate(resultSet, (Function1)new Function1<ResultSet, ForeignKeyConstraint>(this, (Map<String, ? extends Table>)object){
                final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
                final /* synthetic */ Map<String, Table> $allTables;
                {
                    this.this$0 = jdbcDatabaseMetadataImpl;
                    this.$allTables = map;
                    super(1);
                }

                public final ForeignKeyConstraint invoke(ResultSet resultSet) {
                    ReferenceOption referenceOption;
                    Object object;
                    Object object2;
                    Object object32;
                    String string;
                    Object object4;
                    block15: {
                        block14: {
                            Object v11;
                            block11: {
                                Object object5;
                                Object object6;
                                block13: {
                                    block12: {
                                        Iterable<Object> iterable;
                                        block10: {
                                            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
                                            String string2 = resultSet.getString("FKTABLE_NAME");
                                            Intrinsics.checkNotNull((Object)string2);
                                            object4 = string2;
                                            IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                                            String string3 = resultSet.getString("FKCOLUMN_NAME");
                                            Intrinsics.checkNotNull((Object)string3);
                                            string = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string3);
                                            object6 = this.$allTables.get(object4);
                                            if (object6 == null || (object6 = object6.getColumns()) == null) break block12;
                                            object32 = (Iterable)object6;
                                            object2 = this.this$0;
                                            for (Object object32 : object32) {
                                                object5 = (Column)object32;
                                                if (!Intrinsics.areEqual((Object)object2.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(object5.getName()), (Object)string)) continue;
                                                iterable = object32;
                                                break block10;
                                            }
                                            iterable = null;
                                        }
                                        if ((object6 = (Column)iterable) != null) break block13;
                                    }
                                    return null;
                                }
                                object4 = object6;
                                String string4 = resultSet.getString("FK_NAME");
                                Intrinsics.checkNotNull((Object)string4);
                                string = string4;
                                String string5 = resultSet.getString("PKTABLE_NAME");
                                Intrinsics.checkNotNull((Object)string5);
                                object32 = string5;
                                IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                                IdentifierManagerApi identifierManagerApi2 = this.this$0.getIdentifierManager();
                                String string6 = resultSet.getString("PKCOLUMN_NAME");
                                Intrinsics.checkNotNull((Object)string6);
                                object2 = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(identifierManagerApi2.inProperCase(string6));
                                object = this.$allTables.get(object32);
                                if (object == null || (object = object.getColumns()) == null) break block14;
                                object32 = (Iterable)object;
                                object5 = this.this$0;
                                for (T t : object32) {
                                    Column column = (Column)t;
                                    if (!Intrinsics.areEqual((Object)object5.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(column.nameInDatabaseCase()), (Object)object2)) continue;
                                    v11 = t;
                                    break block11;
                                }
                                v11 = null;
                            }
                            if ((object = (Column)v11) != null) break block15;
                        }
                        return null;
                    }
                    object32 = object;
                    Object object7 = resultSet.getObject("UPDATE_RULE");
                    if (object7 != null && (object7 = object7.toString()) != null && (object7 = StringsKt.toIntOrNull((String)object7)) != null) {
                        int n = ((Number)object7).intValue();
                        referenceOption = DatabaseDialectKt.getCurrentDialect().resolveRefOptionFromJdbc(n);
                    } else {
                        referenceOption = null;
                    }
                    object2 = referenceOption;
                    resultSet = DatabaseDialectKt.getCurrentDialect().resolveRefOptionFromJdbc(resultSet.getInt("DELETE_RULE"));
                    return new ForeignKeyConstraint((Column)object32, (Column)object4, (ReferenceOption)object2, (ReferenceOption)resultSet, string);
                }
            }));
            object5 = new LinkedHashMap();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                Object v2;
                iterator2 = object3.next();
                object8 = (ForeignKeyConstraint)iterator2;
                object7 = object5;
                object6 = object7.get(object8 = object8.getFkName());
                if (object6 == null) {
                    object6 = new ArrayList();
                    object7.put(object8, object6);
                    v2 = object6;
                } else {
                    v2 = object6;
                }
                object8 = (List)v2;
                object8.add(iterator2);
            }
            object3 = object5 = (Iterable)object5.values();
            object5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object5, (int)10));
            object3 = object3.iterator();
            while (object3.hasNext()) {
                iterator2 = object3.next();
                object8 = (List)((Object)iterator2);
                object7 = object5;
                iterator2 = (object8 = (Iterable)object8).iterator();
                if (!iterator2.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                object6 = iterator2.next();
                while (iterator2.hasNext()) {
                    Object object9 = object6;
                    object6 = (ForeignKeyConstraint)iterator2.next();
                    object8 = (ForeignKeyConstraint)object9;
                    object6 = object8.plus(object6);
                }
                object7.add((ForeignKeyConstraint)object6);
            }
            object5 = (List)object5;
            object2.put(iterator, object5);
        }
        return linkedHashMap;
    }

    private final Pair<String, String> tableCatalogAndSchema(Table object) {
        IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
        String string = object.getSchemaName();
        if (string == null) {
            String string2 = this.getCurrentSchema();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        object = identifierManagerApi.inProperCase(string);
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect) {
            String string3 = this.getCurrentSchema();
            Intrinsics.checkNotNull((Object)string3);
            if (!Intrinsics.areEqual((Object)object, (Object)string3)) {
                Object object2 = object;
                return TuplesKt.to((Object)object2, (Object)object2);
            }
        }
        return TuplesKt.to((Object)this.getDatabaseName(), (Object)object);
    }

    public final synchronized void cleanCache() {
        this.existingIndicesCache.clear();
    }

    private final <T> Lazy<T> lazyMetadata(Function1<? super DatabaseMetaData, ? extends T> function1) {
        return LazyKt.lazy((Function0)new Function0<T>(function1, this){
            final /* synthetic */ Function1<DatabaseMetaData, T> $body;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$body = function1;
                this.this$0 = jdbcDatabaseMetadataImpl;
                super(0);
            }

            public final T invoke() {
                return (T)this.$body.invoke((Object)this.this$0.getMetadata());
            }
        });
    }

    public static final /* synthetic */ List access$tableNamesFor(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, String string) {
        return jdbcDatabaseMetadataImpl.tableNamesFor(string);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getIdentityManagerCache$cp() {
        return identityManagerCache;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B/\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault;", "K", "V", "", "map", "", "default", "Lkotlin/Function1;", "(Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "getDefault", "()Lkotlin/jvm/functions/Function1;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "exposed-jdbc"})
    private final class CachableMapWithDefault<K, V>
    implements Map<K, V>,
    KMappedMarker {
        private final Map<K, V> map;
        private final Function1<K, V> default;
        final /* synthetic */ JdbcDatabaseMetadataImpl this$0;

        public CachableMapWithDefault(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, Map<K, V> map, Function1<? super K, ? extends V> function1) {
            Intrinsics.checkNotNullParameter(map, (String)"");
            Intrinsics.checkNotNullParameter(function1, (String)"");
            this.this$0 = jdbcDatabaseMetadataImpl;
            this.map = map;
            this.default = function1;
        }

        public /* synthetic */ CachableMapWithDefault(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, Map map, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(jdbcDatabaseMetadataImpl, map, function1);
        }

        public final Function1<K, V> getDefault() {
            return this.default;
        }

        public final Set<Map.Entry<K, V>> getEntries() {
            return this.map.entrySet();
        }

        public final Set<K> getKeys() {
            return this.map.keySet();
        }

        public final int getSize() {
            return this.map.size();
        }

        public final Collection<V> getValues() {
            return this.map.values();
        }

        @Override
        public final boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public final V get(Object object) {
            Map<Object, V> map = this.map;
            Object object2 = map.get(object);
            if (object2 == null) {
                object2 = this.default.invoke(object);
                map.put(object, object2);
                return object2;
            }
            return object2;
        }

        @Override
        public final boolean containsKey(Object object) {
            return true;
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final V put(K k, V v) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final V putIfAbsent(K k, V v) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final V remove(Object object) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final boolean remove(Object object, Object object2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final boolean replace(K k, V v, V v2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final V replace(K k, V v) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            return this.getEntries();
        }

        @Override
        public final Set<K> keySet() {
            return this.getKeys();
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public final Collection<V> values() {
            return this.getValues();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$Companion;", "", "()V", "identityManagerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcIdentifierManager;", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

