/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.URLProtocol;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0017\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\fR\u0014\u0010\u000e\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0014\u0010\u0010\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0018\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\nR\u001a\u0010\u001c\u001a\u00020\b8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\nR\u001a\u0010!\u001a\u00020\u001d8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010#\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0014\u0010%\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\nR\u0014\u0010'\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u0014\u0010)\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001fR\u0014\u0010+\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001fR\u0014\u0010-\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001fR\u0014\u0010/\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\nR\u0014\u00101\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001fR\u0014\u00103\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\n\u00a8\u00064"}, d2={"Lio/ktor/server/netty/http1/NettyConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "Lio/netty/handler/codec/http/HttpRequest;", "request", "Lio/netty/channel/ChannelHandlerContext;", "context", "<init>", "(Lio/netty/handler/codec/http/HttpRequest;Lio/netty/channel/ChannelHandlerContext;)V", "", "toString", "()Ljava/lang/String;", "Lio/netty/handler/codec/http/HttpRequest;", "Lio/netty/channel/ChannelHandlerContext;", "getVersion", "version", "getUri", "uri", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "method", "scheme$delegate", "Lkotlin/Lazy;", "getScheme", "scheme", "getHost", "getHost$annotations", "()V", "host", "", "getPort", "()I", "getPort$annotations", "port", "getLocalHost", "localHost", "getServerHost", "serverHost", "getLocalAddress", "localAddress", "getDefaultPort", "defaultPort", "getLocalPort", "localPort", "getServerPort", "serverPort", "getRemoteHost", "remoteHost", "getRemotePort", "remotePort", "getRemoteAddress", "remoteAddress", "ktor-server-netty"})
public final class NettyConnectionPoint
implements RequestConnectionPoint {
    private final HttpRequest request;
    private final ChannelHandlerContext context;
    private final Lazy scheme$delegate;

    public NettyConnectionPoint(HttpRequest httpRequest, ChannelHandlerContext channelHandlerContext) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"");
        Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
        this.request = httpRequest;
        this.context = channelHandlerContext;
        this.scheme$delegate = LazyKt.lazy(() -> NettyConnectionPoint.scheme_delegate$lambda$0(this));
    }

    public final String getVersion() {
        String string = this.request.protocolVersion().text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String getUri() {
        String string = this.request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final HttpMethod getMethod() {
        String string = this.request.method().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return HttpMethod.Companion.parse(string);
    }

    public final String getScheme() {
        Lazy lazy = this.scheme$delegate;
        return (String)lazy.getValue();
    }

    public final String getHost() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        if (string == null || (string = StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null)) == null) {
            String string2;
            SocketAddress socketAddress = this.context.channel().localAddress();
            socketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
            if (socketAddress != null) {
                string2 = ((InetSocketAddress)socketAddress).getHostName();
                if (string2 == null) {
                    string2 = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
                }
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "localhost";
            }
        }
        return string;
    }

    @Deprecated(message="Use localHost or serverHost instead", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getHost$annotations() {
    }

    public final int getPort() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (inetSocketAddress != null) {
            return inetSocketAddress.getPort();
        }
        return 80;
    }

    @Deprecated(message="Use localPort or serverPort instead", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getPort$annotations() {
    }

    public final String getLocalHost() {
        Object object;
        block5: {
            block4: {
                SocketAddress socketAddress = this.context.channel().localAddress();
                object = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
                if (object == null) break block4;
                socketAddress = object;
                Object object2 = ((InetSocketAddress)object).getHostName();
                if (object2 == null) {
                    object2 = object = ((InetSocketAddress)socketAddress).getHostString();
                }
                if (object2 != null) break block5;
            }
            object = "localhost";
        }
        return object;
    }

    public final String getServerHost() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        if (string == null || (string = StringsKt.substringBeforeLast$default((String)string, (String)":", null, (int)2, null)) == null) {
            string = this.getLocalHost();
        }
        return string;
    }

    public final String getLocalAddress() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        Object object = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (object == null || (object = ((InetSocketAddress)object).getHostString()) == null) {
            object = "localhost";
        }
        return object;
    }

    private final int getDefaultPort() {
        return URLProtocol.Companion.createOrDefault(this.getScheme()).getDefaultPort();
    }

    public final int getLocalPort() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (inetSocketAddress != null) {
            return inetSocketAddress.getPort();
        }
        return this.getDefaultPort();
    }

    public final int getServerPort() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        if (string != null && (string = StringsKt.substringAfterLast((String)string, (String)":", (String)String.valueOf(this.getDefaultPort()))) != null) {
            return Integer.parseInt(string);
        }
        return this.getLocalPort();
    }

    public final String getRemoteHost() {
        Object object;
        block5: {
            block4: {
                SocketAddress socketAddress = this.context.channel().remoteAddress();
                object = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
                if (object == null) break block4;
                socketAddress = object;
                Object object2 = ((InetSocketAddress)object).getHostName();
                if (object2 == null) {
                    object2 = object = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
                }
                if (object2 != null) break block5;
            }
            object = "unknown";
        }
        return object;
    }

    public final int getRemotePort() {
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (inetSocketAddress != null) {
            return inetSocketAddress.getPort();
        }
        return 0;
    }

    public final String getRemoteAddress() {
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        Object object = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (object == null || (object = ((InetSocketAddress)object).getHostString()) == null) {
            object = "unknown";
        }
        return object;
    }

    public final String toString() {
        return "NettyConnectionPoint(uri=" + this.getUri() + ", method=" + this.getMethod() + ", version=" + this.getVersion() + ", localAddress=" + this.getLocalAddress() + ", localPort=" + this.getLocalPort() + ", remoteAddress=" + this.getRemoteAddress() + ", remotePort=" + this.getRemotePort() + ')';
    }

    private static final String scheme_delegate$lambda$0(NettyConnectionPoint nettyConnectionPoint) {
        if (nettyConnectionPoint.context.pipeline().context("ssl") == null) {
            return "http";
        }
        return "https";
    }
}

