/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.LazyGridSnapLayoutInfoProviderKt;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchScope;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchStrategy;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import androidx.compose.runtime.collection.MutableVector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u001c\u0010\u0019\u001a\u00020\u0010*\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0003*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u001d\u001a\u00020\u0003*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy;", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchStrategy;", "initialNestedPrefetchItemCount", "", "<init>", "(I)V", "lineToPrefetch", "currentLinePrefetchHandles", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "wasScrollingForward", "", "previousPassItemCount", "previousPassDelta", "", "onScroll", "", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;", "delta", "layoutInfo", "Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "onVisibleItemsUpdated", "onNestedPrefetch", "Landroidx/compose/foundation/lazy/layout/NestedPrefetchScope;", "firstVisibleItemIndex", "evaluatePrefetchForCancellation", "currentPrefetchingLineIndex", "scrollingForward", "calculateLineIndexToPrefetch", "calculateClosestNextItemToPrefetch", "resetPrefetchState", "foundation"})
final class DefaultLazyGridPrefetchStrategy
implements LazyGridPrefetchStrategy {
    private final int initialNestedPrefetchItemCount;
    private int lineToPrefetch;
    private final MutableVector<LazyLayoutPrefetchState.PrefetchHandle> currentLinePrefetchHandles;
    private boolean wasScrollingForward;
    private int previousPassItemCount;
    private float previousPassDelta;

    public DefaultLazyGridPrefetchStrategy(int n) {
        this.initialNestedPrefetchItemCount = n;
        this.lineToPrefetch = -1;
        this.currentLinePrefetchHandles = new MutableVector((Object[])new LazyLayoutPrefetchState.PrefetchHandle[16], 0);
        this.previousPassItemCount = -1;
    }

    public /* synthetic */ DefaultLazyGridPrefetchStrategy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    @Override
    public final void onScroll(LazyGridPrefetchScope object, float f2, LazyGridLayoutInfo objectArray) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        if (!((Collection)objectArray.getVisibleItemsInfo()).isEmpty()) {
            int n = f2 < 0.0f ? 1 : 0;
            int n2 = this.calculateLineIndexToPrefetch((LazyGridLayoutInfo)objectArray, n != 0);
            int n3 = this.calculateClosestNextItemToPrefetch((LazyGridLayoutInfo)objectArray, n != 0);
            boolean bl = n3 >= 0 ? n3 < objectArray.getTotalItemsCount() : false;
            if (bl) {
                Object[] objectArray2;
                int n4;
                if (n2 != this.lineToPrefetch && n2 >= 0) {
                    if (this.wasScrollingForward != n) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector = this.currentLinePrefetchHandles;
                        Object[] objectArray3 = mutableVector.content;
                        n3 = mutableVector.getSize();
                        for (n4 = 0; n4 < n3; ++n4) {
                            objectArray2 = (Object[])objectArray3[n4];
                            objectArray2.cancel();
                        }
                    }
                    this.wasScrollingForward = n;
                    this.lineToPrefetch = n2;
                    this.currentLinePrefetchHandles.clear();
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector = this.currentLinePrefetchHandles;
                    object = object.scheduleLinePrefetch(n2);
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector2 = mutableVector;
                    mutableVector2.addAll(mutableVector2.getSize(), (List)object);
                }
                if (n != 0) {
                    int n5;
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector = (MutableVector<LazyLayoutPrefetchState.PrefetchHandle>)CollectionsKt.last(objectArray.getVisibleItemsInfo());
                    int n6 = LazyGridSnapLayoutInfoProviderKt.sizeOnMainAxis((LazyGridItemInfo)mutableVector, objectArray.getOrientation());
                    n4 = objectArray.getMainAxisItemSpacing();
                    int n7 = LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis((LazyGridItemInfo)mutableVector, objectArray.getOrientation()) + n6 + n4 - objectArray.getViewportEndOffset();
                    if ((float)n5 < -f2) {
                        mutableVector = this.currentLinePrefetchHandles;
                        objectArray = mutableVector.content;
                        n = mutableVector.getSize();
                        for (n6 = 0; n6 < n; ++n6) {
                            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)objectArray[n6];
                            prefetchHandle.markAsUrgent();
                        }
                    }
                } else {
                    int n8;
                    LazyGridItemInfo lazyGridItemInfo = (LazyGridItemInfo)CollectionsKt.first(objectArray.getVisibleItemsInfo());
                    int n9 = objectArray.getViewportStartOffset() - LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(lazyGridItemInfo, objectArray.getOrientation());
                    if ((float)n8 < f2) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector = this.currentLinePrefetchHandles;
                        objectArray2 = mutableVector.content;
                        n9 = mutableVector.getSize();
                        for (int i2 = 0; i2 < n9; ++i2) {
                            objectArray = (LazyLayoutPrefetchState.PrefetchHandle)objectArray2[i2];
                            objectArray.markAsUrgent();
                        }
                    }
                }
            }
        }
        this.previousPassDelta = f2;
    }

    @Override
    public final void onVisibleItemsUpdated(LazyGridPrefetchScope object, LazyGridLayoutInfo mutableVector) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableVector, (String)"");
        this.evaluatePrefetchForCancellation((LazyGridLayoutInfo)mutableVector, this.lineToPrefetch, this.wasScrollingForward);
        int n = mutableVector.getTotalItemsCount();
        if (this.previousPassItemCount != -1 && !(this.previousPassDelta == 0.0f) && this.previousPassItemCount != n && !((Collection)mutableVector.getVisibleItemsInfo()).isEmpty()) {
            int n2 = this.calculateLineIndexToPrefetch((LazyGridLayoutInfo)mutableVector, this.previousPassDelta < 0.0f);
            int n3 = this.calculateClosestNextItemToPrefetch((LazyGridLayoutInfo)mutableVector, this.previousPassDelta < 0.0f);
            boolean bl = n3 >= 0 ? n3 < mutableVector.getTotalItemsCount() : false;
            if (bl && n2 != this.lineToPrefetch && n2 >= 0) {
                this.lineToPrefetch = n2;
                this.currentLinePrefetchHandles.clear();
                mutableVector = this.currentLinePrefetchHandles;
                object = object.scheduleLinePrefetch(n2);
                MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector2 = mutableVector;
                mutableVector2.addAll(mutableVector2.getSize(), (List)object);
            }
        }
        this.previousPassItemCount = n;
    }

    @Override
    public final void onNestedPrefetch(NestedPrefetchScope nestedPrefetchScope, int n) {
        Intrinsics.checkNotNullParameter((Object)nestedPrefetchScope, (String)"");
        int n2 = nestedPrefetchScope.getNestedPrefetchItemCount() == -1 ? this.initialNestedPrefetchItemCount : nestedPrefetchScope.getNestedPrefetchItemCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            nestedPrefetchScope.schedulePrecomposition(n + n4);
        }
    }

    private final void evaluatePrefetchForCancellation(LazyGridLayoutInfo lazyGridLayoutInfo, int n, boolean bl) {
        int n2;
        if (n != -1 && !((Collection)lazyGridLayoutInfo.getVisibleItemsInfo()).isEmpty() && n != (n2 = this.calculateLineIndexToPrefetch(lazyGridLayoutInfo, bl))) {
            this.resetPrefetchState();
        }
    }

    private final int calculateLineIndexToPrefetch(LazyGridLayoutInfo lazyGridLayoutInfo, boolean bl) {
        if (bl) {
            LazyGridItemInfo lazyGridItemInfo = (LazyGridItemInfo)CollectionsKt.last(lazyGridLayoutInfo.getVisibleItemsInfo());
            return (lazyGridLayoutInfo.getOrientation() == Orientation.Vertical ? lazyGridItemInfo.getRow() : lazyGridItemInfo.getColumn()) + 1;
        }
        LazyGridItemInfo lazyGridItemInfo = (LazyGridItemInfo)CollectionsKt.first(lazyGridLayoutInfo.getVisibleItemsInfo());
        return (lazyGridLayoutInfo.getOrientation() == Orientation.Vertical ? lazyGridItemInfo.getRow() : lazyGridItemInfo.getColumn()) - 1;
    }

    private final int calculateClosestNextItemToPrefetch(LazyGridLayoutInfo lazyGridLayoutInfo, boolean bl) {
        if (bl) {
            return ((LazyGridItemInfo)CollectionsKt.last(lazyGridLayoutInfo.getVisibleItemsInfo())).getIndex() + 1;
        }
        return ((LazyGridItemInfo)CollectionsKt.first(lazyGridLayoutInfo.getVisibleItemsInfo())).getIndex() - 1;
    }

    private final void resetPrefetchState() {
        this.lineToPrefetch = -1;
        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> mutableVector = this.currentLinePrefetchHandles;
        Object[] objectArray = mutableVector.content;
        int n = mutableVector.getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)objectArray[i2];
            prefetchHandle.cancel();
        }
        this.currentLinePrefetchHandles.clear();
    }

    public DefaultLazyGridPrefetchStrategy() {
        this(0, 1, null);
    }
}

