/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.osx.AwtOsxMenuItem;
import dorkbox.systemTray.ui.osx.AwtOsxMenuItemCheckbox;
import dorkbox.systemTray.ui.osx.AwtOsxMenuItemSeparator;
import dorkbox.systemTray.ui.osx.AwtOsxMenuItemStatus;
import dorkbox.systemTray.util.AwtAccessor;
import dorkbox.util.SwingUtil;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.io.File;
import javax.swing.ImageIcon;

class AwtOsxMenu
implements MenuPeer {
    volatile java.awt.Menu _native;
    private final AwtOsxMenu parent;
    private final Object peerObj;

    AwtOsxMenu(AwtOsxMenu awtOsxMenu) {
        this.parent = awtOsxMenu;
        if (awtOsxMenu == null) {
            this._native = new PopupMenu();
        } else {
            this._native = new java.awt.Menu();
            awtOsxMenu._native.add(this._native);
        }
        this._native.addNotify();
        this.peerObj = AwtAccessor.getPeer(this._native);
    }

    @Override
    public void add(Menu menu, Entry entry, int n) {
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
            if (entry instanceof Menu) {
                AwtOsxMenu awtOsxMenu = new AwtOsxMenu(this);
                Menu menu2 = menu;
                ((Menu)entry).bind(awtOsxMenu, menu2, menu2.getImageResizeUtil());
                return;
            }
            if (entry instanceof Separator) {
                AwtOsxMenuItemSeparator awtOsxMenuItemSeparator = new AwtOsxMenuItemSeparator(this);
                Menu menu3 = menu;
                entry.bind(awtOsxMenuItemSeparator, menu3, menu3.getImageResizeUtil());
                return;
            }
            if (entry instanceof Checkbox) {
                AwtOsxMenuItemCheckbox awtOsxMenuItemCheckbox = new AwtOsxMenuItemCheckbox(this);
                Menu menu4 = menu;
                ((Checkbox)entry).bind(awtOsxMenuItemCheckbox, menu4, menu4.getImageResizeUtil());
                return;
            }
            if (entry instanceof Status) {
                AwtOsxMenuItemStatus awtOsxMenuItemStatus = new AwtOsxMenuItemStatus(this);
                Menu menu5 = menu;
                ((Status)entry).bind(awtOsxMenuItemStatus, menu5, menu5.getImageResizeUtil());
                return;
            }
            if (entry instanceof MenuItem) {
                AwtOsxMenuItem awtOsxMenuItem = new AwtOsxMenuItem(this);
                Menu menu6 = menu;
                ((MenuItem)entry).bind(awtOsxMenuItem, menu6, menu6.getImageResizeUtil());
            }
        });
    }

    @Override
    public void setImage(MenuItem object) {
        object = ((MenuItem)object).getImage();
        if (this.peerObj != null && object != null) {
            object = new ImageIcon(((File)object).getAbsolutePath()).getImage();
            SwingUtil.INSTANCE.invokeLater(() -> this.lambda$setImage$1((Image)object));
        }
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setLabel(menuItem.getText()));
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int n = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setShortcut(new MenuShortcut(n)));
    }

    @Override
    public void setTooltip(MenuItem object) {
        object = ((MenuItem)object).getTooltip();
        if (this.peerObj != null && object != null) {
            SwingUtil.INSTANCE.invokeLater(() -> this.lambda$setTooltip$5((String)object));
        }
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.removeAll();
            this._native.deleteShortcut();
            this._native.setEnabled(false);
            if (this.parent != null) {
                this.parent._native.remove(this._native);
            }
            this._native.removeNotify();
        });
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    private /* synthetic */ void lambda$setTooltip$5(String string) {
        try {
            AwtAccessor.setToolTipText(this.peerObj, string);
            return;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to setTooltip for awt-osx menus.", (Throwable)exception);
            return;
        }
    }

    private /* synthetic */ void lambda$setImage$1(Image image) {
        try {
            AwtAccessor.setImage(this.peerObj, image);
            return;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to setImage for awt-osx menus.", (Throwable)exception);
            return;
        }
    }
}

