/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.JvmFunctionSignature;
import kotlin.reflect.jvm.internal.JvmPropertySignature;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.calls.ValueClassAwareCallerKt;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.CloneableClassScope;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaField;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAbi;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaMethodDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.sources.JavaSourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorFactory;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00052\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u0006\u0012\u0002\b\u00030\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lkotlin/reflect/jvm/internal/RuntimeTypeMapper;", "", "<init>", "()V", "JAVA_LANG_VOID", "Lkotlin/reflect/jvm/internal/impl/name/ClassId;", "mapSignature", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "possiblySubstitutedFunction", "Lkotlin/reflect/jvm/internal/impl/descriptors/FunctionDescriptor;", "mapPropertySignature", "Lkotlin/reflect/jvm/internal/JvmPropertySignature;", "possiblyOverriddenProperty", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "isKnownBuiltInFunction", "", "descriptor", "mapJvmFunctionSignature", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature$KotlinFunction;", "mapName", "", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableMemberDescriptor;", "mapJvmClassToKotlinClassId", "klass", "Ljava/lang/Class;", "primitiveType", "Lkotlin/reflect/jvm/internal/impl/builtins/PrimitiveType;", "getPrimitiveType", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "kotlin-reflection"})
public final class RuntimeTypeMapper {
    public static final RuntimeTypeMapper INSTANCE = new RuntimeTypeMapper();
    private static final ClassId JAVA_LANG_VOID = ClassId.Companion.topLevel(new FqName("java.lang.Void"));

    private RuntimeTypeMapper() {
    }

    public final JvmFunctionSignature mapSignature(FunctionDescriptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        FunctionDescriptor functionDescriptor = ((FunctionDescriptor)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)object)).getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"");
        Object object2 = functionDescriptor;
        Object object3 = functionDescriptor;
        if (functionDescriptor instanceof DeserializedCallableMemberDescriptor) {
            JvmMemberSignature.Method method;
            object3 = ((DeserializedMemberDescriptor)object2).getProto();
            if (object3 instanceof ProtoBuf.Function && (method = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)object3, ((DeserializedMemberDescriptor)object2).getNameResolver(), ((DeserializedMemberDescriptor)object2).getTypeTable())) != null) {
                object2 = method;
                return new JvmFunctionSignature.KotlinFunction((JvmMemberSignature.Method)object2);
            }
            if (object3 instanceof ProtoBuf.Constructor && (method = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf.Constructor)object3, ((DeserializedMemberDescriptor)object2).getNameResolver(), ((DeserializedMemberDescriptor)object2).getTypeTable())) != null) {
                object2 = method;
                DeclarationDescriptor declarationDescriptor = object.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
                if (InlineClassesUtilsKt.isInlineClass(declarationDescriptor)) {
                    return new JvmFunctionSignature.KotlinFunction((JvmMemberSignature.Method)object2);
                }
                DeclarationDescriptor declarationDescriptor2 = object.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"");
                if (InlineClassesUtilsKt.isMultiFieldValueClass(declarationDescriptor2)) {
                    Object object4;
                    if (((ConstructorDescriptor)object).isPrimary()) {
                        if (!(Intrinsics.areEqual((Object)((JvmMemberSignature.Method)object2).getName(), (Object)"constructor-impl") && StringsKt.endsWith$default((String)((JvmMemberSignature.Method)object2).getDesc(), (String)")V", (boolean)false, (int)2, null))) {
                            object = "Invalid signature: " + object2;
                            throw new IllegalArgumentException(object.toString());
                        }
                        object4 = object2;
                    } else {
                        if (!Intrinsics.areEqual((Object)((JvmMemberSignature.Method)object2).getName(), (Object)"constructor-impl")) {
                            object = "Invalid signature: " + object2;
                            throw new IllegalArgumentException(object.toString());
                        }
                        ClassDescriptor classDescriptor = ((ConstructorDescriptor)object).getConstructedClass();
                        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
                        object = ValueClassAwareCallerKt.toJvmDescriptor(classDescriptor);
                        if (StringsKt.endsWith$default((String)((JvmMemberSignature.Method)object2).getDesc(), (String)")V", (boolean)false, (int)2, null)) {
                            object4 = JvmMemberSignature.Method.copy$default((JvmMemberSignature.Method)object2, null, StringsKt.removeSuffix((String)((JvmMemberSignature.Method)object2).getDesc(), (CharSequence)"V") + (String)object, 1, null);
                        } else {
                            if (!StringsKt.endsWith$default((String)((JvmMemberSignature.Method)object2).getDesc(), (String)object, (boolean)false, (int)2, null)) {
                                object = "Invalid signature: " + object2;
                                throw new IllegalArgumentException(object.toString());
                            }
                            object4 = object2;
                        }
                    }
                    object = object4;
                    return new JvmFunctionSignature.KotlinFunction((JvmMemberSignature.Method)object);
                }
                return new JvmFunctionSignature.KotlinConstructor((JvmMemberSignature.Method)object2);
            }
            return this.mapJvmFunctionSignature((FunctionDescriptor)object2);
        }
        if (object3 instanceof JavaMethodDescriptor) {
            object = ((JavaMethodDescriptor)object2).getSource();
            JavaSourceElement javaSourceElement = object instanceof JavaSourceElement ? (JavaSourceElement)object : null;
            object = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            Object object5 = object instanceof ReflectJavaMethod ? (ReflectJavaMethod)object : null;
            if (object5 == null || (object5 = ((ReflectJavaMethod)object5).getMember()) == null) {
                throw new KotlinReflectionInternalError("Incorrect resolution sequence for Java method " + object2);
            }
            object3 = object5;
            return new JvmFunctionSignature.JavaMethod((Method)object3);
        }
        if (object3 instanceof JavaClassConstructorDescriptor) {
            object = ((JavaClassConstructorDescriptor)object2).getSource();
            JavaSourceElement javaSourceElement = object instanceof JavaSourceElement ? (JavaSourceElement)object : null;
            object3 = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            if (object3 instanceof ReflectJavaConstructor) {
                return new JvmFunctionSignature.JavaConstructor((Constructor<?>)((ReflectJavaConstructor)object3).getMember());
            }
            if (object3 instanceof ReflectJavaClass && ((ReflectJavaClass)object3).isAnnotationType()) {
                return new JvmFunctionSignature.FakeJavaAnnotationConstructor((Class<?>)((ReflectJavaClass)object3).getElement());
            }
            throw new KotlinReflectionInternalError("Incorrect resolution sequence for Java constructor " + object2 + " (" + object3 + ')');
        }
        if (this.isKnownBuiltInFunction((FunctionDescriptor)object2)) {
            return this.mapJvmFunctionSignature((FunctionDescriptor)object2);
        }
        throw new KotlinReflectionInternalError("Unknown origin of " + object2 + " (" + object2.getClass() + ')');
    }

    public final JvmPropertySignature mapPropertySignature(PropertyDescriptor object) {
        JvmFunctionSignature.KotlinFunction kotlinFunction;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        PropertyDescriptor propertyDescriptor = ((PropertyDescriptor)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)object)).getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"");
        object = propertyDescriptor;
        Object object3 = propertyDescriptor;
        if (propertyDescriptor instanceof DeserializedPropertyDescriptor) {
            object3 = ((DeserializedPropertyDescriptor)object).getProto();
            GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)object3;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
            Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
            object2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
            if (object2 != null) {
                return new JvmPropertySignature.KotlinProperty((PropertyDescriptor)object, (ProtoBuf.Property)object3, (JvmProtoBuf.JvmPropertySignature)object2, ((DeserializedPropertyDescriptor)object).getNameResolver(), ((DeserializedPropertyDescriptor)object).getTypeTable());
            }
        } else if (object3 instanceof JavaPropertyDescriptor) {
            object3 = ((JavaPropertyDescriptor)object).getSource();
            JavaSourceElement javaSourceElement = object3 instanceof JavaSourceElement ? (JavaSourceElement)object3 : null;
            object3 = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            if (object3 instanceof ReflectJavaField) {
                return new JvmPropertySignature.JavaField(((ReflectJavaField)object3).getMember());
            }
            if (object3 instanceof ReflectJavaMethod) {
                Method method = ((ReflectJavaMethod)object3).getMember();
                PropertySetterDescriptor propertySetterDescriptor = ((JavaPropertyDescriptor)object).getSetter();
                object = propertySetterDescriptor != null ? propertySetterDescriptor.getSource() : null;
                JavaSourceElement javaSourceElement2 = object instanceof JavaSourceElement ? (JavaSourceElement)object : null;
                object3 = javaSourceElement2 != null ? javaSourceElement2.getJavaElement() : null;
                ReflectJavaMethod reflectJavaMethod = object3 instanceof ReflectJavaMethod ? (ReflectJavaMethod)object3 : null;
                return new JvmPropertySignature.JavaMethodProperty(method, reflectJavaMethod != null ? reflectJavaMethod.getMember() : null);
            }
            throw new KotlinReflectionInternalError("Incorrect resolution sequence for Java field " + object + " (source = " + object3 + ')');
        }
        PropertyGetterDescriptor propertyGetterDescriptor = object.getGetter();
        Intrinsics.checkNotNull((Object)propertyGetterDescriptor);
        object3 = propertyGetterDescriptor;
        Object object4 = this.mapJvmFunctionSignature((FunctionDescriptor)object3);
        PropertySetterDescriptor propertySetterDescriptor = object.getSetter();
        if (propertySetterDescriptor != null) {
            object2 = propertySetterDescriptor;
            object = object4;
            kotlinFunction = this.mapJvmFunctionSignature((FunctionDescriptor)object2);
            object4 = object;
        } else {
            kotlinFunction = null;
        }
        object = kotlinFunction;
        object3 = object4;
        return new JvmPropertySignature.MappedKotlinProperty((JvmFunctionSignature.KotlinFunction)object3, (JvmFunctionSignature.KotlinFunction)object);
    }

    private final boolean isKnownBuiltInFunction(FunctionDescriptor functionDescriptor) {
        if (DescriptorFactory.isEnumValueOfMethod(functionDescriptor) || DescriptorFactory.isEnumValuesMethod(functionDescriptor)) {
            return true;
        }
        return Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)CloneableClassScope.Companion.getCLONE_NAME()) && functionDescriptor.getValueParameters().isEmpty();
    }

    private final JvmFunctionSignature.KotlinFunction mapJvmFunctionSignature(FunctionDescriptor functionDescriptor) {
        return new JvmFunctionSignature.KotlinFunction(new JvmMemberSignature.Method(this.mapName(functionDescriptor), MethodSignatureMappingKt.computeJvmDescriptor$default(functionDescriptor, false, false, 1, null)));
    }

    private final String mapName(CallableMemberDescriptor callableMemberDescriptor) {
        String string = SpecialBuiltinMembers.getJvmMethodNameIfSpecial(callableMemberDescriptor);
        if (string == null) {
            CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
            if (callableMemberDescriptor2 instanceof PropertyGetterDescriptor) {
                String string2 = DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                return JvmAbi.getterName(string2);
            }
            if (callableMemberDescriptor2 instanceof PropertySetterDescriptor) {
                String string3 = DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                return JvmAbi.setterName(string3);
            }
            String string4 = callableMemberDescriptor.getName().asString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
        }
        return string;
    }

    public final ClassId mapJvmClassToKotlinClassId(Class<?> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        if (((Class)object).isArray()) {
            Class<?> clazz = ((Class)object).getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
            PrimitiveType primitiveType = this.getPrimitiveType(clazz);
            if (primitiveType != null) {
                object = primitiveType;
                return new ClassId(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, ((PrimitiveType)((Object)object)).getArrayTypeName());
            }
            return ClassId.Companion.topLevel(StandardNames.FqNames.array.toSafe());
        }
        if (Intrinsics.areEqual(object, Void.TYPE)) {
            return JAVA_LANG_VOID;
        }
        Object object2 = this.getPrimitiveType((Class<?>)object);
        if (object2 != null) {
            object = object2;
            return new ClassId(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, ((PrimitiveType)((Object)object)).getTypeName());
        }
        object2 = ReflectClassUtilKt.getClassId(object);
        if (!((ClassId)object2).isLocal() && (object = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(((ClassId)object2).asSingleFqName())) != null) {
            return object;
        }
        return object2;
    }

    private final PrimitiveType getPrimitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return JvmPrimitiveType.get(clazz.getSimpleName()).getPrimitiveType();
        }
        return null;
    }
}

