/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.text.StringsKt;

public final class FunctionTypeKindExtractor {
    public static final Companion Companion = new Companion(null);
    private final List<FunctionTypeKind> kinds;
    private final Map<FqName, List<FunctionTypeKind>> knownKindsByPackageFqName;
    private static final FunctionTypeKindExtractor Default;

    public FunctionTypeKindExtractor(List<? extends FunctionTypeKind> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        this.kinds = object;
        FunctionTypeKindExtractor functionTypeKindExtractor = this;
        object = functionTypeKindExtractor.kinds;
        FunctionTypeKindExtractor functionTypeKindExtractor2 = functionTypeKindExtractor;
        Map map = new LinkedHashMap();
        object = object.iterator();
        while (object.hasNext()) {
            Object v;
            Object e = object.next();
            Object object2 = (FunctionTypeKind)e;
            Map map2 = map;
            Object object3 = map2.get(object2 = ((FunctionTypeKind)object2).getPackageFqName());
            if (object3 == null) {
                object3 = new ArrayList();
                map2.put(object2, object3);
                v = object3;
            } else {
                v = object3;
            }
            object2 = (List)v;
            object2.add(e);
        }
        functionTypeKindExtractor2.knownKindsByPackageFqName = map;
    }

    public final FunctionTypeKind getFunctionalClassKind(FqName fqName, String string) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        KindWithArity kindWithArity = this.getFunctionalClassKindWithArity(fqName, string);
        if (kindWithArity != null) {
            return kindWithArity.getKind();
        }
        return null;
    }

    public final KindWithArity getFunctionalClassKindWithArity(FqName iterator2, String string) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        List<FunctionTypeKind> list = this.knownKindsByPackageFqName.get(iterator2);
        if (list == null) {
            return null;
        }
        iterator2 = list;
        for (FunctionTypeKind functionTypeKind : list) {
            if (!StringsKt.startsWith$default((String)string, (String)functionTypeKind.getClassNamePrefix(), (boolean)false, (int)2, null)) continue;
            String string2 = string.substring(functionTypeKind.getClassNamePrefix().length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            Integer n = this.toInt(string2);
            if (n == null) {
                continue;
            }
            int n2 = n;
            return new KindWithArity(functionTypeKind, n2);
        }
        return null;
    }

    private final Integer toInt(String string) {
        if (((CharSequence)string).length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i);
            if (!((n3 -= 48) >= 0 ? n3 < 10 : false)) {
                return null;
            }
            n = n * 10 + n3;
        }
        return n;
    }

    static {
        Object[] objectArray = new FunctionTypeKind[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = FunctionTypeKind.Function.INSTANCE;
        objectArray2[1] = FunctionTypeKind.SuspendFunction.INSTANCE;
        objectArray2[2] = FunctionTypeKind.KFunction.INSTANCE;
        objectArray2[3] = FunctionTypeKind.KSuspendFunction.INSTANCE;
        Default = new FunctionTypeKindExtractor(CollectionsKt.listOf((Object[])objectArray2));
    }

    public static final class Companion {
        private Companion() {
        }

        public final FunctionTypeKindExtractor getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public static final class KindWithArity {
        private final FunctionTypeKind kind;
        private final int arity;

        public KindWithArity(FunctionTypeKind functionTypeKind, int n) {
            Intrinsics.checkNotNullParameter((Object)functionTypeKind, (String)"");
            this.kind = functionTypeKind;
            this.arity = n;
        }

        public final FunctionTypeKind getKind() {
            return this.kind;
        }

        public final FunctionTypeKind component1() {
            return this.kind;
        }

        public final int component2() {
            return this.arity;
        }

        public final String toString() {
            return "KindWithArity(kind=" + this.kind + ", arity=" + this.arity + ')';
        }

        public final int hashCode() {
            int n = this.kind.hashCode();
            n = n * 31 + Integer.hashCode(this.arity);
            return n;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof KindWithArity)) {
                return false;
            }
            object = (KindWithArity)object;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)((KindWithArity)object).kind)) {
                return false;
            }
            return this.arity == ((KindWithArity)object).arity;
        }
    }
}

