/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionSpecificBehaviorKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MemberDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

public final class DeserializationContext {
    private final DeserializationComponents components;
    private final NameResolver nameResolver;
    private final DeclarationDescriptor containingDeclaration;
    private final TypeTable typeTable;
    private final VersionRequirementTable versionRequirementTable;
    private final BinaryVersion metadataVersion;
    private final DeserializedContainerSource containerSource;
    private final TypeDeserializer typeDeserializer;
    private final MemberDeserializer memberDeserializer;

    public DeserializationContext(DeserializationComponents deserializationComponents, NameResolver nameResolver, DeclarationDescriptor declarationDescriptor, TypeTable typeTable, VersionRequirementTable versionRequirementTable, BinaryVersion binaryVersion, DeserializedContainerSource deserializedContainerSource, TypeDeserializer typeDeserializer, List<ProtoBuf.TypeParameter> list) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponents, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)binaryVersion, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.components = deserializationComponents;
        this.nameResolver = nameResolver;
        this.containingDeclaration = declarationDescriptor;
        this.typeTable = typeTable;
        this.versionRequirementTable = versionRequirementTable;
        this.metadataVersion = binaryVersion;
        this.containerSource = deserializedContainerSource;
        String string = "Deserializer for \"" + this.containingDeclaration.getName() + '\"';
        Object object = this.containerSource;
        if (object == null || (object = object.getPresentableString()) == null) {
            object = "[container not found]";
        }
        this.typeDeserializer = new TypeDeserializer(this, typeDeserializer, list, string, (String)object);
        this.memberDeserializer = new MemberDeserializer(this);
    }

    public final DeserializationComponents getComponents() {
        return this.components;
    }

    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    public final DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public final VersionRequirementTable getVersionRequirementTable() {
        return this.versionRequirementTable;
    }

    public final DeserializedContainerSource getContainerSource() {
        return this.containerSource;
    }

    public final TypeDeserializer getTypeDeserializer() {
        return this.typeDeserializer;
    }

    public final MemberDeserializer getMemberDeserializer() {
        return this.memberDeserializer;
    }

    public final StorageManager getStorageManager() {
        return this.components.getStorageManager();
    }

    public final DeserializationContext childContext(DeclarationDescriptor declarationDescriptor, List<ProtoBuf.TypeParameter> list, NameResolver nameResolver, TypeTable typeTable, VersionRequirementTable versionRequirementTable, BinaryVersion binaryVersion) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)binaryVersion, (String)"");
        return new DeserializationContext(this.components, nameResolver, declarationDescriptor, typeTable, VersionSpecificBehaviorKt.isVersionRequirementTableWrittenCorrectly(binaryVersion) ? versionRequirementTable : this.versionRequirementTable, binaryVersion, this.containerSource, this.typeDeserializer, list);
    }

    public static /* synthetic */ DeserializationContext childContext$default(DeserializationContext deserializationContext, DeclarationDescriptor declarationDescriptor, List list, NameResolver nameResolver, TypeTable typeTable, VersionRequirementTable versionRequirementTable, BinaryVersion binaryVersion, int n, Object object) {
        if ((n & 4) != 0) {
            nameResolver = deserializationContext.nameResolver;
        }
        if ((n & 8) != 0) {
            typeTable = deserializationContext.typeTable;
        }
        if ((n & 0x10) != 0) {
            versionRequirementTable = deserializationContext.versionRequirementTable;
        }
        if ((n & 0x20) != 0) {
            binaryVersion = deserializationContext.metadataVersion;
        }
        return deserializationContext.childContext(declarationDescriptor, list, nameResolver, typeTable, versionRequirementTable, binaryVersion);
    }
}

