/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;

public class DefaultHttp2RemoteFlowController
implements Http2RemoteFlowController {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2RemoteFlowController.class);
    private static final int MIN_WRITABLE_CHUNK = 32768;
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private final StreamByteDistributor streamByteDistributor;
    private final FlowState connectionState;
    private int initialWindowSize = 65535;
    private WritabilityMonitor monitor;
    private ChannelHandlerContext ctx;

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection) {
        this(http2Connection, (Http2RemoteFlowController.Listener)null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, StreamByteDistributor streamByteDistributor) {
        this(http2Connection, streamByteDistributor, null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, Http2RemoteFlowController.Listener listener) {
        this(http2Connection, new WeightedFairQueueByteDistributor(http2Connection), listener);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, StreamByteDistributor streamByteDistributor, Http2RemoteFlowController.Listener listener) {
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)http2Connection, (String)"connection");
        this.streamByteDistributor = (StreamByteDistributor)ObjectUtil.checkNotNull((Object)streamByteDistributor, (String)"streamWriteDistributor");
        this.stateKey = http2Connection.newKey();
        this.connectionState = new FlowState(http2Connection.connectionStream());
        http2Connection.connectionStream().setProperty(this.stateKey, this.connectionState);
        this.listener(listener);
        this.monitor.windowSize(this.connectionState, this.initialWindowSize);
        http2Connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream http2Stream) {
                http2Stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, new FlowState(http2Stream));
            }

            @Override
            public void onStreamActive(Http2Stream http2Stream) {
                DefaultHttp2RemoteFlowController.this.monitor.windowSize(DefaultHttp2RemoteFlowController.this.state(http2Stream), DefaultHttp2RemoteFlowController.this.initialWindowSize);
            }

            @Override
            public void onStreamClosed(Http2Stream http2Stream) {
                DefaultHttp2RemoteFlowController.this.state(http2Stream).cancel(Http2Error.STREAM_CLOSED, null);
            }

            @Override
            public void onStreamHalfClosed(Http2Stream http2Stream) {
                if (Http2Stream.State.HALF_CLOSED_LOCAL == http2Stream.state()) {
                    DefaultHttp2RemoteFlowController.this.state(http2Stream).cancel(Http2Error.STREAM_CLOSED, null);
                }
            }
        });
    }

    @Override
    public void channelHandlerContext(ChannelHandlerContext channelHandlerContext) {
        this.ctx = (ChannelHandlerContext)ObjectUtil.checkNotNull((Object)channelHandlerContext, (String)"ctx");
        this.channelWritabilityChanged();
        if (this.isChannelWritable()) {
            this.writePendingBytes();
        }
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }

    @Override
    public void initialWindowSize(int n) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.initialWindowSize(n);
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).windowSize();
    }

    @Override
    public boolean isWritable(Http2Stream http2Stream) {
        return this.monitor.isWritable(this.state(http2Stream));
    }

    @Override
    public void channelWritabilityChanged() {
        this.monitor.channelWritabilityChange();
    }

    @Override
    public void updateDependencyTree(int n, int n2, short s, boolean bl) {
        assert (s > 0 && s <= 256) : "Invalid weight";
        assert (n != n2) : "A stream cannot depend on itself";
        assert (n > 0 && n2 >= 0) : "childStreamId must be > 0. parentStreamId must be >= 0.";
        this.streamByteDistributor.updateDependencyTree(n, n2, s, bl);
    }

    private boolean isChannelWritable() {
        return this.ctx != null && this.isChannelWritable0();
    }

    private boolean isChannelWritable0() {
        return this.ctx.channel().isWritable();
    }

    @Override
    public void listener(Http2RemoteFlowController.Listener listener) {
        this.monitor = listener == null ? new WritabilityMonitor() : new ListenerWritabilityMonitor(listener);
    }

    @Override
    public void incrementWindowSize(Http2Stream http2Stream, int n) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.incrementWindowSize(this.state(http2Stream), n);
    }

    @Override
    public void addFlowControlled(Http2Stream http2Stream, Http2RemoteFlowController.FlowControlled flowControlled) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull((Object)flowControlled, (String)"frame");
        try {
            this.monitor.enqueueFrame(this.state(http2Stream), flowControlled);
            return;
        }
        catch (Throwable throwable) {
            flowControlled.error(this.ctx, throwable);
            return;
        }
    }

    @Override
    public boolean hasFlowControlled(Http2Stream http2Stream) {
        return this.state(http2Stream).hasFrame();
    }

    private FlowState state(Http2Stream http2Stream) {
        return (FlowState)http2Stream.getProperty(this.stateKey);
    }

    private int connectionWindowSize() {
        return this.connectionState.windowSize();
    }

    private int minUsableChannelBytes() {
        return Math.max(this.ctx.channel().config().getWriteBufferLowWaterMark(), 32768);
    }

    private int maxUsableChannelBytes() {
        int n = (int)Math.min(Integer.MAX_VALUE, this.ctx.channel().bytesBeforeUnwritable());
        n = n > 0 ? Math.max(n, this.minUsableChannelBytes()) : 0;
        return Math.min(this.connectionState.windowSize(), n);
    }

    private int writableBytes() {
        return Math.min(this.connectionWindowSize(), this.maxUsableChannelBytes());
    }

    @Override
    public void writePendingBytes() {
        this.monitor.writePendingBytes();
    }

    private final class ListenerWritabilityMonitor
    extends WritabilityMonitor
    implements Http2StreamVisitor {
        private final Http2RemoteFlowController.Listener listener;

        ListenerWritabilityMonitor(Http2RemoteFlowController.Listener listener) {
            this.listener = listener;
        }

        @Override
        public final boolean visit(Http2Stream object) {
            if (this.isWritable((FlowState)(object = DefaultHttp2RemoteFlowController.this.state((Http2Stream)object))) != ((FlowState)object).markedWritability()) {
                this.notifyWritabilityChanged((FlowState)object);
            }
            return true;
        }

        @Override
        final void windowSize(FlowState flowState, int n) {
            super.windowSize(flowState, n);
            try {
                this.checkStateWritability(flowState);
                return;
            }
            catch (Http2Exception http2Exception) {
                throw new RuntimeException("Caught unexpected exception from window", http2Exception);
            }
        }

        @Override
        final void incrementWindowSize(FlowState flowState, int n) {
            super.incrementWindowSize(flowState, n);
            this.checkStateWritability(flowState);
        }

        @Override
        final void initialWindowSize(int n) {
            super.initialWindowSize(n);
            if (this.isWritableConnection()) {
                this.checkAllWritabilityChanged();
            }
        }

        @Override
        final void enqueueFrame(FlowState flowState, Http2RemoteFlowController.FlowControlled flowControlled) {
            super.enqueueFrame(flowState, flowControlled);
            this.checkConnectionThenStreamWritabilityChanged(flowState);
        }

        @Override
        final void stateCancelled(FlowState flowState) {
            try {
                this.checkConnectionThenStreamWritabilityChanged(flowState);
                return;
            }
            catch (Http2Exception http2Exception) {
                throw new RuntimeException("Caught unexpected exception from checkAllWritabilityChanged", http2Exception);
            }
        }

        @Override
        final void channelWritabilityChange() {
            if (DefaultHttp2RemoteFlowController.this.connectionState.markedWritability() != DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.checkAllWritabilityChanged();
            }
        }

        private void checkStateWritability(FlowState flowState) {
            if (this.isWritable(flowState) != flowState.markedWritability()) {
                if (flowState == DefaultHttp2RemoteFlowController.this.connectionState) {
                    this.checkAllWritabilityChanged();
                    return;
                }
                this.notifyWritabilityChanged(flowState);
            }
        }

        private void notifyWritabilityChanged(FlowState flowState) {
            FlowState flowState2 = flowState;
            flowState2.markedWritability(!flowState2.markedWritability());
            try {
                this.listener.writabilityChanged(flowState.stream);
                return;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener.writabilityChanged", throwable);
                return;
            }
        }

        private void checkConnectionThenStreamWritabilityChanged(FlowState flowState) {
            if (this.isWritableConnection() != DefaultHttp2RemoteFlowController.this.connectionState.markedWritability()) {
                this.checkAllWritabilityChanged();
                return;
            }
            if (this.isWritable(flowState) != flowState.markedWritability()) {
                this.notifyWritabilityChanged(flowState);
            }
        }

        private void checkAllWritabilityChanged() {
            DefaultHttp2RemoteFlowController.this.connectionState.markedWritability(this.isWritableConnection());
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(this);
        }
    }

    private class WritabilityMonitor
    implements StreamByteDistributor.Writer {
        private boolean inWritePendingBytes;
        private long totalPendingBytes;

        private WritabilityMonitor() {
        }

        @Override
        public final void write(Http2Stream http2Stream, int n) {
            DefaultHttp2RemoteFlowController.this.state(http2Stream).writeAllocatedBytes(n);
        }

        void channelWritabilityChange() {
        }

        void stateCancelled(FlowState flowState) {
        }

        void windowSize(FlowState flowState, int n) {
            flowState.windowSize(n);
        }

        void incrementWindowSize(FlowState flowState, int n) {
            flowState.incrementStreamWindow(n);
        }

        void enqueueFrame(FlowState flowState, Http2RemoteFlowController.FlowControlled flowControlled) {
            flowState.enqueueFrame(flowControlled);
        }

        final void incrementPendingBytes(int n) {
            this.totalPendingBytes += (long)n;
        }

        final boolean isWritable(FlowState flowState) {
            return this.isWritableConnection() && flowState.isWritable();
        }

        final void writePendingBytes() {
            if (this.inWritePendingBytes) {
                return;
            }
            this.inWritePendingBytes = true;
            try {
                int n = DefaultHttp2RemoteFlowController.this.writableBytes();
                while (DefaultHttp2RemoteFlowController.this.streamByteDistributor.distribute(n, this) && (n = DefaultHttp2RemoteFlowController.this.writableBytes()) > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable0()) {
                }
                return;
            }
            finally {
                this.inWritePendingBytes = false;
            }
        }

        void initialWindowSize(int n) {
            ObjectUtil.checkPositiveOrZero((int)n, (String)"newWindowSize");
            final int n2 = n - DefaultHttp2RemoteFlowController.this.initialWindowSize;
            DefaultHttp2RemoteFlowController.this.initialWindowSize = n;
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream http2Stream) {
                    DefaultHttp2RemoteFlowController.this.state(http2Stream).incrementStreamWindow(n2);
                    return true;
                }
            });
            if (n2 > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.writePendingBytes();
            }
        }

        final boolean isWritableConnection() {
            return (long)DefaultHttp2RemoteFlowController.this.connectionState.windowSize() - this.totalPendingBytes > 0L && DefaultHttp2RemoteFlowController.this.isChannelWritable();
        }
    }

    private final class FlowState
    implements StreamByteDistributor.StreamState {
        private final Http2Stream stream;
        private final Deque<Http2RemoteFlowController.FlowControlled> pendingWriteQueue;
        private int window;
        private long pendingBytes;
        private boolean markedWritable;
        private boolean writing;
        private boolean cancelled;

        FlowState(Http2Stream http2Stream) {
            this.stream = http2Stream;
            this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController.FlowControlled>(2);
        }

        final boolean isWritable() {
            return (long)this.windowSize() > this.pendingBytes() && !this.cancelled;
        }

        @Override
        public final Http2Stream stream() {
            return this.stream;
        }

        final boolean markedWritability() {
            return this.markedWritable;
        }

        final void markedWritability(boolean bl) {
            this.markedWritable = bl;
        }

        @Override
        public final int windowSize() {
            return this.window;
        }

        final void windowSize(int n) {
            this.window = n;
        }

        final int writeAllocatedBytes(int n) {
            int n2 = n;
            try {
                int n3;
                Http2RemoteFlowController.FlowControlled flowControlled;
                assert (!this.writing);
                this.writing = true;
                boolean bl = false;
                while (!(this.cancelled || (flowControlled = this.peek()) == null || (n3 = Math.min(n, this.writableWindow())) <= 0 && flowControlled.size() > 0)) {
                    bl = true;
                    int n4 = flowControlled.size();
                    try {
                        flowControlled.write(DefaultHttp2RemoteFlowController.this.ctx, Math.max(0, n3));
                        if (flowControlled.size() != 0) continue;
                        this.pendingWriteQueue.remove();
                        flowControlled.writeComplete();
                    }
                    finally {
                        n -= n4 - flowControlled.size();
                    }
                }
                if (!bl) {
                    this.writing = false;
                    n = n2 - n;
                    this.decrementPendingBytes(n, false);
                    this.decrementFlowControlWindow(n);
                    if (this.cancelled) {
                        this.cancel(Http2Error.INTERNAL_ERROR, null);
                    }
                    return -1;
                }
                this.writing = false;
                n = n2 - n;
                this.decrementPendingBytes(n, false);
                this.decrementFlowControlWindow(n);
                if (this.cancelled) {
                    this.cancel(Http2Error.INTERNAL_ERROR, null);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.cancelled = true;
                    Throwable throwable2 = throwable;
                    this.writing = false;
                    n = n2 - n;
                    this.decrementPendingBytes(n, false);
                    this.decrementFlowControlWindow(n);
                    if (this.cancelled) {
                        this.cancel(Http2Error.INTERNAL_ERROR, throwable2);
                    }
                }
                catch (Throwable throwable3) {
                    this.writing = false;
                    n = n2 - n;
                    this.decrementPendingBytes(n, false);
                    this.decrementFlowControlWindow(n);
                    if (this.cancelled) {
                        this.cancel(Http2Error.INTERNAL_ERROR, null);
                    }
                    throw throwable3;
                }
            }
            return n;
        }

        final int incrementStreamWindow(int n) {
            if (n > 0 && Integer.MAX_VALUE - n < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
            }
            this.window += n;
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            return this.window;
        }

        private int writableWindow() {
            return Math.min(this.window, DefaultHttp2RemoteFlowController.this.connectionWindowSize());
        }

        @Override
        public final long pendingBytes() {
            return this.pendingBytes;
        }

        final void enqueueFrame(Http2RemoteFlowController.FlowControlled flowControlled) {
            Http2RemoteFlowController.FlowControlled flowControlled2 = this.pendingWriteQueue.peekLast();
            if (flowControlled2 == null) {
                this.enqueueFrameWithoutMerge(flowControlled);
                return;
            }
            int n = flowControlled2.size();
            if (flowControlled2.merge(DefaultHttp2RemoteFlowController.this.ctx, flowControlled)) {
                this.incrementPendingBytes(flowControlled2.size() - n, true);
                return;
            }
            this.enqueueFrameWithoutMerge(flowControlled);
        }

        private void enqueueFrameWithoutMerge(Http2RemoteFlowController.FlowControlled flowControlled) {
            this.pendingWriteQueue.offer(flowControlled);
            this.incrementPendingBytes(flowControlled.size(), true);
        }

        @Override
        public final boolean hasFrame() {
            return !this.pendingWriteQueue.isEmpty();
        }

        private Http2RemoteFlowController.FlowControlled peek() {
            return this.pendingWriteQueue.peek();
        }

        final void cancel(Http2Error object, Throwable throwable) {
            this.cancelled = true;
            if (this.writing) {
                return;
            }
            Http2RemoteFlowController.FlowControlled flowControlled = this.pendingWriteQueue.poll();
            if (flowControlled != null) {
                object = Http2Exception.streamError(this.stream.id(), object, throwable, "Stream closed before write could take place", new Object[0]);
                do {
                    this.writeError(flowControlled, (Http2Exception)object);
                } while ((flowControlled = this.pendingWriteQueue.poll()) != null);
            }
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            DefaultHttp2RemoteFlowController.this.monitor.stateCancelled(this);
        }

        private void incrementPendingBytes(int n, boolean bl) {
            this.pendingBytes += (long)n;
            DefaultHttp2RemoteFlowController.this.monitor.incrementPendingBytes(n);
            if (bl) {
                DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            }
        }

        private void decrementPendingBytes(int n, boolean bl) {
            this.incrementPendingBytes(-n, bl);
        }

        private void decrementFlowControlWindow(int n) {
            try {
                n = -n;
                DefaultHttp2RemoteFlowController.this.connectionState.incrementStreamWindow(n);
                this.incrementStreamWindow(n);
                return;
            }
            catch (Http2Exception http2Exception) {
                throw new IllegalStateException("Invalid window state when writing frame: " + http2Exception.getMessage(), http2Exception);
            }
        }

        private void writeError(Http2RemoteFlowController.FlowControlled flowControlled, Http2Exception http2Exception) {
            assert (DefaultHttp2RemoteFlowController.this.ctx != null);
            this.decrementPendingBytes(flowControlled.size(), true);
            flowControlled.error(DefaultHttp2RemoteFlowController.this.ctx, http2Exception);
        }
    }
}

