/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;

@ChannelHandler.Sharable
public class Http2StreamFrameToHttpObjectCodec
extends MessageToMessageCodec<Http2StreamFrame, HttpObject> {
    private static final AttributeKey<HttpScheme> SCHEME_ATTR_KEY = AttributeKey.valueOf(HttpScheme.class, (String)"STREAMFRAMECODEC_SCHEME");
    private final boolean isServer;
    private final boolean validateHeaders;

    public Http2StreamFrameToHttpObjectCodec(boolean bl, boolean bl2) {
        this.isServer = bl;
        this.validateHeaders = bl2;
    }

    public Http2StreamFrameToHttpObjectCodec(boolean bl) {
        this(bl, true);
    }

    public boolean acceptInboundMessage(Object object) {
        return object instanceof Http2HeadersFrame || object instanceof Http2DataFrame;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void decode(ChannelHandlerContext channelHandlerContext, Http2StreamFrame http2StreamFrame, List<Object> list) {
        if (http2StreamFrame instanceof Http2HeadersFrame) {
            http2StreamFrame = (Http2HeadersFrame)http2StreamFrame;
            Http2Headers http2Headers = http2StreamFrame.headers();
            Http2FrameStream http2FrameStream = http2StreamFrame.stream();
            int n = http2FrameStream == null ? 0 : http2FrameStream.id();
            CharSequence charSequence = http2Headers.status();
            if (charSequence != null && Http2StreamFrameToHttpObjectCodec.isInformationalResponseHeaderFrame(charSequence)) {
                channelHandlerContext = this.newFullMessage(n, http2Headers, channelHandlerContext.alloc());
                list.add(channelHandlerContext);
                return;
            }
            if (http2StreamFrame.isEndStream()) {
                if (http2Headers.method() == null && charSequence == null) {
                    channelHandlerContext = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
                    HttpConversionUtil.addHttp2ToHttpHeaders(n, http2Headers, channelHandlerContext.trailingHeaders(), HttpVersion.HTTP_1_1, true, true);
                    list.add(channelHandlerContext);
                    return;
                }
                channelHandlerContext = this.newFullMessage(n, http2Headers, channelHandlerContext.alloc());
                list.add(channelHandlerContext);
                return;
            }
            channelHandlerContext = this.newMessage(n, http2Headers);
            if (!(charSequence != null && Http2StreamFrameToHttpObjectCodec.isContentAlwaysEmpty(charSequence) || HttpUtil.isContentLengthSet((HttpMessage)channelHandlerContext))) {
                channelHandlerContext.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            list.add(channelHandlerContext);
            return;
        }
        if (!(http2StreamFrame instanceof Http2DataFrame)) return;
        if ((http2StreamFrame = (Http2DataFrame)http2StreamFrame).isEndStream()) {
            list.add(new DefaultLastHttpContent(http2StreamFrame.content().retain(), this.validateHeaders));
            return;
        }
        list.add(new DefaultHttpContent(http2StreamFrame.content().retain()));
    }

    private void encodeLastContent(LastHttpContent object, List<Object> list) {
        boolean bl;
        boolean bl2 = bl = !(object instanceof FullHttpMessage) && object.trailingHeaders().isEmpty();
        if (object.content().isReadable() || bl) {
            list.add(new DefaultHttp2DataFrame(object.content().retain(), object.trailingHeaders().isEmpty()));
        }
        if (!object.trailingHeaders().isEmpty()) {
            object = HttpConversionUtil.toHttp2Headers(object.trailingHeaders(), this.validateHeaders);
            list.add(new DefaultHttp2HeadersFrame((Http2Headers)object, true));
        }
    }

    protected void encode(ChannelHandlerContext object, HttpObject httpObject, List<Object> list) {
        Object object2;
        if (httpObject instanceof HttpResponse) {
            object2 = (HttpResponse)httpObject;
            HttpResponseStatus httpResponseStatus = object2.status();
            int n = httpResponseStatus.code();
            HttpStatusClass httpStatusClass = httpResponseStatus.codeClass();
            if (httpStatusClass == HttpStatusClass.INFORMATIONAL && n != 101) {
                if (object2 instanceof FullHttpResponse) {
                    object = this.toHttp2Headers((ChannelHandlerContext)object, (HttpMessage)object2);
                    list.add(new DefaultHttp2HeadersFrame((Http2Headers)object, false));
                    return;
                }
                throw new EncoderException(httpResponseStatus + " must be a FullHttpResponse");
            }
        }
        if (httpObject instanceof HttpMessage) {
            object2 = this.toHttp2Headers((ChannelHandlerContext)object, (HttpMessage)httpObject);
            boolean bl = false;
            if (httpObject instanceof FullHttpMessage) {
                FullHttpMessage fullHttpMessage = (FullHttpMessage)httpObject;
                bl = !fullHttpMessage.content().isReadable() && fullHttpMessage.trailingHeaders().isEmpty();
            }
            list.add(new DefaultHttp2HeadersFrame((Http2Headers)object2, bl));
        }
        if (httpObject instanceof LastHttpContent) {
            object2 = (LastHttpContent)httpObject;
            this.encodeLastContent((LastHttpContent)object2, list);
            return;
        }
        if (httpObject instanceof HttpContent) {
            object2 = (HttpContent)httpObject;
            list.add(new DefaultHttp2DataFrame(object2.content().retain(), false));
        }
    }

    private Http2Headers toHttp2Headers(ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage) {
        if (httpMessage instanceof HttpRequest) {
            httpMessage.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)Http2StreamFrameToHttpObjectCodec.connectionScheme(channelHandlerContext));
        }
        return HttpConversionUtil.toHttp2Headers(httpMessage, this.validateHeaders);
    }

    private HttpMessage newMessage(int n, Http2Headers http2Headers) {
        if (this.isServer) {
            return HttpConversionUtil.toHttpRequest(n, http2Headers, this.validateHeaders);
        }
        return HttpConversionUtil.toHttpResponse(n, http2Headers, this.validateHeaders);
    }

    private FullHttpMessage newFullMessage(int n, Http2Headers http2Headers, ByteBufAllocator byteBufAllocator) {
        if (this.isServer) {
            return HttpConversionUtil.toFullHttpRequest(n, http2Headers, byteBufAllocator, this.validateHeaders);
        }
        return HttpConversionUtil.toFullHttpResponse(n, http2Headers, byteBufAllocator, this.validateHeaders);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        Attribute<HttpScheme> attribute = Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(channelHandlerContext);
        if (attribute.get() == null) {
            channelHandlerContext = this.isSsl(channelHandlerContext) ? HttpScheme.HTTPS : HttpScheme.HTTP;
            attribute.set((Object)channelHandlerContext);
        }
    }

    protected boolean isSsl(ChannelHandlerContext channelHandlerContext) {
        return null != (channelHandlerContext = Http2StreamFrameToHttpObjectCodec.connectionChannel(channelHandlerContext)).pipeline().get(SslHandler.class);
    }

    private static HttpScheme connectionScheme(ChannelHandlerContext channelHandlerContext) {
        if ((channelHandlerContext = (HttpScheme)Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(channelHandlerContext).get()) == null) {
            return HttpScheme.HTTP;
        }
        return channelHandlerContext;
    }

    private static Attribute<HttpScheme> connectionSchemeAttribute(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext = Http2StreamFrameToHttpObjectCodec.connectionChannel(channelHandlerContext);
        return channelHandlerContext.attr(SCHEME_ATTR_KEY);
    }

    private static Channel connectionChannel(ChannelHandlerContext channelHandlerContext) {
        if ((channelHandlerContext = channelHandlerContext.channel()) instanceof Http2StreamChannel) {
            return channelHandlerContext.parent();
        }
        return channelHandlerContext;
    }

    private static boolean isInformationalResponseHeaderFrame(CharSequence charSequence) {
        if (charSequence.length() == 3) {
            char c = charSequence.charAt(0);
            char c2 = charSequence.charAt(1);
            char c3 = charSequence.charAt(2);
            return c == '1' && c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c3 != '1';
        }
        return false;
    }

    private static boolean isContentAlwaysEmpty(CharSequence charSequence) {
        if (charSequence.length() == 3) {
            char c = charSequence.charAt(0);
            char c2 = charSequence.charAt(1);
            char c3 = charSequence.charAt(2);
            return (c == '2' || c == '3') && c2 == '0' && c3 == '4';
        }
        return false;
    }
}

