/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.ReferenceCountUtil;

public class HttpToHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private final boolean validateHeaders;
    private int currentStreamId;
    private HttpScheme httpScheme;

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings);
        this.validateHeaders = bl;
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl, boolean bl2) {
        this(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl, bl2, null);
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl, boolean bl2, HttpScheme httpScheme) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl2);
        this.validateHeaders = bl;
        this.httpScheme = httpScheme;
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl, boolean bl2, boolean bl3, HttpScheme httpScheme) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl2, bl3);
        this.validateHeaders = bl;
        this.httpScheme = httpScheme;
    }

    private int getStreamId(HttpHeaders httpHeaders) {
        return httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), this.connection().local().incrementAndGetNextStreamId());
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise object2) {
        if (!(object instanceof HttpMessage) && !(object instanceof HttpContent)) {
            channelHandlerContext.write(object, (ChannelPromise)object2);
            return;
        }
        boolean bl = true;
        object2 = new Http2CodecUtil.SimpleChannelPromiseAggregator((ChannelPromise)object2, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            Object object3;
            Http2ConnectionEncoder http2ConnectionEncoder = this.encoder();
            boolean bl2 = false;
            if (object instanceof HttpMessage) {
                HttpMessage httpMessage = (HttpMessage)object;
                this.currentStreamId = this.getStreamId(httpMessage.headers());
                if (this.httpScheme != null && !httpMessage.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text())) {
                    httpMessage.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)this.httpScheme.name());
                }
                object3 = HttpConversionUtil.toHttp2Headers(httpMessage, this.validateHeaders);
                bl2 = object instanceof FullHttpMessage && !((FullHttpMessage)object).content().isReadable();
                HttpToHttp2ConnectionHandler.writeHeaders(channelHandlerContext, http2ConnectionEncoder, this.currentStreamId, httpMessage.headers(), (Http2Headers)object3, bl2, (Http2CodecUtil.SimpleChannelPromiseAggregator)((Object)object2));
            }
            if (!bl2 && object instanceof HttpContent) {
                ByteBuf byteBuf;
                boolean bl3 = false;
                object3 = EmptyHttpHeaders.INSTANCE;
                Http2Headers http2Headers = EmptyHttp2Headers.INSTANCE;
                if (object instanceof LastHttpContent) {
                    bl3 = true;
                    byteBuf = (LastHttpContent)object;
                    object3 = byteBuf.trailingHeaders();
                    http2Headers = HttpConversionUtil.toHttp2Headers((HttpHeaders)object3, this.validateHeaders);
                }
                byteBuf = ((HttpContent)object).content();
                bl2 = bl3 && object3.isEmpty();
                http2ConnectionEncoder.writeData(channelHandlerContext, this.currentStreamId, byteBuf, 0, bl2, ((Http2CodecUtil.SimpleChannelPromiseAggregator)((Object)object2)).newPromise());
                bl = false;
                if (!object3.isEmpty()) {
                    HttpToHttp2ConnectionHandler.writeHeaders(channelHandlerContext, http2ConnectionEncoder, this.currentStreamId, (HttpHeaders)object3, http2Headers, true, (Http2CodecUtil.SimpleChannelPromiseAggregator)((Object)object2));
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.onError(channelHandlerContext, true, throwable);
            object2.setFailure(throwable);
            return;
        }
        finally {
            if (bl) {
                ReferenceCountUtil.release((Object)object);
            }
            ((Http2CodecUtil.SimpleChannelPromiseAggregator)((Object)object2)).doneAllocatingPromises();
        }
    }

    private static void writeHeaders(ChannelHandlerContext channelHandlerContext, Http2ConnectionEncoder http2ConnectionEncoder, int n, HttpHeaders httpHeaders, Http2Headers http2Headers, boolean bl, Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator) {
        int n2 = httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
        short s = httpHeaders.getShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        http2ConnectionEncoder.writeHeaders(channelHandlerContext, n, http2Headers, n2, s, false, 0, bl, simpleChannelPromiseAggregator.newPromise());
    }
}

