/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.NOP_FallbackServiceProvider;
import org.slf4j.helpers.Reporter;
import org.slf4j.helpers.SubstituteLogger;
import org.slf4j.helpers.SubstituteServiceProvider;
import org.slf4j.helpers.Util;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public final class LoggerFactory {
    static final String CODES_PREFIX = "https://www.slf4j.org/codes.html";
    static final String NO_PROVIDERS_URL = "https://www.slf4j.org/codes.html#noProviders";
    static final String IGNORED_BINDINGS_URL = "https://www.slf4j.org/codes.html#ignoredBindings";
    static final String MULTIPLE_BINDINGS_URL = "https://www.slf4j.org/codes.html#multiple_bindings";
    static final String VERSION_MISMATCH = "https://www.slf4j.org/codes.html#version_mismatch";
    static final String SUBSTITUTE_LOGGER_URL = "https://www.slf4j.org/codes.html#substituteLogger";
    static final String LOGGER_NAME_MISMATCH_URL = "https://www.slf4j.org/codes.html#loggerNameMismatch";
    static final String REPLAY_URL = "https://www.slf4j.org/codes.html#replay";
    static final String UNSUCCESSFUL_INIT_URL = "https://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String UNSUCCESSFUL_INIT_MSG = "org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also https://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String CONNECTED_WITH_MSG = "Connected with provider of type [";
    public static final String PROVIDER_PROPERTY_KEY = "slf4j.provider";
    static final int UNINITIALIZED = 0;
    static final int ONGOING_INITIALIZATION = 1;
    static final int FAILED_INITIALIZATION = 2;
    static final int SUCCESSFUL_INITIALIZATION = 3;
    static final int NOP_FALLBACK_INITIALIZATION = 4;
    static volatile int INITIALIZATION_STATE = 0;
    static final SubstituteServiceProvider SUBST_PROVIDER = new SubstituteServiceProvider();
    static final NOP_FallbackServiceProvider NOP_FALLBACK_SERVICE_PROVIDER = new NOP_FallbackServiceProvider();
    static final String DETECT_LOGGER_NAME_MISMATCH_PROPERTY = "slf4j.detectLoggerNameMismatch";
    static final String JAVA_VENDOR_PROPERTY = "java.vendor.url";
    static boolean DETECT_LOGGER_NAME_MISMATCH = Util.safeGetBooleanSystemProperty("slf4j.detectLoggerNameMismatch");
    static volatile SLF4JServiceProvider PROVIDER;
    private static final String[] API_COMPATIBILITY_LIST;
    private static final String STATIC_LOGGER_BINDER_PATH = "org/slf4j/impl/StaticLoggerBinder.class";

    static List<SLF4JServiceProvider> findServiceProviders() {
        ArrayList<SLF4JServiceProvider> arrayList = new ArrayList<SLF4JServiceProvider>();
        Object object = LoggerFactory.class.getClassLoader();
        SLF4JServiceProvider sLF4JServiceProvider = LoggerFactory.loadExplicitlySpecified((ClassLoader)object);
        if (sLF4JServiceProvider != null) {
            arrayList.add(sLF4JServiceProvider);
            return arrayList;
        }
        object = LoggerFactory.getServiceLoader((ClassLoader)object);
        object = ((ServiceLoader)object).iterator();
        while (object.hasNext()) {
            LoggerFactory.safelyInstantiate(arrayList, object);
        }
        return arrayList;
    }

    private static ServiceLoader<SLF4JServiceProvider> getServiceLoader(ClassLoader object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            object = ServiceLoader.load(SLF4JServiceProvider.class, (ClassLoader)object);
        } else {
            object = () -> LoggerFactory.lambda$getServiceLoader$0((ClassLoader)object);
            object = AccessController.doPrivileged(object);
        }
        return object;
    }

    private static void safelyInstantiate(List<SLF4JServiceProvider> list, Iterator<SLF4JServiceProvider> object) {
        try {
            object = object.next();
            list.add((SLF4JServiceProvider)object);
            return;
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            Reporter.error("A service provider failed to instantiate:\n" + serviceConfigurationError.getMessage());
            return;
        }
    }

    private LoggerFactory() {
    }

    static void reset() {
        INITIALIZATION_STATE = 0;
    }

    private static final void performInitialization() {
        LoggerFactory.bind();
        if (INITIALIZATION_STATE == 3) {
            LoggerFactory.versionSanityCheck();
        }
    }

    private static final void bind() {
        try {
            Collection<Object> collection = LoggerFactory.findServiceProviders();
            LoggerFactory.reportMultipleBindingAmbiguity(collection);
            if (collection != null && !collection.isEmpty()) {
                PROVIDER = collection.get(0);
                LoggerFactory.earlyBindMDCAdapter();
                PROVIDER.initialize();
                INITIALIZATION_STATE = 3;
                LoggerFactory.reportActualBinding(collection);
            } else {
                INITIALIZATION_STATE = 4;
                Reporter.warn("No SLF4J providers were found.");
                Reporter.warn("Defaulting to no-operation (NOP) logger implementation");
                Reporter.warn("See https://www.slf4j.org/codes.html#noProviders for further details.");
                collection = LoggerFactory.findPossibleStaticLoggerBinderPathSet();
                LoggerFactory.reportIgnoredStaticLoggerBinders(collection);
            }
            LoggerFactory.postBindCleanUp();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            LoggerFactory.failedBinding(exception);
            throw new IllegalStateException("Unexpected initialization failure", exception2);
        }
    }

    private static void earlyBindMDCAdapter() {
        MDCAdapter mDCAdapter = PROVIDER.getMDCAdapter();
        if (mDCAdapter != null) {
            MDC.setMDCAdapter(mDCAdapter);
        }
    }

    static SLF4JServiceProvider loadExplicitlySpecified(ClassLoader genericDeclaration) {
        String string = System.getProperty(PROVIDER_PROPERTY_KEY);
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            String string2 = String.format("Attempting to load provider \"%s\" specified via \"%s\" system property", string, PROVIDER_PROPERTY_KEY);
            Reporter.info(string2);
            genericDeclaration = ((ClassLoader)((Object)genericDeclaration)).loadClass(string);
            genericDeclaration = genericDeclaration.getConstructor(new Class[0]);
            genericDeclaration = ((Constructor)genericDeclaration).newInstance(new Object[0]);
            return (SLF4JServiceProvider)((Object)genericDeclaration);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            genericDeclaration = String.format("Failed to instantiate the specified SLF4JServiceProvider (%s)", string);
            Reporter.error((String)((Object)genericDeclaration), reflectiveOperationException);
            return null;
        }
        catch (ClassCastException classCastException) {
            genericDeclaration = String.format("Specified SLF4JServiceProvider (%s) does not implement SLF4JServiceProvider interface", string);
            Reporter.error((String)((Object)genericDeclaration), classCastException);
            return null;
        }
    }

    private static void reportIgnoredStaticLoggerBinders(Set<URL> object) {
        if (object.isEmpty()) {
            return;
        }
        Reporter.warn("Class path contains SLF4J bindings targeting slf4j-api versions 1.7.x or earlier.");
        object = object.iterator();
        while (object.hasNext()) {
            URL uRL = (URL)object.next();
            Reporter.warn("Ignoring binding found at [" + uRL + "]");
        }
        Reporter.warn("See https://www.slf4j.org/codes.html#ignoredBindings for an explanation.");
    }

    static Set<URL> findPossibleStaticLoggerBinderPathSet() {
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> enumeration = LoggerFactory.class.getClassLoader();
            enumeration = enumeration == null ? ClassLoader.getSystemResources(STATIC_LOGGER_BINDER_PATH) : ((ClassLoader)((Object)enumeration)).getResources(STATIC_LOGGER_BINDER_PATH);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                linkedHashSet.add(uRL);
            }
        }
        catch (IOException iOException) {
            Reporter.error("Error getting resources from path", iOException);
        }
        return linkedHashSet;
    }

    private static void postBindCleanUp() {
        LoggerFactory.fixSubstituteLoggers();
        LoggerFactory.replayEvents();
        SUBST_PROVIDER.getSubstituteLoggerFactory().clear();
    }

    private static void fixSubstituteLoggers() {
        SubstituteServiceProvider substituteServiceProvider = SUBST_PROVIDER;
        synchronized (substituteServiceProvider) {
            SUBST_PROVIDER.getSubstituteLoggerFactory().postInitialization();
            for (SubstituteLogger substituteLogger : SUBST_PROVIDER.getSubstituteLoggerFactory().getLoggers()) {
                Logger logger = LoggerFactory.getLogger(substituteLogger.getName());
                substituteLogger.setDelegate(logger);
            }
            return;
        }
    }

    static void failedBinding(Throwable throwable) {
        INITIALIZATION_STATE = 2;
        Reporter.error("Failed to instantiate SLF4J LoggerFactory", throwable);
    }

    private static void replayEvents() {
        int n;
        LinkedBlockingQueue<SubstituteLoggingEvent> linkedBlockingQueue = SUBST_PROVIDER.getSubstituteLoggerFactory().getEventQueue();
        int n2 = linkedBlockingQueue.size();
        int n3 = 0;
        ArrayList arrayList = new ArrayList(128);
        while ((n = linkedBlockingQueue.drainTo(arrayList, 128)) != 0) {
            for (SubstituteLoggingEvent substituteLoggingEvent : arrayList) {
                LoggerFactory.replaySingleEvent(substituteLoggingEvent);
                if (n3++ != 0) continue;
                LoggerFactory.emitReplayOrSubstituionWarning(substituteLoggingEvent, n2);
            }
            arrayList.clear();
        }
    }

    private static void emitReplayOrSubstituionWarning(SubstituteLoggingEvent substituteLoggingEvent, int n) {
        if (substituteLoggingEvent.getLogger().isDelegateEventAware()) {
            LoggerFactory.emitReplayWarning(n);
            return;
        }
        if (!substituteLoggingEvent.getLogger().isDelegateNOP()) {
            LoggerFactory.emitSubstitutionWarning();
        }
    }

    private static void replaySingleEvent(SubstituteLoggingEvent substituteLoggingEvent) {
        if (substituteLoggingEvent == null) {
            return;
        }
        SubstituteLogger substituteLogger = substituteLoggingEvent.getLogger();
        String string = substituteLogger.getName();
        if (substituteLogger.isDelegateNull()) {
            throw new IllegalStateException("Delegate logger cannot be null at this state.");
        }
        if (!substituteLogger.isDelegateNOP()) {
            if (substituteLogger.isDelegateEventAware()) {
                if (substituteLogger.isEnabledForLevel(substituteLoggingEvent.getLevel())) {
                    substituteLogger.log(substituteLoggingEvent);
                    return;
                }
            } else {
                Reporter.warn(string);
            }
        }
    }

    private static void emitSubstitutionWarning() {
        Reporter.warn("The following set of substitute loggers may have been accessed");
        Reporter.warn("during the initialization phase. Logging calls during this");
        Reporter.warn("phase were not honored. However, subsequent logging calls to these");
        Reporter.warn("loggers will work as normally expected.");
        Reporter.warn("See also https://www.slf4j.org/codes.html#substituteLogger");
    }

    private static void emitReplayWarning(int n) {
        Reporter.warn("A number (" + n + ") of logging calls during the initialization phase have been intercepted and are");
        Reporter.warn("now being replayed. These are subject to the filtering rules of the underlying logging system.");
        Reporter.warn("See also https://www.slf4j.org/codes.html#replay");
    }

    private static final void versionSanityCheck() {
        try {
            String string = PROVIDER.getRequestedApiVersion();
            boolean bl = false;
            String[] stringArray = API_COMPATIBILITY_LIST;
            int n = API_COMPATIBILITY_LIST.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!string.startsWith(string2)) continue;
                bl = true;
            }
            if (!bl) {
                Reporter.warn("The requested version " + string + " by your slf4j provider is not compatible with " + Arrays.asList(API_COMPATIBILITY_LIST).toString());
                Reporter.warn("See https://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
            return;
        }
        catch (Throwable throwable) {
            Reporter.error("Unexpected problem occurred during version sanity check", throwable);
            return;
        }
    }

    private static boolean isAmbiguousProviderList(List<SLF4JServiceProvider> list) {
        return list.size() > 1;
    }

    private static void reportMultipleBindingAmbiguity(List<SLF4JServiceProvider> object) {
        if (LoggerFactory.isAmbiguousProviderList(object)) {
            Reporter.warn("Class path contains multiple SLF4J providers.");
            object = object.iterator();
            while (object.hasNext()) {
                SLF4JServiceProvider sLF4JServiceProvider = (SLF4JServiceProvider)object.next();
                Reporter.warn("Found provider [" + sLF4JServiceProvider + "]");
            }
            Reporter.warn("See https://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
        }
    }

    private static void reportActualBinding(List<SLF4JServiceProvider> object) {
        if (object.isEmpty()) {
            throw new IllegalStateException("No providers were found which is impossible after successful initialization.");
        }
        if (LoggerFactory.isAmbiguousProviderList(object)) {
            Reporter.info("Actual provider is of type [" + object.get(0) + "]");
            return;
        }
        object = object.get(0);
        Reporter.debug(CONNECTED_WITH_MSG + object.getClass().getName() + "]");
    }

    public static Logger getLogger(String string) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(string);
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        Logger logger = LoggerFactory.getLogger(clazz.getName());
        if (DETECT_LOGGER_NAME_MISMATCH && (clazz2 = Util.getCallingClass()) != null && LoggerFactory.nonMatchingClasses(clazz, clazz2)) {
            Reporter.warn(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", logger.getName(), clazz2.getName()));
            Reporter.warn("See https://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return logger;
    }

    private static boolean nonMatchingClasses(Class<?> clazz, Class<?> clazz2) {
        return !clazz2.isAssignableFrom(clazz);
    }

    public static ILoggerFactory getILoggerFactory() {
        return LoggerFactory.getProvider().getLoggerFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static SLF4JServiceProvider getProvider() {
        if (INITIALIZATION_STATE == 0) {
            Class<LoggerFactory> clazz = LoggerFactory.class;
            // MONITORENTER : org.slf4j.LoggerFactory.class
            if (INITIALIZATION_STATE == 0) {
                INITIALIZATION_STATE = 1;
                LoggerFactory.performInitialization();
            }
            // MONITOREXIT : clazz
        }
        switch (INITIALIZATION_STATE) {
            case 3: {
                return PROVIDER;
            }
            case 4: {
                return NOP_FALLBACK_SERVICE_PROVIDER;
            }
            case 2: {
                throw new IllegalStateException(UNSUCCESSFUL_INIT_MSG);
            }
            case 1: {
                return SUBST_PROVIDER;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    private static /* synthetic */ ServiceLoader lambda$getServiceLoader$0(ClassLoader classLoader) {
        return ServiceLoader.load(SLF4JServiceProvider.class, classLoader);
    }

    static {
        API_COMPATIBILITY_LIST = new String[]{"2.0"};
    }
}

