/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.WrappedByteBuf;
import io.netty.buffer.WrappedCompositeByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.RecyclableArrayList;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CompositeByteBuf
extends AbstractReferenceCountedByteBuf
implements Iterable<ByteBuf> {
    private static final ByteBuffer EMPTY_NIO_BUFFER = Unpooled.EMPTY_BUFFER.nioBuffer();
    private static final Iterator<ByteBuf> EMPTY_ITERATOR = Collections.emptyList().iterator();
    private final ByteBufAllocator alloc;
    private final boolean direct;
    private final int maxNumComponents;
    private int componentCount;
    private Component[] components;
    private boolean freed;
    static final ByteWrapper<byte[]> BYTE_ARRAY_WRAPPER = new ByteWrapper<byte[]>(){

        @Override
        public final ByteBuf wrap(byte[] byArray) {
            return Unpooled.wrappedBuffer(byArray);
        }

        @Override
        public final boolean isEmpty(byte[] byArray) {
            return byArray.length == 0;
        }
    };
    static final ByteWrapper<ByteBuffer> BYTE_BUFFER_WRAPPER = new ByteWrapper<ByteBuffer>(){

        @Override
        public final ByteBuf wrap(ByteBuffer byteBuffer) {
            return Unpooled.wrappedBuffer(byteBuffer);
        }

        @Override
        public final boolean isEmpty(ByteBuffer byteBuffer) {
            return !byteBuffer.hasRemaining();
        }
    };
    private Component lastAccessed;

    private CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, int n2) {
        super(Integer.MAX_VALUE);
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)byteBufAllocator, (String)"alloc");
        if (n <= 0) {
            throw new IllegalArgumentException("maxNumComponents: " + n + " (expected: >= 1)");
        }
        this.direct = bl;
        this.maxNumComponents = n;
        this.components = CompositeByteBuf.newCompArray(n2, n);
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n) {
        this(byteBufAllocator, bl, n, 0);
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, ByteBuf ... byteBufArray) {
        this(byteBufAllocator, bl, n, byteBufArray, 0);
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, ByteBuf[] byteBufArray, int n2) {
        this(byteBufAllocator, bl, n, byteBufArray.length - n2);
        this.addComponents0(false, 0, byteBufArray, n2);
        this.consolidateIfNeeded();
        this.setIndex0(0, ((ByteBuf)this).capacity());
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, Iterable<ByteBuf> iterable) {
        this(byteBufAllocator, bl, n, iterable instanceof Collection ? ((Collection)iterable).size() : 0);
        this.addComponents(false, 0, iterable);
        this.setIndex(0, ((ByteBuf)this).capacity());
    }

    <T> CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, ByteWrapper<T> byteWrapper, T[] TArray, int n2) {
        this(byteBufAllocator, bl, n, TArray.length - n2);
        this.addComponents0(false, 0, byteWrapper, TArray, n2);
        this.consolidateIfNeeded();
        this.setIndex(0, ((ByteBuf)this).capacity());
    }

    private static Component[] newCompArray(int n, int n2) {
        n2 = Math.min(16, n2);
        return new Component[Math.max(n, n2)];
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator) {
        super(Integer.MAX_VALUE);
        this.alloc = byteBufAllocator;
        this.direct = false;
        this.maxNumComponents = 0;
        this.components = null;
    }

    public CompositeByteBuf addComponent(ByteBuf byteBuf) {
        return this.addComponent(false, byteBuf);
    }

    public CompositeByteBuf addComponents(ByteBuf ... byteBufArray) {
        return this.addComponents(false, byteBufArray);
    }

    public CompositeByteBuf addComponents(Iterable<ByteBuf> iterable) {
        return this.addComponents(false, iterable);
    }

    public CompositeByteBuf addComponent(int n, ByteBuf byteBuf) {
        return this.addComponent(false, n, byteBuf);
    }

    public CompositeByteBuf addComponent(boolean bl, ByteBuf byteBuf) {
        return this.addComponent(bl, this.componentCount, byteBuf);
    }

    public CompositeByteBuf addComponents(boolean bl, ByteBuf ... byteBufArray) {
        ObjectUtil.checkNotNull((Object)byteBufArray, (String)"buffers");
        this.addComponents0(bl, this.componentCount, byteBufArray, 0);
        this.consolidateIfNeeded();
        return this;
    }

    public CompositeByteBuf addComponents(boolean bl, Iterable<ByteBuf> iterable) {
        return this.addComponents(bl, this.componentCount, iterable);
    }

    public CompositeByteBuf addComponent(boolean bl, int n, ByteBuf byteBuf) {
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"buffer");
        this.addComponent0(bl, n, byteBuf);
        this.consolidateIfNeeded();
        return this;
    }

    private static void checkForOverflow(int n, int n2) {
        if (n + n2 < 0) {
            throw new IllegalArgumentException("Can't increase by " + n2 + " as capacity(" + n + ") would overflow 2147483647");
        }
    }

    private int addComponent0(boolean bl, int n, ByteBuf byteBuf) {
        assert (byteBuf != null);
        boolean bl2 = false;
        try {
            this.checkComponentIndex(n);
            Component component = this.newComponent(CompositeByteBuf.ensureAccessible(byteBuf), 0);
            int n2 = component.length();
            CompositeByteBuf.checkForOverflow(((ByteBuf)this).capacity(), n2);
            this.addComp(n, component);
            bl2 = true;
            if (n2 > 0 && n < this.componentCount - 1) {
                this.updateComponentOffsets(n);
            } else if (n > 0) {
                component.reposition(this.components[n - 1].endOffset);
            }
            if (bl) {
                this.writerIndex += n2;
            }
            return n;
        }
        catch (Throwable throwable) {
            if (!bl2) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    private static ByteBuf ensureAccessible(ByteBuf byteBuf) {
        if (checkAccessible && !byteBuf.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
        return byteBuf;
    }

    private Component newComponent(ByteBuf byteBuf, int n) {
        int n2;
        ByteBuf byteBuf2;
        int n3;
        int n4;
        block6: {
            block4: {
                block5: {
                    block3: {
                        n4 = byteBuf.readerIndex();
                        n3 = byteBuf.readableBytes();
                        byteBuf2 = byteBuf;
                        n2 = n4;
                        while (byteBuf2 instanceof WrappedByteBuf || byteBuf2 instanceof SwappedByteBuf) {
                            byteBuf2 = byteBuf2.unwrap();
                        }
                        if (!(byteBuf2 instanceof AbstractUnpooledSlicedByteBuf)) break block3;
                        n2 = n4 + ((AbstractUnpooledSlicedByteBuf)byteBuf2).idx(0);
                        break block4;
                    }
                    if (!(byteBuf2 instanceof PooledSlicedByteBuf)) break block5;
                    n2 = n4 + ((PooledSlicedByteBuf)byteBuf2).adjustment;
                    break block4;
                }
                if (!(byteBuf2 instanceof DuplicatedByteBuf) && !(byteBuf2 instanceof PooledDuplicatedByteBuf)) break block6;
            }
            byteBuf2 = byteBuf2.unwrap();
        }
        ByteBuf byteBuf3 = byteBuf.capacity() == n3 ? byteBuf : null;
        return new Component(byteBuf.order(ByteOrder.BIG_ENDIAN), n4, byteBuf2.order(ByteOrder.BIG_ENDIAN), n2, n, n3, byteBuf3);
    }

    public CompositeByteBuf addComponents(int n, ByteBuf ... byteBufArray) {
        ObjectUtil.checkNotNull((Object)byteBufArray, (String)"buffers");
        this.addComponents0(false, n, byteBufArray, 0);
        this.consolidateIfNeeded();
        return this;
    }

    private CompositeByteBuf addComponents0(boolean bl, int n, ByteBuf[] byteBufArray, int n2) {
        ByteBuf byteBuf;
        int n3;
        int n4 = byteBufArray.length;
        int n5 = n4 - n2;
        int n6 = 0;
        int n7 = ((ByteBuf)this).capacity();
        for (n3 = n2; n3 < byteBufArray.length && (byteBuf = byteBufArray[n3]) != null; ++n3) {
            CompositeByteBuf.checkForOverflow(n7, n6 += byteBuf.readableBytes());
        }
        n3 = Integer.MAX_VALUE;
        try {
            Object object;
            this.checkComponentIndex(n);
            this.shiftComps(n, n5);
            int n8 = n > 0 ? this.components[n - 1].endOffset : 0;
            n3 = n;
            while (n2 < n4 && (object = byteBufArray[n2]) != null) {
                this.components[n3] = object = this.newComponent(CompositeByteBuf.ensureAccessible((ByteBuf)object), n8);
                n8 = ((Component)object).endOffset;
                ++n2;
                ++n3;
            }
            CompositeByteBuf compositeByteBuf = this;
            return compositeByteBuf;
        }
        finally {
            if (n3 < this.componentCount) {
                if (n3 < n + n5) {
                    this.removeCompRange(n3, n + n5);
                    while (n2 < n4) {
                        ReferenceCountUtil.safeRelease((Object)byteBufArray[n2]);
                        ++n2;
                    }
                }
                this.updateComponentOffsets(n3);
            }
            if (bl && n3 > n && n3 <= this.componentCount) {
                this.writerIndex += this.components[n3 - 1].endOffset - this.components[n].offset;
            }
        }
    }

    private <T> int addComponents0(boolean bl, int n, ByteWrapper<T> byteWrapper, T[] TArray, int n2) {
        T t;
        this.checkComponentIndex(n);
        int n3 = TArray.length;
        while (n2 < n3 && (t = TArray[n2]) != null) {
            int n4;
            if (!byteWrapper.isEmpty(t) && (n = this.addComponent0(bl, n, byteWrapper.wrap(t)) + 1) > (n4 = this.componentCount)) {
                n = n4;
            }
            ++n2;
        }
        return n;
    }

    public CompositeByteBuf addComponents(int n, Iterable<ByteBuf> iterable) {
        return this.addComponents(false, n, iterable);
    }

    public CompositeByteBuf addFlattenedComponents(boolean n, ByteBuf byteBuf) {
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"buffer");
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.writerIndex();
        if (n2 == n3) {
            byteBuf.release();
            return this;
        }
        if (!(byteBuf instanceof CompositeByteBuf)) {
            this.addComponent0(n != 0, this.componentCount, byteBuf);
            this.consolidateIfNeeded();
            return this;
        }
        CompositeByteBuf compositeByteBuf = byteBuf instanceof WrappedCompositeByteBuf ? (CompositeByteBuf)byteBuf.unwrap() : (CompositeByteBuf)byteBuf;
        compositeByteBuf.checkIndex(n2, n3 - n2);
        Component[] componentArray = compositeByteBuf.components;
        int n4 = this.componentCount;
        int n5 = this.writerIndex;
        try {
            int n6 = compositeByteBuf.toComponentIndex0(n2);
            int n7 = ((ByteBuf)this).capacity();
            while (true) {
                Component component = componentArray[n6];
                int n8 = component.offset;
                n8 = Math.max(n2, n8);
                int n9 = Math.min(n3, component.endOffset);
                int n10 = n9 - n8;
                if (n10 > 0) {
                    CompositeByteBuf compositeByteBuf2 = this;
                    compositeByteBuf2.addComp(compositeByteBuf2.componentCount, new Component(component.srcBuf.retain(), component.srcIdx(n8), component.buf, component.idx(n8), n7, n10, null));
                }
                if (n3 == n9) break;
                n7 += n10;
                ++n6;
            }
            if (n != 0) {
                this.writerIndex = n5 + (n3 - n2);
            }
            this.consolidateIfNeeded();
            byteBuf.release();
            byteBuf = null;
            CompositeByteBuf compositeByteBuf3 = this;
            return compositeByteBuf3;
        }
        catch (Throwable throwable) {
            if (byteBuf != null) {
                if (n != 0) {
                    this.writerIndex = n5;
                }
                for (n = this.componentCount - 1; n >= n4; --n) {
                    this.components[n].free();
                    this.removeComp(n);
                }
            }
            throw throwable;
        }
    }

    private CompositeByteBuf addComponents(boolean bl, int n, Iterable<ByteBuf> object) {
        if (object instanceof ByteBuf) {
            return this.addComponent(bl, n, (ByteBuf)object);
        }
        ObjectUtil.checkNotNull(object, (String)"buffers");
        object = object.iterator();
        try {
            ByteBuf byteBuf;
            this.checkComponentIndex(n);
            while (object.hasNext() && (byteBuf = (ByteBuf)object.next()) != null) {
                n = this.addComponent0(bl, n, byteBuf) + 1;
                n = Math.min(n, this.componentCount);
            }
        }
        finally {
            while (object.hasNext()) {
                ReferenceCountUtil.safeRelease(object.next());
            }
        }
        this.consolidateIfNeeded();
        return this;
    }

    private void consolidateIfNeeded() {
        int n = this.componentCount;
        if (n > this.maxNumComponents) {
            this.consolidate0(0, n);
        }
    }

    private void checkComponentIndex(int n) {
        this.ensureAccessible();
        if (n < 0 || n > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d (expected: >= 0 && <= numComponents(%d))", n, this.componentCount));
        }
    }

    private void checkComponentIndex(int n, int n2) {
        this.ensureAccessible();
        if (n < 0 || n + n2 > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d, numComponents: %d (expected: cIndex >= 0 && cIndex + numComponents <= totalNumComponents(%d))", n, n2, this.componentCount));
        }
    }

    private void updateComponentOffsets(int n) {
        int n2;
        int n3 = this.componentCount;
        if (n3 <= n) {
            return;
        }
        int n4 = n2 = n > 0 ? this.components[n - 1].endOffset : 0;
        while (n < n3) {
            Component component = this.components[n];
            component.reposition(n2);
            n2 = component.endOffset;
            ++n;
        }
    }

    public CompositeByteBuf removeComponent(int n) {
        this.checkComponentIndex(n);
        Component component = this.components[n];
        if (this.lastAccessed == component) {
            this.lastAccessed = null;
        }
        component.free();
        this.removeComp(n);
        if (component.length() > 0) {
            this.updateComponentOffsets(n);
        }
        return this;
    }

    public CompositeByteBuf removeComponents(int n, int n2) {
        this.checkComponentIndex(n, n2);
        if (n2 == 0) {
            return this;
        }
        n2 = n + n2;
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            Component component = this.components[i];
            if (component.length() > 0) {
                bl = true;
            }
            if (this.lastAccessed == component) {
                this.lastAccessed = null;
            }
            component.free();
        }
        this.removeCompRange(n, n2);
        if (bl) {
            this.updateComponentOffsets(n);
        }
        return this;
    }

    @Override
    public Iterator<ByteBuf> iterator() {
        this.ensureAccessible();
        if (this.componentCount == 0) {
            return EMPTY_ITERATOR;
        }
        return new CompositeByteBufIterator();
    }

    @Override
    protected int forEachByteAsc0(int n, int n2, ByteProcessor byteProcessor) {
        if (n2 <= n) {
            return -1;
        }
        int n3 = this.toComponentIndex0(n);
        n2 -= n;
        while (n2 > 0) {
            Component component = this.components[n3];
            if (component.offset != component.endOffset) {
                int n4;
                int n5;
                ByteBuf byteBuf = component.buf;
                int n6 = component.idx(n);
                int n7 = Math.min(n2, component.endOffset - n);
                if (byteBuf instanceof AbstractByteBuf) {
                    int n8 = n6;
                    n5 = ((AbstractByteBuf)byteBuf).forEachByteAsc0(n8, n8 + n7, byteProcessor);
                } else {
                    n5 = n4 = byteBuf.forEachByte(n6, n7, byteProcessor);
                }
                if (n5 != -1) {
                    return n4 - component.adjustment;
                }
                n += n7;
                n2 -= n7;
            }
            ++n3;
        }
        return -1;
    }

    @Override
    protected int forEachByteDesc0(int n, int n2, ByteProcessor byteProcessor) {
        if (n2 > n) {
            return -1;
        }
        int n3 = this.toComponentIndex0(n);
        n = n + 1 - n2;
        while (n > 0) {
            Component component = this.components[n3];
            if (component.offset != component.endOffset) {
                ByteBuf byteBuf = component.buf;
                int n4 = component.idx(n + n2);
                int n5 = Math.min(n, n4);
                int n6 = n4 - n5;
                int n7 = byteBuf instanceof AbstractByteBuf ? ((AbstractByteBuf)byteBuf).forEachByteDesc0(n4 - 1, n6, byteProcessor) : byteBuf.forEachByteDesc(n6, n5, byteProcessor);
                if (n7 != -1) {
                    return n7 - component.adjustment;
                }
                n -= n5;
            }
            --n3;
        }
        return -1;
    }

    public List<ByteBuf> decompose(int n, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return Collections.emptyList();
        }
        int n3 = this.toComponentIndex0(n);
        Object object = this.components[n3];
        if ((n = n2 - ((ByteBuf)(object = ((Component)object).srcBuf.slice(((Component)object).srcIdx(n), Math.min(((Component)object).endOffset - n, n2)))).readableBytes()) == 0) {
            return Collections.singletonList(object);
        }
        ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>(this.componentCount - n3);
        arrayList.add((ByteBuf)object);
        do {
            Object object2 = object = this.components[++n3];
            object = ((Component)object).srcBuf.slice(((Component)object2).srcIdx(((Component)object2).offset), Math.min(((Component)object).length(), n));
            arrayList.add((ByteBuf)object);
        } while ((n -= ((ByteBuf)object).readableBytes()) > 0);
        return arrayList;
    }

    @Override
    public boolean isDirect() {
        int n = this.componentCount;
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.components[i].buf.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasArray() {
        switch (this.componentCount) {
            case 0: {
                return true;
            }
            case 1: {
                return this.components[0].buf.hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.componentCount) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.components[0].buf.array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        switch (this.componentCount) {
            case 0: {
                return 0;
            }
            case 1: {
                Component component = this.components[0];
                return component.idx(component.buf.arrayOffset());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.components[0].buf.hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public long memoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                Component component = this.components[0];
                return component.buf.memoryAddress() + (long)component.adjustment;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        int n = this.componentCount;
        if (n > 0) {
            return this.components[n - 1].endOffset;
        }
        return 0;
    }

    @Override
    public CompositeByteBuf capacity(int n) {
        this.checkNewCapacity(n);
        int n2 = this.componentCount;
        int n3 = ((ByteBuf)this).capacity();
        if (n > n3) {
            int n4 = n - n3;
            ByteBuf byteBuf = this.allocBuffer(n4).setIndex(0, n4);
            this.addComponent0(false, n2, byteBuf);
            if (this.componentCount >= this.maxNumComponents) {
                this.consolidateIfNeeded();
            }
        } else if (n < n3) {
            int n5;
            this.lastAccessed = null;
            n3 -= n;
            for (n5 = n2 - 1; n5 >= 0; --n5) {
                Component component = this.components[n5];
                int n6 = component.length();
                if (n3 < n6) {
                    component.endOffset -= n3;
                    ByteBuf byteBuf = component.slice;
                    if (byteBuf == null) break;
                    component.slice = byteBuf.slice(0, component.length());
                    break;
                }
                component.free();
                n3 -= n6;
            }
            this.removeCompRange(n5 + 1, n2);
            if (((ByteBuf)this).readerIndex() > n) {
                int n7 = n;
                this.setIndex0(n7, n7);
            } else if (this.writerIndex > n) {
                this.writerIndex = n;
            }
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public int numComponents() {
        return this.componentCount;
    }

    public int maxNumComponents() {
        return this.maxNumComponents;
    }

    public int toComponentIndex(int n) {
        this.checkIndex(n);
        return this.toComponentIndex0(n);
    }

    private int toComponentIndex0(int n) {
        int n2;
        int n3 = this.componentCount;
        if (n == 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.components[n2].endOffset <= 0) continue;
                return n2;
            }
        }
        if (n3 <= 2) {
            if (n3 == 1 || n < this.components[0].endOffset) {
                return 0;
            }
            return 1;
        }
        n2 = 0;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            Component component = this.components[n4];
            if (n >= component.endOffset) {
                n2 = n4 + 1;
                continue;
            }
            if (n < component.offset) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        throw new Error("should not reach here");
    }

    public int toByteIndex(int n) {
        this.checkComponentIndex(n);
        return this.components[n].offset;
    }

    @Override
    public byte getByte(int n) {
        Component component = this.findComponent(n);
        return component.buf.getByte(component.idx(n));
    }

    @Override
    protected byte _getByte(int n) {
        Component component = this.findComponent0(n);
        return component.buf.getByte(component.idx(n));
    }

    @Override
    protected short _getShort(int n) {
        Component component = this.findComponent0(n);
        if (n + 2 <= component.endOffset) {
            return component.buf.getShort(component.idx(n));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n) & 0xFF) << 8 | this._getByte(n + 1) & 0xFF);
        }
        return (short)(this._getByte(n) & 0xFF | (this._getByte(n + 1) & 0xFF) << 8);
    }

    @Override
    protected short _getShortLE(int n) {
        Component component = this.findComponent0(n);
        if (n + 2 <= component.endOffset) {
            return component.buf.getShortLE(component.idx(n));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(n) & 0xFF | (this._getByte(n + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(n) & 0xFF) << 8 | this._getByte(n + 1) & 0xFF);
    }

    @Override
    protected int _getUnsignedMedium(int n) {
        Component component = this.findComponent0(n);
        if (n + 3 <= component.endOffset) {
            return component.buf.getUnsignedMedium(component.idx(n));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n) & 0xFFFF) << 8 | this._getByte(n + 2) & 0xFF;
        }
        return this._getShort(n) & 0xFFFF | (this._getByte(n + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getUnsignedMediumLE(int n) {
        Component component = this.findComponent0(n);
        if (n + 3 <= component.endOffset) {
            return component.buf.getUnsignedMediumLE(component.idx(n));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n) & 0xFFFF | (this._getByte(n + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(n) & 0xFFFF) << 8 | this._getByte(n + 2) & 0xFF;
    }

    @Override
    protected int _getInt(int n) {
        Component component = this.findComponent0(n);
        if (n + 4 <= component.endOffset) {
            return component.buf.getInt(component.idx(n));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n) & 0xFFFF) << 16 | this._getShort(n + 2) & 0xFFFF;
        }
        return this._getShort(n) & 0xFFFF | (this._getShort(n + 2) & 0xFFFF) << 16;
    }

    @Override
    protected int _getIntLE(int n) {
        Component component = this.findComponent0(n);
        if (n + 4 <= component.endOffset) {
            return component.buf.getIntLE(component.idx(n));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n) & 0xFFFF | (this._getShortLE(n + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(n) & 0xFFFF) << 16 | this._getShortLE(n + 2) & 0xFFFF;
    }

    @Override
    protected long _getLong(int n) {
        Component component = this.findComponent0(n);
        if (n + 8 <= component.endOffset) {
            return component.buf.getLong(component.idx(n));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n) & 0xFFFFFFFFL | ((long)this._getInt(n + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    protected long _getLongLE(int n) {
        Component component = this.findComponent0(n);
        if (n + 8 <= component.endOffset) {
            return component.buf.getLongLE(component.idx(n));
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(n) & 0xFFFFFFFFL | ((long)this._getIntLE(n + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(n) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE(n + 4) & 0xFFFFFFFFL;
    }

    @Override
    public CompositeByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byArray.length);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        while (n3 > 0) {
            Component component = this.components[n4];
            int n5 = Math.min(n3, component.endOffset - n);
            component.buf.getBytes(component.idx(n), byArray, n2, n5);
            n += n5;
            n2 += n5;
            n3 -= n5;
            ++n4;
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.remaining();
        this.checkIndex(n, n3);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        try {
            while (n3 > 0) {
                Component component = this.components[n4];
                int n5 = Math.min(n3, component.endOffset - n);
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.limit(byteBuffer2.position() + n5);
                component.buf.getBytes(component.idx(n), byteBuffer);
                n += n5;
                n3 -= n5;
                ++n4;
            }
        }
        finally {
            byteBuffer.limit(n2);
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byteBuf.capacity());
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        while (n3 > 0) {
            Component component = this.components[n4];
            int n5 = Math.min(n3, component.endOffset - n);
            component.buf.getBytes(component.idx(n), byteBuf, n2, n5);
            n += n5;
            n2 += n5;
            n3 -= n5;
            ++n4;
        }
        return this;
    }

    @Override
    public int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        int n3 = ((ByteBuf)this).nioBufferCount();
        if (n3 == 1) {
            return gatheringByteChannel.write(((ByteBuf)this).internalNioBuffer(n, n2));
        }
        long l = gatheringByteChannel.write(((ByteBuf)this).nioBuffers(n, n2));
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        int n3 = ((ByteBuf)this).nioBufferCount();
        if (n3 == 1) {
            return fileChannel.write(((ByteBuf)this).internalNioBuffer(n, n2), l);
        }
        long l2 = 0L;
        for (ByteBuffer byteBuffer : ((ByteBuf)this).nioBuffers(n, n2)) {
            l2 += (long)fileChannel.write(byteBuffer, l + l2);
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public CompositeByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return this;
        }
        int n3 = this.toComponentIndex0(n);
        while (n2 > 0) {
            Component component = this.components[n3];
            int n4 = Math.min(n2, component.endOffset - n);
            component.buf.getBytes(component.idx(n), outputStream, n4);
            n += n4;
            n2 -= n4;
            ++n3;
        }
        return this;
    }

    @Override
    public CompositeByteBuf setByte(int n, int n2) {
        Component component = this.findComponent(n);
        component.buf.setByte(component.idx(n), n2);
        return this;
    }

    @Override
    protected void _setByte(int n, int n2) {
        Component component = this.findComponent0(n);
        component.buf.setByte(component.idx(n), n2);
    }

    @Override
    public CompositeByteBuf setShort(int n, int n2) {
        this.checkIndex(n, 2);
        this._setShort(n, n2);
        return this;
    }

    @Override
    protected void _setShort(int n, int n2) {
        Component component = this.findComponent0(n);
        if (n + 2 <= component.endOffset) {
            component.buf.setShort(component.idx(n), n2);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(n, (byte)(n2 >>> 8));
            this._setByte(n + 1, (byte)n2);
            return;
        }
        this._setByte(n, (byte)n2);
        this._setByte(n + 1, (byte)(n2 >>> 8));
    }

    @Override
    protected void _setShortLE(int n, int n2) {
        Component component = this.findComponent0(n);
        if (n + 2 <= component.endOffset) {
            component.buf.setShortLE(component.idx(n), n2);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(n, (byte)n2);
            this._setByte(n + 1, (byte)(n2 >>> 8));
            return;
        }
        this._setByte(n, (byte)(n2 >>> 8));
        this._setByte(n + 1, (byte)n2);
    }

    @Override
    public CompositeByteBuf setMedium(int n, int n2) {
        this.checkIndex(n, 3);
        this._setMedium(n, n2);
        return this;
    }

    @Override
    protected void _setMedium(int n, int n2) {
        Component component = this.findComponent0(n);
        if (n + 3 <= component.endOffset) {
            component.buf.setMedium(component.idx(n), n2);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n, (short)(n2 >> 8));
            this._setByte(n + 2, (byte)n2);
            return;
        }
        this._setShort(n, (short)n2);
        this._setByte(n + 2, (byte)(n2 >>> 16));
    }

    @Override
    protected void _setMediumLE(int n, int n2) {
        Component component = this.findComponent0(n);
        if (n + 3 <= component.endOffset) {
            component.buf.setMediumLE(component.idx(n), n2);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(n, (short)n2);
            this._setByte(n + 2, (byte)(n2 >>> 16));
            return;
        }
        this._setShortLE(n, (short)(n2 >> 8));
        this._setByte(n + 2, (byte)n2);
    }

    @Override
    public CompositeByteBuf setInt(int n, int n2) {
        this.checkIndex(n, 4);
        this._setInt(n, n2);
        return this;
    }

    @Override
    protected void _setInt(int n, int n2) {
        Component component = this.findComponent0(n);
        if (n + 4 <= component.endOffset) {
            component.buf.setInt(component.idx(n), n2);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n, (short)(n2 >>> 16));
            this._setShort(n + 2, (short)n2);
            return;
        }
        this._setShort(n, (short)n2);
        this._setShort(n + 2, (short)(n2 >>> 16));
    }

    @Override
    protected void _setIntLE(int n, int n2) {
        Component component = this.findComponent0(n);
        if (n + 4 <= component.endOffset) {
            component.buf.setIntLE(component.idx(n), n2);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(n, (short)n2);
            this._setShortLE(n + 2, (short)(n2 >>> 16));
            return;
        }
        this._setShortLE(n, (short)(n2 >>> 16));
        this._setShortLE(n + 2, (short)n2);
    }

    @Override
    public CompositeByteBuf setLong(int n, long l) {
        this.checkIndex(n, 8);
        this._setLong(n, l);
        return this;
    }

    @Override
    protected void _setLong(int n, long l) {
        Component component = this.findComponent0(n);
        if (n + 8 <= component.endOffset) {
            component.buf.setLong(component.idx(n), l);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setInt(n, (int)(l >>> 32));
            this._setInt(n + 4, (int)l);
            return;
        }
        this._setInt(n, (int)l);
        this._setInt(n + 4, (int)(l >>> 32));
    }

    @Override
    protected void _setLongLE(int n, long l) {
        Component component = this.findComponent0(n);
        if (n + 8 <= component.endOffset) {
            component.buf.setLongLE(component.idx(n), l);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setIntLE(n, (int)l);
            this._setIntLE(n + 4, (int)(l >>> 32));
            return;
        }
        this._setIntLE(n, (int)(l >>> 32));
        this._setIntLE(n + 4, (int)l);
    }

    @Override
    public CompositeByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkSrcIndex(n, n3, n2, byArray.length);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        while (n3 > 0) {
            Component component = this.components[n4];
            int n5 = Math.min(n3, component.endOffset - n);
            component.buf.setBytes(component.idx(n), byArray, n2, n5);
            n += n5;
            n2 += n5;
            n3 -= n5;
            ++n4;
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.remaining();
        this.checkIndex(n, n3);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        try {
            while (n3 > 0) {
                Component component = this.components[n4];
                int n5 = Math.min(n3, component.endOffset - n);
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.limit(byteBuffer2.position() + n5);
                component.buf.setBytes(component.idx(n), byteBuffer);
                n += n5;
                n3 -= n5;
                ++n4;
            }
        }
        finally {
            byteBuffer.limit(n2);
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkSrcIndex(n, n3, n2, byteBuf.capacity());
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        while (n3 > 0) {
            Component component = this.components[n4];
            int n5 = Math.min(n3, component.endOffset - n);
            component.buf.setBytes(component.idx(n), byteBuf, n2, n5);
            n += n5;
            n2 += n5;
            n3 -= n5;
            ++n4;
        }
        return this;
    }

    @Override
    public int setBytes(int n, InputStream inputStream, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return inputStream.read(EmptyArrays.EMPTY_BYTES);
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = 0;
        do {
            Component component = this.components[n3];
            int n5 = Math.min(n2, component.endOffset - n);
            if (n5 == 0) {
                ++n3;
                continue;
            }
            int n6 = component.buf.setBytes(component.idx(n), inputStream, n5);
            if (n6 < 0) {
                if (n4 != 0) break;
                return -1;
            }
            n += n6;
            n2 -= n6;
            n4 += n6;
            if (n6 != n5) continue;
            ++n3;
        } while (n2 > 0);
        return n4;
    }

    @Override
    public int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return scatteringByteChannel.read(EMPTY_NIO_BUFFER);
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = 0;
        do {
            Component component = this.components[n3];
            int n5 = Math.min(n2, component.endOffset - n);
            if (n5 == 0) {
                ++n3;
                continue;
            }
            int n6 = component.buf.setBytes(component.idx(n), scatteringByteChannel, n5);
            if (n6 == 0) break;
            if (n6 < 0) {
                if (n4 != 0) break;
                return -1;
            }
            n += n6;
            n2 -= n6;
            n4 += n6;
            if (n6 != n5) continue;
            ++n3;
        } while (n2 > 0);
        return n4;
    }

    @Override
    public int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return fileChannel.read(EMPTY_NIO_BUFFER, l);
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = 0;
        do {
            Component component = this.components[n3];
            int n5 = Math.min(n2, component.endOffset - n);
            if (n5 == 0) {
                ++n3;
                continue;
            }
            int n6 = component.buf.setBytes(component.idx(n), fileChannel, l + (long)n4, n5);
            if (n6 == 0) break;
            if (n6 < 0) {
                if (n4 != 0) break;
                return -1;
            }
            n += n6;
            n2 -= n6;
            n4 += n6;
            if (n6 != n5) continue;
            ++n3;
        } while (n2 > 0);
        return n4;
    }

    @Override
    public ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        ByteBuf byteBuf = this.allocBuffer(n2);
        if (n2 != 0) {
            this.copyTo(n, n2, this.toComponentIndex0(n), byteBuf);
        }
        return byteBuf;
    }

    private void copyTo(int n, int n2, int n3, ByteBuf byteBuf) {
        int n4 = 0;
        while (n2 > 0) {
            Component component = this.components[n3];
            int n5 = Math.min(n2, component.endOffset - n);
            component.buf.getBytes(component.idx(n), byteBuf, n4, n5);
            n += n5;
            n4 += n5;
            n2 -= n5;
            ++n3;
        }
        ByteBuf byteBuf2 = byteBuf;
        byteBuf2.writerIndex(byteBuf2.capacity());
    }

    public ByteBuf component(int n) {
        this.checkComponentIndex(n);
        return this.components[n].duplicate();
    }

    public ByteBuf componentAtOffset(int n) {
        return this.findComponent(n).duplicate();
    }

    public ByteBuf internalComponent(int n) {
        this.checkComponentIndex(n);
        return this.components[n].slice();
    }

    public ByteBuf internalComponentAtOffset(int n) {
        return this.findComponent(n).slice();
    }

    private Component findComponent(int n) {
        Component component = this.lastAccessed;
        if (component != null && n >= component.offset && n < component.endOffset) {
            this.ensureAccessible();
            return component;
        }
        this.checkIndex(n);
        return this.findIt(n);
    }

    private Component findComponent0(int n) {
        Component component = this.lastAccessed;
        if (component != null && n >= component.offset && n < component.endOffset) {
            return component;
        }
        return this.findIt(n);
    }

    private Component findIt(int n) {
        int n2 = 0;
        int n3 = this.componentCount;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            Component component = this.components[n4];
            if (component == null) {
                throw new IllegalStateException("No component found for offset. Composite buffer layout might be outdated, e.g. from a discardReadBytes call.");
            }
            if (n >= component.endOffset) {
                n2 = n4 + 1;
                continue;
            }
            if (n < component.offset) {
                n3 = n4 - 1;
                continue;
            }
            this.lastAccessed = component;
            return component;
        }
        throw new Error("should not reach here");
    }

    @Override
    public int nioBufferCount() {
        int n = this.componentCount;
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return this.components[0].buf.nioBufferCount();
            }
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.components[i].buf.nioBufferCount();
        }
        return n2;
    }

    @Override
    public ByteBuffer internalNioBuffer(int n, int n2) {
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                return this.components[0].internalNioBuffer(n, n2);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer nioBuffer(int n, int n2) {
        Comparable<ByteBuf> comparable;
        ByteBuffer[] byteBufferArray;
        this.checkIndex(n, n2);
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                byteBufferArray = this.components[0];
                comparable = byteBufferArray.buf;
                if (((ByteBuf)comparable).nioBufferCount() != 1) break;
                return ((ByteBuf)comparable).nioBuffer(byteBufferArray.idx(n), n2);
            }
        }
        byteBufferArray = ((ByteBuf)this).nioBuffers(n, n2);
        if (byteBufferArray.length == 1) {
            return byteBufferArray[0];
        }
        comparable = ByteBuffer.allocate(n2).order(((ByteBuf)this).order());
        ByteBuffer[] byteBufferArray2 = byteBufferArray;
        n2 = byteBufferArray.length;
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray2[i];
            ((ByteBuffer)comparable).put(byteBuffer);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return new ByteBuffer[]{EMPTY_NIO_BUFFER};
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance((int)this.componentCount);
        try {
            ByteBuffer[] byteBufferArray;
            int n3 = this.toComponentIndex0(n);
            while (n2 > 0) {
                byteBufferArray = this.components[n3];
                ByteBuf byteBuf = byteBufferArray.buf;
                int n4 = Math.min(n2, byteBufferArray.endOffset - n);
                switch (byteBuf.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        recyclableArrayList.add((Object)byteBuf.nioBuffer(byteBufferArray.idx(n), n4));
                        break;
                    }
                    default: {
                        Collections.addAll(recyclableArrayList, byteBuf.nioBuffers(byteBufferArray.idx(n), n4));
                    }
                }
                n += n4;
                n2 -= n4;
                ++n3;
            }
            byteBufferArray = (ByteBuffer[])recyclableArrayList.toArray((Object[])EmptyArrays.EMPTY_BYTE_BUFFERS);
            return byteBufferArray;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    public CompositeByteBuf consolidate() {
        this.ensureAccessible();
        this.consolidate0(0, this.componentCount);
        return this;
    }

    public CompositeByteBuf consolidate(int n, int n2) {
        this.checkComponentIndex(n, n2);
        this.consolidate0(n, n2);
        return this;
    }

    private void consolidate0(int n, int n2) {
        if (n2 <= 1) {
            return;
        }
        int n3 = n + n2;
        int n4 = n != 0 ? this.components[n].offset : 0;
        n4 = this.components[n3 - 1].endOffset - n4;
        ByteBuf byteBuf = this.allocBuffer(n4);
        for (int i = n; i < n3; ++i) {
            this.components[i].transferTo(byteBuf);
        }
        this.lastAccessed = null;
        this.removeCompRange(n + 1, n3);
        this.components[n] = this.newComponent(byteBuf, 0);
        if (n != 0 || n2 != this.componentCount) {
            this.updateComponentOffsets(n);
        }
    }

    public CompositeByteBuf discardReadComponents() {
        int n;
        this.ensureAccessible();
        int n2 = ((ByteBuf)this).readerIndex();
        if (n2 == 0) {
            return this;
        }
        int n3 = ((ByteBuf)this).writerIndex();
        if (n2 == n3 && n3 == ((ByteBuf)this).capacity()) {
            int n4 = this.componentCount;
            for (int i = 0; i < n4; ++i) {
                this.components[i].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(n2);
            return this;
        }
        Component component = null;
        int n5 = this.componentCount;
        for (n = 0; n < n5; ++n) {
            component = this.components[n];
            if (component.endOffset > n2) break;
            component.free();
        }
        if (n == 0) {
            return this;
        }
        Component component2 = this.lastAccessed;
        if (component2 != null && component2.endOffset <= n2) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, n);
        n = component.offset;
        this.updateComponentOffsets(0);
        this.setIndex(n2 - n, n3 - n);
        this.adjustMarkers(n);
        return this;
    }

    @Override
    public CompositeByteBuf discardReadBytes() {
        int n;
        this.ensureAccessible();
        int n2 = ((ByteBuf)this).readerIndex();
        if (n2 == 0) {
            return this;
        }
        int n3 = ((ByteBuf)this).writerIndex();
        if (n2 == n3 && n3 == ((ByteBuf)this).capacity()) {
            int n4 = this.componentCount;
            for (int i = 0; i < n4; ++i) {
                this.components[i].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(n2);
            return this;
        }
        Component component = null;
        int n5 = this.componentCount;
        for (n = 0; n < n5; ++n) {
            component = this.components[n];
            if (component.endOffset > n2) break;
            component.free();
        }
        n5 = n2 - component.offset;
        component.offset = 0;
        component.endOffset -= n2;
        component.srcAdjustment += n2;
        component.adjustment += n2;
        ByteBuf byteBuf = component.slice;
        if (byteBuf != null) {
            component.slice = byteBuf.slice(n5, component.length());
        }
        if ((component = this.lastAccessed) != null && component.endOffset <= n2) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, n);
        this.updateComponentOffsets(0);
        this.setIndex(0, n3 - n2);
        this.adjustMarkers(n2);
        return this;
    }

    private ByteBuf allocBuffer(int n) {
        if (this.direct) {
            return ((ByteBuf)this).alloc().directBuffer(n);
        }
        return ((ByteBuf)this).alloc().heapBuffer(n);
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.componentCount + ')';
    }

    @Override
    public CompositeByteBuf readerIndex(int n) {
        super.readerIndex(n);
        return this;
    }

    @Override
    public CompositeByteBuf writerIndex(int n) {
        super.writerIndex(n);
        return this;
    }

    @Override
    public CompositeByteBuf setIndex(int n, int n2) {
        super.setIndex(n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf clear() {
        super.clear();
        return this;
    }

    @Override
    public CompositeByteBuf markReaderIndex() {
        super.markReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetReaderIndex() {
        super.resetReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf markWriterIndex() {
        super.markWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetWriterIndex() {
        super.resetWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf ensureWritable(int n) {
        super.ensureWritable(n);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return this.getBytes(n, byteBuf2, byteBuf2.writableBytes());
    }

    @Override
    public CompositeByteBuf getBytes(int n, ByteBuf byteBuf, int n2) {
        ByteBuf byteBuf2 = byteBuf;
        this.getBytes(n, byteBuf2, byteBuf2.writerIndex(), n2);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.writerIndex(byteBuf3.writerIndex() + n2);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n, byte[] byArray) {
        return this.getBytes(n, byArray, 0, byArray.length);
    }

    @Override
    public CompositeByteBuf setBoolean(int n, boolean bl) {
        return this.setByte(n, bl ? 1 : 0);
    }

    @Override
    public CompositeByteBuf setChar(int n, int n2) {
        return this.setShort(n, n2);
    }

    @Override
    public CompositeByteBuf setFloat(int n, float f) {
        return this.setInt(n, Float.floatToRawIntBits(f));
    }

    @Override
    public CompositeByteBuf setDouble(int n, double d) {
        return this.setLong(n, Double.doubleToRawLongBits(d));
    }

    @Override
    public CompositeByteBuf setBytes(int n, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        super.setBytes(n, byteBuf2, byteBuf2.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n, ByteBuf byteBuf, int n2) {
        super.setBytes(n, byteBuf, n2);
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n, byte[] byArray) {
        return this.setBytes(n, byArray, 0, byArray.length);
    }

    @Override
    public CompositeByteBuf setZero(int n, int n2) {
        super.setZero(n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        super.readBytes(byteBuf2, byteBuf2.writableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n) {
        super.readBytes(byteBuf, n);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        super.readBytes(byteBuf, n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray) {
        super.readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray, int n, int n2) {
        super.readBytes(byArray, n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuffer byteBuffer) {
        super.readBytes(byteBuffer);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(OutputStream outputStream, int n) {
        super.readBytes(outputStream, n);
        return this;
    }

    @Override
    public CompositeByteBuf skipBytes(int n) {
        super.skipBytes(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeBoolean(boolean bl) {
        this.writeByte(bl ? 1 : 0);
        return this;
    }

    @Override
    public CompositeByteBuf writeByte(int n) {
        this.ensureWritable0(1);
        CompositeByteBuf compositeByteBuf = this;
        compositeByteBuf._setByte(compositeByteBuf.writerIndex++, n);
        return this;
    }

    @Override
    public CompositeByteBuf writeShort(int n) {
        super.writeShort(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeMedium(int n) {
        super.writeMedium(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeInt(int n) {
        super.writeInt(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeLong(long l) {
        super.writeLong(l);
        return this;
    }

    @Override
    public CompositeByteBuf writeChar(int n) {
        super.writeShort(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeFloat(float f) {
        super.writeInt(Float.floatToRawIntBits(f));
        return this;
    }

    @Override
    public CompositeByteBuf writeDouble(double d) {
        super.writeLong(Double.doubleToRawLongBits(d));
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        super.writeBytes(byteBuf2, byteBuf2.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n) {
        super.writeBytes(byteBuf, n);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n, int n2) {
        super.writeBytes(byteBuf, n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray) {
        super.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray, int n, int n2) {
        super.writeBytes(byArray, n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuffer byteBuffer) {
        super.writeBytes(byteBuffer);
        return this;
    }

    @Override
    public CompositeByteBuf writeZero(int n) {
        super.writeZero(n);
        return this;
    }

    @Override
    public CompositeByteBuf retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public CompositeByteBuf retain() {
        super.retain();
        return this;
    }

    @Override
    public CompositeByteBuf touch() {
        return this;
    }

    @Override
    public CompositeByteBuf touch(Object object) {
        return this;
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        CompositeByteBuf compositeByteBuf = this;
        return ((ByteBuf)compositeByteBuf).nioBuffers(((ByteBuf)compositeByteBuf).readerIndex(), ((ByteBuf)this).readableBytes());
    }

    @Override
    public CompositeByteBuf discardSomeReadBytes() {
        return this.discardReadComponents();
    }

    @Override
    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        int n = this.componentCount;
        for (int i = 0; i < n; ++i) {
            this.components[i].free();
        }
    }

    @Override
    boolean isAccessible() {
        return !this.freed;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    private void clearComps() {
        this.removeCompRange(0, this.componentCount);
    }

    private void removeComp(int n) {
        int n2 = n;
        this.removeCompRange(n2, n2 + 1);
    }

    private void removeCompRange(int n, int n2) {
        if (n >= n2) {
            return;
        }
        int n3 = this.componentCount;
        assert (n >= 0 && n2 <= n3);
        if (n2 < n3) {
            System.arraycopy(this.components, n2, this.components, n, n3 - n2);
        }
        for (n2 = n = n3 - n2 + n; n2 < n3; ++n2) {
            this.components[n2] = null;
        }
        this.componentCount = n;
    }

    private void addComp(int n, Component component) {
        this.shiftComps(n, 1);
        this.components[n] = component;
    }

    private void shiftComps(int n, int n2) {
        int n3 = this.componentCount;
        int n4 = n3 + n2;
        assert (n >= 0 && n <= n3 && n2 > 0);
        if (n4 > this.components.length) {
            Component[] componentArray;
            int n5 = n3;
            int n6 = Math.max(n5 + (n5 >> 1), n4);
            if (n == n3) {
                componentArray = (Component[])Arrays.copyOf(this.components, n6, Component[].class);
            } else {
                componentArray = new Component[n6];
                if (n > 0) {
                    System.arraycopy(this.components, 0, componentArray, 0, n);
                }
                if (n < n3) {
                    System.arraycopy(this.components, n, componentArray, n + n2, n3 - n);
                }
            }
            this.components = componentArray;
        } else if (n < n3) {
            System.arraycopy(this.components, n, this.components, n + n2, n3 - n);
        }
        this.componentCount = n4;
    }

    private final class CompositeByteBufIterator
    implements Iterator<ByteBuf> {
        private final int size;
        private int index;

        private CompositeByteBufIterator() {
            this.size = CompositeByteBuf.this.numComponents();
        }

        @Override
        public final boolean hasNext() {
            return this.size > this.index;
        }

        @Override
        public final ByteBuf next() {
            if (this.size != CompositeByteBuf.this.numComponents()) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return CompositeByteBuf.this.components[this.index++].slice();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Read-Only");
        }
    }

    private static final class Component {
        final ByteBuf srcBuf;
        final ByteBuf buf;
        int srcAdjustment;
        int adjustment;
        int offset;
        int endOffset;
        private ByteBuf slice;

        Component(ByteBuf byteBuf, int n, ByteBuf byteBuf2, int n2, int n3, int n4, ByteBuf byteBuf3) {
            this.srcBuf = byteBuf;
            this.srcAdjustment = n - n3;
            this.buf = byteBuf2;
            this.adjustment = n2 - n3;
            this.offset = n3;
            this.endOffset = n3 + n4;
            this.slice = byteBuf3;
        }

        final int srcIdx(int n) {
            return n + this.srcAdjustment;
        }

        final int idx(int n) {
            return n + this.adjustment;
        }

        final int length() {
            return this.endOffset - this.offset;
        }

        final void reposition(int n) {
            int n2 = n - this.offset;
            this.endOffset += n2;
            this.srcAdjustment -= n2;
            this.adjustment -= n2;
            this.offset = n;
        }

        final void transferTo(ByteBuf byteBuf) {
            Component component = this;
            byteBuf.writeBytes(this.buf, component.idx(component.offset), this.length());
            this.free();
        }

        final ByteBuf slice() {
            ByteBuf byteBuf = this.slice;
            if (byteBuf == null) {
                Component component = this;
                this.slice = byteBuf = this.srcBuf.slice(component.srcIdx(component.offset), this.length());
            }
            return byteBuf;
        }

        final ByteBuf duplicate() {
            return this.srcBuf.duplicate();
        }

        final ByteBuffer internalNioBuffer(int n, int n2) {
            return this.srcBuf.internalNioBuffer(this.srcIdx(n), n2);
        }

        final void free() {
            this.slice = null;
            this.srcBuf.release();
        }
    }

    static interface ByteWrapper<T> {
        public ByteBuf wrap(T var1);

        public boolean isEmpty(T var1);
    }
}

