/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields;
import io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import io.netty.util.internal.shaded.org.jctools.queues.LinkedArrayQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final Object BUFFER_CONSUMED = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    public BaseMpscLinkedArrayQueue(int n) {
        RangeUtil.checkGreaterThanOrEqual(n, 2, "initialCapacity");
        n = Pow2.roundToPowerOfTwo(n);
        long l = n - 1 << 1;
        E[] EArray = UnsafeRefArrayAccess.allocateRefArray(n + 1);
        this.producerBuffer = EArray;
        this.producerMask = l;
        this.consumerBuffer = EArray;
        this.consumerMask = l;
        this.soProducerLimit(l);
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 2);
    }

    @Override
    public boolean isEmpty() {
        return (this.lvConsumerIndex() - this.lvProducerIndex()) / 2L == 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e) {
        E[] EArray;
        long l;
        long l2;
        long l3;
        if (e == null) {
            throw new NullPointerException();
        }
        block6: while (true) {
            l3 = this.lvProducerLimit();
            l2 = this.lvProducerIndex();
            if ((l2 & 1L) == 1L) continue;
            l = this.producerMask;
            EArray = this.producerBuffer;
            if (l3 <= l2) {
                int n = this.offerSlowPath(l, l2, l3);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l, EArray, l2, e, null);
                        return true;
                    }
                }
            }
            long l4 = l2;
            if (this.casProducerIndex(l4, l4 + 2L)) break;
        }
        l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l);
        UnsafeRefArrayAccess.soRefElement(EArray, l3, e);
        return true;
    }

    @Override
    public E poll() {
        long l;
        E[] EArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(EArray, l3);
        if (e == null) {
            long l4 = this.lvProducerIndex();
            if ((l2 - l4) / 2L == 0L) {
                return null;
            }
            while ((e = UnsafeRefArrayAccess.lvRefElement(EArray, l3)) == null) {
            }
        }
        if (e == JUMP) {
            E[] EArray2 = this.nextBuffer(EArray, l);
            return this.newBufferPoll(EArray2, l2);
        }
        UnsafeRefArrayAccess.soRefElement(EArray, l3, null);
        this.soConsumerIndex(l2 + 2L);
        return e;
    }

    @Override
    public E peek() {
        long l;
        E[] EArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(EArray, l3);
        if (e == null) {
            long l4 = this.lvProducerIndex();
            if ((l2 - l4) / 2L == 0L) {
                return null;
            }
            while ((e = UnsafeRefArrayAccess.lvRefElement(EArray, l3)) == null) {
            }
        }
        if (e == JUMP) {
            BaseMpscLinkedArrayQueue baseMpscLinkedArrayQueue = this;
            return baseMpscLinkedArrayQueue.newBufferPeek(baseMpscLinkedArrayQueue.nextBuffer(EArray, l), l2);
        }
        return e;
    }

    private int offerSlowPath(long l, long l2, long l3) {
        long l4;
        long l5 = this.lvConsumerIndex();
        if (l5 + (l4 = this.getCurrentBufferCapacity(l)) > l2) {
            if (!this.casProducerLimit(l3, l5 + l4)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(l2, l5) <= 0L) {
            return 2;
        }
        long l6 = l2;
        if (this.casProducerIndex(l6, l6 + 1L)) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private E[] nextBuffer(E[] EArray, long l) {
        long l2 = BaseMpscLinkedArrayQueue.nextArrayOffset(l);
        Object[] objectArray = (Object[])UnsafeRefArrayAccess.lvRefElement(EArray, l2);
        this.consumerBuffer = objectArray;
        this.consumerMask = LinkedArrayQueueUtil.length(objectArray) - 2 << 1;
        UnsafeRefArrayAccess.soRefElement(EArray, l2, BUFFER_CONSUMED);
        return objectArray;
    }

    private static long nextArrayOffset(long l) {
        return LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] EArray, long l) {
        long l2 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l, this.consumerMask);
        E e = UnsafeRefArrayAccess.lvRefElement(EArray, l2);
        if (e == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soRefElement(EArray, l2, null);
        this.soConsumerIndex(l + 2L);
        return e;
    }

    private E newBufferPeek(E[] object, long l) {
        long l2 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l, this.consumerMask);
        if ((object = UnsafeRefArrayAccess.lvRefElement(object, l2)) == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return (E)object;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        long l;
        E[] EArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(EArray, l3);
        if (e == null) {
            return null;
        }
        if (e == JUMP) {
            EArray = this.nextBuffer(EArray, l);
            return this.newBufferPoll(EArray, l2);
        }
        UnsafeRefArrayAccess.soRefElement(EArray, l3, null);
        this.soConsumerIndex(l2 + 2L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        long l;
        E[] EArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(EArray, l3);
        if (e == JUMP) {
            BaseMpscLinkedArrayQueue baseMpscLinkedArrayQueue = this;
            return baseMpscLinkedArrayQueue.newBufferPeek(baseMpscLinkedArrayQueue.nextBuffer(EArray, l), l2);
        }
        return e;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        int n;
        long l = 0L;
        int n2 = this.capacity();
        do {
            if ((n = this.fill(supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l;
        } while ((l += (long)n) <= (long)n2);
        return (int)l;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        long l;
        E[] EArray;
        long l2;
        long l3;
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        block5: while (true) {
            long l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            EArray = this.producerBuffer;
            l = Math.min(l4, l3 + 2L * (long)n);
            if (l3 >= l4) {
                int n2 = this.offerSlowPath(l2, l3, l4);
                switch (n2) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l2, EArray, l3, null, supplier);
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l3, l)) break;
        }
        n = (int)((l - l3) / 2L);
        for (int i = 0; i < n; ++i) {
            long l5 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3 + 2L * (long)i, l2);
            UnsafeRefArrayAccess.soRefElement(EArray, l5, supplier.get());
        }
        return n;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        return MessagePassingQueueUtil.drain(this, consumer, n);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public Iterator<E> iterator() {
        return new WeakIterator(this.consumerBuffer, this.lvConsumerIndex(), this.lvProducerIndex());
    }

    private void resize(long l, E[] EArray, long l2, E e, MessagePassingQueue.Supplier<E> supplier) {
        E[] EArray2;
        assert (e != null && supplier == null || e == null || supplier != null);
        int n = this.getNextBufferSize(EArray);
        try {
            EArray2 = UnsafeRefArrayAccess.allocateRefArray(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            assert (this.lvProducerIndex() == l2 + 1L);
            this.soProducerIndex(l2);
            throw outOfMemoryError;
        }
        this.producerBuffer = EArray2;
        n = n - 2 << 1;
        this.producerMask = n;
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l);
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, n);
        UnsafeRefArrayAccess.soRefElement(EArray2, l4, e == null ? supplier.get() : e);
        UnsafeRefArrayAccess.soRefElement(EArray, BaseMpscLinkedArrayQueue.nextArrayOffset(l), EArray2);
        long l5 = this.lvConsumerIndex();
        long l6 = this.availableInQueue(l2, l5);
        RangeUtil.checkPositive(l6, "availableInQueue");
        this.soProducerLimit(l2 + Math.min((long)n, l6));
        this.soProducerIndex(l2 + 2L);
        UnsafeRefArrayAccess.soRefElement(EArray, l3, JUMP);
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private long nextIndex;
        private E nextElement;
        private E[] currentBuffer;
        private int mask;

        WeakIterator(E[] EArray, long l, long l2) {
            this.pIndex = l2 >> 1;
            this.nextIndex = l >> 1;
            this.setBuffer(EArray);
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            E e = this.nextElement;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return e;
        }

        private void setBuffer(E[] EArray) {
            this.currentBuffer = EArray;
            this.mask = LinkedArrayQueueUtil.length(EArray) - 2;
        }

        private E getNext() {
            while (this.nextIndex < this.pIndex) {
                long l;
                ++this.nextIndex;
                E e = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(l, this.mask));
                if (e == null) continue;
                if (e != JUMP) {
                    return e;
                }
                int n = this.mask + 1;
                e = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcRefElementOffset(n));
                if (e == BUFFER_CONSUMED || e == null) {
                    return null;
                }
                this.setBuffer((Object[])e);
                e = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(l, this.mask));
                if (e == null) continue;
                return e;
            }
            return null;
        }
    }
}

