/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.util.List;

public final class BrotliDecoder
extends ByteToMessageDecoder {
    private final int inputBufferSize;
    private DecoderJNI.Wrapper decoder;
    private boolean destroyed;

    public BrotliDecoder() {
        this(8192);
    }

    public BrotliDecoder(int n) {
        this.inputBufferSize = ObjectUtil.checkPositive((int)n, (String)"inputBufferSize");
    }

    private ByteBuf pull(ByteBufAllocator byteBufAllocator) {
        ByteBuffer byteBuffer = this.decoder.pull();
        byteBufAllocator = byteBufAllocator.buffer(byteBuffer.remaining());
        byteBufAllocator.writeBytes(byteBuffer);
        return byteBufAllocator;
    }

    private State decompress(ByteBuf byteBuf, List<Object> list, ByteBufAllocator byteBufAllocator) {
        block6: while (true) {
            switch (this.decoder.getStatus()) {
                case DONE: {
                    return State.DONE;
                }
                case OK: {
                    this.decoder.push(0);
                    continue block6;
                }
                case NEEDS_MORE_INPUT: {
                    if (this.decoder.hasOutput()) {
                        list.add(this.pull(byteBufAllocator));
                    }
                    if (!byteBuf.isReadable()) {
                        return State.NEEDS_MORE_INPUT;
                    }
                    ByteBuffer byteBuffer = this.decoder.getInputBuffer();
                    byteBuffer.clear();
                    int n = BrotliDecoder.readBytes(byteBuf, byteBuffer);
                    this.decoder.push(n);
                    continue block6;
                }
                case NEEDS_MORE_OUTPUT: {
                    list.add(this.pull(byteBufAllocator));
                    continue block6;
                }
            }
            break;
        }
        return State.ERROR;
    }

    private static int readBytes(ByteBuf byteBuf, ByteBuffer byteBuffer) {
        int n = Math.min(byteBuf.readableBytes(), byteBuffer.remaining());
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(n);
        byteBuf.readBytes(byteBuffer2);
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer3.position(byteBuffer3.position() + n);
        return n;
    }

    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.decoder = new DecoderJNI.Wrapper(this.inputBufferSize);
    }

    @Override
    protected final void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if (this.destroyed) {
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.skipBytes(byteBuf2.readableBytes());
            return;
        }
        if (!byteBuf.isReadable()) {
            return;
        }
        try {
            object = this.decompress(byteBuf, list, object.alloc());
            if (object != State.DONE) {
                if (object == State.ERROR) {
                    throw new DecompressionException("Brotli stream corrupted");
                }
                return;
            }
            this.destroy();
        }
        catch (Exception exception) {
            this.destroy();
            throw exception;
        }
    }

    private void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.decoder.destroy();
        }
    }

    @Override
    protected final void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        try {
            this.destroy();
            return;
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    @Override
    public final void channelInactive(ChannelHandlerContext channelHandlerContext) {
        try {
            this.destroy();
            return;
        }
        finally {
            super.channelInactive(channelHandlerContext);
        }
    }

    static {
        try {
            Brotli.ensureAvailability();
            return;
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }

    private static enum State {
        DONE,
        NEEDS_MORE_INPUT,
        ERROR;

    }
}

