/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.serialization.CompactObjectOutputStream;
import io.netty.util.internal.ObjectUtil;
import java.io.DataOutputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;

@Deprecated
public class ObjectEncoderOutputStream
extends OutputStream
implements ObjectOutput {
    private final DataOutputStream out;
    private final int estimatedLength;

    public ObjectEncoderOutputStream(OutputStream outputStream) {
        this(outputStream, 512);
    }

    public ObjectEncoderOutputStream(OutputStream outputStream, int n) {
        ObjectUtil.checkNotNull((Object)outputStream, (String)"out");
        ObjectUtil.checkPositiveOrZero((int)n, (String)"estimatedLength");
        this.out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.estimatedLength = n;
    }

    @Override
    public void writeObject(Object object) {
        ByteBuf byteBuf = Unpooled.buffer((int)this.estimatedLength);
        try {
            CompactObjectOutputStream compactObjectOutputStream = new CompactObjectOutputStream((OutputStream)new ByteBufOutputStream(byteBuf));
            try {
                compactObjectOutputStream.writeObject(object);
                compactObjectOutputStream.flush();
            }
            finally {
                compactObjectOutputStream.close();
            }
            int n = byteBuf.readableBytes();
            this.writeInt(n);
            byteBuf.getBytes(0, (OutputStream)this, n);
            return;
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void write(int n) {
        this.out.write(n);
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    public final int size() {
        return this.out.size();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.out.write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) {
        this.out.write(byArray);
    }

    @Override
    public final void writeBoolean(boolean bl) {
        this.out.writeBoolean(bl);
    }

    @Override
    public final void writeByte(int n) {
        this.out.writeByte(n);
    }

    @Override
    public final void writeBytes(String string) {
        this.out.writeBytes(string);
    }

    @Override
    public final void writeChar(int n) {
        this.out.writeChar(n);
    }

    @Override
    public final void writeChars(String string) {
        this.out.writeChars(string);
    }

    @Override
    public final void writeDouble(double d) {
        this.out.writeDouble(d);
    }

    @Override
    public final void writeFloat(float f) {
        this.out.writeFloat(f);
    }

    @Override
    public final void writeInt(int n) {
        this.out.writeInt(n);
    }

    @Override
    public final void writeLong(long l) {
        this.out.writeLong(l);
    }

    @Override
    public final void writeShort(int n) {
        this.out.writeShort(n);
    }

    @Override
    public final void writeUTF(String string) {
        this.out.writeUTF(string);
    }
}

