/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class FlatDesktopIconUI
extends BasicDesktopIconUI {
    private Dimension iconSize;
    private Dimension closeSize;
    private JLabel dockIcon;
    private JButton closeButton;
    private JToolTip titleTip;
    private ActionListener closeListener;
    private MouseInputListener mouseInputListener;
    private PropertyChangeListener ancestorListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatDesktopIconUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent.isDisplayable()) {
            this.updateDockIconPreviewLater();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.dockIcon = null;
        this.closeButton = null;
    }

    @Override
    protected void installComponents() {
        this.dockIcon = new JLabel();
        this.dockIcon.setHorizontalAlignment(0);
        this.closeButton = new JButton();
        this.closeButton.setIcon(UIManager.getIcon("DesktopIcon.closeIcon"));
        this.closeButton.setFocusable(false);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.setOpaque(true);
        this.closeButton.setBackground(FlatUIUtils.nonUIResource(this.desktopIcon.getBackground()));
        this.closeButton.setForeground(FlatUIUtils.nonUIResource(this.desktopIcon.getForeground()));
        this.closeButton.setVisible(false);
        this.desktopIcon.setLayout(new FlatDesktopIconLayout());
        this.desktopIcon.add(this.closeButton);
        this.desktopIcon.add(this.dockIcon);
    }

    @Override
    protected void uninstallComponents() {
        this.hideTitleTip();
        this.desktopIcon.remove(this.dockIcon);
        this.desktopIcon.remove(this.closeButton);
        this.desktopIcon.setLayout(null);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColors(this.desktopIcon, "DesktopIcon.background", "DesktopIcon.foreground");
        this.iconSize = UIManager.getDimension("DesktopIcon.iconSize");
        this.closeSize = UIManager.getDimension("DesktopIcon.closeSize");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.closeListener = actionEvent -> {
            if (this.frame.isClosable()) {
                this.frame.doDefaultCloseAction();
            }
        };
        this.closeButton.addActionListener(this.closeListener);
        this.closeButton.addMouseListener(this.mouseInputListener);
        this.ancestorListener = propertyChangeEvent -> {
            if (propertyChangeEvent.getNewValue() != null) {
                this.updateDockIconPreviewLater();
                return;
            }
            this.dockIcon.setIcon(null);
        };
        this.desktopIcon.addPropertyChangeListener("ancestor", this.ancestorListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.closeButton.removeActionListener(this.closeListener);
        this.closeButton.removeMouseListener(this.mouseInputListener);
        this.closeListener = null;
        this.mouseInputListener = null;
        this.desktopIcon.removePropertyChangeListener("ancestor", this.ancestorListener);
        this.ancestorListener = null;
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        this.mouseInputListener = new MouseInputAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (FlatDesktopIconUI.this.frame.isIcon() && FlatDesktopIconUI.this.desktopIcon.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    FlatDesktopIconUI.this.hideTitleTip();
                    FlatDesktopIconUI.this.closeButton.setVisible(false);
                    try {
                        FlatDesktopIconUI.this.frame.setIcon(false);
                        return;
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FlatDesktopIconUI.this.showTitleTip();
                if (FlatDesktopIconUI.this.frame.isClosable()) {
                    FlatDesktopIconUI.this.closeButton.setVisible(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FlatDesktopIconUI.this.hideTitleTip();
                FlatDesktopIconUI.this.closeButton.setVisible(false);
            }
        };
        return this.mouseInputListener;
    }

    private void showTitleTip() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this.desktopIcon);
        if (jRootPane == null) {
            return;
        }
        if (this.titleTip == null) {
            this.titleTip = new JToolTip();
            jRootPane.getLayeredPane().add((Component)this.titleTip, JLayeredPane.POPUP_LAYER);
        }
        this.titleTip.setTipText(this.frame.getTitle());
        this.titleTip.setSize(this.titleTip.getPreferredSize());
        int n = (this.desktopIcon.getWidth() - this.titleTip.getWidth()) / 2;
        int n2 = -(this.titleTip.getHeight() + UIScale.scale(4));
        Point point = SwingUtilities.convertPoint(this.desktopIcon, n, n2, this.titleTip.getParent());
        if (point.x + this.titleTip.getWidth() > jRootPane.getWidth()) {
            point.x = jRootPane.getWidth() - this.titleTip.getWidth();
        }
        if (point.x < 0) {
            point.x = 0;
        }
        this.titleTip.setLocation(point);
        this.titleTip.repaint();
    }

    private void hideTitleTip() {
        if (this.titleTip == null) {
            return;
        }
        this.titleTip.setVisible(false);
        this.titleTip.getParent().remove(this.titleTip);
        this.titleTip = null;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return UIScale.scale(this.iconSize);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            Color color = jComponent.getBackground();
            JDesktopPane jDesktopPane = this.desktopIcon.getDesktopPane();
            graphics.setColor(jDesktopPane != null ? FlatUIUtils.deriveColor(color, jDesktopPane.getBackground()) : color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
    }

    private void updateDockIconPreviewLater() {
        EventQueue.invokeLater(() -> {
            if (this.dockIcon != null) {
                this.updateDockIconPreview();
            }
        });
    }

    protected void updateDockIconPreview() {
        int n;
        if (this.frame.isSelected()) {
            try {
                this.frame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        if (!this.frame.isValid()) {
            this.frame.doLayout();
        }
        for (Component object2 : this.frame.getComponents()) {
            if (object2.isValid()) continue;
            object2.doLayout();
        }
        int n2 = Math.max(this.frame.getWidth(), 1);
        int n22 = Math.max(this.frame.getHeight(), 1);
        Image image = new BufferedImage(n2, n22, 2);
        Graphics2D n3 = image.createGraphics();
        try {
            this.frame.paint(n3);
        }
        finally {
            n3.dispose();
        }
        Insets insets = this.desktopIcon.getInsets();
        int n4 = UIScale.scale(this.iconSize.width) - insets.left - insets.right;
        int n5 = UIScale.scale(this.iconSize.height) - insets.top - insets.bottom;
        float f = (float)n22 / (float)n2;
        if ((float)n4 / (float)n2 > (float)n5 / (float)n22) {
            n = Math.round((float)n5 / f);
        } else {
            n5 = Math.round((float)n4 * f);
        }
        Image image2 = image.getScaledInstance(n, n5, 4);
        if (MultiResolutionImageSupport.isAvailable()) {
            Image image3 = image.getScaledInstance(n << 1, n5 << 1, 4);
            double d = UIScale.getSystemScaleFactor(this.desktopIcon.getGraphicsConfiguration());
            if (d != 1.0 && d != 2.0) {
                image = image.getScaledInstance((int)Math.round((double)n * d), (int)Math.round((double)n5 * d), 4);
                image2 = d < 2.0 ? MultiResolutionImageSupport.create(0, image2, image, image3) : MultiResolutionImageSupport.create(0, image2, image3, image);
            } else {
                image2 = MultiResolutionImageSupport.create(0, image2, image3);
            }
        }
        this.dockIcon.setIcon(new ImageIcon(image2));
    }

    private class FlatDesktopIconLayout
    implements LayoutManager {
        private FlatDesktopIconLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return FlatDesktopIconUI.this.dockIcon.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return FlatDesktopIconUI.this.dockIcon.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container container) {
            Cloneable cloneable = container.getInsets();
            FlatDesktopIconUI.this.dockIcon.setBounds(cloneable.left, cloneable.top, container.getWidth() - cloneable.left - cloneable.right, container.getHeight() - cloneable.top - cloneable.bottom);
            cloneable = UIScale.scale(FlatDesktopIconUI.this.closeSize);
            FlatDesktopIconUI.this.closeButton.setBounds(container.getWidth() - ((Dimension)cloneable).width, 0, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
        }
    }
}

