/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatNativeMacLibrary;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class FullWindowContentSupport {
    private static final String KEY_DEBUG_SHOW_PLACEHOLDERS = "FlatLaf.debug.panel.showPlaceholders";
    private static ArrayList<WeakReference<JComponent>> placeholders = new ArrayList();

    FullWindowContentSupport() {
    }

    static Dimension getPlaceholderPreferredSize(JComponent serializable, String string) {
        Serializable serializable2;
        if (!string.startsWith(SystemInfo.isMacOS ? "mac" : "win") || !serializable.isDisplayable() || (serializable2 = SwingUtilities.getRootPane(serializable)) == null || (serializable2 = (Rectangle)serializable2.getClientProperty("FlatLaf.fullWindowContent.buttonsBounds")) == null) {
            return new Dimension(0, 0);
        }
        if (string.length() > 3 && (string.contains("leftToRight") && !serializable.getComponentOrientation().isLeftToRight() || string.contains("rightToLeft") && serializable.getComponentOrientation().isLeftToRight())) {
            return new Dimension(0, 0);
        }
        if (SystemInfo.isMacFullWindowContentSupported && FlatNativeMacLibrary.isLoaded() && (serializable = FlatNativeMacLibrary.getWindowButtonsBounds(SwingUtilities.windowForComponent(serializable))) != null) {
            serializable2 = serializable;
        }
        int n = ((Rectangle)serializable2).width;
        int n2 = ((Rectangle)serializable2).height;
        if (string.length() > 3) {
            if (n == 0 && string.contains("zeroInFullScreen")) {
                n2 = 0;
            }
            if (string.contains("horizontal")) {
                n2 = 0;
            }
            if (string.contains("vertical")) {
                n = 0;
            }
        }
        return new Dimension(n, n2);
    }

    static void registerPlaceholder(JComponent jComponent) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            if (FullWindowContentSupport.indexOfPlaceholder(jComponent) < 0) {
                placeholders.add(new WeakReference<JComponent>(jComponent));
            }
            return;
        }
    }

    static void unregisterPlaceholder(JComponent jComponent) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            int n = FullWindowContentSupport.indexOfPlaceholder(jComponent);
            if (n >= 0) {
                placeholders.remove(n);
            }
            return;
        }
    }

    private static int indexOfPlaceholder(JComponent jComponent) {
        int n = placeholders.size();
        for (int i = 0; i < n; ++i) {
            if (placeholders.get(i).get() != jComponent) continue;
            return i;
        }
        return -1;
    }

    static void revalidatePlaceholders(Component component) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            if (placeholders.isEmpty()) {
                return;
            }
            Iterator<WeakReference<JComponent>> iterator = placeholders.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if ((object = (JComponent)((Reference)object).get()) == null) {
                    iterator.remove();
                    continue;
                }
                if (!SwingUtilities.isDescendingFrom((Component)object, component)) continue;
                ((JComponent)object).revalidate();
            }
            return;
        }
    }

    static ComponentListener macInstallListeners(final JRootPane jRootPane) {
        ComponentAdapter componentAdapter = new ComponentAdapter(){
            boolean lastFullScreen;

            @Override
            public void componentResized(ComponentEvent serializable) {
                serializable = SwingUtilities.windowForComponent(jRootPane);
                if (serializable == null) {
                    return;
                }
                boolean bl = FlatNativeMacLibrary.isLoaded() && FlatNativeMacLibrary.isWindowFullScreen((Window)serializable);
                if (bl == this.lastFullScreen) {
                    return;
                }
                this.lastFullScreen = bl;
                FullWindowContentSupport.macUpdateFullWindowContentButtonsBoundsProperty(jRootPane);
            }
        };
        jRootPane.addComponentListener(componentAdapter);
        return componentAdapter;
    }

    static void macUninstallListeners(JRootPane jRootPane, ComponentListener componentListener) {
        if (componentListener != null) {
            jRootPane.removeComponentListener(componentListener);
        }
    }

    static void macUpdateFullWindowContentButtonsBoundsProperty(JRootPane jRootPane) {
        if (!SystemInfo.isMacFullWindowContentSupported || !jRootPane.isDisplayable()) {
            return;
        }
        Rectangle rectangle = null;
        if (FlatClientProperties.clientPropertyBoolean(jRootPane, "apple.awt.fullWindowContent", false)) {
            rectangle = FlatNativeMacLibrary.isLoaded() ? FlatNativeMacLibrary.getWindowButtonsBounds(SwingUtilities.windowForComponent(jRootPane)) : new Rectangle(68, 28);
        }
        jRootPane.putClientProperty("FlatLaf.fullWindowContent.buttonsBounds", rectangle);
    }

    static void macUninstallFullWindowContentButtonsBoundsProperty(JRootPane jRootPane) {
        if (!SystemInfo.isMacFullWindowContentSupported) {
            return;
        }
        jRootPane.putClientProperty("FlatLaf.fullWindowContent.buttonsBounds", null);
    }

    static void debugPaint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        if (!UIManager.getBoolean(KEY_DEBUG_SHOW_PLACEHOLDERS)) {
            return;
        }
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        graphics.setColor(Color.red);
        FullWindowContentSupport.debugPaintRect(graphics, new Rectangle(n, n2));
        JRootPane jRootPane = SwingUtilities.getRootPane(jComponent);
        if (jRootPane != null && (rectangle = (Rectangle)jRootPane.getClientProperty("FlatLaf.fullWindowContent.buttonsBounds")) != null && (rectangle.width != n || rectangle.height != n2)) {
            graphics.setColor(Color.magenta);
            FullWindowContentSupport.debugPaintRect(graphics, SwingUtilities.convertRectangle(jRootPane, rectangle, jComponent));
        }
    }

    private static void debugPaintRect(Graphics graphics, Rectangle rectangle) {
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        int n = rectangle.x + rectangle.width - 1;
        int n2 = rectangle.y + rectangle.height - 1;
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        graphics.drawLine(rectangle.x, rectangle.y, n, n2);
        graphics.drawLine(rectangle.x, n2, n, rectangle.y);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }
}

