/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.DoubleFunction;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 _2\u00020\u0001:\u0001_B]\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014BE\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0018B]\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0019B%\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u001bB-\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u001cB1\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u001dB%\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0013\u0010\u001fB-\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0013\u0010 BA\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010!B!\b\u0010\u0012\u0006\u0010\"\u001a\u00020\u0000\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010#J\b\u0010=\u001a\u00020\u0005H\u0007J\b\u0010>\u001a\u00020\u0005H\u0007J\b\u0010?\u001a\u00020\u0005H\u0007J\u0012\u0010=\u001a\u00020\u00052\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0007J\u0012\u0010>\u001a\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\u0005H\u0007J\u0012\u0010?\u001a\u00020\u00052\b\b\u0001\u0010+\u001a\u00020\u0005H\u0007J\u0010\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u0012H\u0016J\u0010\u0010B\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u0012H\u0016J \u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rH\u0007J\u0012\u0010C\u001a\u00020\u00052\b\b\u0001\u0010G\u001a\u00020\u0005H\u0007J \u0010H\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rH\u0007J\u0012\u0010H\u001a\u00020\u00052\b\b\u0001\u0010G\u001a\u00020\u0005H\u0007J\u0010\u0010I\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0016J%\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\rH\u0010\u00a2\u0006\u0002\bOJ%\u0010P\u001a\u00020\r2\u0006\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\rH\u0010\u00a2\u0006\u0002\bQJ7\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\r2\u0006\u0010U\u001a\u00020\r2\u0006\u0010V\u001a\u00020\r2\u0006\u0010W\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0001H\u0010\u00a2\u0006\u0004\bX\u0010YJ\u0010\u0010Z\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0013\u0010[\u001a\u00020:2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0096\u0002J\b\u0010^\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0014\u0010+\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u0014\u0010-\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010/R\u0014\u00104\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010/R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00101R\u0014\u00107\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010/R\u0014\u00109\u001a\u00020:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010;R\u0014\u0010<\u001a\u00020:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010;\u00a8\u0006`"}, d2={"Landroidx/compose/ui/graphics/colorspace/Rgb;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "name", "", "primaries", "", "whitePoint", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "transform", "oetf", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "eotf", "min", "", "max", "transferParameters", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "id", "", "<init>", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;[FLandroidx/compose/ui/graphics/colorspace/DoubleFunction;Landroidx/compose/ui/graphics/colorspace/DoubleFunction;FFLandroidx/compose/ui/graphics/colorspace/TransferParameters;I)V", "toXYZ", "Lkotlin/Function1;", "", "(Ljava/lang/String;[FLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;FF)V", "function", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/TransferParameters;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Landroidx/compose/ui/graphics/colorspace/TransferParameters;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Landroidx/compose/ui/graphics/colorspace/TransferParameters;I)V", "gamma", "(Ljava/lang/String;[FD)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;D)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;DFFI)V", "colorSpace", "(Landroidx/compose/ui/graphics/colorspace/Rgb;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;)V", "getWhitePoint", "()Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "getTransferParameters", "()Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "getPrimaries$ui_graphics", "()[F", "getTransform$ui_graphics", "inverseTransform", "getInverseTransform$ui_graphics", "oetfOrig", "getOetfOrig$ui_graphics", "()Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "getOetf", "()Lkotlin/jvm/functions/Function1;", "oetfFunc", "getOetfFunc$ui_graphics", "eotfOrig", "getEotfOrig$ui_graphics", "getEotf", "eotfFunc", "getEotfFunc$ui_graphics", "isWideGamut", "", "()Z", "isSrgb", "getPrimaries", "getTransform", "getInverseTransform", "getMinValue", "component", "getMaxValue", "toLinear", "r", "g", "b", "v", "fromLinear", "toXyz", "toXy", "", "v0", "v1", "v2", "toXy$ui_graphics", "toZ", "toZ$ui_graphics", "xyzaToColor", "Landroidx/compose/ui/graphics/Color;", "x", "y", "z", "a", "xyzaToColor-JlNiLsg$ui_graphics", "(FFFFLandroidx/compose/ui/graphics/colorspace/ColorSpace;)J", "fromXyz", "equals", "other", "", "hashCode", "Companion", "ui-graphics"})
public final class Rgb
extends ColorSpace {
    public static final Companion Companion = new Companion(null);
    private final WhitePoint whitePoint;
    private final float min;
    private final float max;
    private final TransferParameters transferParameters;
    private final float[] primaries;
    private final float[] transform;
    private final float[] inverseTransform;
    private final DoubleFunction oetfOrig;
    private final Function1<Double, Double> oetf;
    private final DoubleFunction oetfFunc;
    private final DoubleFunction eotfOrig;
    private final Function1<Double, Double> eotf;
    private final DoubleFunction eotfFunc;
    private final boolean isWideGamut;
    private final boolean isSrgb;
    private static final DoubleFunction DoubleIdentity = Rgb::DoubleIdentity$lambda$10;

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, float[] fArray2, DoubleFunction doubleFunction, DoubleFunction doubleFunction2, float f, float f2, TransferParameters transferParameters, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        Intrinsics.checkNotNullParameter((Object)doubleFunction, (String)"");
        Intrinsics.checkNotNullParameter((Object)doubleFunction2, (String)"");
        super(string, ColorModel.Companion.getRgb-xdoWZVw(), n, null);
        this.whitePoint = whitePoint;
        this.min = f;
        this.max = f2;
        this.transferParameters = transferParameters;
        this.oetfOrig = doubleFunction;
        this.oetf = arg_0 -> Rgb.oetf$lambda$0(this, arg_0);
        this.oetfFunc = arg_0 -> Rgb.oetfFunc$lambda$1(this, arg_0);
        this.eotfOrig = doubleFunction2;
        this.eotf = arg_0 -> Rgb.eotf$lambda$2(this, arg_0);
        this.eotfFunc = arg_0 -> Rgb.eotfFunc$lambda$3(this, arg_0);
        if (fArray.length != 6 && fArray.length != 9) {
            throw new IllegalArgumentException("The color space's primaries must be defined as an array of 6 floats in xyY or 9 floats in XYZ");
        }
        if (this.min >= this.max) {
            throw new IllegalArgumentException("Invalid range: min=" + this.min + ", max=" + this.max + "; min must be strictly < max");
        }
        this.primaries = Rgb.Companion.xyPrimaries(fArray);
        if (fArray2 == null) {
            this.transform = Rgb.Companion.computeXYZMatrix(this.primaries, this.whitePoint);
        } else {
            if (fArray2.length != 9) {
                throw new IllegalArgumentException("Transform must have 9 entries! Has " + fArray2.length);
            }
            this.transform = fArray2;
        }
        this.inverseTransform = ColorSpaceKt.inverse3x3(this.transform);
        this.isWideGamut = Rgb.Companion.isWideGamut(this.primaries, this.min, this.max);
        this.isSrgb = Rgb.Companion.isSrgb(this.primaries, this.whitePoint, doubleFunction, doubleFunction2, this.min, this.max, n);
    }

    public final WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    public final TransferParameters getTransferParameters() {
        return this.transferParameters;
    }

    public final float[] getPrimaries$ui_graphics() {
        return this.primaries;
    }

    public final float[] getTransform$ui_graphics() {
        return this.transform;
    }

    public final float[] getInverseTransform$ui_graphics() {
        return this.inverseTransform;
    }

    public final DoubleFunction getOetfOrig$ui_graphics() {
        return this.oetfOrig;
    }

    public final Function1<Double, Double> getOetf() {
        return this.oetf;
    }

    public final DoubleFunction getOetfFunc$ui_graphics() {
        return this.oetfFunc;
    }

    public final DoubleFunction getEotfOrig$ui_graphics() {
        return this.eotfOrig;
    }

    public final Function1<Double, Double> getEotf() {
        return this.eotf;
    }

    public final DoubleFunction getEotfFunc$ui_graphics() {
        return this.eotfFunc;
    }

    @Override
    public final boolean isWideGamut() {
        return this.isWideGamut;
    }

    @Override
    public final boolean isSrgb() {
        return this.isSrgb;
    }

    public final float[] getPrimaries() {
        float[] fArray = Arrays.copyOf(this.primaries, this.primaries.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
        return fArray;
    }

    public final float[] getTransform() {
        float[] fArray = Arrays.copyOf(this.transform, this.transform.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
        return fArray;
    }

    public final float[] getInverseTransform() {
        float[] fArray = Arrays.copyOf(this.inverseTransform, this.inverseTransform.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
        return fArray;
    }

    public Rgb(String string, float[] fArray, Function1<? super Double, Double> function1, Function1<? super Double, Double> function12) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(function12, (String)"");
        this(string, Companion.computePrimaries$ui_graphics(fArray), Rgb.Companion.computeWhitePoint(fArray), null, arg_0 -> Rgb._init_$lambda$4(function1, arg_0), arg_0 -> Rgb._init_$lambda$5(function12, arg_0), 0.0f, 1.0f, null, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, Function1<? super Double, Double> function1, Function1<? super Double, Double> function12, float f, float f2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(function12, (String)"");
        this(string, fArray, whitePoint, null, arg_0 -> Rgb._init_$lambda$6(function1, arg_0), arg_0 -> Rgb._init_$lambda$7(function12, arg_0), f, f2, null, -1);
    }

    public Rgb(String string, float[] fArray, TransferParameters transferParameters) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)transferParameters, (String)"");
        this(string, Companion.computePrimaries$ui_graphics(fArray), Rgb.Companion.computeWhitePoint(fArray), transferParameters, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, TransferParameters transferParameters) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        Intrinsics.checkNotNullParameter((Object)transferParameters, (String)"");
        this(string, fArray, whitePoint, transferParameters, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, TransferParameters transferParameters, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        Intrinsics.checkNotNullParameter((Object)transferParameters, (String)"");
        this(string, fArray, whitePoint, null, Rgb.Companion.generateOetf(transferParameters), Rgb.Companion.generateEotf(transferParameters), 0.0f, 1.0f, transferParameters, n);
    }

    public Rgb(String string, float[] fArray, double d2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        this(string, Companion.computePrimaries$ui_graphics(fArray), Rgb.Companion.computeWhitePoint(fArray), d2, 0.0f, 1.0f, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, double d2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        this(string, fArray, whitePoint, d2, 0.0f, 1.0f, -1);
    }

    public Rgb(String string, float[] fArray, WhitePoint whitePoint, double d2, float f, float f2, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        this(string, fArray, whitePoint, null, d2 == 1.0 ? DoubleIdentity : arg_0 -> Rgb._init_$lambda$8(d2, arg_0), d2 == 1.0 ? DoubleIdentity : arg_0 -> Rgb._init_$lambda$9(d2, arg_0), f, f2, new TransferParameters(d2, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 96, null), n);
    }

    public Rgb(Rgb rgb, float[] fArray, WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"");
        this(rgb.getName(), rgb.primaries, whitePoint, fArray, rgb.oetfOrig, rgb.eotfOrig, rgb.min, rgb.max, rgb.transferParameters, -1);
    }

    public final float[] getPrimaries(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        return ArraysKt.copyInto$default((float[])this.primaries, (float[])fArray, (int)0, (int)0, (int)0, (int)14, null);
    }

    public final float[] getTransform(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        return ArraysKt.copyInto$default((float[])this.transform, (float[])fArray, (int)0, (int)0, (int)0, (int)14, null);
    }

    public final float[] getInverseTransform(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        return ArraysKt.copyInto$default((float[])this.inverseTransform, (float[])fArray, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Override
    public final float getMinValue(int n) {
        return this.min;
    }

    @Override
    public final float getMaxValue(int n) {
        return this.max;
    }

    public final float[] toLinear(float f, float f2, float f3) {
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        return this.toLinear(fArray2);
    }

    public final float[] toLinear(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (fArray.length < 3) {
            return fArray;
        }
        fArray[0] = (float)this.eotfFunc.invoke(fArray[0]);
        fArray[1] = (float)this.eotfFunc.invoke(fArray[1]);
        fArray[2] = (float)this.eotfFunc.invoke(fArray[2]);
        return fArray;
    }

    public final float[] fromLinear(float f, float f2, float f3) {
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        return this.fromLinear(fArray2);
    }

    public final float[] fromLinear(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (fArray.length < 3) {
            return fArray;
        }
        fArray[0] = (float)this.oetfFunc.invoke(fArray[0]);
        fArray[1] = (float)this.oetfFunc.invoke(fArray[1]);
        fArray[2] = (float)this.oetfFunc.invoke(fArray[2]);
        return fArray;
    }

    @Override
    public final float[] toXyz(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        if (fArray.length < 3) {
            return fArray;
        }
        fArray[0] = (float)this.eotfFunc.invoke(fArray[0]);
        fArray[1] = (float)this.eotfFunc.invoke(fArray[1]);
        fArray[2] = (float)this.eotfFunc.invoke(fArray[2]);
        return ColorSpaceKt.mul3x3Float3(this.transform, fArray);
    }

    @Override
    public final long toXy$ui_graphics(float f, float f2, float f3) {
        f = (float)this.eotfFunc.invoke(f);
        f2 = (float)this.eotfFunc.invoke(f2);
        f3 = (float)this.eotfFunc.invoke(f3);
        if (this.transform.length < 9) {
            return 0L;
        }
        float[] fArray = this.transform;
        float f4 = this.transform[0] * f + fArray[3] * f2 + fArray[6] * f3;
        fArray = this.transform;
        float f5 = this.transform[1] * f + fArray[4] * f2 + fArray[7] * f3;
        long l2 = Float.floatToRawIntBits(f4);
        long l3 = Float.floatToRawIntBits(f5);
        return l2 << 32 | l3 & 0xFFFFFFFFL;
    }

    @Override
    public final float toZ$ui_graphics(float f, float f2, float f3) {
        f = (float)this.eotfFunc.invoke(f);
        f2 = (float)this.eotfFunc.invoke(f2);
        f3 = (float)this.eotfFunc.invoke(f3);
        float[] fArray = this.transform;
        f = this.transform[2] * f + fArray[5] * f2 + fArray[8] * f3;
        return f;
    }

    @Override
    public final long xyzaToColor-JlNiLsg$ui_graphics(float f, float f2, float f3, float f4, ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"");
        float[] fArray = this.inverseTransform;
        float f5 = this.inverseTransform[0] * f + fArray[3] * f2 + fArray[6] * f3;
        float[] fArray2 = this.inverseTransform;
        float f6 = this.inverseTransform[1] * f + fArray2[4] * f2 + fArray2[7] * f3;
        fArray2 = this.inverseTransform;
        float f7 = this.inverseTransform[2] * f + fArray2[5] * f2 + fArray2[8] * f3;
        f5 = (float)this.oetfFunc.invoke(f5);
        f6 = (float)this.oetfFunc.invoke(f6);
        f7 = (float)this.oetfFunc.invoke(f7);
        return ColorKt.Color(f5, f6, f7, f4, colorSpace);
    }

    @Override
    public final float[] fromXyz(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        ColorSpaceKt.mul3x3Float3(this.inverseTransform, fArray);
        if (fArray.length < 3) {
            return fArray;
        }
        fArray[0] = (float)this.oetfFunc.invoke(fArray[0]);
        fArray[1] = (float)this.oetfFunc.invoke(fArray[1]);
        fArray[2] = (float)this.oetfFunc.invoke(fArray[2]);
        return fArray;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = (Rgb)object;
        if (Float.compare(((Rgb)object).min, this.min) != 0) {
            return false;
        }
        if (Float.compare(((Rgb)object).max, this.max) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.whitePoint, (Object)((Rgb)object).whitePoint)) {
            return false;
        }
        if (!Arrays.equals(this.primaries, ((Rgb)object).primaries)) {
            return false;
        }
        if (this.transferParameters != null) {
            return Intrinsics.areEqual((Object)this.transferParameters, (Object)((Rgb)object).transferParameters);
        }
        if (((Rgb)object).transferParameters == null) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.oetfOrig, (Object)((Rgb)object).oetfOrig)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.eotfOrig, (Object)((Rgb)object).eotfOrig);
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.whitePoint.hashCode();
        n = n * 31 + Arrays.hashCode(this.primaries);
        n = n * 31 + (!(this.min == 0.0f) ? Float.floatToIntBits(this.min) : 0);
        n = n * 31 + (!(this.max == 0.0f) ? Float.floatToIntBits(this.max) : 0);
        TransferParameters transferParameters = this.transferParameters;
        n = n * 31 + (transferParameters != null ? transferParameters.hashCode() : 0);
        if (this.transferParameters == null) {
            n = n * 31 + this.oetfOrig.hashCode();
            n = n * 31 + this.eotfOrig.hashCode();
        }
        return n;
    }

    private static final double oetf$lambda$0(Rgb rgb, double d2) {
        return RangesKt.coerceIn((double)rgb.oetfOrig.invoke(d2), (double)rgb.min, (double)rgb.max);
    }

    private static final double oetfFunc$lambda$1(Rgb rgb, double d2) {
        return RangesKt.coerceIn((double)rgb.oetfOrig.invoke(d2), (double)rgb.min, (double)rgb.max);
    }

    private static final double eotf$lambda$2(Rgb rgb, double d2) {
        return rgb.eotfOrig.invoke(RangesKt.coerceIn((double)d2, (double)rgb.min, (double)rgb.max));
    }

    private static final double eotfFunc$lambda$3(Rgb rgb, double d2) {
        return rgb.eotfOrig.invoke(RangesKt.coerceIn((double)d2, (double)rgb.min, (double)rgb.max));
    }

    private static final double _init_$lambda$4(Function1 function1, double d2) {
        return ((Number)function1.invoke((Object)d2)).doubleValue();
    }

    private static final double _init_$lambda$5(Function1 function1, double d2) {
        return ((Number)function1.invoke((Object)d2)).doubleValue();
    }

    private static final double _init_$lambda$6(Function1 function1, double d2) {
        return ((Number)function1.invoke((Object)d2)).doubleValue();
    }

    private static final double _init_$lambda$7(Function1 function1, double d2) {
        return ((Number)function1.invoke((Object)d2)).doubleValue();
    }

    private static final double _init_$lambda$8(double d2, double d3) {
        return Math.pow(d3 < 0.0 ? 0.0 : d3, 1.0 / d2);
    }

    private static final double _init_$lambda$9(double d2, double d3) {
        return Math.pow(d3 < 0.0 ? 0.0 : d3, d2);
    }

    private static final double DoubleIdentity$lambda$10(double d2) {
        return d2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J)\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0082\bJ\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J\u0015\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\tH\u0002J\u0010\u0010&\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/compose/ui/graphics/colorspace/Rgb$Companion;", "", "<init>", "()V", "DoubleIdentity", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "isSrgb", "", "primaries", "", "whitePoint", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "OETF", "EOTF", "min", "", "max", "id", "", "compare", "point", "", "a", "b", "isWideGamut", "area", "cross", "ax", "ay", "bx", "by", "contains", "p1", "p2", "computePrimaries", "toXYZ", "computePrimaries$ui_graphics", "computeWhitePoint", "xyPrimaries", "computeXYZMatrix", "generateOetf", "function", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "generateEotf", "ui-graphics"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSrgb(float[] object, WhitePoint whitePoint, DoubleFunction doubleFunction, DoubleFunction doubleFunction2, float f, float f2, int n) {
            if (n == 0) {
                return true;
            }
            if (!ColorSpaceKt.compare((float[])object, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics())) {
                return false;
            }
            if (!ColorSpaceKt.compare(whitePoint, Illuminant.INSTANCE.getD65())) {
                return false;
            }
            if (!(f == 0.0f)) {
                return false;
            }
            if (!(f2 == 1.0f)) {
                return false;
            }
            object = ColorSpaces.INSTANCE.getSrgb();
            for (double d2 = 0.0; d2 <= 1.0; d2 += 0.00392156862745098) {
                if (!this.compare(d2, doubleFunction, ((Rgb)object).getOetfOrig$ui_graphics())) {
                    return false;
                }
                if (this.compare(d2, doubleFunction2, ((Rgb)object).getEotfOrig$ui_graphics())) continue;
                return false;
            }
            return true;
        }

        private final boolean compare(double d2, DoubleFunction doubleFunction, DoubleFunction doubleFunction2) {
            double d3;
            double d4 = doubleFunction.invoke(d2);
            return Math.abs(d4 - (d3 = doubleFunction2.invoke(d2))) <= 0.001;
        }

        private final boolean isWideGamut(float[] fArray, float f, float f2) {
            return this.area(fArray) / this.area(ColorSpaces.INSTANCE.getNtsc1953Primaries$ui_graphics()) > 0.9f && this.contains(fArray, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics()) || f < 0.0f && f2 > 1.0f;
        }

        private final float area(float[] fArray) {
            float f;
            if (fArray.length < 6) {
                return 0.0f;
            }
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray[3];
            float f6 = fArray[4];
            float f7 = fArray[5];
            f7 = f2 * f5 + f3 * f6 + f4 * f7 - f5 * f6 - f3 * f4 - f2 * f7;
            f7 = 0.5f * f7;
            if (f < 0.0f) {
                return -f7;
            }
            return f7;
        }

        private final float cross(float f, float f2, float f3, float f4) {
            return f * f4 - f2 * f3;
        }

        private final boolean contains(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[6];
            float[] fArray4 = fArray3;
            fArray3[0] = fArray[0] - fArray2[0];
            fArray4[1] = fArray[1] - fArray2[1];
            fArray4[2] = fArray[2] - fArray2[2];
            fArray4[3] = fArray[3] - fArray2[3];
            fArray4[4] = fArray[4] - fArray2[4];
            fArray4[5] = fArray[5] - fArray2[5];
            float f = fArray4[0];
            float f2 = fArray2[1] - fArray2[5];
            fArray = fArray4;
            float f3 = fArray[1];
            float f4 = fArray2[0] - fArray2[4];
            if (f * f2 - f3 * f4 < 0.0f || (f = fArray2[0] - fArray2[2]) * (f2 = fArray[1]) - (f3 = fArray2[1] - fArray2[3]) * (f4 = fArray[0]) < 0.0f) {
                return false;
            }
            f = fArray[2];
            f2 = fArray2[3] - fArray2[1];
            f3 = fArray[3];
            f4 = fArray2[2] - fArray2[0];
            if (f * f2 - f3 * f4 < 0.0f || (f = fArray2[2] - fArray2[4]) * (f2 = fArray[3]) - (f3 = fArray2[3] - fArray2[5]) * (f4 = fArray[2]) < 0.0f) {
                return false;
            }
            f = fArray[4];
            f2 = fArray2[5] - fArray2[3];
            f3 = fArray[5];
            f4 = fArray2[4] - fArray2[2];
            return !(f * f2 - f3 * f4 < 0.0f) && !((f = fArray2[4] - fArray2[0]) * (f2 = fArray[5]) - (f3 = fArray2[5] - fArray2[1]) * (f4 = fArray[4]) < 0.0f);
        }

        public final float[] computePrimaries$ui_graphics(float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
            float[] fArray2 = new float[3];
            float[] fArray3 = fArray2;
            fArray2[0] = 1.0f;
            fArray3[1] = 0.0f;
            fArray3[2] = 0.0f;
            float[] fArray4 = ColorSpaceKt.mul3x3Float3(fArray, fArray3);
            float[] fArray5 = new float[3];
            float[] fArray6 = fArray5;
            fArray5[0] = 0.0f;
            fArray6[1] = 1.0f;
            fArray6[2] = 0.0f;
            fArray3 = ColorSpaceKt.mul3x3Float3(fArray, fArray6);
            float[] fArray7 = fArray;
            float[] fArray8 = new float[3];
            fArray = fArray8;
            fArray8[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 1.0f;
            fArray6 = ColorSpaceKt.mul3x3Float3(fArray7, fArray);
            float f = fArray4[0] + fArray4[1] + fArray4[2];
            float f2 = fArray3[0] + fArray3[1] + fArray3[2];
            float f3 = fArray6[0] + fArray6[1] + fArray6[2];
            float[] fArray9 = new float[6];
            float[] fArray10 = fArray9;
            fArray9[0] = fArray4[0] / f;
            fArray10[1] = fArray4[1] / f;
            fArray10[2] = fArray3[0] / f2;
            fArray10[3] = fArray3[1] / f2;
            fArray10[4] = fArray6[0] / f3;
            fArray10[5] = fArray6[1] / f3;
            return fArray10;
        }

        private final WhitePoint computeWhitePoint(float[] fArray) {
            float[] fArray2 = new float[3];
            float[] fArray3 = fArray2;
            fArray2[0] = 1.0f;
            fArray3[1] = 1.0f;
            fArray3[2] = 1.0f;
            fArray = ColorSpaceKt.mul3x3Float3(fArray, fArray3);
            float f = fArray[0] + fArray[1] + fArray[2];
            return new WhitePoint(fArray[0] / f, fArray[1] / f);
        }

        private final float[] xyPrimaries(float[] fArray) {
            float[] fArray2 = new float[6];
            if (fArray.length == 9) {
                float f = fArray[0] + fArray[1] + fArray[2];
                fArray2[0] = fArray[0] / f;
                fArray2[1] = fArray[1] / f;
                f = fArray[3] + fArray[4] + fArray[5];
                fArray2[2] = fArray[3] / f;
                fArray2[3] = fArray[4] / f;
                f = fArray[6] + fArray[7] + fArray[8];
                fArray2[4] = fArray[6] / f;
                fArray2[5] = fArray[7] / f;
            } else {
                ArraysKt.copyInto$default((float[])fArray, (float[])fArray2, (int)0, (int)0, (int)6, (int)6, null);
            }
            return fArray2;
        }

        private final float[] computeXYZMatrix(float[] fArray, WhitePoint whitePoint) {
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray[3];
            float f5 = fArray[4];
            float f6 = fArray[5];
            float f7 = whitePoint.getX();
            float f8 = whitePoint.getY();
            float f9 = (1.0f - f) / f2;
            float f10 = (1.0f - f3) / f4;
            float f11 = (1.0f - f5) / f6;
            float f12 = (1.0f - f7) / f8;
            float f13 = f / f2;
            float f14 = f3 / f4;
            float f15 = f5 / f6;
            f8 = f7 / f8;
            f7 = (f12 - f9) * (f14 - f13) - (f8 - f13) * (f10 - f9);
            f9 = (f11 - f9) * (f14 - f13) - (f15 - f13) * (f10 - f9);
            f8 = (f8 - f13 - (f7 /= f9) * (f15 - f13)) / (f14 - f13);
            f9 = 1.0f - f8 - f7;
            f10 = f9 / f2;
            f11 = f8 / f4;
            f12 = f7 / f6;
            float[] fArray2 = new float[9];
            float[] fArray3 = fArray2;
            fArray2[0] = f10 * f;
            fArray3[1] = f9;
            fArray3[2] = f10 * (1.0f - f - f2);
            fArray3[3] = f11 * f3;
            fArray3[4] = f8;
            fArray3[5] = f11 * (1.0f - f3 - f4);
            fArray3[6] = f12 * f5;
            fArray3[7] = f7;
            fArray3[8] = f12 * (1.0f - f5 - f6);
            return fArray3;
        }

        private final DoubleFunction generateOetf(TransferParameters transferParameters) {
            if (transferParameters.isHLGish$ui_graphics()) {
                return arg_0 -> Companion.generateOetf$lambda$0(transferParameters, arg_0);
            }
            if (transferParameters.isPQish$ui_graphics()) {
                return arg_0 -> Companion.generateOetf$lambda$1(transferParameters, arg_0);
            }
            if (transferParameters.getE() == 0.0 && transferParameters.getF() == 0.0) {
                return arg_0 -> Companion.generateOetf$lambda$2(transferParameters, arg_0);
            }
            return arg_0 -> Companion.generateOetf$lambda$3(transferParameters, arg_0);
        }

        private final DoubleFunction generateEotf(TransferParameters transferParameters) {
            if (transferParameters.isHLGish$ui_graphics()) {
                return arg_0 -> Companion.generateEotf$lambda$4(transferParameters, arg_0);
            }
            if (transferParameters.isPQish$ui_graphics()) {
                return arg_0 -> Companion.generateEotf$lambda$5(transferParameters, arg_0);
            }
            if (transferParameters.getE() == 0.0 && transferParameters.getF() == 0.0) {
                return arg_0 -> Companion.generateEotf$lambda$6(transferParameters, arg_0);
            }
            return arg_0 -> Companion.generateEotf$lambda$7(transferParameters, arg_0);
        }

        private static final double generateOetf$lambda$0(TransferParameters transferParameters, double d2) {
            return ColorSpaces.INSTANCE.transferHlgOetf$ui_graphics(transferParameters, d2);
        }

        private static final double generateOetf$lambda$1(TransferParameters transferParameters, double d2) {
            return ColorSpaces.INSTANCE.transferSt2048Oetf$ui_graphics(transferParameters, d2);
        }

        private static final double generateOetf$lambda$2(TransferParameters transferParameters, double d2) {
            return ColorSpaceKt.rcpResponse(d2, transferParameters.getA(), transferParameters.getB(), transferParameters.getC(), transferParameters.getD(), transferParameters.getGamma());
        }

        private static final double generateOetf$lambda$3(TransferParameters transferParameters, double d2) {
            return ColorSpaceKt.rcpResponse(d2, transferParameters.getA(), transferParameters.getB(), transferParameters.getC(), transferParameters.getD(), transferParameters.getE(), transferParameters.getF(), transferParameters.getGamma());
        }

        private static final double generateEotf$lambda$4(TransferParameters transferParameters, double d2) {
            return ColorSpaces.INSTANCE.transferHlgEotf$ui_graphics(transferParameters, d2);
        }

        private static final double generateEotf$lambda$5(TransferParameters transferParameters, double d2) {
            return ColorSpaces.INSTANCE.transferSt2048Eotf$ui_graphics(transferParameters, d2);
        }

        private static final double generateEotf$lambda$6(TransferParameters transferParameters, double d2) {
            return ColorSpaceKt.response(d2, transferParameters.getA(), transferParameters.getB(), transferParameters.getC(), transferParameters.getD(), transferParameters.getGamma());
        }

        private static final double generateEotf$lambda$7(TransferParameters transferParameters, double d2) {
            return ColorSpaceKt.response(d2, transferParameters.getA(), transferParameters.getB(), transferParameters.getC(), transferParameters.getD(), transferParameters.getE(), transferParameters.getF(), transferParameters.getGamma());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

