/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.sound3d.AudioSystem3D;
import com.jogamp.openal.sound3d.Device;

public final class Context {
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final Device device;
    private volatile ALCcontext alCtx;
    private boolean threadContextLocked;
    public final boolean hasALC_thread_local_context;
    private static final ThreadLocal<Context> currentContext = new ThreadLocal();

    public Context(ALCcontext aLCcontext, Device device) {
        boolean bl;
        this.device = device;
        this.alCtx = aLCcontext;
        if (this.makeCurrent(false)) {
            bl = AudioSystem3D.alc.alcIsExtensionPresent(null, "ALC_EXT_thread_local_context") || AudioSystem3D.alc.alcIsExtensionPresent(device.getALDevice(), "ALC_EXT_thread_local_context");
            this.release(false);
        } else {
            bl = false;
        }
        this.hasALC_thread_local_context = bl;
    }

    public Context(Device device, int[] nArray) {
        this(Context.createImpl(device.getALDevice(), nArray), device);
    }

    private static ALCcontext createImpl(ALCdevice aLCdevice, int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            return AudioSystem3D.alc.alcCreateContext(aLCdevice, nArray, 0);
        }
        return AudioSystem3D.alc.alcCreateContext(aLCdevice, null);
    }

    public final boolean create(int[] nArray) {
        this.lock.lock();
        try {
            if (this.alCtx == null) {
                this.alCtx = Context.createImpl(this.device.getALDevice(), nArray);
                boolean bl = this.alCtx != null;
                return bl;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final boolean recreate(int[] nArray) {
        this.lock.lock();
        try {
            boolean bl = this == Context.getCurrentContext();
            this.destroyImpl();
            this.alCtx = Context.createImpl(this.device.getALDevice(), nArray);
            if (this.alCtx != null) {
                if (bl) {
                    boolean bl2 = this.makeCurrentImpl();
                    return bl2;
                }
                return false;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final ALCcontext getALContext() {
        return this.alCtx;
    }

    public final boolean isValid() {
        return this.alCtx != null;
    }

    public final int getALCError() {
        return this.device.getALCError();
    }

    public final void destroy() {
        this.lock.lock();
        try {
            this.destroyImpl();
            if (currentContext.get() == this) {
                currentContext.set(null);
            }
            while (this.lock.getHoldCount() > 1) {
                this.lock.unlock();
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void destroyImpl() {
        if (this.alCtx != null) {
            if (this.threadContextLocked) {
                AudioSystem3D.alExt.alcSetThreadContext(null);
            } else {
                AudioSystem3D.alc.alcMakeContextCurrent(null);
            }
            AudioSystem3D.alc.alcDestroyContext(this.alCtx);
            this.alCtx = null;
        }
    }

    public static Context getCurrentContext() {
        return currentContext.get();
    }

    public final int getLockCount() {
        return this.lock.getHoldCount();
    }

    public final boolean makeCurrent(boolean bl) {
        this.lock.lock();
        if (this.alCtx == null) {
            this.lock.unlock();
            if (bl) {
                throw new ALException("Invalid " + this);
            }
            return false;
        }
        Context context = Context.getCurrentContext();
        if (context != null) {
            if (context == this) {
                return true;
            }
            this.lock.unlock();
            if (bl) {
                throw new ALException("Current thread " + Thread.currentThread() + " holds another " + context + " while claiming this " + this);
            }
            return false;
        }
        boolean bl2 = this.makeCurrentImpl();
        if (bl2) {
            currentContext.set(this);
        } else {
            this.lock.unlock();
            if (bl) {
                throw new ALException("Context make current failed " + this);
            }
        }
        return bl2;
    }

    private boolean makeCurrentImpl() {
        if (this.hasALC_thread_local_context) {
            this.threadContextLocked = true;
            return AudioSystem3D.alExt.alcSetThreadContext(this.alCtx);
        }
        this.threadContextLocked = false;
        return AudioSystem3D.alc.alcMakeContextCurrent(this.alCtx);
    }

    public final boolean release(boolean bl) {
        if (!this.lock.isOwner(Thread.currentThread())) {
            if (bl) {
                throw new ALException("Context not held on current thread " + Thread.currentThread() + ", " + this);
            }
            return false;
        }
        if (this.lock.getHoldCount() == 1) {
            boolean bl2 = this.threadContextLocked ? AudioSystem3D.alExt.alcSetThreadContext(null) : AudioSystem3D.alc.alcMakeContextCurrent(null);
            if (bl2) {
                currentContext.set(null);
            } else {
                if (bl) {
                    throw new ALException("Context release failed " + this);
                }
                return false;
            }
        }
        this.lock.unlock();
        return true;
    }

    public final void suspend() {
        AudioSystem3D.alc.alcSuspendContext(this.alCtx);
    }

    public final Device getDevice() {
        return this.device;
    }

    public final String toString() {
        String string = this.alCtx != null ? "0x" + Integer.toHexString(this.alCtx.hashCode()) : "null";
        return "ALContext[this 0x" + Integer.toHexString(this.hashCode()) + ", alCtx " + string + " lockCount " + this.lock.getHoldCount() + ", on " + this.device + "]";
    }
}

