/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.javax;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.javax.SmackJavaxSaslException;

public abstract class SASLJavaXMechanism
extends SASLMechanism {
    protected SaslClient sc;

    public abstract String getName();

    public final void checkIfSuccessfulOrThrow() {
        if (!this.sc.isComplete()) {
            throw new SmackException.SmackSaslException(this.getName() + " was not completed");
        }
    }

    protected void authenticateInternal() {
        String[] stringArray = new String[]{this.getName()};
        Map<String, String> map = this.getSaslProps();
        String string = null;
        if (this.authorizationId != null) {
            string = this.authorizationId.toString();
        }
        try {
            this.sc = Sasl.createSaslClient(stringArray, string, "xmpp", this.getServerName().toString(), map, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbackArray) {
                    for (int i = 0; i < callbackArray.length; ++i) {
                        Callback callback;
                        if (callbackArray[i] instanceof NameCallback) {
                            callback = (NameCallback)callbackArray[i];
                            ((NameCallback)callback).setName(SASLJavaXMechanism.this.authenticationId);
                            continue;
                        }
                        if (callbackArray[i] instanceof PasswordCallback) {
                            callback = (PasswordCallback)callbackArray[i];
                            ((PasswordCallback)callback).setPassword(SASLJavaXMechanism.this.password.toCharArray());
                            continue;
                        }
                        if (callbackArray[i] instanceof RealmCallback) {
                            callback = (RealmCallback)callbackArray[i];
                            String string = ((TextInputCallback)callback).getDefaultText();
                            ((TextInputCallback)callback).setText(string);
                            continue;
                        }
                        if (callbackArray[i] instanceof RealmChoiceCallback) continue;
                        throw new UnsupportedCallbackException(callbackArray[i]);
                    }
                }
            });
            return;
        }
        catch (SaslException saslException) {
            throw new SmackJavaxSaslException(saslException);
        }
    }

    protected void authenticateInternal(CallbackHandler callbackHandler) {
        String[] stringArray = new String[]{this.getName()};
        Map<String, String> map = this.getSaslProps();
        try {
            this.sc = Sasl.createSaslClient(stringArray, null, "xmpp", this.host, map, callbackHandler);
            return;
        }
        catch (SaslException saslException) {
            throw new SmackJavaxSaslException(saslException);
        }
    }

    protected byte[] getAuthenticationText() {
        if (this.sc.hasInitialResponse()) {
            try {
                return this.sc.evaluateChallenge(new byte[0]);
            }
            catch (SaslException saslException) {
                throw new SmackJavaxSaslException(saslException);
            }
        }
        return null;
    }

    protected byte[] evaluateChallenge(byte[] byArray) {
        try {
            if (byArray != null) {
                return this.sc.evaluateChallenge(byArray);
            }
            return this.sc.evaluateChallenge(new byte[0]);
        }
        catch (SaslException saslException) {
            throw new SmackJavaxSaslException(saslException);
        }
    }

    protected Map<String, String> getSaslProps() {
        return new HashMap<String, String>();
    }

    protected String getServerName() {
        return this.serviceName.toString();
    }
}

