/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class AdvancedLeakAwareByteBuf
extends SimpleLeakAwareByteBuf {
    private static final String PROP_ACQUIRE_AND_RELEASE_ONLY = "io.netty.leakDetection.acquireAndReleaseOnly";
    private static final boolean ACQUIRE_AND_RELEASE_ONLY;
    private static final InternalLogger logger;

    AdvancedLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        super(byteBuf, resourceLeakTracker);
    }

    AdvancedLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        super(byteBuf, byteBuf2, resourceLeakTracker);
    }

    static void recordLeakNonRefCountingOperation(ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        if (!ACQUIRE_AND_RELEASE_ONLY) {
            resourceLeakTracker.record();
        }
    }

    @Override
    public final ByteBuf order(ByteOrder byteOrder) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.order(byteOrder);
    }

    @Override
    public final ByteBuf slice() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.slice();
    }

    @Override
    public final ByteBuf slice(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.slice(n, n2);
    }

    @Override
    public final ByteBuf retainedSlice() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.retainedSlice();
    }

    @Override
    public final ByteBuf retainedSlice(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.retainedSlice(n, n2);
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.retainedDuplicate();
    }

    @Override
    public final ByteBuf readRetainedSlice(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readRetainedSlice(n);
    }

    @Override
    public final ByteBuf duplicate() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.duplicate();
    }

    @Override
    public final ByteBuf readSlice(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readSlice(n);
    }

    @Override
    public final ByteBuf discardReadBytes() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.discardReadBytes();
    }

    @Override
    public final ByteBuf discardSomeReadBytes() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.discardSomeReadBytes();
    }

    @Override
    public final ByteBuf ensureWritable(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.ensureWritable(n);
    }

    @Override
    public final int ensureWritable(int n, boolean bl) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.ensureWritable(n, bl);
    }

    @Override
    public final boolean getBoolean(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBoolean(n);
    }

    @Override
    public final byte getByte(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getByte(n);
    }

    @Override
    public final short getUnsignedByte(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedByte(n);
    }

    @Override
    public final short getShort(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getShort(n);
    }

    @Override
    public final int getUnsignedShort(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedShort(n);
    }

    @Override
    public final int getMedium(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getMedium(n);
    }

    @Override
    public final int getUnsignedMedium(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedMedium(n);
    }

    @Override
    public final int getInt(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getInt(n);
    }

    @Override
    public final long getUnsignedInt(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedInt(n);
    }

    @Override
    public final long getLong(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getLong(n);
    }

    @Override
    public final char getChar(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getChar(n);
    }

    @Override
    public final float getFloat(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getFloat(n);
    }

    @Override
    public final double getDouble(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getDouble(n);
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, byteBuf);
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, byteBuf, n2);
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, byteBuf, n2, n3);
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, byArray);
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, byArray, n2, n3);
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, byteBuffer);
    }

    @Override
    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, outputStream, n2);
    }

    @Override
    public final int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, gatheringByteChannel, n2);
    }

    @Override
    public final CharSequence getCharSequence(int n, int n2, Charset charset) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getCharSequence(n, n2, charset);
    }

    @Override
    public final ByteBuf setBoolean(int n, boolean bl) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBoolean(n, bl);
    }

    @Override
    public final ByteBuf setByte(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setByte(n, n2);
    }

    @Override
    public final ByteBuf setShort(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setShort(n, n2);
    }

    @Override
    public final ByteBuf setMedium(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setMedium(n, n2);
    }

    @Override
    public final ByteBuf setInt(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setInt(n, n2);
    }

    @Override
    public final ByteBuf setLong(int n, long l) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setLong(n, l);
    }

    @Override
    public final ByteBuf setChar(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setChar(n, n2);
    }

    @Override
    public final ByteBuf setFloat(int n, float f) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setFloat(n, f);
    }

    @Override
    public final ByteBuf setDouble(int n, double d) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setDouble(n, d);
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, byteBuf);
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, byteBuf, n2);
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, byteBuf, n2, n3);
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, byArray);
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, byArray, n2, n3);
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, byteBuffer);
    }

    @Override
    public final int setBytes(int n, InputStream inputStream, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, inputStream, n2);
    }

    @Override
    public final int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, scatteringByteChannel, n2);
    }

    @Override
    public final ByteBuf setZero(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setZero(n, n2);
    }

    @Override
    public final int setCharSequence(int n, CharSequence charSequence, Charset charset) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setCharSequence(n, charSequence, charset);
    }

    @Override
    public final boolean readBoolean() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBoolean();
    }

    @Override
    public final byte readByte() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readByte();
    }

    @Override
    public final short readUnsignedByte() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedByte();
    }

    @Override
    public final short readShort() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readShort();
    }

    @Override
    public final int readUnsignedShort() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedShort();
    }

    @Override
    public final int readMedium() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readMedium();
    }

    @Override
    public final int readUnsignedMedium() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedMedium();
    }

    @Override
    public final int readInt() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readInt();
    }

    @Override
    public final long readUnsignedInt() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedInt();
    }

    @Override
    public final long readLong() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readLong();
    }

    @Override
    public final char readChar() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readChar();
    }

    @Override
    public final float readFloat() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readFloat();
    }

    @Override
    public final double readDouble() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readDouble();
    }

    @Override
    public final ByteBuf readBytes(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(n);
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(byteBuf);
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf, int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(byteBuf, n);
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(byteBuf, n, n2);
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(byArray);
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray, int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(byArray, n, n2);
    }

    @Override
    public final ByteBuf readBytes(ByteBuffer byteBuffer) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(byteBuffer);
    }

    @Override
    public final ByteBuf readBytes(OutputStream outputStream, int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(outputStream, n);
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(gatheringByteChannel, n);
    }

    @Override
    public final CharSequence readCharSequence(int n, Charset charset) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readCharSequence(n, charset);
    }

    @Override
    public final ByteBuf skipBytes(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.skipBytes(n);
    }

    @Override
    public final ByteBuf writeBoolean(boolean bl) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBoolean(bl);
    }

    @Override
    public final ByteBuf writeByte(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeByte(n);
    }

    @Override
    public final ByteBuf writeShort(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeShort(n);
    }

    @Override
    public final ByteBuf writeMedium(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeMedium(n);
    }

    @Override
    public final ByteBuf writeInt(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeInt(n);
    }

    @Override
    public final ByteBuf writeLong(long l) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeLong(l);
    }

    @Override
    public final ByteBuf writeChar(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeChar(n);
    }

    @Override
    public final ByteBuf writeFloat(float f) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeFloat(f);
    }

    @Override
    public final ByteBuf writeDouble(double d) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeDouble(d);
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(byteBuf);
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf, int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(byteBuf, n);
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf, int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(byteBuf, n, n2);
    }

    @Override
    public final ByteBuf writeBytes(byte[] byArray) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(byArray);
    }

    @Override
    public final ByteBuf writeBytes(byte[] byArray, int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(byArray, n, n2);
    }

    @Override
    public final ByteBuf writeBytes(ByteBuffer byteBuffer) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(byteBuffer);
    }

    @Override
    public final int writeBytes(InputStream inputStream, int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(inputStream, n);
    }

    @Override
    public final int writeBytes(ScatteringByteChannel scatteringByteChannel, int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(scatteringByteChannel, n);
    }

    @Override
    public final ByteBuf writeZero(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeZero(n);
    }

    @Override
    public final int indexOf(int n, int n2, byte by) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.indexOf(n, n2, by);
    }

    @Override
    public final int bytesBefore(byte by) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.bytesBefore(by);
    }

    @Override
    public final int bytesBefore(int n, byte by) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.bytesBefore(n, by);
    }

    @Override
    public final int bytesBefore(int n, int n2, byte by) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.bytesBefore(n, n2, by);
    }

    @Override
    public final int forEachByte(ByteProcessor byteProcessor) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.forEachByte(byteProcessor);
    }

    @Override
    public final int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.forEachByte(n, n2, byteProcessor);
    }

    @Override
    public final int forEachByteDesc(ByteProcessor byteProcessor) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.forEachByteDesc(byteProcessor);
    }

    @Override
    public final int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.forEachByteDesc(n, n2, byteProcessor);
    }

    @Override
    public final ByteBuf copy() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.copy();
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.copy(n, n2);
    }

    @Override
    public final int nioBufferCount() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBufferCount();
    }

    @Override
    public final ByteBuffer nioBuffer() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBuffer();
    }

    @Override
    public final ByteBuffer nioBuffer(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBuffer(n, n2);
    }

    @Override
    public final ByteBuffer[] nioBuffers() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBuffers();
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.nioBuffers(n, n2);
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.internalNioBuffer(n, n2);
    }

    @Override
    public final String toString(Charset charset) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.toString(charset);
    }

    @Override
    public final String toString(int n, int n2, Charset charset) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.toString(n, n2, charset);
    }

    @Override
    public final ByteBuf capacity(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.capacity(n);
    }

    @Override
    public final short getShortLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getShortLE(n);
    }

    @Override
    public final int getUnsignedShortLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedShortLE(n);
    }

    @Override
    public final int getMediumLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getMediumLE(n);
    }

    @Override
    public final int getUnsignedMediumLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedMediumLE(n);
    }

    @Override
    public final int getIntLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getIntLE(n);
    }

    @Override
    public final long getUnsignedIntLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getUnsignedIntLE(n);
    }

    @Override
    public final long getLongLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getLongLE(n);
    }

    @Override
    public final ByteBuf setShortLE(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setShortLE(n, n2);
    }

    @Override
    public final ByteBuf setIntLE(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setIntLE(n, n2);
    }

    @Override
    public final ByteBuf setMediumLE(int n, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setMediumLE(n, n2);
    }

    @Override
    public final ByteBuf setLongLE(int n, long l) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setLongLE(n, l);
    }

    @Override
    public final short readShortLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readShortLE();
    }

    @Override
    public final int readUnsignedShortLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedShortLE();
    }

    @Override
    public final int readMediumLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readMediumLE();
    }

    @Override
    public final int readUnsignedMediumLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedMediumLE();
    }

    @Override
    public final int readIntLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readIntLE();
    }

    @Override
    public final long readUnsignedIntLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readUnsignedIntLE();
    }

    @Override
    public final long readLongLE() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readLongLE();
    }

    @Override
    public final ByteBuf writeShortLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeShortLE(n);
    }

    @Override
    public final ByteBuf writeMediumLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeMediumLE(n);
    }

    @Override
    public final ByteBuf writeIntLE(int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeIntLE(n);
    }

    @Override
    public final ByteBuf writeLongLE(long l) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeLongLE(l);
    }

    @Override
    public final int writeCharSequence(CharSequence charSequence, Charset charset) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeCharSequence(charSequence, charset);
    }

    @Override
    public final int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.getBytes(n, fileChannel, l, n2);
    }

    @Override
    public final int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.setBytes(n, fileChannel, l, n2);
    }

    @Override
    public final int readBytes(FileChannel fileChannel, long l, int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.readBytes(fileChannel, l, n);
    }

    @Override
    public final int writeBytes(FileChannel fileChannel, long l, int n) {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.writeBytes(fileChannel, l, n);
    }

    @Override
    public final ByteBuf asReadOnly() {
        AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation(this.leak);
        return super.asReadOnly();
    }

    @Override
    public final ByteBuf retain() {
        this.leak.record();
        return super.retain();
    }

    @Override
    public final ByteBuf retain(int n) {
        this.leak.record();
        return super.retain(n);
    }

    @Override
    public final boolean release() {
        this.leak.record();
        return super.release();
    }

    @Override
    public final boolean release(int n) {
        this.leak.record();
        return super.release(n);
    }

    @Override
    public final ByteBuf touch() {
        this.leak.record();
        return this;
    }

    @Override
    public final ByteBuf touch(Object object) {
        this.leak.record(object);
        return this;
    }

    @Override
    protected final AdvancedLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        return new AdvancedLeakAwareByteBuf(byteBuf, byteBuf2, resourceLeakTracker);
    }

    static {
        logger = InternalLoggerFactory.getInstance(AdvancedLeakAwareByteBuf.class);
        ACQUIRE_AND_RELEASE_ONLY = SystemPropertyUtil.getBoolean((String)PROP_ACQUIRE_AND_RELEASE_ONLY, (boolean)false);
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_ACQUIRE_AND_RELEASE_ONLY, (Object)ACQUIRE_AND_RELEASE_ONLY);
        }
        ResourceLeakDetector.addExclusions(AdvancedLeakAwareByteBuf.class, (String[])new String[]{"touch", "recordLeakNonRefCountingOperation"});
    }
}

