/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.buffer.WrappedCompositeByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.Recycler;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SWARUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<byte[]> BYTE_ARRAYS;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final int WRITE_CHUNK_SIZE = 8192;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    static final int MAX_TL_ARRAY_LEN = 1024;
    private static final ByteProcessor FIND_NON_ASCII;

    static byte[] threadLocalTempArray(int n) {
        if (n <= 1024 && Thread.currentThread() instanceof FastThreadLocalThread) {
            return (byte[])BYTE_ARRAYS.get();
        }
        return PlatformDependent.allocateUninitializedArray((int)n);
    }

    public static boolean isAccessible(ByteBuf byteBuf) {
        return byteBuf.isAccessible();
    }

    public static ByteBuf ensureAccessible(ByteBuf byteBuf) {
        if (!byteBuf.isAccessible()) {
            throw new IllegalReferenceCountException(byteBuf.refCnt());
        }
        return byteBuf;
    }

    public static String hexDump(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.hexDump(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static String hexDump(ByteBuf byteBuf, int n, int n2) {
        return HexUtil.hexDump(byteBuf, n, n2);
    }

    public static String hexDump(byte[] byArray) {
        return ByteBufUtil.hexDump(byArray, 0, byArray.length);
    }

    public static String hexDump(byte[] byArray, int n, int n2) {
        return HexUtil.hexDump(byArray, n, n2);
    }

    public static byte decodeHexByte(CharSequence charSequence, int n) {
        return StringUtil.decodeHexByte((CharSequence)charSequence, (int)n);
    }

    public static byte[] decodeHexDump(CharSequence charSequence) {
        return StringUtil.decodeHexDump((CharSequence)charSequence, (int)0, (int)charSequence.length());
    }

    public static byte[] decodeHexDump(CharSequence charSequence, int n, int n2) {
        return StringUtil.decodeHexDump((CharSequence)charSequence, (int)n, (int)n2);
    }

    public static boolean ensureWritableSuccess(int n) {
        return n == 0 || n == 2;
    }

    public static int hashCode(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        int n2 = n >>> 2;
        n &= 3;
        int n3 = 1;
        int n4 = byteBuf.readerIndex();
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            while (n2 > 0) {
                n3 = n3 * 31 + byteBuf.getInt(n4);
                n4 += 4;
                --n2;
            }
        } else {
            while (n2 > 0) {
                n3 = n3 * 31 + ByteBufUtil.swapInt(byteBuf.getInt(n4));
                n4 += 4;
                --n2;
            }
        }
        for (n2 = n; n2 > 0; --n2) {
            n3 = n3 * 31 + byteBuf.getByte(n4++);
        }
        if (n3 == 0) {
            n3 = 1;
        }
        return n3;
    }

    public static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n;
        if (byteBuf2 == null || byteBuf == null) {
            return -1;
        }
        if (byteBuf.readableBytes() > byteBuf2.readableBytes()) {
            return -1;
        }
        int n2 = byteBuf2.readableBytes();
        int n3 = byteBuf.readableBytes();
        if (n3 == 0) {
            return 0;
        }
        if (n3 == 1) {
            ByteBuf byteBuf3 = byteBuf2;
            ByteBuf byteBuf4 = byteBuf;
            return byteBuf3.indexOf(byteBuf3.readerIndex(), byteBuf2.writerIndex(), byteBuf4.getByte(byteBuf4.readerIndex()));
        }
        int n4 = 0;
        int n5 = byteBuf.readerIndex();
        int n6 = byteBuf2.readerIndex();
        long l = ByteBufUtil.maxSuf(byteBuf, n3, n5, true);
        long l2 = ByteBufUtil.maxSuf(byteBuf, n3, n5, false);
        int n7 = Math.max((int)(l >> 32), (int)(l2 >> 32));
        int n8 = Math.max((int)l, (int)l2);
        if (ByteBufUtil.equals(byteBuf, n5, byteBuf, n5 + n8, n = Math.min(n3 - n8, n7 + 1))) {
            int n9 = -1;
            while (n4 <= n2 - n3) {
                for (n = Math.max(n7, n9) + 1; n < n3 && byteBuf.getByte(n + n5) == byteBuf2.getByte(n + n4 + n6); ++n) {
                }
                if (n > n2) {
                    return -1;
                }
                if (n >= n3) {
                    for (n = n7; n > n9 && byteBuf.getByte(n + n5) == byteBuf2.getByte(n + n4 + n6); --n) {
                    }
                    if (n <= n9) {
                        return n4 + n6;
                    }
                    n4 += n8;
                    n9 = n3 - n8 - 1;
                    continue;
                }
                n4 += n - n7;
                n9 = -1;
            }
        } else {
            n8 = Math.max(n7 + 1, n3 - n7 - 1) + 1;
            while (n4 <= n2 - n3) {
                for (n = n7 + 1; n < n3 && byteBuf.getByte(n + n5) == byteBuf2.getByte(n + n4 + n6); ++n) {
                }
                if (n > n2) {
                    return -1;
                }
                if (n >= n3) {
                    for (n = n7; n >= 0 && byteBuf.getByte(n + n5) == byteBuf2.getByte(n + n4 + n6); --n) {
                    }
                    if (n < 0) {
                        return n4 + n6;
                    }
                    n4 += n8;
                    continue;
                }
                n4 += n - n7;
            }
        }
        return -1;
    }

    private static long maxSuf(ByteBuf byteBuf, int n, int n2, boolean bl) {
        int n3 = 1;
        int n4 = -1;
        int n5 = 1;
        while (n2 + n5 < n) {
            boolean bl2;
            byte by = byteBuf.getByte(n2 + n5);
            byte by2 = byteBuf.getByte(n4 + n5);
            boolean bl3 = bl ? by < by2 : (bl2 = by > by2);
            if (bl3) {
                n5 = 1;
                n3 = (n2 += n5) - n4;
                continue;
            }
            if (by == by2) {
                if (n5 != n3) {
                    ++n5;
                    continue;
                }
                n2 += n3;
                n5 = 1;
                continue;
            }
            n4 = n2;
            n2 = n4 + 1;
            n3 = 1;
            n5 = 1;
        }
        return ((long)n4 << 32) + (long)n3;
    }

    public static boolean equals(ByteBuf byteBuf, int n, ByteBuf byteBuf2, int n2, int n3) {
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"a");
        ObjectUtil.checkNotNull((Object)byteBuf2, (String)"b");
        ObjectUtil.checkPositiveOrZero((int)n, (String)"aStartIndex");
        ObjectUtil.checkPositiveOrZero((int)n2, (String)"bStartIndex");
        ObjectUtil.checkPositiveOrZero((int)n3, (String)"length");
        if (byteBuf.writerIndex() - n3 < n || byteBuf2.writerIndex() - n3 < n2) {
            return false;
        }
        int n4 = n3 >>> 3;
        n3 &= 7;
        if (byteBuf.order() == byteBuf2.order()) {
            while (n4 > 0) {
                if (byteBuf.getLong(n) != byteBuf2.getLong(n2)) {
                    return false;
                }
                n += 8;
                n2 += 8;
                --n4;
            }
        } else {
            while (n4 > 0) {
                if (byteBuf.getLong(n) != ByteBufUtil.swapLong(byteBuf2.getLong(n2))) {
                    return false;
                }
                n += 8;
                n2 += 8;
                --n4;
            }
        }
        for (n4 = n3; n4 > 0; --n4) {
            if (byteBuf.getByte(n) != byteBuf2.getByte(n2)) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public static boolean equals(ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (byteBuf == byteBuf2) {
            return true;
        }
        int n = byteBuf.readableBytes();
        if (n != byteBuf2.readableBytes()) {
            return false;
        }
        ByteBuf byteBuf3 = byteBuf;
        ByteBuf byteBuf4 = byteBuf2;
        return ByteBufUtil.equals(byteBuf3, byteBuf3.readerIndex(), byteBuf4, byteBuf4.readerIndex(), n);
    }

    public static int compare(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n;
        if (byteBuf == byteBuf2) {
            return 0;
        }
        int n2 = byteBuf.readableBytes();
        int n3 = byteBuf2.readableBytes();
        int n4 = Math.min(n2, n3);
        int n5 = n4 >>> 2;
        n4 &= 3;
        int n6 = byteBuf.readerIndex();
        int n7 = byteBuf2.readerIndex();
        if (n5 > 0) {
            long l;
            n = byteBuf.order() == ByteOrder.BIG_ENDIAN ? 1 : 0;
            n5 <<= 2;
            if (byteBuf.order() == byteBuf2.order()) {
                l = n != 0 ? ByteBufUtil.compareUintBigEndian(byteBuf, byteBuf2, n6, n7, n5) : ByteBufUtil.compareUintLittleEndian(byteBuf, byteBuf2, n6, n7, n5);
            } else {
                long l2 = l = n != 0 ? ByteBufUtil.compareUintBigEndianA(byteBuf, byteBuf2, n6, n7, n5) : ByteBufUtil.compareUintBigEndianB(byteBuf, byteBuf2, n6, n7, n5);
            }
            if (l != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, l));
            }
            n6 += n5;
            n7 += n5;
        }
        n = n6 + n4;
        while (n6 < n) {
            int n8 = byteBuf.getUnsignedByte(n6) - byteBuf2.getUnsignedByte(n7);
            if (n8 != 0) {
                return n8;
            }
            ++n6;
            ++n7;
        }
        return n2 - n3;
    }

    private static long compareUintBigEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        n3 = n + n3;
        while (n < n3) {
            long l = byteBuf.getUnsignedInt(n) - byteBuf2.getUnsignedInt(n2);
            if (l != 0L) {
                return l;
            }
            n += 4;
            n2 += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        n3 = n + n3;
        while (n < n3) {
            long l = ByteBufUtil.uintFromLE(byteBuf.getUnsignedIntLE(n)) - ByteBufUtil.uintFromLE(byteBuf2.getUnsignedIntLE(n2));
            if (l != 0L) {
                return l;
            }
            n += 4;
            n2 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        n3 = n + n3;
        while (n < n3) {
            long l;
            long l2 = byteBuf.getUnsignedInt(n);
            long l3 = l2 - (l = ByteBufUtil.uintFromLE(byteBuf2.getUnsignedIntLE(n2)));
            if (l3 != 0L) {
                return l3;
            }
            n += 4;
            n2 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        n3 = n + n3;
        while (n < n3) {
            long l;
            long l2 = ByteBufUtil.uintFromLE(byteBuf.getUnsignedIntLE(n));
            long l3 = l2 - (l = byteBuf2.getUnsignedInt(n2));
            if (l3 != 0L) {
                return l3;
            }
            n += 4;
            n2 += 4;
        }
        return 0L;
    }

    private static long uintFromLE(long l) {
        return Long.reverseBytes(l) >>> 32;
    }

    private static int unrolledFirstIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        assert (n2 > 0 && n2 < 8);
        if (abstractByteBuf._getByte(n) == by) {
            return n;
        }
        if (n2 == 1) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 1) == by) {
            return n + 1;
        }
        if (n2 == 2) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 2) == by) {
            return n + 2;
        }
        if (n2 == 3) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 3) == by) {
            return n + 3;
        }
        if (n2 == 4) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 4) == by) {
            return n + 4;
        }
        if (n2 == 5) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 5) == by) {
            return n + 5;
        }
        if (n2 == 6) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 6) == by) {
            return n + 6;
        }
        return -1;
    }

    static int firstIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        int n3;
        if ((n = Math.max(n, 0)) >= n2 || abstractByteBuf.capacity() == 0) {
            return -1;
        }
        int n4 = n2 - n;
        abstractByteBuf.checkIndex(n, n4);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearFirstIndexOf(abstractByteBuf, n, n2, by);
        }
        assert (PlatformDependent.isUnaligned());
        int n5 = n;
        int n6 = n4 & 7;
        if (n6 > 0) {
            n3 = ByteBufUtil.unrolledFirstIndexOf(abstractByteBuf, n, n6, by);
            if (n3 != -1) {
                return n3;
            }
            n5 = n + n6;
            if (n5 == n2) {
                return -1;
            }
        }
        n3 = n4 >>> 3;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        n2 = byteOrder == abstractByteBuf.order() ? 1 : 0;
        boolean bl = byteOrder == ByteOrder.LITTLE_ENDIAN;
        long l = SWARUtil.compilePattern((byte)by);
        for (by = 0; by < n3; by = (byte)(by + 1)) {
            long l2 = bl ? abstractByteBuf._getLongLE(n5) : abstractByteBuf._getLong(n5);
            long l3 = SWARUtil.applyPattern((long)l2, (long)l);
            if (l3 != 0L) {
                return n5 + SWARUtil.getIndex((long)l3, n2 != 0);
            }
            n5 += 8;
        }
        return -1;
    }

    private static int linearFirstIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        while (n < n2) {
            if (abstractByteBuf._getByte(n) == by) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int indexOf(ByteBuf byteBuf, int n, int n2, byte by) {
        return byteBuf.indexOf(n, n2, by);
    }

    public static short swapShort(short s) {
        return Short.reverseBytes(s);
    }

    public static int swapMedium(int n) {
        if (((n = n << 16 & 0xFF0000 | n & 0xFF00 | n >>> 16 & 0xFF) & 0x800000) != 0) {
            n |= 0xFF000000;
        }
        return n;
    }

    public static int swapInt(int n) {
        return Integer.reverseBytes(n);
    }

    public static long swapLong(long l) {
        return Long.reverseBytes(l);
    }

    public static ByteBuf writeShortBE(ByteBuf byteBuf, int n) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.writeShort(n);
        }
        return byteBuf.writeShort(ByteBufUtil.swapShort((short)n));
    }

    public static ByteBuf setShortBE(ByteBuf byteBuf, int n, int n2) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.setShort(n, n2);
        }
        return byteBuf.setShort(n, ByteBufUtil.swapShort((short)n2));
    }

    public static ByteBuf writeMediumBE(ByteBuf byteBuf, int n) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.writeMedium(n);
        }
        return byteBuf.writeMedium(ByteBufUtil.swapMedium(n));
    }

    public static int readUnsignedShortBE(ByteBuf byteBuf) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.readUnsignedShort();
        }
        return ByteBufUtil.swapShort((short)byteBuf.readUnsignedShort()) & 0xFFFF;
    }

    public static int readIntBE(ByteBuf byteBuf) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.readInt();
        }
        return ByteBufUtil.swapInt(byteBuf.readInt());
    }

    public static ByteBuf readBytes(ByteBufAllocator object, ByteBuf object2, int n) {
        boolean bl = true;
        object = object.buffer(n);
        try {
            ((ByteBuf)object2).readBytes((ByteBuf)object);
            bl = false;
            object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (bl) {
                object.release();
            }
            throw throwable;
        }
    }

    static int lastIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        assert (n > n2);
        int n3 = abstractByteBuf.capacity();
        if ((n = Math.min(n, n3)) <= 0) {
            return -1;
        }
        n3 = n - n2;
        abstractByteBuf.checkIndex(n2, n3);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearLastIndexOf(abstractByteBuf, n, n2, by);
        }
        n2 = n3 >>> 3;
        if (n2 > 0) {
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            boolean bl = byteOrder == abstractByteBuf.order();
            boolean bl2 = byteOrder == ByteOrder.LITTLE_ENDIAN;
            long l = SWARUtil.compilePattern((byte)by);
            int n4 = 0;
            int n5 = n - 8;
            while (n4 < n2) {
                long l2 = bl2 ? abstractByteBuf._getLongLE(n5) : abstractByteBuf._getLong(n5);
                long l3 = SWARUtil.applyPattern((long)l2, (long)l);
                if (l3 != 0L) {
                    return n5 + 8 - 1 - SWARUtil.getIndex((long)l3, (!bl ? 1 : 0) != 0);
                }
                ++n4;
                n5 -= 8;
            }
        }
        return ByteBufUtil.unrolledLastIndexOf(abstractByteBuf, n - (n2 << 3), n3 & 7, by);
    }

    private static int linearLastIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        --n;
        while (n >= n2) {
            if (abstractByteBuf._getByte(n) == by) {
                return n;
            }
            --n;
        }
        return -1;
    }

    private static int unrolledLastIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        assert (n2 >= 0 && n2 < 8);
        if (n2 == 0) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 1) == by) {
            return n - 1;
        }
        if (n2 == 1) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 2) == by) {
            return n - 2;
        }
        if (n2 == 2) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 3) == by) {
            return n - 3;
        }
        if (n2 == 3) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 4) == by) {
            return n - 4;
        }
        if (n2 == 4) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 5) == by) {
            return n - 5;
        }
        if (n2 == 5) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 6) == by) {
            return n - 6;
        }
        if (n2 == 6) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 7) == by) {
            return n - 7;
        }
        return -1;
    }

    private static CharSequence checkCharSequenceBounds(CharSequence charSequence, int n, int n2) {
        if (MathUtil.isOutOfBounds((int)n, (int)(n2 - n), (int)charSequence.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n + ") <= end (" + n2 + ") <= seq.length(" + charSequence.length() + ')');
        }
        return charSequence;
    }

    public static ByteBuf writeUtf8(ByteBufAllocator object, CharSequence charSequence) {
        object = object.buffer(ByteBufUtil.utf8MaxBytes(charSequence));
        ByteBufUtil.writeUtf8((ByteBuf)object, charSequence);
        return object;
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence) {
        int n;
        int n2 = n = charSequence.length();
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, 0, n2, ByteBufUtil.utf8MaxBytes(n2));
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence, int n, int n2) {
        ByteBufUtil.checkCharSequenceBounds(charSequence, n, n2);
        int n3 = n2;
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, n, n3, ByteBufUtil.utf8MaxBytes(n3 - n));
    }

    public static int reserveAndWriteUtf8(ByteBuf byteBuf, CharSequence charSequence, int n) {
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, 0, charSequence.length(), n);
    }

    public static int reserveAndWriteUtf8(ByteBuf byteBuf, CharSequence charSequence, int n, int n2, int n3) {
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, ByteBufUtil.checkCharSequenceBounds(charSequence, n, n2), n, n2, n3);
    }

    private static int reserveAndWriteUtf8Seq(ByteBuf byteBuf, CharSequence charSequence, int n, int n2, int n3) {
        while (true) {
            if (byteBuf instanceof WrappedCompositeByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            if (byteBuf instanceof AbstractByteBuf) {
                AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                abstractByteBuf.ensureWritable0(n3);
                AbstractByteBuf abstractByteBuf2 = abstractByteBuf;
                int n4 = ByteBufUtil.writeUtf8(abstractByteBuf2, abstractByteBuf2.writerIndex, n3, charSequence, n, n2);
                abstractByteBuf.writerIndex += n4;
                return n4;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.subSequence(n, n2).toString().getBytes(CharsetUtil.UTF_8);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n, int n2, CharSequence charSequence, int n3) {
        return ByteBufUtil.writeUtf8(abstractByteBuf, n, n2, charSequence, 0, n3);
    }

    static int writeUtf8(AbstractByteBuf comparable, int n, int n2, CharSequence charSequence, int n3, int n4) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(comparable, n, (AsciiString)charSequence, n3, n4);
            return n4 - n3;
        }
        if (PlatformDependent.hasUnsafe()) {
            if (comparable.hasArray()) {
                return ByteBufUtil.unsafeWriteUtf8(comparable.array(), PlatformDependent.byteArrayBaseOffset(), comparable.arrayOffset() + n, charSequence, n3, n4);
            }
            if (comparable.hasMemoryAddress()) {
                return ByteBufUtil.unsafeWriteUtf8(null, comparable.memoryAddress(), n, charSequence, n3, n4);
            }
        } else {
            if (comparable.hasArray()) {
                return ByteBufUtil.safeArrayWriteUtf8(comparable.array(), comparable.arrayOffset() + n, charSequence, n3, n4);
            }
            if (comparable.isDirect()) {
                assert (comparable.nioBufferCount() == 1);
                comparable = comparable.internalNioBuffer(n, n2);
                n = ((Buffer)((Object)comparable)).position();
                return ByteBufUtil.safeDirectWriteUtf8((ByteBuffer)comparable, n, charSequence, n3, n4);
            }
        }
        return ByteBufUtil.safeWriteUtf8(comparable, n, charSequence, n3, n4);
    }

    static void writeAsciiString(AbstractByteBuf abstractByteBuf, int n, AsciiString asciiString, int n2, int n3) {
        int n4 = asciiString.arrayOffset() + n2;
        n2 = n3 - n2;
        if (PlatformDependent.hasUnsafe()) {
            if (abstractByteBuf.hasArray()) {
                PlatformDependent.copyMemory((byte[])asciiString.array(), (int)n4, (byte[])abstractByteBuf.array(), (int)(abstractByteBuf.arrayOffset() + n), (long)n2);
                return;
            }
            if (abstractByteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory((byte[])asciiString.array(), (int)n4, (long)(abstractByteBuf.memoryAddress() + (long)n), (long)n2);
                return;
            }
        }
        if (abstractByteBuf.hasArray()) {
            System.arraycopy(asciiString.array(), n4, abstractByteBuf.array(), abstractByteBuf.arrayOffset() + n, n2);
            return;
        }
        abstractByteBuf.setBytes(n, asciiString.array(), n4, n2);
    }

    private static int safeDirectWriteUtf8(ByteBuffer byteBuffer, int n, CharSequence charSequence, int n2, int n3) {
        assert (!(charSequence instanceof AsciiString));
        int n4 = n;
        while (n2 < n3) {
            int n5 = charSequence.charAt(n2);
            if (n5 < 128) {
                byteBuffer.put(n++, (byte)n5);
            } else if (n5 < 2048) {
                byteBuffer.put(n++, (byte)(0xC0 | n5 >> 6));
                byteBuffer.put(n++, (byte)(0x80 | n5 & 0x3F));
            } else if (StringUtil.isSurrogate((char)n5)) {
                if (!Character.isHighSurrogate((char)n5)) {
                    byteBuffer.put(n++, (byte)63);
                } else {
                    if (++n2 == n3) {
                        byteBuffer.put(n++, (byte)63);
                        break;
                    }
                    char c = charSequence.charAt(n2);
                    if (!Character.isLowSurrogate(c)) {
                        byteBuffer.put(n++, (byte)63);
                        byteBuffer.put(n++, (byte)(Character.isHighSurrogate(c) ? 63 : (byte)c));
                    } else {
                        n5 = Character.toCodePoint((char)n5, c);
                        byteBuffer.put(n++, (byte)(0xF0 | n5 >> 18));
                        byteBuffer.put(n++, (byte)(0x80 | n5 >> 12 & 0x3F));
                        byteBuffer.put(n++, (byte)(0x80 | n5 >> 6 & 0x3F));
                        byteBuffer.put(n++, (byte)(0x80 | n5 & 0x3F));
                    }
                }
            } else {
                byteBuffer.put(n++, (byte)(0xE0 | n5 >> 12));
                byteBuffer.put(n++, (byte)(0x80 | n5 >> 6 & 0x3F));
                byteBuffer.put(n++, (byte)(0x80 | n5 & 0x3F));
            }
            ++n2;
        }
        return n - n4;
    }

    private static int safeWriteUtf8(AbstractByteBuf abstractByteBuf, int n, CharSequence charSequence, int n2, int n3) {
        assert (!(charSequence instanceof AsciiString));
        int n4 = n;
        while (n2 < n3) {
            int n5 = charSequence.charAt(n2);
            if (n5 < 128) {
                abstractByteBuf._setByte(n++, (byte)n5);
            } else if (n5 < 2048) {
                abstractByteBuf._setByte(n++, (byte)(0xC0 | n5 >> 6));
                abstractByteBuf._setByte(n++, (byte)(0x80 | n5 & 0x3F));
            } else if (StringUtil.isSurrogate((char)n5)) {
                if (!Character.isHighSurrogate((char)n5)) {
                    abstractByteBuf._setByte(n++, 63);
                } else {
                    if (++n2 == n3) {
                        abstractByteBuf._setByte(n++, 63);
                        break;
                    }
                    char c = charSequence.charAt(n2);
                    if (!Character.isLowSurrogate(c)) {
                        abstractByteBuf._setByte(n++, 63);
                        abstractByteBuf._setByte(n++, Character.isHighSurrogate(c) ? 63 : (int)c);
                    } else {
                        n5 = Character.toCodePoint((char)n5, c);
                        abstractByteBuf._setByte(n++, (byte)(0xF0 | n5 >> 18));
                        abstractByteBuf._setByte(n++, (byte)(0x80 | n5 >> 12 & 0x3F));
                        abstractByteBuf._setByte(n++, (byte)(0x80 | n5 >> 6 & 0x3F));
                        abstractByteBuf._setByte(n++, (byte)(0x80 | n5 & 0x3F));
                    }
                }
            } else {
                abstractByteBuf._setByte(n++, (byte)(0xE0 | n5 >> 12));
                abstractByteBuf._setByte(n++, (byte)(0x80 | n5 >> 6 & 0x3F));
                abstractByteBuf._setByte(n++, (byte)(0x80 | n5 & 0x3F));
            }
            ++n2;
        }
        return n - n4;
    }

    private static int safeArrayWriteUtf8(byte[] byArray, int n, CharSequence charSequence, int n2, int n3) {
        int n4 = n;
        while (n2 < n3) {
            int n5 = charSequence.charAt(n2);
            if (n5 < 128) {
                byArray[n++] = (byte)n5;
            } else if (n5 < 2048) {
                byArray[n++] = (byte)(0xC0 | n5 >> 6);
                byArray[n++] = (byte)(0x80 | n5 & 0x3F);
            } else if (StringUtil.isSurrogate((char)n5)) {
                if (!Character.isHighSurrogate((char)n5)) {
                    byArray[n++] = 63;
                } else {
                    if (++n2 == n3) {
                        byArray[n++] = 63;
                        break;
                    }
                    char c = charSequence.charAt(n2);
                    if (!Character.isLowSurrogate(c)) {
                        byArray[n++] = 63;
                        byArray[n++] = (byte)(Character.isHighSurrogate(c) ? 63 : (int)c);
                    } else {
                        n5 = Character.toCodePoint((char)n5, c);
                        byArray[n++] = (byte)(0xF0 | n5 >> 18);
                        byArray[n++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                        byArray[n++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                        byArray[n++] = (byte)(0x80 | n5 & 0x3F);
                    }
                }
            } else {
                byArray[n++] = (byte)(0xE0 | n5 >> 12);
                byArray[n++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n++] = (byte)(0x80 | n5 & 0x3F);
            }
            ++n2;
        }
        return n - n4;
    }

    private static int unsafeWriteUtf8(byte[] byArray, long l, int n, CharSequence charSequence, int n2, int n3) {
        long l2;
        assert (!(charSequence instanceof AsciiString));
        long l3 = l2 = l + (long)n;
        for (int i = n2; i < n3; ++i) {
            int n4 = charSequence.charAt(i);
            if (n4 < 128) {
                PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)n4));
                continue;
            }
            if (n4 < 2048) {
                PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0xC0 | n4 >> 6)));
                PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0x80 | n4 & 0x3F)));
                continue;
            }
            if (StringUtil.isSurrogate((char)n4)) {
                if (!Character.isHighSurrogate((char)n4)) {
                    PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)63);
                    continue;
                }
                if (++i == n3) {
                    PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)63);
                    break;
                }
                char c = charSequence.charAt(i);
                n = c;
                if (!Character.isLowSurrogate(c)) {
                    PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)63);
                    PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(Character.isHighSurrogate((char)n) ? 63 : n)));
                    continue;
                }
                n4 = Character.toCodePoint((char)n4, (char)n);
                PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0xF0 | n4 >> 18)));
                PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0x80 | n4 >> 12 & 0x3F)));
                PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0x80 | n4 >> 6 & 0x3F)));
                PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0x80 | n4 & 0x3F)));
                continue;
            }
            PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0xE0 | n4 >> 12)));
            PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0x80 | n4 >> 6 & 0x3F)));
            PlatformDependent.putByte((Object)byArray, (long)l2++, (byte)((byte)(0x80 | n4 & 0x3F)));
        }
        return (int)(l2 - l3);
    }

    public static int utf8MaxBytes(int n) {
        return n * MAX_BYTES_PER_CHAR_UTF8;
    }

    public static int utf8MaxBytes(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return charSequence.length();
        }
        return ByteBufUtil.utf8MaxBytes(charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence) {
        return ByteBufUtil.utf8ByteCount(charSequence, 0, charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence, int n, int n2) {
        return ByteBufUtil.utf8ByteCount(ByteBufUtil.checkCharSequenceBounds(charSequence, n, n2), n, n2);
    }

    private static int utf8ByteCount(CharSequence charSequence, int n, int n2) {
        int n3;
        if (charSequence instanceof AsciiString) {
            return n2 - n;
        }
        for (n3 = n; n3 < n2 && charSequence.charAt(n3) < '\u0080'; ++n3) {
        }
        if (n3 < n2) {
            return n3 - n + ByteBufUtil.utf8BytesNonAscii(charSequence, n3, n2);
        }
        return n3 - n;
    }

    private static int utf8BytesNonAscii(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += (127 - c >>> 31) + 1;
            } else if (StringUtil.isSurrogate((char)c)) {
                if (!Character.isHighSurrogate(c)) {
                    ++n3;
                } else {
                    if (++n == n2) {
                        ++n3;
                        break;
                    }
                    n3 = !Character.isLowSurrogate(charSequence.charAt(n)) ? (n3 += 2) : (n3 += 4);
                }
            } else {
                n3 += 3;
            }
            ++n;
        }
        return n3;
    }

    public static ByteBuf writeAscii(ByteBufAllocator object, CharSequence charSequence) {
        object = object.buffer(charSequence.length());
        ByteBufUtil.writeAscii((ByteBuf)object, charSequence);
        return object;
    }

    public static int writeAscii(ByteBuf byteBuf, CharSequence charSequence) {
        while (true) {
            if (byteBuf instanceof WrappedCompositeByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            if (byteBuf instanceof AbstractByteBuf) {
                int n = charSequence.length();
                byteBuf = (AbstractByteBuf)byteBuf;
                ((AbstractByteBuf)byteBuf).ensureWritable0(n);
                if (charSequence instanceof AsciiString) {
                    ByteBuf byteBuf2 = byteBuf;
                    ByteBufUtil.writeAsciiString((AbstractByteBuf)byteBuf2, ((AbstractByteBuf)byteBuf2).writerIndex, (AsciiString)charSequence, 0, n);
                } else {
                    ByteBuf byteBuf3 = byteBuf;
                    int n2 = ByteBufUtil.writeAscii((AbstractByteBuf)byteBuf3, ((AbstractByteBuf)byteBuf3).writerIndex, charSequence, n);
                    assert (n2 == n);
                }
                ((AbstractByteBuf)byteBuf).writerIndex += n;
                return n;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.toString().getBytes(CharsetUtil.US_ASCII);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeAscii(AbstractByteBuf abstractByteBuf, int n, CharSequence charSequence, int n2) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(abstractByteBuf, n, (AsciiString)charSequence, 0, n2);
        } else {
            ByteBufUtil.writeAsciiCharSequence(abstractByteBuf, n, charSequence, n2);
        }
        return n2;
    }

    private static int writeAsciiCharSequence(AbstractByteBuf abstractByteBuf, int n, CharSequence charSequence, int n2) {
        for (int i = 0; i < n2; ++i) {
            abstractByteBuf._setByte(n++, AsciiString.c2b((char)charSequence.charAt(i)));
        }
        return n2;
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset, 0);
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset, int n) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset, n);
    }

    static ByteBuf encodeString0(ByteBufAllocator object, boolean bl, CharBuffer object2, Charset object3, int n) {
        object3 = CharsetUtil.encoder((Charset)object3);
        n = (int)((double)((Buffer)object2).remaining() * (double)((CharsetEncoder)object3).maxBytesPerChar()) + n;
        boolean bl2 = true;
        object = bl ? object.heapBuffer(n) : object.buffer(n);
        try {
            Object object4 = object;
            Object object5 = ((ByteBuf)object4).internalNioBuffer(((ByteBuf)object4).readerIndex(), n);
            n = ((Buffer)object5).position();
            object2 = ((CharsetEncoder)object3).encode((CharBuffer)object2, (ByteBuffer)object5, true);
            if (!((CoderResult)object2).isUnderflow()) {
                ((CoderResult)object2).throwException();
            }
            if (!((CoderResult)(object2 = ((CharsetEncoder)object3).flush((ByteBuffer)object5))).isUnderflow()) {
                ((CoderResult)object2).throwException();
            }
            Object object6 = object;
            ((ByteBuf)object6).writerIndex(((ByteBuf)object6).writerIndex() + ((Buffer)object5).position() - n);
            bl2 = false;
            object5 = object;
            return object5;
        }
        catch (CharacterCodingException characterCodingException) {
            try {
                throw new IllegalStateException(characterCodingException);
            }
            catch (Throwable throwable) {
                if (bl2) {
                    object.release();
                }
                throw throwable;
            }
        }
    }

    static String decodeString(ByteBuf byteBuf, int n, int n2, Charset charset) {
        int n3;
        byte[] byArray;
        if (n2 == 0) {
            return "";
        }
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n3 = byteBuf.arrayOffset() + n;
        } else {
            byArray = ByteBufUtil.threadLocalTempArray(n2);
            n3 = 0;
            byteBuf.getBytes(n, byArray, 0, n2);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return new String(byArray, 0, n3, n2);
        }
        return new String(byArray, n3, n2, charset);
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ThreadLocalDirectByteBuf.newInstance();
    }

    public static byte[] getBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.getBytes(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n, int n2) {
        return ByteBufUtil.getBytes(byteBuf, n, n2, true);
    }

    public static byte[] getBytes(ByteBuf object, int n, int n2, boolean bl) {
        int n3 = ((ByteBuf)object).capacity();
        if (MathUtil.isOutOfBounds((int)n, (int)n2, (int)n3)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n + ") <= start + length(" + n2 + ") <= buf.capacity(" + n3 + ')');
        }
        if (((ByteBuf)object).hasArray()) {
            n3 = ((ByteBuf)object).arrayOffset() + n;
            object = ((ByteBuf)object).array();
            if (bl || n3 != 0 || n2 != ((Object)object).length) {
                int n4 = n3;
                return Arrays.copyOfRange((byte[])object, n4, n4 + n2);
            }
            return object;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray((int)n2);
        ((ByteBuf)object).getBytes(n, byArray);
        return byArray;
    }

    public static void copy(AsciiString asciiString, ByteBuf byteBuf) {
        ByteBufUtil.copy(asciiString, 0, byteBuf, asciiString.length());
    }

    public static void copy(AsciiString asciiString, int n, ByteBuf byteBuf, int n2, int n3) {
        if (MathUtil.isOutOfBounds((int)n, (int)n3, (int)asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n + ") <= srcIdx + length(" + n3 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ((ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"dst")).setBytes(n2, asciiString.array(), n + asciiString.arrayOffset(), n3);
    }

    public static void copy(AsciiString asciiString, int n, ByteBuf byteBuf, int n2) {
        if (MathUtil.isOutOfBounds((int)n, (int)n2, (int)asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n + ") <= srcIdx + length(" + n2 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ((ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"dst")).writeBytes(asciiString.array(), n + asciiString.arrayOffset(), n2);
    }

    public static String prettyHexDump(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.prettyHexDump(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static String prettyHexDump(ByteBuf byteBuf, int n, int n2) {
        return HexUtil.prettyHexDump(byteBuf, n, n2);
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ByteBufUtil.appendPrettyHexDump(stringBuilder, byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n, int n2) {
        HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n, n2);
    }

    public static boolean isText(ByteBuf byteBuf, Charset charset) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.isText(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes(), charset);
    }

    public static boolean isText(ByteBuf byteBuf, int n, int n2, Charset object) {
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"buf");
        ObjectUtil.checkNotNull((Object)object, (String)"charset");
        int n3 = byteBuf.readerIndex() + byteBuf.readableBytes();
        if (n < 0 || n2 < 0 || n > n3 - n2) {
            throw new IndexOutOfBoundsException("index: " + n + " length: " + n2);
        }
        if (((Charset)object).equals(CharsetUtil.UTF_8)) {
            return ByteBufUtil.isUtf8(byteBuf, n, n2);
        }
        if (((Charset)object).equals(CharsetUtil.US_ASCII)) {
            return ByteBufUtil.isAscii(byteBuf, n, n2);
        }
        CodingErrorAction codingErrorAction = CodingErrorAction.REPORT;
        object = CharsetUtil.decoder((Charset)object, (CodingErrorAction)codingErrorAction, (CodingErrorAction)codingErrorAction);
        try {
            if (byteBuf.nioBufferCount() == 1) {
                ((CharsetDecoder)object).decode(byteBuf.nioBuffer(n, n2));
            } else {
                ByteBuf byteBuf2 = byteBuf.alloc().heapBuffer(n2);
                try {
                    byteBuf2.writeBytes(byteBuf, n, n2);
                    ByteBuf byteBuf3 = byteBuf2;
                    ((CharsetDecoder)object).decode(byteBuf3.internalNioBuffer(byteBuf3.readerIndex(), n2));
                }
                finally {
                    byteBuf2.release();
                }
            }
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    private static boolean isAscii(ByteBuf byteBuf, int n, int n2) {
        return byteBuf.forEachByte(n, n2, FIND_NON_ASCII) == -1;
    }

    private static boolean isUtf8(ByteBuf byteBuf, int n, int n2) {
        n2 = n + n2;
        while (n < n2) {
            byte by;
            byte by2;
            byte by3;
            if (((by3 = byteBuf.getByte(n++)) & 0x80) == 0) continue;
            if ((by3 & 0xE0) == 192) {
                if (n >= n2) {
                    return false;
                }
                if (((by2 = byteBuf.getByte(n++)) & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xFF) >= 194) continue;
                return false;
            }
            if ((by3 & 0xF0) == 224) {
                if (n > n2 - 2) {
                    return false;
                }
                by2 = byteBuf.getByte(n++);
                by = byteBuf.getByte(n++);
                if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xF) == 0 && (by2 & 0xFF) < 160) {
                    return false;
                }
                if ((by3 & 0xF) != 13 || (by2 & 0xFF) <= 159) continue;
                return false;
            }
            if ((by3 & 0xF8) == 240) {
                if (n > n2 - 3) {
                    return false;
                }
                by2 = byteBuf.getByte(n++);
                by = byteBuf.getByte(n++);
                byte by4 = byteBuf.getByte(n++);
                if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128 || (by4 & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xFF) <= 244 && ((by3 & 0xFF) != 240 || (by2 & 0xFF) >= 144) && ((by3 & 0xFF) != 244 || (by2 & 0xFF) <= 143)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    static void readBytes(ByteBufAllocator object, ByteBuffer byteBuffer, int n, int n2, OutputStream outputStream) {
        if (byteBuffer.hasArray()) {
            outputStream.write(byteBuffer.array(), n + byteBuffer.arrayOffset(), n2);
            return;
        }
        int n3 = Math.min(n2, 8192);
        byteBuffer.clear().position(n);
        if (n2 <= 1024 || !object.isDirectBufferPooled()) {
            ByteBufUtil.getBytes(byteBuffer, ByteBufUtil.threadLocalTempArray(n3), 0, n3, outputStream, n2);
            return;
        }
        object = object.heapBuffer(n3);
        try {
            byte[] byArray = ((ByteBuf)object).array();
            int n4 = ((ByteBuf)object).arrayOffset();
            ByteBufUtil.getBytes(byteBuffer, byArray, n4, n3, outputStream, n2);
            return;
        }
        finally {
            object.release();
        }
    }

    private static void getBytes(ByteBuffer byteBuffer, byte[] byArray, int n, int n2, OutputStream outputStream, int n3) {
        int n4;
        do {
            n4 = Math.min(n2, n3);
            byteBuffer.get(byArray, n, n4);
            outputStream.write(byArray, n, n4);
        } while ((n3 -= n4) > 0);
    }

    public static void setLeakListener(ResourceLeakDetector.LeakListener leakListener) {
        AbstractByteBuf.leakDetector.setLeakListener(leakListener);
    }

    private ByteBufUtil() {
    }

    static {
        AbstractByteBufAllocator abstractByteBufAllocator;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        BYTE_ARRAYS = new FastThreadLocal<byte[]>(){

            protected final byte[] initialValue() {
                return PlatformDependent.allocateUninitializedArray((int)1024);
            }
        };
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder((Charset)CharsetUtil.UTF_8).maxBytesPerChar();
        String string = SystemPropertyUtil.get((String)"io.netty.allocator.type", (String)(PlatformDependent.isAndroid() ? "unpooled" : "pooled"));
        if ("unpooled".equals(string)) {
            abstractByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("pooled".equals(string)) {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("adaptive".equals(string)) {
            abstractByteBufAllocator = new AdaptiveByteBufAllocator();
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: pooled (unknown: {})", (Object)string);
        }
        DEFAULT_ALLOCATOR = abstractByteBufAllocator;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt((String)"io.netty.threadLocalDirectBufferSize", (int)0);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt((String)"io.netty.maxThreadLocalCharBufferSize", (int)16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteProcessor(){

            public final boolean process(byte by) {
                return by >= 0;
            }
        };
    }

    static final class ThreadLocalDirectByteBuf
    extends UnpooledDirectByteBuf {
        private static final ObjectPool<ThreadLocalDirectByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<ThreadLocalDirectByteBuf>(){

            public final ThreadLocalDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle) {
                return new ThreadLocalDirectByteBuf(handle);
            }
        });
        private final Recycler.EnhancedHandle<ThreadLocalDirectByteBuf> handle;

        static ThreadLocalDirectByteBuf newInstance() {
            ThreadLocalDirectByteBuf threadLocalDirectByteBuf = (ThreadLocalDirectByteBuf)RECYCLER.get();
            threadLocalDirectByteBuf.resetRefCnt();
            return threadLocalDirectByteBuf;
        }

        private ThreadLocalDirectByteBuf(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            this.handle = (Recycler.EnhancedHandle)handle;
        }

        @Override
        protected final void deallocate() {
            if (((ByteBuf)this).capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
                return;
            }
            ((ByteBuf)this).clear();
            this.handle.unguardedRecycle((Object)this);
        }
    }

    static final class ThreadLocalUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        private static final ObjectPool<ThreadLocalUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<ThreadLocalUnsafeDirectByteBuf>(){

            public final ThreadLocalUnsafeDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle) {
                return new ThreadLocalUnsafeDirectByteBuf(handle);
            }
        });
        private final Recycler.EnhancedHandle<ThreadLocalUnsafeDirectByteBuf> handle;

        static ThreadLocalUnsafeDirectByteBuf newInstance() {
            ThreadLocalUnsafeDirectByteBuf threadLocalUnsafeDirectByteBuf = (ThreadLocalUnsafeDirectByteBuf)RECYCLER.get();
            threadLocalUnsafeDirectByteBuf.resetRefCnt();
            return threadLocalUnsafeDirectByteBuf;
        }

        private ThreadLocalUnsafeDirectByteBuf(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            this.handle = (Recycler.EnhancedHandle)handle;
        }

        @Override
        protected final void deallocate() {
            if (((ByteBuf)this).capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
                return;
            }
            ((ByteBuf)this).clear();
            this.handle.unguardedRecycle((Object)this);
        }
    }

    private static final class HexUtil {
        private static final char[] BYTE2CHAR;
        private static final char[] HEXDUMP_TABLE;
        private static final String[] HEXPADDING;
        private static final String[] HEXDUMP_ROWPREFIXES;
        private static final String[] BYTE2HEX;
        private static final String[] BYTEPADDING;

        private HexUtil() {
        }

        private static String hexDump(ByteBuf byteBuf, int n, int n2) {
            ObjectUtil.checkPositiveOrZero((int)n2, (String)"length");
            if (n2 == 0) {
                return "";
            }
            int n3 = n + n2;
            char[] cArray = new char[n2 << 1];
            int n4 = 0;
            while (n < n3) {
                System.arraycopy(HEXDUMP_TABLE, byteBuf.getUnsignedByte(n) << 1, cArray, n4, 2);
                ++n;
                n4 += 2;
            }
            return new String(cArray);
        }

        private static String hexDump(byte[] byArray, int n, int n2) {
            ObjectUtil.checkPositiveOrZero((int)n2, (String)"length");
            if (n2 == 0) {
                return "";
            }
            int n3 = n + n2;
            char[] cArray = new char[n2 << 1];
            int n4 = 0;
            while (n < n3) {
                System.arraycopy(HEXDUMP_TABLE, (byArray[n] & 0xFF) << 1, cArray, n4, 2);
                ++n;
                n4 += 2;
            }
            return new String(cArray);
        }

        private static String prettyHexDump(ByteBuf byteBuf, int n, int n2) {
            if (n2 == 0) {
                return "";
            }
            int n3 = n2 / 16 + ((n2 & 0xF) == 0 ? 0 : 1) + 4;
            StringBuilder stringBuilder = new StringBuilder(n3 * 80);
            HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n, n2);
            return stringBuilder.toString();
        }

        private static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n, int n2) {
            int n3;
            int n4;
            int n5;
            if (MathUtil.isOutOfBounds((int)n, (int)n2, (int)byteBuf.capacity())) {
                throw new IndexOutOfBoundsException("expected: 0 <= offset(" + n + ") <= offset + length(" + n2 + ") <= buf.capacity(" + byteBuf.capacity() + ')');
            }
            if (n2 == 0) {
                return;
            }
            stringBuilder.append("         +-------------------------------------------------+" + StringUtil.NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
            int n6 = n2 >>> 4;
            n2 &= 0xF;
            for (n5 = 0; n5 < n6; ++n5) {
                int n7;
                n4 = (n5 << 4) + n;
                HexUtil.appendHexDumpRowPrefix(stringBuilder, n5, n4);
                n3 = n4 + 16;
                for (n7 = n4; n7 < n3; ++n7) {
                    stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n7)]);
                }
                stringBuilder.append(" |");
                for (n7 = n4; n7 < n3; ++n7) {
                    stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n7)]);
                }
                stringBuilder.append('|');
            }
            if (n2 != 0) {
                n5 = (n6 << 4) + n;
                HexUtil.appendHexDumpRowPrefix(stringBuilder, n6, n5);
                n4 = n5 + n2;
                for (n3 = n5; n3 < n4; ++n3) {
                    stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n3)]);
                }
                stringBuilder.append(HEXPADDING[n2]);
                stringBuilder.append(" |");
                for (n3 = n5; n3 < n4; ++n3) {
                    stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n3)]);
                }
                stringBuilder.append(BYTEPADDING[n2]);
                stringBuilder.append('|');
            }
            stringBuilder.append(StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
        }

        private static void appendHexDumpRowPrefix(StringBuilder stringBuilder, int n, int n2) {
            if (n < HEXDUMP_ROWPREFIXES.length) {
                stringBuilder.append(HEXDUMP_ROWPREFIXES[n]);
                return;
            }
            stringBuilder.append(StringUtil.NEWLINE);
            stringBuilder.append(Long.toHexString((long)n2 & 0xFFFFFFFFL | 0x100000000L));
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setCharAt(stringBuilder2.length() - 9, '|');
            stringBuilder.append('|');
        }

        static {
            int n;
            StringBuilder stringBuilder;
            int n2;
            BYTE2CHAR = new char[256];
            HEXDUMP_TABLE = new char[1024];
            HEXPADDING = new String[16];
            HEXDUMP_ROWPREFIXES = new String[4096];
            BYTE2HEX = new String[256];
            BYTEPADDING = new String[16];
            Object object = "0123456789abcdef".toCharArray();
            for (n2 = 0; n2 < 256; ++n2) {
                HexUtil.HEXDUMP_TABLE[n2 << 1] = object[n2 >>> 4 & 0xF];
                HexUtil.HEXDUMP_TABLE[(n2 << 1) + 1] = object[n2 & 0xF];
            }
            for (n2 = 0; n2 < HEXPADDING.length; ++n2) {
                int n3 = HEXPADDING.length - n2;
                stringBuilder = new StringBuilder(n3 * 3);
                for (n = 0; n < n3; ++n) {
                    stringBuilder.append("   ");
                }
                HexUtil.HEXPADDING[n2] = stringBuilder.toString();
            }
            for (n2 = 0; n2 < HEXDUMP_ROWPREFIXES.length; ++n2) {
                StringBuilder stringBuilder2 = new StringBuilder(12);
                object = stringBuilder2;
                stringBuilder2.append(StringUtil.NEWLINE);
                ((StringBuilder)object).append(Long.toHexString((long)(n2 << 4) & 0xFFFFFFFFL | 0x100000000L));
                Object object2 = object;
                ((StringBuilder)object2).setCharAt(((StringBuilder)object2).length() - 9, '|');
                ((StringBuilder)object).append('|');
                HexUtil.HEXDUMP_ROWPREFIXES[n2] = ((StringBuilder)object).toString();
            }
            for (n2 = 0; n2 < BYTE2HEX.length; ++n2) {
                HexUtil.BYTE2HEX[n2] = " " + StringUtil.byteToHexStringPadded((int)n2);
            }
            for (n2 = 0; n2 < BYTEPADDING.length; ++n2) {
                int n4 = BYTEPADDING.length - n2;
                stringBuilder = new StringBuilder(n4);
                for (n = 0; n < n4; ++n) {
                    stringBuilder.append(' ');
                }
                HexUtil.BYTEPADDING[n2] = stringBuilder.toString();
            }
            for (n2 = 0; n2 < BYTE2CHAR.length; ++n2) {
                if (n2 <= 31 || n2 >= 127) {
                    HexUtil.BYTE2CHAR[n2] = 46;
                    continue;
                }
                int n5 = n2;
                HexUtil.BYTE2CHAR[n5] = (char)n5;
            }
        }
    }
}

