/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer.search;

import io.netty.buffer.search.AbstractSearchProcessorFactory;
import io.netty.buffer.search.SearchProcessor;
import io.netty.util.internal.PlatformDependent;

public class BitapSearchProcessorFactory
extends AbstractSearchProcessorFactory {
    private final long[] bitMasks = new long[256];
    private final long successBit;

    BitapSearchProcessorFactory(byte[] byArray) {
        if (byArray.length > 64) {
            throw new IllegalArgumentException("Maximum supported search pattern length is 64, got " + byArray.length);
        }
        long l = 1L;
        byte[] byArray2 = byArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray2[i];
            int n2 = by & 0xFF;
            this.bitMasks[n2] = this.bitMasks[n2] | l;
            l <<= 1;
        }
        this.successBit = 1L << byArray.length - 1;
    }

    @Override
    public Processor newSearchProcessor() {
        return new Processor(this.bitMasks, this.successBit);
    }

    public static class Processor
    implements SearchProcessor {
        private final long[] bitMasks;
        private final long successBit;
        private long currentMask;

        Processor(long[] lArray, long l) {
            this.bitMasks = lArray;
            this.successBit = l;
        }

        public boolean process(byte by) {
            this.currentMask = (this.currentMask << 1 | 1L) & PlatformDependent.getLong((long[])this.bitMasks, (long)((long)by & 0xFFL));
            return (this.currentMask & this.successBit) == 0L;
        }

        @Override
        public void reset() {
            this.currentMask = 0L;
        }
    }
}

