/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer.search;

import io.netty.buffer.search.AbstractSearchProcessorFactory;
import io.netty.buffer.search.SearchProcessor;
import io.netty.util.internal.PlatformDependent;

public class KmpSearchProcessorFactory
extends AbstractSearchProcessorFactory {
    private final int[] jumpTable;
    private final byte[] needle;

    KmpSearchProcessorFactory(byte[] byArray) {
        this.needle = (byte[])byArray.clone();
        this.jumpTable = new int[byArray.length + 1];
        int n = 0;
        for (int i = 1; i < byArray.length; ++i) {
            while (n > 0 && byArray[n] != byArray[i]) {
                n = this.jumpTable[n];
            }
            if (byArray[n] == byArray[i]) {
                // empty if block
            }
            this.jumpTable[i + 1] = ++n;
        }
    }

    @Override
    public Processor newSearchProcessor() {
        return new Processor(this.needle, this.jumpTable);
    }

    public static class Processor
    implements SearchProcessor {
        private final byte[] needle;
        private final int[] jumpTable;
        private long currentPosition;

        Processor(byte[] byArray, int[] nArray) {
            this.needle = byArray;
            this.jumpTable = nArray;
        }

        public boolean process(byte by) {
            while (this.currentPosition > 0L && PlatformDependent.getByte((byte[])this.needle, (long)this.currentPosition) != by) {
                this.currentPosition = PlatformDependent.getInt((int[])this.jumpTable, (long)this.currentPosition);
            }
            if (PlatformDependent.getByte((byte[])this.needle, (long)this.currentPosition) == by) {
                ++this.currentPosition;
            }
            if (this.currentPosition == (long)this.needle.length) {
                this.currentPosition = PlatformDependent.getInt((int[])this.jumpTable, (long)this.currentPosition);
                return false;
            }
            return true;
        }

        @Override
        public void reset() {
            this.currentPosition = 0L;
        }
    }
}

