/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.flow;

import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;

public class FlowControlHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FlowControlHandler.class);
    private final boolean releaseMessages;
    private RecyclableArrayDeque queue;
    private ChannelConfig config;
    private boolean shouldConsume;

    public FlowControlHandler() {
        this(true);
    }

    public FlowControlHandler(boolean bl) {
        this.releaseMessages = bl;
    }

    boolean isQueueEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    private void destroy() {
        if (this.queue != null) {
            if (!this.queue.isEmpty()) {
                logger.trace("Non-empty queue: {}", (Object)this.queue);
                if (this.releaseMessages) {
                    Object e;
                    while ((e = this.queue.poll()) != null) {
                        ReferenceCountUtil.safeRelease(e);
                    }
                }
            }
            this.queue.recycle();
            this.queue = null;
        }
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.config = channelHandlerContext.channel().config();
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved(channelHandlerContext);
        if (!this.isQueueEmpty()) {
            this.dequeue(channelHandlerContext, this.queue.size());
        }
        this.destroy();
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
        channelHandlerContext.fireChannelInactive();
    }

    public void read(ChannelHandlerContext channelHandlerContext) {
        if (this.dequeue(channelHandlerContext, 1) == 0) {
            this.shouldConsume = true;
            channelHandlerContext.read();
            return;
        }
        if (this.config.isAutoRead()) {
            channelHandlerContext.read();
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.queue == null) {
            this.queue = RecyclableArrayDeque.newInstance();
        }
        this.queue.offer(object);
        int n = this.shouldConsume ? 1 : 0;
        this.shouldConsume = false;
        this.dequeue(channelHandlerContext, n);
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (this.isQueueEmpty()) {
            channelHandlerContext.fireChannelReadComplete();
        }
    }

    private int dequeue(ChannelHandlerContext channelHandlerContext, int n) {
        Object e;
        int n2;
        for (n2 = 0; this.queue != null && (n2 < n || this.config.isAutoRead()) && (e = this.queue.poll()) != null; ++n2) {
            channelHandlerContext.fireChannelRead(e);
        }
        if (this.queue != null && this.queue.isEmpty()) {
            this.queue.recycle();
            this.queue = null;
            if (n2 > 0) {
                channelHandlerContext.fireChannelReadComplete();
            }
        }
        return n2;
    }

    private static final class RecyclableArrayDeque
    extends ArrayDeque<Object> {
        private static final long serialVersionUID = 0L;
        private static final int DEFAULT_NUM_ELEMENTS = 2;
        private static final ObjectPool<RecyclableArrayDeque> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<RecyclableArrayDeque>(){

            public final RecyclableArrayDeque newObject(ObjectPool.Handle<RecyclableArrayDeque> handle) {
                return new RecyclableArrayDeque(2, handle);
            }
        });
        private final ObjectPool.Handle<RecyclableArrayDeque> handle;

        public static RecyclableArrayDeque newInstance() {
            return (RecyclableArrayDeque)RECYCLER.get();
        }

        private RecyclableArrayDeque(int n, ObjectPool.Handle<RecyclableArrayDeque> handle) {
            super(n);
            this.handle = handle;
        }

        public final void recycle() {
            this.clear();
            this.handle.recycle((Object)this);
        }
    }
}

