/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.logging.ByteBufFormat;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class LoggingHandler
extends ChannelDuplexHandler {
    private static final LogLevel DEFAULT_LEVEL = LogLevel.DEBUG;
    protected final InternalLogger logger;
    protected final InternalLogLevel internalLevel;
    private final LogLevel level;
    private final ByteBufFormat byteBufFormat;

    public LoggingHandler() {
        this(DEFAULT_LEVEL);
    }

    public LoggingHandler(ByteBufFormat byteBufFormat) {
        this(DEFAULT_LEVEL, byteBufFormat);
    }

    public LoggingHandler(LogLevel logLevel) {
        this(logLevel, ByteBufFormat.HEX_DUMP);
    }

    public LoggingHandler(LogLevel logLevel, ByteBufFormat byteBufFormat) {
        this.level = (LogLevel)((Object)ObjectUtil.checkNotNull((Object)((Object)logLevel), (String)"level"));
        this.byteBufFormat = (ByteBufFormat)((Object)ObjectUtil.checkNotNull((Object)((Object)byteBufFormat), (String)"byteBufFormat"));
        this.logger = InternalLoggerFactory.getInstance(((Object)((Object)this)).getClass());
        this.internalLevel = logLevel.toInternalLevel();
    }

    public LoggingHandler(Class<?> clazz) {
        this(clazz, DEFAULT_LEVEL);
    }

    public LoggingHandler(Class<?> clazz, LogLevel logLevel) {
        this(clazz, logLevel, ByteBufFormat.HEX_DUMP);
    }

    public LoggingHandler(Class<?> clazz, LogLevel logLevel, ByteBufFormat byteBufFormat) {
        ObjectUtil.checkNotNull(clazz, (String)"clazz");
        this.level = (LogLevel)((Object)ObjectUtil.checkNotNull((Object)((Object)logLevel), (String)"level"));
        this.byteBufFormat = (ByteBufFormat)((Object)ObjectUtil.checkNotNull((Object)((Object)byteBufFormat), (String)"byteBufFormat"));
        this.logger = InternalLoggerFactory.getInstance(clazz);
        this.internalLevel = logLevel.toInternalLevel();
    }

    public LoggingHandler(String string) {
        this(string, DEFAULT_LEVEL);
    }

    public LoggingHandler(String string, LogLevel logLevel) {
        this(string, logLevel, ByteBufFormat.HEX_DUMP);
    }

    public LoggingHandler(String string, LogLevel logLevel, ByteBufFormat byteBufFormat) {
        ObjectUtil.checkNotNull((Object)string, (String)"name");
        this.level = (LogLevel)((Object)ObjectUtil.checkNotNull((Object)((Object)logLevel), (String)"level"));
        this.byteBufFormat = (ByteBufFormat)((Object)ObjectUtil.checkNotNull((Object)((Object)byteBufFormat), (String)"byteBufFormat"));
        this.logger = InternalLoggerFactory.getInstance((String)string);
        this.internalLevel = logLevel.toInternalLevel();
    }

    public LogLevel level() {
        return this.level;
    }

    public ByteBufFormat byteBufFormat() {
        return this.byteBufFormat;
    }

    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "REGISTERED"));
        }
        channelHandlerContext.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "UNREGISTERED"));
        }
        channelHandlerContext.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "ACTIVE"));
        }
        channelHandlerContext.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "INACTIVE"));
        }
        channelHandlerContext.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "EXCEPTION", throwable), throwable);
        }
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "USER_EVENT", object));
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "BIND", socketAddress));
        }
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "CONNECT", socketAddress, socketAddress2));
        }
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "DISCONNECT"));
        }
        channelHandlerContext.disconnect(channelPromise);
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "CLOSE"));
        }
        channelHandlerContext.close(channelPromise);
    }

    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "DEREGISTER"));
        }
        channelHandlerContext.deregister(channelPromise);
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "READ COMPLETE"));
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "READ", object));
        }
        channelHandlerContext.fireChannelRead(object);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "WRITE", object));
        }
        channelHandlerContext.write(object, channelPromise);
    }

    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "WRITABILITY CHANGED"));
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "FLUSH"));
        }
        channelHandlerContext.flush();
    }

    protected String format(ChannelHandlerContext object, String string) {
        object = object.channel().toString();
        return new StringBuilder(((String)object).length() + 1 + string.length()).append((String)object).append(' ').append(string).toString();
    }

    protected String format(ChannelHandlerContext channelHandlerContext, String string, Object object) {
        if (object instanceof ByteBuf) {
            return this.formatByteBuf(channelHandlerContext, string, (ByteBuf)object);
        }
        if (object instanceof ByteBufHolder) {
            return this.formatByteBufHolder(channelHandlerContext, string, (ByteBufHolder)object);
        }
        return LoggingHandler.formatSimple(channelHandlerContext, string, object);
    }

    protected String format(ChannelHandlerContext object, String string, Object object2, Object object3) {
        if (object3 == null) {
            return LoggingHandler.formatSimple((ChannelHandlerContext)object, string, object2);
        }
        object = object.channel().toString();
        object2 = String.valueOf(object2);
        object3 = object3.toString();
        StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 1 + string.length() + 2 + ((String)object2).length() + 2 + ((String)object3).length());
        stringBuilder.append((String)object).append(' ').append(string).append(": ").append((String)object2).append(", ").append((String)object3);
        return stringBuilder.toString();
    }

    private String formatByteBuf(ChannelHandlerContext object, String string, ByteBuf byteBuf) {
        object = object.channel().toString();
        int n = byteBuf.readableBytes();
        if (n == 0) {
            StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 1 + string.length() + 4);
            stringBuilder.append((String)object).append(' ').append(string).append(": 0B");
            return stringBuilder.toString();
        }
        int n2 = ((String)object).length() + 1 + string.length() + 2 + 10 + 1;
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            int n3 = n / 16 + (n % 15 == 0 ? 0 : 1) + 4;
            n3 = 2 + n3 * 80;
            n2 += n3;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append((String)object).append(' ').append(string).append(": ").append(n).append('B');
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            stringBuilder.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump((StringBuilder)stringBuilder, (ByteBuf)byteBuf);
        }
        return stringBuilder.toString();
    }

    private String formatByteBufHolder(ChannelHandlerContext object, String string, ByteBufHolder byteBufHolder) {
        object = object.channel().toString();
        String string2 = byteBufHolder.toString();
        int n = (byteBufHolder = byteBufHolder.content()).readableBytes();
        if (n == 0) {
            StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 1 + string.length() + 2 + string2.length() + 4);
            stringBuilder.append((String)object).append(' ').append(string).append(", ").append(string2).append(", 0B");
            return stringBuilder.toString();
        }
        int n2 = ((String)object).length() + 1 + string.length() + 2 + string2.length() + 2 + 10 + 1;
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            int n3 = n / 16 + (n % 15 == 0 ? 0 : 1) + 4;
            n3 = 2 + n3 * 80;
            n2 += n3;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append((String)object).append(' ').append(string).append(": ").append(string2).append(", ").append(n).append('B');
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            stringBuilder.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump((StringBuilder)stringBuilder, (ByteBuf)byteBufHolder);
        }
        return stringBuilder.toString();
    }

    private static String formatSimple(ChannelHandlerContext object, String string, Object object2) {
        object = object.channel().toString();
        object2 = String.valueOf(object2);
        StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 1 + string.length() + 2 + ((String)object2).length());
        return stringBuilder.append((String)object).append(' ').append(string).append(": ").append((String)object2).toString();
    }
}

