/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContextOption;
import io.netty.internal.tcnative.CertificateCallback;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SniHostNameMatcher;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class ReferenceCountedOpenSslServerContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslServerContext.class);
    private static final byte[] ID = new byte[]{110, 101, 116, 116, 121};
    private final OpenSslServerSessionContext sessionContext;

    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, ReferenceCountedOpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2, clientAuth, stringArray, bl, bl2, string2, resumptionController, entryArray);
    }

    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, 1, x509CertificateArray2, clientAuth, stringArray, bl, null, bl2, true, resumptionController, entryArray);
        try {
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2, l, l2, resumptionController);
            if (SERVER_ENABLE_SESSION_TICKET) {
                this.sessionContext.setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    public final OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }

    static OpenSslServerSessionContext newSessionContext(ReferenceCountedOpenSslContext object, long l, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] object2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2, long l2, long l3, ResumptionController resumptionController) {
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object3;
            try {
                SSLContext.setVerify((long)l, (int)0, (int)10);
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    ObjectUtil.checkNotNull((Object)object2, (String)"keyCertChain");
                    ReferenceCountedOpenSslServerContext.setKeyMaterial(l, object2, privateKey, string);
                } else {
                    if (keyManagerFactory == null) {
                        object3 = ReferenceCountedOpenSslServerContext.keyStorePassword(string);
                        keyManagerFactory = (object2 = ReferenceCountedOpenSslServerContext.buildKeyStore(object2, privateKey, object3, string2)).aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init((KeyStore)object2, (char[])object3);
                    }
                    openSslKeyMaterialProvider = ReferenceCountedOpenSslServerContext.providerFor(keyManagerFactory, string);
                    SSLContext.setCertificateCallback((long)l, (CertificateCallback)new OpenSslServerCertificateCallback(openSslEngineMap, new OpenSslKeyMaterialManager(openSslKeyMaterialProvider)));
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslServerContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object3 = ReferenceCountedOpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers(), resumptionController);
                ReferenceCountedOpenSslServerContext.setVerifyCallback(l, openSslEngineMap, (X509TrustManager)object3);
                object2 = object3.getAcceptedIssuers();
                if (object2 != null && ((X509Certificate[])object2).length > 0) {
                    long l4 = 0L;
                    try {
                        l4 = ReferenceCountedOpenSslServerContext.toBIO(ByteBufAllocator.DEFAULT, object2);
                        if (!SSLContext.setCACertificateBio((long)l, (long)l4)) {
                            object = "unable to setup accepted issuers for trustmanager " + object3;
                            int n = SSL.getLastErrorNumber();
                            if (n != 0) {
                                object = (String)object + ". " + SSL.getErrorString((long)n);
                            }
                            throw new SSLException((String)object);
                        }
                    }
                    finally {
                        ReferenceCountedOpenSslServerContext.freeBio(l4);
                    }
                }
                if (PlatformDependent.javaVersion() >= 8) {
                    SSLContext.setSniHostnameMatcher((long)l, (SniHostNameMatcher)new OpenSslSniHostnameMatcher(openSslEngineMap));
                }
            }
            catch (SSLException sSLException) {
                object3 = sSLException;
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("unable to setup trustmanager", exception);
            }
            object3 = new OpenSslServerSessionContext((ReferenceCountedOpenSslContext)object, openSslKeyMaterialProvider);
            object3.setSessionIdContext(ID);
            object3.setSessionCacheEnabled(SERVER_ENABLE_SESSION_CACHE);
            if (l2 > 0L) {
                object3.setSessionCacheSize((int)Math.min(l2, Integer.MAX_VALUE));
            }
            if (l3 > 0L) {
                object3.setSessionTimeout((int)Math.min(l3, Integer.MAX_VALUE));
            }
            openSslKeyMaterialProvider = null;
            object2 = object3;
            return object2;
        }
        catch (Throwable throwable) {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
            throw throwable;
        }
    }

    private static void setVerifyCallback(long l, OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
        if (ReferenceCountedOpenSslServerContext.useExtendedTrustManager(x509TrustManager)) {
            SSLContext.setCertVerifyCallback((long)l, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)x509TrustManager));
            return;
        }
        SSLContext.setCertVerifyCallback((long)l, (CertificateVerifier)new TrustManagerVerifyCallback(openSslEngineMap, x509TrustManager));
    }

    private static final class OpenSslSniHostnameMatcher
    implements SniHostNameMatcher {
        private final OpenSslEngineMap engineMap;

        OpenSslSniHostnameMatcher(OpenSslEngineMap openSslEngineMap) {
            this.engineMap = openSslEngineMap;
        }

        public final boolean match(long l, String string) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l);
            if (referenceCountedOpenSslEngine != null) {
                return referenceCountedOpenSslEngine.checkSniHostnameMatch(string.getBytes(CharsetUtil.UTF_8));
            }
            logger.warn("No ReferenceCountedOpenSslEngine found for SSL pointer: {}", (Object)l);
            return false;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(openSslEngineMap);
            this.manager = x509ExtendedTrustManager;
        }

        @Override
        final void verify(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, X509Certificate[] x509CertificateArray, String string) {
            this.manager.checkClientTrusted(x509CertificateArray, string, referenceCountedOpenSslEngine);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
            super(openSslEngineMap);
            this.manager = x509TrustManager;
        }

        @Override
        final void verify(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, X509Certificate[] x509CertificateArray, String string) {
            this.manager.checkClientTrusted(x509CertificateArray, string);
        }
    }

    private static final class OpenSslServerCertificateCallback
    implements CertificateCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslServerCertificateCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engineMap = openSslEngineMap;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }

        public final void handle(long l, byte[] byArray, byte[][] byArray2) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l);
            if (referenceCountedOpenSslEngine == null) {
                return;
            }
            try {
                this.keyManagerHolder.setKeyMaterialServerSide(referenceCountedOpenSslEngine);
                return;
            }
            catch (Throwable throwable) {
                referenceCountedOpenSslEngine.initHandshakeException(throwable);
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new SSLException(throwable);
            }
        }
    }
}

