/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.util.internal.ObjectUtil;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class LazyX509Certificate
extends X509Certificate {
    static final CertificateFactory X509_CERT_FACTORY;
    private final byte[] bytes;
    private X509Certificate wrapped;

    public LazyX509Certificate(byte[] byArray) {
        this.bytes = (byte[])ObjectUtil.checkNotNull((Object)byArray, (String)"bytes");
    }

    @Override
    public final void checkValidity() {
        this.unwrap().checkValidity();
    }

    @Override
    public final void checkValidity(Date date) {
        this.unwrap().checkValidity(date);
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        return this.unwrap().getIssuerX500Principal();
    }

    @Override
    public final X500Principal getSubjectX500Principal() {
        return this.unwrap().getSubjectX500Principal();
    }

    @Override
    public final List<String> getExtendedKeyUsage() {
        return this.unwrap().getExtendedKeyUsage();
    }

    @Override
    public final Collection<List<?>> getSubjectAlternativeNames() {
        return this.unwrap().getSubjectAlternativeNames();
    }

    @Override
    public final Collection<List<?>> getIssuerAlternativeNames() {
        return this.unwrap().getIssuerAlternativeNames();
    }

    @Override
    public final void verify(PublicKey publicKey, Provider provider) {
        this.unwrap().verify(publicKey, provider);
    }

    @Override
    public final int getVersion() {
        return this.unwrap().getVersion();
    }

    @Override
    public final BigInteger getSerialNumber() {
        return this.unwrap().getSerialNumber();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.unwrap().getIssuerDN();
    }

    @Override
    public final Principal getSubjectDN() {
        return this.unwrap().getSubjectDN();
    }

    @Override
    public final Date getNotBefore() {
        return this.unwrap().getNotBefore();
    }

    @Override
    public final Date getNotAfter() {
        return this.unwrap().getNotAfter();
    }

    @Override
    public final byte[] getTBSCertificate() {
        return this.unwrap().getTBSCertificate();
    }

    @Override
    public final byte[] getSignature() {
        return this.unwrap().getSignature();
    }

    @Override
    public final String getSigAlgName() {
        return this.unwrap().getSigAlgName();
    }

    @Override
    public final String getSigAlgOID() {
        return this.unwrap().getSigAlgOID();
    }

    @Override
    public final byte[] getSigAlgParams() {
        return this.unwrap().getSigAlgParams();
    }

    @Override
    public final boolean[] getIssuerUniqueID() {
        return this.unwrap().getIssuerUniqueID();
    }

    @Override
    public final boolean[] getSubjectUniqueID() {
        return this.unwrap().getSubjectUniqueID();
    }

    @Override
    public final boolean[] getKeyUsage() {
        return this.unwrap().getKeyUsage();
    }

    @Override
    public final int getBasicConstraints() {
        return this.unwrap().getBasicConstraints();
    }

    @Override
    public final byte[] getEncoded() {
        return (byte[])this.bytes.clone();
    }

    @Override
    public final void verify(PublicKey publicKey) {
        this.unwrap().verify(publicKey);
    }

    @Override
    public final void verify(PublicKey publicKey, String string) {
        this.unwrap().verify(publicKey, string);
    }

    @Override
    public final String toString() {
        return this.unwrap().toString();
    }

    @Override
    public final PublicKey getPublicKey() {
        return this.unwrap().getPublicKey();
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        return this.unwrap().hasUnsupportedCriticalExtension();
    }

    @Override
    public final Set<String> getCriticalExtensionOIDs() {
        return this.unwrap().getCriticalExtensionOIDs();
    }

    @Override
    public final Set<String> getNonCriticalExtensionOIDs() {
        return this.unwrap().getNonCriticalExtensionOIDs();
    }

    @Override
    public final byte[] getExtensionValue(String string) {
        return this.unwrap().getExtensionValue(string);
    }

    private X509Certificate unwrap() {
        X509Certificate x509Certificate = this.wrapped;
        if (x509Certificate == null) {
            try {
                x509Certificate = this.wrapped = (X509Certificate)X509_CERT_FACTORY.generateCertificate(new ByteArrayInputStream(this.bytes));
            }
            catch (CertificateException certificateException) {
                throw new IllegalStateException(certificateException);
            }
        }
        return x509Certificate;
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
            return;
        }
        catch (CertificateException certificateException) {
            throw new ExceptionInInitializerError(certificateException);
        }
    }
}

