/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.X509TrustManagerWrapper;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class SimpleTrustManagerFactory
extends TrustManagerFactory {
    private static final Provider PROVIDER = new Provider("", 0.0, ""){
        private static final long serialVersionUID = -2680540247105807895L;
    };
    private static final FastThreadLocal<SimpleTrustManagerFactorySpi> CURRENT_SPI = new FastThreadLocal<SimpleTrustManagerFactorySpi>(){

        protected final SimpleTrustManagerFactorySpi initialValue() {
            return new SimpleTrustManagerFactorySpi();
        }
    };

    protected SimpleTrustManagerFactory() {
        this("");
    }

    protected SimpleTrustManagerFactory(String string) {
        super((TrustManagerFactorySpi)CURRENT_SPI.get(), PROVIDER, string);
        ((SimpleTrustManagerFactorySpi)CURRENT_SPI.get()).init(this);
        CURRENT_SPI.remove();
        ObjectUtil.checkNotNull((Object)string, (String)"name");
    }

    protected abstract void engineInit(KeyStore var1);

    protected abstract void engineInit(ManagerFactoryParameters var1);

    protected abstract TrustManager[] engineGetTrustManagers();

    static final class SimpleTrustManagerFactorySpi
    extends TrustManagerFactorySpi {
        private SimpleTrustManagerFactory parent;
        private volatile TrustManager[] trustManagers;

        SimpleTrustManagerFactorySpi() {
        }

        final void init(SimpleTrustManagerFactory simpleTrustManagerFactory) {
            this.parent = simpleTrustManagerFactory;
        }

        @Override
        protected final void engineInit(KeyStore object) {
            try {
                this.parent.engineInit((KeyStore)object);
                return;
            }
            catch (KeyStoreException keyStoreException) {
                object = keyStoreException;
                throw keyStoreException;
            }
            catch (Exception exception) {
                throw new KeyStoreException(exception);
            }
        }

        @Override
        protected final void engineInit(ManagerFactoryParameters object) {
            try {
                this.parent.engineInit((ManagerFactoryParameters)object);
                return;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                object = invalidAlgorithmParameterException;
                throw invalidAlgorithmParameterException;
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception);
            }
        }

        @Override
        protected final TrustManager[] engineGetTrustManagers() {
            TrustManager[] trustManagerArray = this.trustManagers;
            if (this.trustManagers == null) {
                trustManagerArray = this.parent.engineGetTrustManagers();
                if (PlatformDependent.javaVersion() >= 7) {
                    SimpleTrustManagerFactorySpi.wrapIfNeeded(trustManagerArray);
                }
                this.trustManagers = trustManagerArray;
            }
            return (TrustManager[])trustManagerArray.clone();
        }

        private static void wrapIfNeeded(TrustManager[] trustManagerArray) {
            for (int i = 0; i < trustManagerArray.length; ++i) {
                TrustManager trustManager = trustManagerArray[i];
                if (!(trustManager instanceof X509TrustManager) || trustManager instanceof X509ExtendedTrustManager) continue;
                trustManagerArray[i] = new X509TrustManagerWrapper((X509TrustManager)trustManager);
            }
        }
    }
}

