/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.linux;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.linux.XAttr;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;

public abstract class XAttrUtil {
    private XAttrUtil() {
    }

    public static void setXAttr(String string, String string2, String string3) {
        XAttrUtil.setXAttr(string, string2, string3, Native.getDefaultStringEncoding());
    }

    public static void setXAttr(String string, String string2, String string3, String string4) {
        XAttrUtil.setXAttr(string, string2, string3.getBytes(string4));
    }

    public static void setXAttr(String string, String string2, byte[] byArray) {
        int n = XAttr.INSTANCE.setxattr(string, string2, byArray, new XAttr.size_t(byArray.length), 0);
        if (n != 0) {
            n = Native.getLastError();
            throw new IOException("errno: " + n);
        }
    }

    public static void lSetXAttr(String string, String string2, String string3) {
        XAttrUtil.lSetXAttr(string, string2, string3, Native.getDefaultStringEncoding());
    }

    public static void lSetXAttr(String string, String string2, String string3, String string4) {
        XAttrUtil.lSetXAttr(string, string2, string3.getBytes(string4));
    }

    public static void lSetXAttr(String string, String string2, byte[] byArray) {
        int n = XAttr.INSTANCE.lsetxattr(string, string2, byArray, new XAttr.size_t(byArray.length), 0);
        if (n != 0) {
            n = Native.getLastError();
            throw new IOException("errno: " + n);
        }
    }

    public static void fSetXAttr(int n, String string, String string2) {
        XAttrUtil.fSetXAttr(n, string, string2, Native.getDefaultStringEncoding());
    }

    public static void fSetXAttr(int n, String string, String string2, String string3) {
        XAttrUtil.fSetXAttr(n, string, string2.getBytes(string3));
    }

    public static void fSetXAttr(int n, String string, byte[] byArray) {
        if ((n = XAttr.INSTANCE.fsetxattr(n, string, byArray, new XAttr.size_t(byArray.length), 0)) != 0) {
            n = Native.getLastError();
            throw new IOException("errno: " + n);
        }
    }

    public static String getXAttr(String string, String string2) {
        return XAttrUtil.getXAttr(string, string2, Native.getDefaultStringEncoding());
    }

    public static String getXAttr(String object, String string, String string2) {
        object = XAttrUtil.getXAttrBytes((String)object, string);
        return new String((byte[])object, Charset.forName(string2));
    }

    public static byte[] getXAttrBytes(String string, String string2) {
        byte[] byArray;
        XAttr.ssize_t ssize_t2;
        int n = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.getxattr(string, string2, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n = Native.getLastError();
                throw new IOException("errno: " + n);
            }
            byArray = new byte[ssize_t2.intValue()];
            if ((ssize_t2 = XAttr.INSTANCE.getxattr(string, string2, byArray, new XAttr.size_t(byArray.length))).longValue() >= 0L || (n = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n);
        } while (ssize_t2.longValue() < 0L && n == 34);
        return byArray;
    }

    public static Memory getXAttrAsMemory(String string, String string2) {
        Memory memory;
        XAttr.ssize_t ssize_t2;
        int n = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.getxattr(string, string2, (Pointer)null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n = Native.getLastError();
                throw new IOException("errno: " + n);
            }
            if (ssize_t2.longValue() == 0L) {
                return null;
            }
            memory = new Memory(ssize_t2.longValue());
            if ((ssize_t2 = XAttr.INSTANCE.getxattr(string, string2, (Pointer)memory, new XAttr.size_t(memory.size()))).longValue() >= 0L || (n = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n);
        } while (ssize_t2.longValue() < 0L && n == 34);
        return memory;
    }

    public static String lGetXAttr(String string, String string2) {
        return XAttrUtil.lGetXAttr(string, string2, Native.getDefaultStringEncoding());
    }

    public static String lGetXAttr(String object, String string, String string2) {
        object = XAttrUtil.lGetXAttrBytes((String)object, string);
        return new String((byte[])object, Charset.forName(string2));
    }

    public static byte[] lGetXAttrBytes(String string, String string2) {
        byte[] byArray;
        XAttr.ssize_t ssize_t2;
        int n = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.lgetxattr(string, string2, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n = Native.getLastError();
                throw new IOException("errno: " + n);
            }
            byArray = new byte[ssize_t2.intValue()];
            if ((ssize_t2 = XAttr.INSTANCE.lgetxattr(string, string2, byArray, new XAttr.size_t(byArray.length))).longValue() >= 0L || (n = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n);
        } while (ssize_t2.longValue() < 0L && n == 34);
        return byArray;
    }

    public static Memory lGetXAttrAsMemory(String string, String string2) {
        Memory memory;
        XAttr.ssize_t ssize_t2;
        int n = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.lgetxattr(string, string2, (Pointer)null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n = Native.getLastError();
                throw new IOException("errno: " + n);
            }
            if (ssize_t2.longValue() == 0L) {
                return null;
            }
            memory = new Memory(ssize_t2.longValue());
            if ((ssize_t2 = XAttr.INSTANCE.lgetxattr(string, string2, (Pointer)memory, new XAttr.size_t(memory.size()))).longValue() >= 0L || (n = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n);
        } while (ssize_t2.longValue() < 0L && n == 34);
        return memory;
    }

    public static String fGetXAttr(int n, String string) {
        return XAttrUtil.fGetXAttr(n, string, Native.getDefaultStringEncoding());
    }

    public static String fGetXAttr(int n, String string, String string2) {
        byte[] byArray = XAttrUtil.fGetXAttrBytes(n, string);
        return new String(byArray, Charset.forName(string2));
    }

    public static byte[] fGetXAttrBytes(int n, String string) {
        byte[] byArray;
        XAttr.ssize_t ssize_t2;
        int n2 = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.fgetxattr(n, string, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n2 = Native.getLastError();
                throw new IOException("errno: " + n2);
            }
            byArray = new byte[ssize_t2.intValue()];
            if ((ssize_t2 = XAttr.INSTANCE.fgetxattr(n, string, byArray, new XAttr.size_t(byArray.length))).longValue() >= 0L || (n2 = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n2);
        } while (ssize_t2.longValue() < 0L && n2 == 34);
        return byArray;
    }

    public static Memory fGetXAttrAsMemory(int n, String string) {
        Memory memory;
        XAttr.ssize_t ssize_t2;
        int n2 = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.fgetxattr(n, string, (Pointer)null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n2 = Native.getLastError();
                throw new IOException("errno: " + n2);
            }
            if (ssize_t2.longValue() == 0L) {
                return null;
            }
            memory = new Memory(ssize_t2.longValue());
            if ((ssize_t2 = XAttr.INSTANCE.fgetxattr(n, string, (Pointer)memory, new XAttr.size_t(memory.size()))).longValue() >= 0L || (n2 = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n2);
        } while (ssize_t2.longValue() < 0L && n2 == 34);
        return memory;
    }

    public static Collection<String> listXAttr(String string) {
        return XAttrUtil.listXAttr(string, Native.getDefaultStringEncoding());
    }

    public static Collection<String> listXAttr(String string, String string2) {
        byte[] byArray;
        XAttr.ssize_t ssize_t2;
        int n = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.listxattr(string, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n = Native.getLastError();
                throw new IOException("errno: " + n);
            }
            byArray = new byte[ssize_t2.intValue()];
            if ((ssize_t2 = XAttr.INSTANCE.listxattr(string, byArray, new XAttr.size_t(byArray.length))).longValue() >= 0L || (n = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n);
        } while (ssize_t2.longValue() < 0L && n == 34);
        return XAttrUtil.splitBufferToStrings(byArray, string2);
    }

    public static Collection<String> lListXAttr(String string) {
        return XAttrUtil.lListXAttr(string, Native.getDefaultStringEncoding());
    }

    public static Collection<String> lListXAttr(String string, String string2) {
        byte[] byArray;
        XAttr.ssize_t ssize_t2;
        int n = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.llistxattr(string, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n = Native.getLastError();
                throw new IOException("errno: " + n);
            }
            byArray = new byte[ssize_t2.intValue()];
            if ((ssize_t2 = XAttr.INSTANCE.llistxattr(string, byArray, new XAttr.size_t(byArray.length))).longValue() >= 0L || (n = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n);
        } while (ssize_t2.longValue() < 0L && n == 34);
        return XAttrUtil.splitBufferToStrings(byArray, string2);
    }

    public static Collection<String> fListXAttr(int n) {
        return XAttrUtil.fListXAttr(n, Native.getDefaultStringEncoding());
    }

    public static Collection<String> fListXAttr(int n, String string) {
        byte[] byArray;
        XAttr.ssize_t ssize_t2;
        int n2 = 0;
        do {
            if ((ssize_t2 = XAttr.INSTANCE.flistxattr(n, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                n2 = Native.getLastError();
                throw new IOException("errno: " + n2);
            }
            byArray = new byte[ssize_t2.intValue()];
            if ((ssize_t2 = XAttr.INSTANCE.flistxattr(n, byArray, new XAttr.size_t(byArray.length))).longValue() >= 0L || (n2 = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + n2);
        } while (ssize_t2.longValue() < 0L && n2 == 34);
        return XAttrUtil.splitBufferToStrings(byArray, string);
    }

    public static void removeXAttr(String string, String string2) {
        int n = XAttr.INSTANCE.removexattr(string, string2);
        if (n != 0) {
            n = Native.getLastError();
            throw new IOException("errno: " + n);
        }
    }

    public static void lRemoveXAttr(String string, String string2) {
        int n = XAttr.INSTANCE.lremovexattr(string, string2);
        if (n != 0) {
            n = Native.getLastError();
            throw new IOException("errno: " + n);
        }
    }

    public static void fRemoveXAttr(int n, String string) {
        if ((n = XAttr.INSTANCE.fremovexattr(n, string)) != 0) {
            n = Native.getLastError();
            throw new IOException("errno: " + n);
        }
    }

    private static Collection<String> splitBufferToStrings(byte[] byArray, String object) {
        object = Charset.forName((String)object);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(1);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            String string = new String(byArray, n, i - n, (Charset)object);
            linkedHashSet.add(string);
            n = i + 1;
        }
        return linkedHashSet;
    }
}

