/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector.servlet;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import org.slf4j.LoggerFactory;

public class LoggerContextFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ContextSelector contextSelector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
        ContextJNDISelector contextJNDISelector = null;
        if (contextSelector instanceof ContextJNDISelector) {
            contextJNDISelector = (ContextJNDISelector)contextSelector;
            contextJNDISelector.setLocalContext(loggerContext);
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
            if (contextJNDISelector != null) {
                contextJNDISelector.removeLocalContext();
                return;
            }
        }
        catch (Throwable throwable) {
            if (contextJNDISelector != null) {
                contextJNDISelector.removeLocalContext();
            }
            throw throwable;
        }
    }

    public void init(FilterConfig filterConfig) {
    }
}

