/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.http.IpParserKt;
import io.ktor.network.tls.TLSException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\b\u0010\u0006\u001a\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\r*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\r*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000f\"\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\"\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"", "serverName", "Ljava/security/cert/X509Certificate;", "certificate", "", "verifyHostnameInCertificate", "(Ljava/lang/String;Ljava/security/cert/X509Certificate;)V", "ipString", "verifyIpInCertificate", "certificateHost", "", "matchHostnameWithCertificate", "(Ljava/lang/String;Ljava/lang/String;)Z", "", "hosts", "(Ljava/security/cert/X509Certificate;)Ljava/util/List;", "ips", "", "DNS_NAME_TYPE", "I", "IP_ADDRESS_TYPE", "ktor-network-tls"})
public final class HostnameUtilsKt {
    private static final int DNS_NAME_TYPE = 2;
    private static final int IP_ADDRESS_TYPE = 7;

    public static final void verifyHostnameInCertificate(String string, X509Certificate object) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (IpParserKt.hostIsIp((String)string)) {
            HostnameUtilsKt.verifyIpInCertificate(string, (X509Certificate)object);
            return;
        }
        if ((object = HostnameUtilsKt.hosts((X509Certificate)object)).isEmpty()) {
            return;
        }
        Object object2 = (Iterable)object;
        if (!(object2 instanceof Collection) || !((Collection)object2).isEmpty()) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3 = object2.next();
                if (!HostnameUtilsKt.matchHostnameWithCertificate(string, object3 = (String)object3)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        throw new TLSException("No server host: " + string + " in the server certificate. Provided in certificate: " + CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, null, (int)63, null), null, 2, null);
    }

    public static final void verifyIpInCertificate(String string, X509Certificate object) {
        boolean bl;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object3 = ((X509Certificate)object).getSubjectAlternativeNames();
        if (object3 != null) {
            Object object4;
            object3 = (Iterable)object3;
            object2 = object3;
            object = new ArrayList();
            object3 = object2.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object4 = (List)object2;
                Object e = object4.get(0);
                Intrinsics.checkNotNull(e);
                if (!((Integer)e == 7)) continue;
                object.add(object2);
            }
            object = object2 = (Iterable)((List)object);
            object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            object2 = object.iterator();
            while (object2.hasNext()) {
                object = object4 = object2.next();
                object4 = object3;
                Object e = object.get(1);
                Intrinsics.checkNotNull(e);
                object4.add((String)e);
            }
        } else {
            return;
        }
        object = (List)object3;
        if (object.isEmpty()) {
            return;
        }
        object3 = (Iterable)object;
        if (!((Collection)object3).isEmpty()) {
            object3 = object3.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (!Intrinsics.areEqual((Object)(object2 = (String)object2), (Object)string)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        throw new TLSException("No server host: " + string + " in the server certificate. The certificate was issued for: " + CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, null, (int)63, null) + '.', null, 2, null);
    }

    public static final boolean matchHostnameWithCertificate(String object, String object2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        if (StringsKt.equals((String)object, (String)object2, (boolean)true)) {
            return true;
        }
        char[] cArray = new char[1];
        Object object3 = cArray;
        cArray[0] = 46;
        object = CollectionsKt.asReversed((List)StringsKt.split$default((CharSequence)((CharSequence)object), (char[])object3, (boolean)false, (int)0, (int)6, null));
        CharSequence charSequence = (CharSequence)object2;
        char[] cArray2 = new char[1];
        object2 = cArray2;
        cArray2[0] = 46;
        object3 = CollectionsKt.asReversed((List)StringsKt.split$default((CharSequence)charSequence, (char[])object2, (boolean)false, (int)0, (int)6, null));
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n < object.size() && n2 < object3.size()) {
            String string = (String)object.get(n);
            if (n == 0 && ((CharSequence)string).length() == 0) {
                ++n;
                continue;
            }
            String string2 = (String)object3.get(n2);
            if (n2 == 0 && ((CharSequence)string2).length() == 0) {
                ++n2;
                continue;
            }
            if (!bl2 && StringsKt.equals((String)string, (String)string2, (boolean)true)) {
                ++n3;
                ++n;
                ++n2;
                continue;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"*")) {
                bl2 = true;
                ++n;
                ++n2;
                continue;
            }
            return false;
        }
        boolean bl3 = bl = !bl2 || n3 >= 2;
        return n == object.size() && n2 == object3.size() && bl;
    }

    private static final List<String> hosts(X509Certificate object) {
        if ((object = ((X509Certificate)object).getSubjectAlternativeNames()) != null) {
            object = (Iterable)object;
            Iterable<Object> iterable = new ArrayList();
            object = object.iterator();
            while (object.hasNext()) {
                Object t2 = object.next();
                Object object2 = (List)t2;
                Object e = object2.get(0);
                Intrinsics.checkNotNull(e);
                if (!((Integer)e == 2)) continue;
                iterable.add((Object)t2);
            }
            object = (List)iterable;
            iterable = object;
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            for (Object object2 : iterable) {
                iterable = object2;
                object2 = object;
                Object e = iterable.get(1);
                Intrinsics.checkNotNull(e);
                object2.add((String)e);
            }
            return (List)object;
        }
        return CollectionsKt.emptyList();
    }

    private static final List<String> ips(X509Certificate object) {
        if ((object = ((X509Certificate)object).getSubjectAlternativeNames()) != null) {
            object = (Iterable)object;
            Iterable<Object> iterable = new ArrayList();
            object = object.iterator();
            while (object.hasNext()) {
                Object t2 = object.next();
                Object object2 = (List)t2;
                Object e = object2.get(0);
                Intrinsics.checkNotNull(e);
                if (!((Integer)e == 7)) continue;
                iterable.add((Object)t2);
            }
            object = (List)iterable;
            iterable = object;
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            for (Object object2 : iterable) {
                iterable = object2;
                object2 = object;
                Object e = iterable.get(1);
                Intrinsics.checkNotNull(e);
                object2.add((String)e);
            }
            return (List)object;
        }
        return CollectionsKt.emptyList();
    }
}

