/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.netty.KtorReadTimeoutHandler;
import io.ktor.server.netty.http1.NettyHttp1Handler;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.G;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002;:B\u008c\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003\u0012\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00182\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0013\u0010)\u001a\u00020\u001c*\u00020(H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u0004\u0018\u00010+*\u00020(H\u0002\u00a2\u0006\u0004\b,\u0010-R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010.R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010/R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00100R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00101R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00102R\u0014\u0010\u000e\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00102R\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u00103R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u00104R\u0014\u0010\u0013\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u00104R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u00104R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010.R%\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u00105R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u00106R\u0018\u00108\u001a\u0004\u0018\u0001078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/netty/util/concurrent/EventExecutorGroup;", "callEventGroup", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "Lio/ktor/server/engine/EngineConnectorConfig;", "connector", "", "runningLimit", "responseWriteTimeout", "requestReadTimeout", "Lio/netty/handler/codec/http/HttpServerCodec;", "httpServerCodec", "Lkotlin/Function1;", "Lio/netty/channel/ChannelPipeline;", "", "Lkotlin/ExtensionFunctionType;", "channelPipelineConfig", "", "enableHttp2", "<init>", "(Lkotlin/jvm/functions/Function0;Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/ApplicationEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lio/ktor/server/engine/EngineConnectorConfig;IIILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Z)V", "ch", "initChannel", "(Lio/netty/channel/socket/SocketChannel;)V", "pipeline", "", "protocol", "configurePipeline", "(Lio/netty/channel/ChannelPipeline;Ljava/lang/String;)V", "Lio/ktor/server/engine/EngineSSLConnectorConfig;", "hasTrustStore", "(Lio/ktor/server/engine/EngineSSLConnectorConfig;)Z", "Ljavax/net/ssl/TrustManagerFactory;", "trustManagerFactory", "(Lio/ktor/server/engine/EngineSSLConnectorConfig;)Ljavax/net/ssl/TrustManagerFactory;", "Lkotlin/jvm/functions/Function0;", "Lio/ktor/server/engine/EnginePipeline;", "Lio/ktor/server/application/ApplicationEnvironment;", "Lio/netty/util/concurrent/EventExecutorGroup;", "Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/server/engine/EngineConnectorConfig;", "I", "Lkotlin/jvm/functions/Function1;", "Z", "Lio/netty/handler/ssl/SslContext;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "Companion", "NegotiatedPipelineInitializer", "ktor-server-netty"})
public final class NettyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final Companion Companion = new Companion(null);
    private final Function0<Application> applicationProvider;
    private final EnginePipeline enginePipeline;
    private final ApplicationEnvironment environment;
    private final EventExecutorGroup callEventGroup;
    private final CoroutineContext engineContext;
    private final CoroutineContext userContext;
    private final EngineConnectorConfig connector;
    private final int runningLimit;
    private final int responseWriteTimeout;
    private final int requestReadTimeout;
    private final Function0<HttpServerCodec> httpServerCodec;
    private final Function1<ChannelPipeline, Unit> channelPipelineConfig;
    private final boolean enableHttp2;
    private SslContext sslContext;
    private static final Lazy<SslProvider> alpnProvider$delegate = LazyKt.lazy(NettyChannelInitializer::alpnProvider_delegate$lambda$12);

    public NettyChannelInitializer(Function0<Application> sslContextBuilder, EnginePipeline object, ApplicationEnvironment stringArray, EventExecutorGroup object2, CoroutineContext coroutineContext, CoroutineContext coroutineContext2, EngineConnectorConfig engineConnectorConfig, int n, int n2, int n3, Function0<HttpServerCodec> function0, Function1<? super ChannelPipeline, Unit> function1, boolean bl) {
        Intrinsics.checkNotNullParameter(sslContextBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)coroutineContext2, (String)"");
        Intrinsics.checkNotNullParameter((Object)engineConnectorConfig, (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.applicationProvider = sslContextBuilder;
        this.enginePipeline = object;
        this.environment = stringArray;
        this.callEventGroup = object2;
        this.engineContext = coroutineContext;
        this.userContext = coroutineContext2;
        this.connector = engineConnectorConfig;
        this.runningLimit = n;
        this.responseWriteTimeout = n2;
        this.requestReadTimeout = n3;
        this.httpServerCodec = function0;
        this.channelPipelineConfig = function1;
        this.enableHttp2 = bl;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            Certificate[] certificateArray = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getCertificateChain(((EngineSSLConnectorConfig)this.connector).getKeyAlias());
            Intrinsics.checkNotNullExpressionValue((Object)certificateArray, (String)"");
            List list = ArraysKt.toList((Object[])certificateArray);
            Intrinsics.checkNotNull((Object)list);
            sslContextBuilder = list;
            object = CollectionsKt.toList((Iterable)list);
            sslContextBuilder = object;
            sslContextBuilder = object.toArray(new X509Certificate[0]);
            object = (char[])((EngineSSLConnectorConfig)this.connector).getPrivateKeyPassword().invoke();
            Key key = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getKey(((EngineSSLConnectorConfig)this.connector).getKeyAlias(), (char[])object);
            Intrinsics.checkNotNull((Object)key);
            stringArray = (PrivateKey)key;
            ArraysKt.fill$default((char[])object, (char)'\u0000', (int)0, (int)0, (int)6, null);
            SslContextBuilder sslContextBuilder2 = sslContextBuilder;
            sslContextBuilder = SslContextBuilder.forServer((PrivateKey)stringArray, (X509Certificate[])Arrays.copyOf(sslContextBuilder2, ((X509Certificate[])sslContextBuilder2).length));
            object = sslContextBuilder;
            object2 = this;
            if (this.enableHttp2 && Companion.getAlpnProvider$ktor_server_netty() != null) {
                object.sslProvider(Companion.getAlpnProvider$ktor_server_netty());
                object.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                String[] stringArray2 = new String[2];
                stringArray = stringArray2;
                stringArray2[0] = "h2";
                stringArray[1] = "http/1.1";
                object.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, stringArray));
            }
            NettyChannelInitializer nettyChannelInitializer = this;
            TrustManagerFactory trustManagerFactory = nettyChannelInitializer.trustManagerFactory((EngineSSLConnectorConfig)nettyChannelInitializer.connector);
            if (trustManagerFactory != null) {
                stringArray = trustManagerFactory;
                object.trustManager((TrustManagerFactory)stringArray);
            }
            object2.sslContext = sslContextBuilder.build();
        }
    }

    protected final void initChannel(SocketChannel channelHandlerArray) {
        Intrinsics.checkNotNullParameter((Object)channelHandlerArray, (String)"");
        ChannelPipeline channelPipeline = channelHandlerArray.pipeline();
        if (this.connector instanceof EngineSSLConnectorConfig) {
            SslContext sslContext = this.sslContext;
            Intrinsics.checkNotNull((Object)sslContext);
            channelHandlerArray = sslContext.newEngine(channelHandlerArray.alloc());
            Object object = channelHandlerArray;
            NettyChannelInitializer nettyChannelInitializer = this;
            if (nettyChannelInitializer.hasTrustStore((EngineSSLConnectorConfig)nettyChannelInitializer.connector)) {
                ((SSLEngine)object).setUseClientMode(false);
                ((SSLEngine)object).setNeedClientAuth(true);
            }
            List list = ((EngineSSLConnectorConfig)this.connector).getEnabledProtocols();
            if (list != null) {
                List list2 = list;
                SSLEngine sSLEngine = object;
                Collection collection = list2;
                object = collection;
                object = collection;
                sSLEngine.setEnabledProtocols(collection.toArray(new String[0]));
            }
            channelPipeline.addLast("ssl", (ChannelHandler)new SslHandler((SSLEngine)channelHandlerArray));
            if (this.enableHttp2 && Companion.getAlpnProvider$ktor_server_netty() != null) {
                ChannelHandler[] channelHandlerArray2 = new ChannelHandler[1];
                channelHandlerArray = channelHandlerArray2;
                channelHandlerArray2[0] = new NegotiatedPipelineInitializer();
                channelPipeline.addLast(channelHandlerArray);
                return;
            }
            Intrinsics.checkNotNull((Object)channelPipeline);
            this.configurePipeline(channelPipeline, "http/1.1");
            return;
        }
        Intrinsics.checkNotNull((Object)channelPipeline);
        this.configurePipeline(channelPipeline, "http/1.1");
    }

    private final void configurePipeline(ChannelPipeline channelPipeline, String object) {
        ChannelPipeline channelPipeline2 = object;
        if (Intrinsics.areEqual((Object)channelPipeline2, (Object)"h2")) {
            object = new NettyHttp2Handler(this.enginePipeline, (Application)this.applicationProvider.invoke(), this.callEventGroup, this.userContext, this.runningLimit);
            ChannelPipeline channelPipeline3 = new ChannelHandler[1];
            channelPipeline2 = channelPipeline3;
            channelPipeline3[0] = Http2MultiplexCodecBuilder.forServer((ChannelHandler)((ChannelHandler)object)).build();
            channelPipeline.addLast((ChannelHandler[])channelPipeline2);
            channelPipeline.channel().closeFuture().addListener(arg_0 -> NettyChannelInitializer.configurePipeline$lambda$5((NettyHttp2Handler)((Object)object), arg_0));
            this.channelPipelineConfig.invoke((Object)channelPipeline);
            return;
        }
        if (Intrinsics.areEqual((Object)channelPipeline2, (Object)"http/1.1")) {
            object = new NettyHttp1Handler(this.applicationProvider, this.enginePipeline, this.environment, this.callEventGroup, this.engineContext, this.userContext, this.runningLimit);
            channelPipeline2 = channelPipeline;
            if (this.requestReadTimeout > 0) {
                channelPipeline2.addLast("readTimeout", (ChannelHandler)new KtorReadTimeoutHandler(this.requestReadTimeout));
            }
            channelPipeline2.addLast("codec", (ChannelHandler)this.httpServerCodec.invoke());
            channelPipeline2.addLast("continue", (ChannelHandler)new HttpServerExpectContinueHandler());
            channelPipeline2.addLast("timeout", (ChannelHandler)new WriteTimeoutHandler(this.responseWriteTimeout));
            channelPipeline2.addLast("http1", (ChannelHandler)object);
            this.channelPipelineConfig.invoke((Object)channelPipeline2);
            channelPipeline.context("codec").fireChannelActive();
            return;
        }
        this.environment.getLog().error("Unsupported protocol " + (String)object);
        channelPipeline.close();
    }

    private final boolean hasTrustStore(EngineSSLConnectorConfig engineSSLConnectorConfig) {
        return engineSSLConnectorConfig.getTrustStore() != null || engineSSLConnectorConfig.getTrustStorePath() != null;
    }

    private final TrustManagerFactory trustManagerFactory(EngineSSLConnectorConfig object) {
        Object object2;
        Object object3;
        Object object4;
        block5: {
            block6: {
                object4 = object.getTrustStore();
                if (object4 != null) break block5;
                File file = object.getTrustStorePath();
                if (file == null) break block6;
                object3 = file;
                object = new FileInputStream((File)object3);
                object3 = null;
                try {
                    KeyStore keyStore;
                    object2 = (FileInputStream)object;
                    KeyStore keyStore2 = keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load((InputStream)object2, null);
                    object2 = keyStore;
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = throwable;
                        object3 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
                        throw throwable3;
                    }
                }
                CloseableKt.closeFinally((Closeable)object, null);
                object4 = object2;
                break block5;
            }
            object4 = object = null;
        }
        if (object4 != null) {
            object = object4;
            object2 = object3 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object3).init((KeyStore)object);
            return object3;
        }
        return null;
    }

    private static final void configurePipeline$lambda$5(NettyHttp2Handler nettyHttp2Handler, Future future) {
        boolean bl = true;
        CoroutineScope coroutineScope = null;
        coroutineScope = nettyHttp2Handler;
        G.a((CoroutineScope)coroutineScope, null);
    }

    private static final SslProvider alpnProvider_delegate$lambda$12() {
        return NettyChannelInitializer.Companion.findAlpnProvider();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\n\u001a\u0004\u0018\u00010\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$Companion;", "", "<init>", "()V", "Lio/netty/handler/ssl/SslProvider;", "findAlpnProvider", "()Lio/netty/handler/ssl/SslProvider;", "alpnProvider$delegate", "Lkotlin/Lazy;", "getAlpnProvider$ktor_server_netty", "alpnProvider", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        public final SslProvider getAlpnProvider$ktor_server_netty() {
            Lazy lazy = alpnProvider$delegate;
            return (SslProvider)lazy.getValue();
        }

        private final SslProvider findAlpnProvider() {
            try {
                if (SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL)) {
                    return SslProvider.OPENSSL;
                }
            }
            catch (Throwable throwable) {}
            try {
                if (SslProvider.isAlpnSupported((SslProvider)SslProvider.JDK)) {
                    return SslProvider.JDK;
                }
            }
            catch (Throwable throwable) {}
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$NegotiatedPipelineInitializer;", "Lio/netty/handler/ssl/ApplicationProtocolNegotiationHandler;", "<init>", "(Lio/ktor/server/netty/NettyChannelInitializer;)V", "Lio/netty/channel/ChannelHandlerContext;", "ctx", "", "protocol", "", "configurePipeline", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/String;)V", "", "cause", "handshakeFailure", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "ktor-server-netty"})
    private final class NegotiatedPipelineInitializer
    extends ApplicationProtocolNegotiationHandler {
        public NegotiatedPipelineInitializer() {
            super("http/1.1");
        }

        protected final void configurePipeline(ChannelHandlerContext channelHandlerContext, String string) {
            Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
            Intrinsics.checkNotNullExpressionValue((Object)channelPipeline, (String)"");
            NettyChannelInitializer.this.configurePipeline(channelPipeline, string);
        }

        protected final void handshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)channelHandlerContext, (String)"");
            if (throwable instanceof ClosedChannelException) {
                channelHandlerContext.close();
                return;
            }
            super.handshakeFailure(channelHandlerContext, throwable);
        }
    }
}

