/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkotlinx/serialization/internal/InternalHexConverter;", "", "<init>", "()V", "hexCode", "", "parseHexBinary", "", "s", "hexToInt", "", "ch", "", "printHexBinary", "data", "lowerCase", "", "toHexString", "n", "kotlinx-serialization-core"})
public final class InternalHexConverter {
    public static final InternalHexConverter INSTANCE = new InternalHexConverter();
    private static final String hexCode = "0123456789ABCDEF";

    private InternalHexConverter() {
    }

    public final byte[] parseHexBinary(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = string.length();
        if (!(n % 2 == 0)) {
            String string2 = "HexBinary string must be even length";
            throw new IllegalArgumentException(string2.toString());
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            int n2 = this.hexToInt(string.charAt(i));
            int n3 = this.hexToInt(string.charAt(i + 1));
            if (!(n2 != -1 && n3 != -1)) {
                string = "Invalid hex chars: " + string.charAt(i) + string.charAt(i + 1);
                throw new IllegalArgumentException(string.toString());
            }
            byArray[i / 2] = (byte)((n2 << 4) + n3);
        }
        return byArray;
    }

    private final int hexToInt(char c) {
        boolean bl = '0' <= c ? c < ':' : false;
        if (bl) {
            return c - 48;
        }
        boolean bl2 = 'A' <= c ? c < 'G' : false;
        if (bl2) {
            return c - 65 + 10;
        }
        boolean bl3 = 'a' <= c ? c < 'g' : false;
        if (bl3) {
            return c - 97 + 10;
        }
        return -1;
    }

    public final String printHexBinary(byte[] byArray, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        for (byte by : byArray) {
            stringBuilder.append(hexCode.charAt(by >> 4 & 0xF));
            stringBuilder.append(hexCode.charAt(by & 0xF));
        }
        if (bl) {
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            return string2;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public static /* synthetic */ String printHexBinary$default(InternalHexConverter internalHexConverter, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return internalHexConverter.printHexBinary(byArray, bl);
    }

    public final String toHexString(int n) {
        Object object = new byte[4];
        for (int i = 0; i < 4; ++i) {
            object[i] = (byte)(n >> 24 - (i << 3));
        }
        char[] cArray = new char[1];
        Object object2 = cArray;
        cArray[0] = 48;
        String string = StringsKt.trimStart((String)this.printHexBinary((byte[])object, true), (char[])object2);
        object2 = string;
        object = string;
        Object object3 = (char[])(((CharSequence)string).length() > 0 ? object2 : null);
        if (object3 == null) {
            object3 = "0";
        }
        return object3;
    }
}

