/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.BusyHandler;
import org.sqlite.Collation;
import org.sqlite.Function;
import org.sqlite.ProgressHandler;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteJDBCLoader;
import org.sqlite.core.DB;
import org.sqlite.core.SafeStmtPtr;

public final class NativeDB
extends DB {
    private static final Logger logger = LoggerFactory.getLogger(NativeDB.class);
    private static final int DEFAULT_BACKUP_BUSY_SLEEP_TIME_MILLIS = 100;
    private static final int DEFAULT_BACKUP_NUM_BUSY_BEFORE_FAIL = 3;
    private static final int DEFAULT_PAGES_PER_BACKUP_STEP = 100;
    private long pointer = 0L;
    private static boolean isLoaded;
    private static boolean loadSucceeded;
    private long busyHandler = 0L;
    private long commitListener = 0L;
    private long updateListener = 0L;
    private long progressHandler;

    public NativeDB(String string, String string2, SQLiteConfig sQLiteConfig) {
        super(string, string2, sQLiteConfig);
    }

    public static boolean load() {
        if (isLoaded) {
            return loadSucceeded;
        }
        try {
            loadSucceeded = SQLiteJDBCLoader.initialize();
        }
        finally {
            isLoaded = true;
        }
        return loadSucceeded;
    }

    @Override
    protected final synchronized void _open(String string, int n) {
        this._open_utf8(NativeDB.stringToUtf8ByteArray(string), n);
    }

    final synchronized native void _open_utf8(byte[] var1, int var2);

    @Override
    protected final synchronized native void _close();

    @Override
    public final synchronized int _exec(String string) {
        if (logger.isTraceEnabled()) {
            logger.trace("DriverManager [{}] [SQLite EXEC] {}", (Object)Thread.currentThread().getName(), (Object)string);
        }
        return this._exec_utf8(NativeDB.stringToUtf8ByteArray(string));
    }

    final synchronized native int _exec_utf8(byte[] var1);

    @Override
    public final synchronized native int shared_cache(boolean var1);

    @Override
    public final synchronized native int enable_load_extension(boolean var1);

    @Override
    public final native void interrupt();

    @Override
    public final synchronized native void busy_timeout(int var1);

    @Override
    public final synchronized native void busy_handler(BusyHandler var1);

    @Override
    protected final synchronized SafeStmtPtr prepare(String string) {
        if (logger.isTraceEnabled()) {
            logger.trace("DriverManager [{}] [SQLite EXEC] {}", (Object)Thread.currentThread().getName(), (Object)string);
        }
        NativeDB nativeDB = this;
        return new SafeStmtPtr(nativeDB, nativeDB.prepare_utf8(NativeDB.stringToUtf8ByteArray(string)));
    }

    final synchronized native long prepare_utf8(byte[] var1);

    @Override
    final synchronized String errmsg() {
        return NativeDB.utf8ByteBufferToString(this.errmsg_utf8());
    }

    final synchronized native ByteBuffer errmsg_utf8();

    @Override
    public final synchronized String libversion() {
        return NativeDB.utf8ByteBufferToString(this.libversion_utf8());
    }

    final native ByteBuffer libversion_utf8();

    @Override
    public final synchronized native long changes();

    @Override
    public final synchronized native long total_changes();

    @Override
    protected final synchronized native int finalize(long var1);

    @Override
    public final synchronized native int step(long var1);

    @Override
    public final synchronized native int reset(long var1);

    @Override
    public final synchronized native int clear_bindings(long var1);

    @Override
    final synchronized native int bind_parameter_count(long var1);

    @Override
    public final synchronized native int column_count(long var1);

    @Override
    public final synchronized native int column_type(long var1, int var3);

    @Override
    public final synchronized String column_decltype(long l, int n) {
        return NativeDB.utf8ByteBufferToString(this.column_decltype_utf8(l, n));
    }

    final synchronized native ByteBuffer column_decltype_utf8(long var1, int var3);

    @Override
    public final synchronized String column_table_name(long l, int n) {
        return NativeDB.utf8ByteBufferToString(this.column_table_name_utf8(l, n));
    }

    final synchronized native ByteBuffer column_table_name_utf8(long var1, int var3);

    @Override
    public final synchronized String column_name(long l, int n) {
        return NativeDB.utf8ByteBufferToString(this.column_name_utf8(l, n));
    }

    final synchronized native ByteBuffer column_name_utf8(long var1, int var3);

    @Override
    public final synchronized String column_text(long l, int n) {
        return NativeDB.utf8ByteBufferToString(this.column_text_utf8(l, n));
    }

    final synchronized native ByteBuffer column_text_utf8(long var1, int var3);

    @Override
    public final synchronized native byte[] column_blob(long var1, int var3);

    @Override
    public final synchronized native double column_double(long var1, int var3);

    @Override
    public final synchronized native long column_long(long var1, int var3);

    @Override
    public final synchronized native int column_int(long var1, int var3);

    @Override
    final synchronized native int bind_null(long var1, int var3);

    @Override
    final synchronized native int bind_int(long var1, int var3, int var4);

    @Override
    final synchronized native int bind_long(long var1, int var3, long var4);

    @Override
    final synchronized native int bind_double(long var1, int var3, double var4);

    @Override
    final synchronized int bind_text(long l, int n, String string) {
        return this.bind_text_utf8(l, n, NativeDB.stringToUtf8ByteArray(string));
    }

    final synchronized native int bind_text_utf8(long var1, int var3, byte[] var4);

    @Override
    final synchronized native int bind_blob(long var1, int var3, byte[] var4);

    @Override
    public final synchronized native void result_null(long var1);

    @Override
    public final synchronized void result_text(long l, String string) {
        this.result_text_utf8(l, NativeDB.stringToUtf8ByteArray(string));
    }

    final synchronized native void result_text_utf8(long var1, byte[] var3);

    @Override
    public final synchronized native void result_blob(long var1, byte[] var3);

    @Override
    public final synchronized native void result_double(long var1, double var3);

    @Override
    public final synchronized native void result_long(long var1, long var3);

    @Override
    public final synchronized native void result_int(long var1, int var3);

    @Override
    public final synchronized void result_error(long l, String string) {
        this.result_error_utf8(l, NativeDB.stringToUtf8ByteArray(string));
    }

    final synchronized native void result_error_utf8(long var1, byte[] var3);

    @Override
    public final synchronized String value_text(Function function, int n) {
        return NativeDB.utf8ByteBufferToString(this.value_text_utf8(function, n));
    }

    final synchronized native ByteBuffer value_text_utf8(Function var1, int var2);

    @Override
    public final synchronized native byte[] value_blob(Function var1, int var2);

    @Override
    public final synchronized native double value_double(Function var1, int var2);

    @Override
    public final synchronized native long value_long(Function var1, int var2);

    @Override
    public final synchronized native int value_int(Function var1, int var2);

    @Override
    public final synchronized native int value_type(Function var1, int var2);

    @Override
    public final synchronized int create_function(String string, Function function, int n, int n2) {
        NativeDB nativeDB = this;
        return nativeDB.create_function_utf8(nativeDB.nameToUtf8ByteArray("function", string), function, n, n2);
    }

    final synchronized native int create_function_utf8(byte[] var1, Function var2, int var3, int var4);

    @Override
    public final synchronized int destroy_function(String string) {
        NativeDB nativeDB = this;
        return nativeDB.destroy_function_utf8(nativeDB.nameToUtf8ByteArray("function", string));
    }

    final synchronized native int destroy_function_utf8(byte[] var1);

    @Override
    public final synchronized int create_collation(String string, Collation collation) {
        NativeDB nativeDB = this;
        return nativeDB.create_collation_utf8(nativeDB.nameToUtf8ByteArray("collation", string), collation);
    }

    final synchronized native int create_collation_utf8(byte[] var1, Collation var2);

    @Override
    public final synchronized int destroy_collation(String string) {
        NativeDB nativeDB = this;
        return nativeDB.destroy_collation_utf8(nativeDB.nameToUtf8ByteArray("collation", string));
    }

    final synchronized native int destroy_collation_utf8(byte[] var1);

    @Override
    public final synchronized native int limit(int var1, int var2);

    private byte[] nameToUtf8ByteArray(String string, String string2) {
        byte[] byArray = NativeDB.stringToUtf8ByteArray(string2);
        if (string2 == null || "".equals(string2) || byArray.length > 255) {
            throw new SQLException("invalid " + string + " name: '" + string2 + "'");
        }
        return byArray;
    }

    @Override
    public final int backup(String string, String string2, DB.ProgressObserver progressObserver) {
        return this.backup(NativeDB.stringToUtf8ByteArray(string), NativeDB.stringToUtf8ByteArray(string2), progressObserver, 100, 3, 100);
    }

    @Override
    public final int backup(String string, String string2, DB.ProgressObserver progressObserver, int n, int n2, int n3) {
        return this.backup(NativeDB.stringToUtf8ByteArray(string), NativeDB.stringToUtf8ByteArray(string2), progressObserver, n, n2, n3);
    }

    final synchronized native int backup(byte[] var1, byte[] var2, DB.ProgressObserver var3, int var4, int var5, int var6);

    @Override
    public final synchronized int restore(String string, String string2, DB.ProgressObserver progressObserver) {
        return ((DB)this).restore(string, string2, progressObserver, 100, 3, 100);
    }

    @Override
    public final synchronized int restore(String string, String string2, DB.ProgressObserver progressObserver, int n, int n2, int n3) {
        return this.restore(NativeDB.stringToUtf8ByteArray(string), NativeDB.stringToUtf8ByteArray(string2), progressObserver, n, n2, n3);
    }

    final synchronized native int restore(byte[] var1, byte[] var2, DB.ProgressObserver var3, int var4, int var5, int var6);

    @Override
    final synchronized native boolean[][] column_metadata(long var1);

    @Override
    final synchronized native void set_commit_listener(boolean var1);

    @Override
    final synchronized native void set_update_listener(boolean var1);

    static void throwex(String string) {
        throw new SQLException(string);
    }

    static byte[] stringToUtf8ByteArray(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    static String utf8ByteBufferToString(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    @Override
    public final synchronized native void register_progress_handler(int var1, ProgressHandler var2);

    @Override
    public final synchronized native void clear_progress_handler();

    final long getBusyHandler() {
        return this.busyHandler;
    }

    final long getCommitListener() {
        return this.commitListener;
    }

    final long getUpdateListener() {
        return this.updateListener;
    }

    final long getProgressHandler() {
        return this.progressHandler;
    }

    @Override
    public final synchronized native byte[] serialize(String var1);

    @Override
    public final synchronized native void deserialize(String var1, byte[] var2);

    static {
        if ("The Android Project".equals(System.getProperty("java.vm.vendor"))) {
            System.loadLibrary("sqlitejdbc");
            isLoaded = true;
            loadSucceeded = true;
        } else {
            isLoaded = false;
            loadSucceeded = false;
        }
    }
}

