/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.pager.PagerState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Landroidx/compose/foundation/pager/PagerBringIntoViewSpec;", "Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "pagerState", "Landroidx/compose/foundation/pager/PagerState;", "defaultBringIntoViewSpec", "<init>", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/gestures/BringIntoViewSpec;)V", "getPagerState", "()Landroidx/compose/foundation/pager/PagerState;", "getDefaultBringIntoViewSpec", "()Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "calculateScrollDistance", "", "offset", "size", "containerSize", "overrideProposedOffsetMove", "proposedOffsetMove", "foundation"})
final class PagerBringIntoViewSpec
implements BringIntoViewSpec {
    private final PagerState pagerState;
    private final BringIntoViewSpec defaultBringIntoViewSpec;

    public PagerBringIntoViewSpec(PagerState pagerState, BringIntoViewSpec bringIntoViewSpec) {
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"");
        Intrinsics.checkNotNullParameter((Object)bringIntoViewSpec, (String)"");
        this.pagerState = pagerState;
        this.defaultBringIntoViewSpec = bringIntoViewSpec;
    }

    public final PagerState getPagerState() {
        return this.pagerState;
    }

    public final BringIntoViewSpec getDefaultBringIntoViewSpec() {
        return this.defaultBringIntoViewSpec;
    }

    @Override
    public final float calculateScrollDistance(float f2, float f3, float f4) {
        float f5;
        boolean bl;
        float f6 = this.defaultBringIntoViewSpec.calculateScrollDistance(f2, f3, f4);
        boolean bl2 = f2 > 0.0f ? f2 + f3 > f4 : (bl = f2 + f3 <= 0.0f);
        if (!(Math.abs(f6) == 0.0f) && bl) {
            f5 = this.overrideProposedOffsetMove(f6);
        } else if ((double)Math.abs(this.pagerState.getFirstVisiblePageOffset$foundation()) < 1.0E-6) {
            f5 = 0.0f;
        } else {
            float f7 = -((float)this.pagerState.getFirstVisiblePageOffset$foundation());
            f5 = RangesKt.coerceIn((float)(this.pagerState.getLastScrolledForward() ? f7 + (float)this.pagerState.getPageSizeWithSpacing$foundation() : f7), (float)(-f4), (float)f4);
        }
        float f8 = f5;
        return f5;
    }

    private final float overrideProposedOffsetMove(float f2) {
        float f3;
        for (f3 = -((float)this.pagerState.getFirstVisiblePageOffset$foundation()); f2 > 0.0f && f3 < f2; f3 += (float)this.pagerState.getPageSizeWithSpacing$foundation()) {
        }
        while (f2 < 0.0f && f3 > f2) {
            f3 -= (float)this.pagerState.getPageSizeWithSpacing$foundation();
        }
        return f3;
    }
}

